/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class EnabledJPanel
extends JPanel {
    public EnabledJPanel() {
        this.setToolTipText("");
    }

    public EnabledJPanel(LayoutManager layout) {
        super(layout);
        this.setToolTipText("");
    }

    public EnabledJPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.setToolTipText("");
    }

    public EnabledJPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.setToolTipText("");
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        Component[] comps = this.getComponents();
        this.setEnabled(comps, b);
    }

    private void setEnabled(Component[] comps, boolean b) {
        for (int i = 0; i < comps.length; ++i) {
            this.setComponentEnabled(comps[i], b);
            if (comps[i] instanceof JScrollPane) {
                this.setComponentEnabled(((JScrollPane)comps[i]).getViewport().getView(), b);
                continue;
            }
            if (!(comps[i] instanceof Container) || comps[i] instanceof JComboBox) continue;
            Container c2 = (Container)comps[i];
            this.setEnabled(c2.getComponents(), b);
        }
    }

    protected void setComponentEnabled(Component component, boolean enabled) {
        component.setEnabled(enabled);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (e.isAltDown() && e.isControlDown() && e.isShiftDown()) {
            return this.getClass().getName();
        }
        String s = super.getToolTipText(e);
        if (s != null && s.length() == 0) {
            return null;
        }
        return s;
    }
}

