/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.ExportOptions;
import rma.swing.IExportOptions;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextField;

public class ExportDialog
extends RmaJDialog
implements IExportOptions {
    private boolean _canceled;
    private RmaJComboBox _delimiterCombo;
    private RmaJCheckBox _quotedStringsCB;
    private RmaJCheckBox _titleCB;
    private RmaJTextField _titleField;
    private ButtonCmdPanel _cmdPanel;

    public ExportDialog(Frame frame) {
        super(frame, true);
        this.buildControls();
        if (frame != null) {
            this._titleField.setText(frame.getTitle());
        }
    }

    public ExportDialog(Dialog dialog) {
        super(dialog, true);
        this.buildControls();
        if (dialog != null) {
            this._titleField.setText(dialog.getTitle());
        }
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Export Options");
        JLabel label = new JLabel("Field Delimiter:", 4);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._delimiterCombo = new RmaJComboBox<String>(DELIMITERS);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._delimiterCombo, gbc);
        this._quotedStringsCB = new RmaJCheckBox("Quoted Strings");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._quotedStringsCB, gbc);
        JPanel panel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(0, 0, 0, 0);
        this.getContentPane().add((Component)panel, gbc);
        this._titleCB = new RmaJCheckBox("Print Title:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)this._titleCB, gbc);
        this._titleField = new RmaJTextField(17);
        this._titleField.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)this._titleField, gbc);
        this._cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._cmdPanel, gbc);
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        ExportDialog.this._canceled = false;
                        ExportDialog.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        ExportDialog.this._canceled = true;
                        ExportDialog.this.setVisible(false);
                    }
                }
            }
        });
        this._titleCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDialog.this._titleField.setEnabled(ExportDialog.this._titleCB.isSelected());
            }
        });
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setResizable(false);
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public ExportOptions getExportOptions() {
        ExportOptions eo = new ExportOptions();
        eo.delimiter = DELIMITER_CHARS[this._delimiterCombo.getSelectedIndex()];
        eo.quotedStrings = this._quotedStringsCB.isSelected();
        if (this._titleCB.isSelected()) {
            eo.title = this._titleField.getText();
        }
        return eo;
    }
}

