/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class FlatPanelButton
extends JButton {
    private static boolean TEST_POPUPMENU_BUTTON = Boolean.getBoolean("flatpanelbutton.test");
    private static int BUTTON_PRESSED = 0;
    private static int BUTTON_RELEASED = 1;
    private int m_buttonState = BUTTON_RELEASED;
    private boolean m_hasPopupMenu = false;
    private int m_popupWidth = 10;

    public FlatPanelButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public FlatPanelButton(Action action) {
        super(action);
        this.init();
    }

    public FlatPanelButton() {
        this(null, null);
    }

    public FlatPanelButton(String text) {
        this(text, null);
    }

    public FlatPanelButton(Icon icon) {
        this(null, icon);
    }

    protected void init() {
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent event) {
                if (!FlatPanelButton.this.isEnabled()) {
                    return;
                }
                FlatPanelButton.this.setBorderPainted(true);
            }

            @Override
            public void mouseExited(MouseEvent event) {
                if (!FlatPanelButton.this.isEnabled()) {
                    return;
                }
                FlatPanelButton.this.setBorderPainted(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!FlatPanelButton.this.isEnabled()) {
                    return;
                }
                FlatPanelButton.this.m_buttonState = BUTTON_PRESSED;
                FlatPanelButton.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!FlatPanelButton.this.isEnabled()) {
                    return;
                }
                FlatPanelButton.this.m_buttonState = BUTTON_RELEASED;
                FlatPanelButton.this.repaint();
            }
        });
    }

    public void setIcon(ImageIcon icon, int iWidth, int iHeight, int pos) {
        if (icon == null || iWidth < 0 || iHeight < 0 || pos < 0) {
            throw new IllegalArgumentException("Invalid Parameter in FlatPanelButton.setIcon()");
        }
        this.setIcon(icon, iWidth, iHeight, pos * iWidth, 0);
    }

    public void setIcon(ImageIcon icon, int iWidth, int iHeight, int posx, int posy) {
        BufferedImage bImage = new BufferedImage(iWidth, iHeight, 1);
        Graphics2D g = (Graphics2D)bImage.getGraphics();
        Rectangle rect = new Rectangle(0, 0, iWidth, iHeight);
        g.setClip(rect.x, rect.y, rect.width, rect.height);
        g.translate(-posx, -posy);
        AffineTransform at = new AffineTransform();
        g.drawImage(icon.getImage(), at, null);
        this.setIcon(new ImageIcon(bImage, ""));
    }

    public void setHasPopupMenu(boolean drawPopup) {
        this.m_hasPopupMenu = drawPopup;
    }

    public boolean hasPopupMenu() {
        return this.m_hasPopupMenu;
    }

    @Override
    public void paintComponent(Graphics g) {
        Color highlite;
        Color shadow;
        super.paintComponent(g);
        if (!this.hasPopupMenu()) {
            return;
        }
        if (!this.isBorderPainted()) {
            return;
        }
        if (this.m_buttonState == BUTTON_RELEASED) {
            shadow = UIManager.getColor("Separator.shadow");
            highlite = UIManager.getColor("Separator.highlight");
        } else {
            shadow = UIManager.getColor("Separator.highlight");
            highlite = UIManager.getColor("Separator.shadow");
        }
        Dimension d = this.getSize();
        g.setColor(shadow);
        g.drawLine(d.width - this.m_popupWidth, 0, d.width - this.m_popupWidth, d.height - 1);
        g.setColor(highlite);
        g.drawLine(d.width - this.m_popupWidth + 1, 0, d.width - this.m_popupWidth + 1, d.height - 1);
    }

    @Override
    public void paintBorder(Graphics g) {
        Color highlite;
        Color shadow;
        if (!this.isBorderPainted()) {
            return;
        }
        Dimension d = this.getSize();
        if (this.m_buttonState == BUTTON_RELEASED) {
            shadow = UIManager.getColor("Separator.shadow");
            highlite = UIManager.getColor("Separator.highlight");
        } else {
            shadow = UIManager.getColor("Separator.highlight");
            highlite = UIManager.getColor("Separator.shadow");
        }
        g.setColor(shadow);
        g.drawLine(0, d.height - 1, d.width - 1, d.height - 1);
        g.drawLine(d.width - 1, 0, d.width - 1, d.height - 1);
        g.setColor(highlite);
        g.drawLine(0, 0, d.width - 1, 0);
        g.drawLine(0, 0, 0, d.height - 1);
    }

    public static void main(String[] args) {
        if (args.length > 0 && !args[0].equals("WINDOWS")) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JFrame frame = new JFrame();
        frame.getRootPane().setLayout(new GridBagLayout());
        FlatPanelButton button_1 = new FlatPanelButton("Button 1");
        button_1.setHasPopupMenu(true);
        frame.getRootPane().add((Component)button_1, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        frame.getRootPane().add((Component)new FlatPanelButton("Button 2"), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 0, 5, 0), 0, 0));
        frame.pack();
        frame.setVisible(true);
    }
}

