/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.FontChooserPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;

public class FontChooser
extends RmaJDialog
implements WindowListener {
    private boolean _isCanceled;
    private ButtonCmdPanel cmdPanel;
    private FontChooserPanel _chooserPanel;
    private Frame parent;

    public FontChooser(Frame frame, String s, boolean modal, Font font) {
        super(frame, s, modal);
        this.buildDialog(font);
    }

    public FontChooser(Dialog dialog, String s, boolean modal, Font font) {
        super(dialog, s, modal);
        this.buildDialog(font);
    }

    private void buildDialog(Font font) {
        this._isCanceled = true;
        this.buildControls(font);
    }

    void buildControls(Font font) {
        this.getContentPane().setLayout(new GridBagLayout());
        this._chooserPanel = new FontChooserPanel(font);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 1;
        this.getContentPane().add((Component)this._chooserPanel, gbc);
        this.cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.insets = RmaInsets.insets(0, 0, 5, 0);
        gbc.anchor = 15;
        gbc.fill = 0;
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.addWindowListener(this);
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        FontChooser.this._isCanceled = false;
                        FontChooser.this.setVisible(false);
                        FontChooser.this.dispose();
                        break;
                    }
                    case 4: {
                        FontChooser.this.setVisible(false);
                        FontChooser.this.dispose();
                    }
                }
            }
        });
        this.setSize(250, 300);
        this.setMinimumSize(this.getSize());
        this.setLocation();
        this.setVisible(true);
        this._chooserPanel.updateWidget();
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
    }

    public Font getSelectedFont() {
        if (this._isCanceled) {
            return null;
        }
        return this._chooserPanel.getSelectedFont();
    }

    @Override
    public void windowActivated(WindowEvent windowevent) {
    }

    @Override
    public void windowClosed(WindowEvent windowevent) {
    }

    @Override
    public void windowClosing(WindowEvent windowevent) {
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent windowevent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowevent) {
    }

    @Override
    public void windowIconified(WindowEvent windowevent) {
    }

    @Override
    public void windowOpened(WindowEvent windowevent) {
    }

    public String[] getFontList() {
        return this._chooserPanel.getFontList();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this._chooserPanel.getFontMetrics(font);
    }

    public static void main(String[] args) {
        new FontChooser(new Frame(), "Font Chooser Test", false, new Font("Dialog", 10, 0));
    }
}

