/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.FontSampleBox;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;
import rma.util.RMAUtil;

public class FontChooserPanel
extends JPanel
implements ActionListener,
ItemListener,
ChangeListener {
    Toolkit tkt;
    private JSlider sizeSB;
    private RmaJIntegerField sizeTxt;
    private RmaJTextField sampleTxt;
    private JLabel fontLabel;
    private JPanel sizePanel;
    private JPanel samplePanel;
    private RmaJCheckBox boldCB;
    private RmaJCheckBox italicCB;
    private RmaJComboBox<String> fontList;
    private FontSampleBox fontSampleBox;
    private Font _currentFont;
    private static final int FONT_SIZE_MAX = 150;
    private static final int FONT_SIZE_MIN = 5;

    public FontChooserPanel(Font font) {
        super(new GridBagLayout());
        this.buildControls(font);
    }

    void buildControls(Font font) {
        String[] fontList1 = this.getFontList();
        this.fontSampleBox = new FontSampleBox();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 1;
        this.add((Component)this.fontSampleBox, gbc);
        this.fontLabel = new JLabel("Font");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add((Component)this.fontLabel, gbc);
        this.fontList = new RmaJComboBox<String>(new RmaListModel<String>(false, fontList1));
        this.fontList.setModifiable(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        gbc.anchor = 18;
        gbc.fill = 2;
        this.add(this.fontList, gbc);
        this.sizePanel = new JPanel();
        this.sizePanel.setBorder(new TitledBorder("Size"));
        this.sizePanel.setLayout(new GridBagLayout());
        this.sizeTxt = new RmaJIntegerField();
        this.sizeTxt.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.ipadx = 20;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 2;
        this.sizePanel.add((Component)this.sizeTxt, gbc);
        this.sizeSB = new JSlider(0, 5, 40, 10);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.anchor = 18;
        gbc.fill = 2;
        this.sizePanel.add((Component)this.sizeSB, gbc);
        this.sizeSB.addChangeListener(e -> RMAUtil.setParentModified(this.sizeSB));
        JPanel panel1 = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 2;
        this.add((Component)panel1, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 2;
        panel1.add((Component)this.sizePanel, gbc);
        this.boldCB = new RmaJCheckBox("Bold");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 7, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 0;
        panel1.add((Component)this.boldCB, gbc);
        this.italicCB = new RmaJCheckBox("Italic");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 7, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 0;
        panel1.add((Component)this.italicCB, gbc);
        this.samplePanel = new JPanel(new BorderLayout());
        this.samplePanel.setBorder(new TitledBorder("Sample text"));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 1;
        panel1.add((Component)this.samplePanel, gbc);
        this.sampleTxt = new RmaJTextField("AaBbCc 123");
        this.samplePanel.add((Component)this.sampleTxt, 0);
        this.sizeSB.addChangeListener(this);
        this.boldCB.addActionListener(this);
        this.italicCB.addActionListener(this);
        this.fontList.addItemListener(this);
        this.sampleTxt.addActionListener(this);
        this.sizeTxt.addActionListener(this);
        this._currentFont = font == null ? this.sampleTxt.getFont() : font;
    }

    public Font getSelectedFont() {
        return this._currentFont;
    }

    public void setSelectedFont(Font font) {
        this._currentFont = font == null ? this.sampleTxt.getFont() : font;
        this.updateWidget();
    }

    void updateWidget() {
        this.boldCB.removeActionListener(this);
        this.italicCB.removeActionListener(this);
        this.boldCB.setSelected(this._currentFont.isBold());
        this.italicCB.setSelected(this._currentFont.isItalic());
        this.boldCB.addActionListener(this);
        this.italicCB.addActionListener(this);
        int i = this._currentFont.getSize();
        this.sizeTxt.setValue(i);
        this.sizeSB.setValue(i);
        String s = this._currentFont.getFamily();
        if (((RmaListModel)this.fontList.getModel()).indexOf(s) == -1) {
            int cnt = this.fontList.getItemCount();
            for (i = 0; i < cnt; ++i) {
                if (!s.equalsIgnoreCase((String)this.fontList.getItemAt(i))) continue;
                this.fontList.setSelectedIndex(i);
                break;
            }
        } else {
            this.fontList.setSelectedItem(s);
        }
        this.fontSampleBox.setSampleText(this.sampleTxt.getText());
        this.fontSampleBox.setSampleFont(this._currentFont);
        this.fontSampleBox.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.sizeTxt) {
            int j = this._currentFont.getSize();
            try {
                j = Integer.parseInt(this.sizeTxt.getText());
            }
            catch (NumberFormatException _ex) {
                Logger.getLogger(FontChooserPanel.class.getName()).log(Level.WARNING, "font chooser difficulties parsing font size", _ex);
            }
            if (j > 150) {
                j = 150;
            } else if (j < 5) {
                j = 5;
            }
            this._currentFont = new Font(this._currentFont.getName(), this._currentFont.getStyle(), j);
            this.updateWidget();
        } else if (src == this.sampleTxt) {
            this.updateWidget();
        } else if (src == this.boldCB || src == this.italicCB) {
            int i = 0;
            if (this.boldCB.isSelected()) {
                i |= 1;
            }
            if (this.italicCB.isSelected()) {
                i |= 2;
            }
            this._currentFont = new Font(this._currentFont.getName(), i, this._currentFont.getSize());
            this.updateWidget();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int i = this.sizeSB.getValue();
        this._currentFont = new Font(this._currentFont.getName(), this._currentFont.getStyle(), i);
        this.updateWidget();
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 2) {
            return;
        }
        if (event.getSource() == this.fontList) {
            String fontName = (String)this.fontList.getItemAt(this.fontList.getSelectedIndex());
            this._currentFont = new Font(fontName, this._currentFont.getStyle(), this._currentFont.getSize());
            this.updateWidget();
        }
    }

    @Override
    public void paint(Graphics g) {
        if (g != null) {
            super.paint(g);
            this.updateWidget();
        }
    }

    public String[] getFontList() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    public void setFontColor(Color color) {
        this.fontSampleBox.setSampleColor(color);
    }

    @Override
    public Toolkit getToolkit() {
        this.tkt = Toolkit.getDefaultToolkit();
        return this.tkt;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        if (this.tkt == null) {
            this.getToolkit();
        }
        return this.tkt.getFontMetrics(font);
    }

    public void setMinimumFontSize(int minFontSize) {
        this.sizeSB.setMinimum(minFontSize);
    }

    public void setMaximumFontSize(int maxFontSize) {
        this.sizeSB.setMaximum(maxFontSize);
    }

    public void addFontSizePropertyChangeListener(PropertyChangeListener listener) {
        this.sizeSB.addPropertyChangeListener(listener);
    }

    public void removeFontSizePropertyChangeListener(PropertyChangeListener listener) {
        this.sizeSB.removePropertyChangeListener(listener);
    }

    public void setSamplePanelVisible(boolean b) {
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.sizeSB.setEnabled(b);
        this.sizeTxt.setEnabled(b);
        this.fontLabel.setEnabled(b);
        this.sampleTxt.setEnabled(b);
        this.sizePanel.setEnabled(b);
        this.samplePanel.setEnabled(b);
        this.boldCB.setEnabled(b);
        this.italicCB.setEnabled(b);
        this.fontList.setEnabled(b);
        this.fontSampleBox.setEnabled(b);
    }
}

