/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class HersheyFont {
    public static final int HORIZONTAL_CENTER = 0;
    public static final int HORIZONTAL_LEFT = 1;
    public static final int HORIZONTAL_RIGHT = 2;
    public static final int HORIZONTAL_NORMAL = 1;
    public static final int VERTICAL_TOP = 0;
    public static final int VERTICAL_HALF = 1;
    public static final int VERTICAL_CAP = 2;
    public static final int VERTICAL_BOTTOM = 3;
    public static final int VERTICAL_NORMAL = 3;
    private static final int MAX_CHARACTERS = 256;
    private static final int MAX_POINTS = 150;
    protected static final int X = 0;
    protected static final int Y = 1;
    private float hersheyWidth = 1.0f;
    private float hersheyHeight = 1.0f;
    private int hersheyLineWidth = 1;
    private int hersheyHorizontalAlignment = 1;
    private int herhseyVerticalAlignment = 3;
    private double hersheyTheta = 0.0;
    private boolean hersheyItalics = false;
    private float hersheyItalicSlant = 0.75f;
    private String copyright = "Copyright (c) James P. Buzbee Mar 30, 1996";
    protected String name;
    protected char[][][] characterVectors = new char[256][2][150];
    protected int[] numberOfPoints = new int[256];
    protected int[] characterMinX;
    protected int[] characterMaxX;
    protected int characterSetMinY;
    protected int characterSetMaxY;
    protected int charactersInSet;

    private int getInt(InputStream file, int n) throws IOException {
        int j = 0;
        char[] buf = new char[n];
        for (int i = 0; i < n; ++i) {
            int c2 = file.read();
            while (c2 == 10 || c2 == 13) {
                c2 = file.read();
            }
            if (c2 == -1) {
                return c2;
            }
            if ((char)c2 == ' ') continue;
            buf[j++] = (char)c2;
        }
        return Integer.parseInt(String.copyValueOf(buf, 0, j));
    }

    public HersheyFont(String fontName) {
        this(ClassLoader.getSystemResource(fontName));
        this.name = fontName;
    }

    public HersheyFont(URL base, String fontName) {
        this.name = fontName;
        try {
            InputStream fontStream = new URL(base, fontName).openStream();
            this.LoadHersheyFont(fontName, fontStream);
            fontStream.close();
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public HersheyFont(URL base) {
        this.name = base.toString();
        try {
            InputStream fontStream = base.openStream();
            this.LoadHersheyFont(this.name, fontStream);
            fontStream.close();
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private void LoadHersheyFont(String fontname, InputStream fontStream) {
        int xadjust = this.fontAdjustment(fontname);
        try {
            int character = 0;
            while (true) {
                int n;
                if (this.getInt(fontStream, 5) < 1) break;
                this.numberOfPoints[character] = n = this.getInt(fontStream, 3);
                for (int i = 0; i < n; ++i) {
                    int c2;
                    if (i == 32 || i == 68 || i == 104 || i == 140) {
                        fontStream.read();
                    }
                    if ((c2 = fontStream.read()) == 10) {
                        c2 = fontStream.read();
                    }
                    this.characterVectors[character][0][i] = (char)c2;
                    this.characterVectors[character][1][i] = (char)fontStream.read();
                }
                fontStream.read();
                ++character;
            }
            this.charactersInSet = character;
            this.characterMinX = new int[this.charactersInSet];
            this.characterMaxX = new int[this.charactersInSet];
            this.characterSetMinY = 1000;
            this.characterSetMaxY = -1000;
            for (int j = 1; j < this.charactersInSet; ++j) {
                this.calculateCharacterSize(j, xadjust);
            }
            if (65 <= this.charactersInSet) {
                this.characterMinX[0] = this.characterMinX[65];
                this.characterMaxX[0] = this.characterMaxX[65];
            } else {
                this.characterMinX[0] = this.characterMinX[this.charactersInSet - 1];
                this.characterMaxX[0] = this.characterMaxX[this.charactersInSet - 1];
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    protected void calculateCharacterSize(int j, int xadj) {
        this.characterMinX[j] = 1000;
        this.characterMaxX[j] = -1000;
        for (int i = 1; i < this.numberOfPoints[j]; ++i) {
            if (this.characterVectors[j][0][i] == ' ') continue;
            if (this.characterVectors[j][0][i] < this.characterMinX[j]) {
                this.characterMinX[j] = this.characterVectors[j][0][i];
            }
            if (this.characterVectors[j][0][i] > this.characterMaxX[j]) {
                this.characterMaxX[j] = this.characterVectors[j][0][i];
            }
            if (this.characterVectors[j][1][i] < this.characterSetMinY) {
                this.characterSetMinY = this.characterVectors[j][1][i];
            }
            if (this.characterVectors[j][1][i] <= this.characterSetMaxY) continue;
            this.characterSetMaxY = this.characterVectors[j][1][i];
        }
        int n = j;
        this.characterMinX[n] = this.characterMinX[n] - xadj;
        int n2 = j;
        this.characterMaxX[n2] = this.characterMaxX[n2] + xadj;
    }

    public void drawString(String text, int x, int y, Graphics g) {
        this.drawText(text, x, y, this.hersheyWidth, this.hersheyHeight, this.hersheyHorizontalAlignment, this.herhseyVerticalAlignment, this.hersheyTheta, true, new Rectangle(), g);
    }

    public Rectangle stringLimit(String text, int x, int y, Graphics g) {
        Rectangle r = new Rectangle();
        this.drawText(text, x, y, this.hersheyWidth, this.hersheyHeight, this.hersheyHorizontalAlignment, this.herhseyVerticalAlignment, this.hersheyTheta, false, r, g);
        r.width = r.width - r.x + 1;
        r.height = r.height - r.y + 1;
        return r;
    }

    public void setRotation(double theta) {
        this.hersheyTheta = theta;
    }

    public void setWidth(float width) {
        this.hersheyWidth = width;
    }

    public void setHeight(float height) {
        this.hersheyHeight = height;
    }

    public void setVerticalAlignment(int alignment) {
        this.herhseyVerticalAlignment = alignment;
    }

    public void setHorizontalAlignment(int alignment) {
        this.hersheyHorizontalAlignment = alignment;
    }

    public void setItalics(boolean flag) {
        this.hersheyItalics = flag;
    }

    public void setItalicsSlant(float slant) {
        this.hersheyItalicSlant = slant;
    }

    public void setLineWidth(int width) {
        this.hersheyLineWidth = width;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    protected int drawText(String text, int xc, int yc, float width, float height, int Horizontal_Alignment, int Vertical_Alignment, double theta, boolean Draw, Rectangle r, Graphics g) {
        int character;
        int j;
        int rotpx = 0;
        int rotpy = 0;
        boolean rotate = false;
        float cosTheta = 0.0f;
        float sinTheta = 0.0f;
        float verticalOffsetFactor = 0.0f;
        boolean bl = rotate = theta != 0.0;
        if (rotate) {
            theta = -Math.PI / 180 * theta;
            cosTheta = (float)Math.cos(theta);
            sinTheta = (float)Math.sin(theta);
            rotpx = xc;
            rotpy = yc;
        }
        int xp = xc;
        int yp = yc;
        if (!Draw) {
            r.x = xp;
            r.y = yp;
            r.width = xp;
            r.height = yp;
        }
        switch (Vertical_Alignment) {
            case 0: {
                verticalOffsetFactor = 0.0f;
                break;
            }
            case 1: {
                verticalOffsetFactor = 0.5f;
                break;
            }
            case 3: {
                verticalOffsetFactor = 1.0f;
                break;
            }
            case 2: {
                verticalOffsetFactor = 0.25f;
            }
        }
        yp -= (int)(verticalOffsetFactor * (height * (float)(this.characterSetMaxY - this.characterSetMinY)));
        if (Horizontal_Alignment != 1 && Horizontal_Alignment != 1) {
            int len = 0;
            for (j = 0; j < text.length(); ++j) {
                character = text.charAt(j) - 32;
                if (character >= this.characterMaxX.length || character >= this.characterMinX.length || character < 0) continue;
                len = (int)((float)len + (float)(this.characterMaxX[character] - this.characterMinX[character]) * width);
            }
            xp = Horizontal_Alignment == 0 ? (xp -= len / 2) : (xp -= len);
        }
        for (j = 0; j < text.length(); ++j) {
            character = text.charAt(j) - 32;
            if (character >= this.characterMaxX.length || character >= this.characterMinX.length || character < 0) continue;
            this.drawCharacter(xp, yp, rotpx, rotpy, width, height, rotate, sinTheta, cosTheta, Draw, r, this.characterVectors[character], this.numberOfPoints[character], this.characterMinX[character], this.characterSetMinY, this.hersheyItalics, this.hersheyItalicSlant, g);
            xp += (int)((float)(this.characterMaxX[character] - this.characterMinX[character]) * width);
        }
        return 0;
    }

    protected void drawFontLine(int x1, int y1, int x2, int y2, int width, Graphics g) {
        if (width > 1) {
            Polygon filledPolygon = new Polygon();
            int offset = width / 2;
            filledPolygon.addPoint(x1 - offset, y1 + offset);
            filledPolygon.addPoint(x1 + offset, y1 - offset);
            filledPolygon.addPoint(x2 + offset, y2 - offset);
            filledPolygon.addPoint(x2 - offset, y2 + offset);
            g.fillPolygon(filledPolygon);
        } else {
            g.drawLine(x1, y1, x2, y2);
        }
    }

    protected int fontAdjustment(String fontname) {
        int xadjust = 0;
        if (fontname.indexOf("scri") < 0) {
            xadjust = fontname.indexOf("goth") >= 0 ? 2 : 3;
        }
        return xadjust;
    }

    protected void drawCharacter(int xp, int yp, int rotpx, int rotpy, float width, float height, boolean rotate, float sinTheta, float cosTheta, boolean Draw, Rectangle r, char[][] Vectors, int numberOfPoints, int minX, int characterSetMinY, boolean Italics, float slant, Graphics g) {
        int oldx = 0;
        int oldy = 0;
        boolean skip = true;
        float finalSlant = height * -slant;
        for (int i = 1; i < numberOfPoints; ++i) {
            if (Vectors[0][i] == ' ') {
                skip = true;
                continue;
            }
            int x = (int)(Italics ? (float)(Vectors[1][i] - characterSetMinY) * finalSlant : 0.0f) + this.transformX(xp, Vectors[0][i], minX, width);
            int y = this.transformY(yp, Vectors[1][i], characterSetMinY, height);
            if (rotate) {
                float xd = x - rotpx;
                float yd = y - rotpy;
                float xd2 = xd * cosTheta - yd * sinTheta;
                float yd2 = xd * sinTheta + yd * cosTheta;
                x = (int)((double)xd2 + 0.5) + rotpx;
                y = (int)((double)yd2 + 0.5) + rotpy;
            }
            if (!Draw) {
                if (x < r.x) {
                    r.x = x;
                }
                if (y < r.y) {
                    r.y = y;
                }
                if (x > r.width) {
                    r.width = x;
                }
                if (y > r.height) {
                    r.height = y;
                }
            }
            if (!skip && Draw) {
                this.drawFontLine(oldx, oldy, x, y, this.hersheyLineWidth, g);
            }
            skip = false;
            oldx = x;
            oldy = y;
        }
    }

    protected final int transformX(int xoffset, int px, int minx, float mag) {
        return (int)((float)xoffset + (float)(px - minx) * mag);
    }

    protected final int transformY(int yoffset, int py, int miny, float mag) {
        return (int)((float)yoffset + (float)(py - miny) * mag);
    }
}

