/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;

public class JButtonGroup
extends ButtonGroup {
    private AbstractButton selectedButton;

    public JButtonGroup() {
    }

    public JButtonGroup(AbstractButton[] buttons) {
        this.add(buttons);
    }

    @Override
    public void add(AbstractButton button) {
        if (button == null || this.buttons.contains(button)) {
            return;
        }
        super.add(button);
        if (this.getSelection() == button.getModel()) {
            this.selectedButton = button;
        }
    }

    public void add(AbstractButton[] buttons) {
        if (buttons == null) {
            return;
        }
        for (int i = 0; i < buttons.length; ++i) {
            this.add(buttons[i]);
        }
    }

    @Override
    public void remove(AbstractButton button) {
        if (button != null) {
            if (this.selectedButton == button) {
                this.selectedButton = null;
            }
            super.remove(button);
        }
    }

    public void remove(AbstractButton[] buttons) {
        if (buttons == null) {
            return;
        }
        for (int i = 0; i < buttons.length; ++i) {
            this.remove(buttons[i]);
        }
    }

    public void setSelected(AbstractButton button, boolean selected) {
        if (button != null && this.buttons.contains(button)) {
            this.setSelected(button.getModel(), selected);
            if (this.getSelection() == button.getModel()) {
                this.selectedButton = button;
            }
        }
    }

    @Override
    public void setSelected(ButtonModel model, boolean selected) {
        AbstractButton button = this.getButton(model);
        if (this.buttons.contains(button)) {
            super.setSelected(model, selected);
        }
    }

    public AbstractButton getButton(ButtonModel model) {
        for (AbstractButton ab : this.buttons) {
            if (ab.getModel() != model) continue;
            return ab;
        }
        return null;
    }

    public AbstractButton getSelected() {
        return this.selectedButton;
    }

    public boolean isSelected(AbstractButton button) {
        return button == this.selectedButton;
    }

    public List getButtons() {
        return Collections.unmodifiableList(this.buttons);
    }

    public boolean contains(AbstractButton button) {
        return this.buttons.contains(button);
    }
}

