/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class JDialogHelp
extends JDialog {
    JMenuBar jMenuBar;
    JMenu jMenuFile;
    JMenuItem jMenuItemExit;
    JPanel jPanelTop;
    boolean fComponentsAdjusted = false;

    public JDialogHelp(Frame parent, boolean modal) {
        super(parent, modal);
        this.setTitle("JDialogHelp");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setVisible(false);
        this.setSize(430, 270);
        this.jMenuBar = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuFile.setText("File");
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuItemExit = new JMenuItem();
        this.jMenuItemExit.setText("Exit");
        this.jMenuFile.add(this.jMenuItemExit);
        this.jPanelTop = new JPanel();
        this.jPanelTop.setLayout(new BorderLayout(0, 0));
        this.jPanelTop.setBounds(0, 0, 20, 40);
        this.jPanelTop.setFont(new Font("Dialog", 0, 12));
        this.jPanelTop.setForeground(new Color(0));
        this.jPanelTop.setBackground(new Color(-3355444));
        this.getContentPane().add("North", this.jPanelTop);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        this.setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public JDialogHelp(Frame parent, String title, String url) {
        this(parent, false);
        this.jPanelTop.add(this.jMenuBar);
        ActionListener newFile = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialogHelp.this.dispose();
            }
        };
        this.jMenuItemExit.addActionListener(newFile);
        this.setTitle(title);
        HtmlPanel panel = new HtmlPanel(url);
        this.getContentPane().add((Component)panel, "Center");
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
        }
        super.setVisible(b);
    }

    void JDialogHelp_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == JDialogHelp.this) {
                JDialogHelp.this.JDialogHelp_WindowClosing(event);
            }
        }
    }

    public class HtmlPanel
    extends JPanel
    implements HyperlinkListener {
        JEditorPane html;

        public HtmlPanel(String strUrl) {
            this.setBorder(new EtchedBorder(0));
            this.setLayout(new BorderLayout());
            this.getAccessibleContext().setAccessibleName("HTML panel");
            this.getAccessibleContext().setAccessibleDescription("A panel for viewing HTML documents, and following their links");
            try {
                URL url = new URL(strUrl);
                this.html = new JEditorPane(url);
                this.html.setEditable(false);
                this.html.addHyperlinkListener(this);
                JScrollPane scroller = new JScrollPane();
                scroller.setBorder(new EtchedBorder(1));
                JViewport vp = scroller.getViewport();
                vp.add(this.html);
                vp.setBackingStoreEnabled(true);
                this.add((Component)scroller, "Center");
            }
            catch (MalformedURLException e) {
                System.out.println("Malformed URL: " + e);
            }
            catch (IOException e) {
                System.out.println("IOException: " + e);
            }
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.linkActivated(e.getURL());
            }
        }

        protected void linkActivated(URL u) {
            Cursor c2 = this.html.getCursor();
            Cursor waitCursor = Cursor.getPredefinedCursor(3);
            this.html.setCursor(waitCursor);
            SwingUtilities.invokeLater(new PageLoader(u, c2));
        }

        public class PageLoader
        implements Runnable {
            URL url;
            Cursor cursor;

            PageLoader(URL u, Cursor c2) {
                this.url = u;
                this.cursor = c2;
            }

            @Override
            public void run() {
                if (this.url == null) {
                    HtmlPanel.this.html.setCursor(this.cursor);
                    Container parent = HtmlPanel.this.html.getParent();
                    parent.repaint();
                } else {
                    Document doc = HtmlPanel.this.html.getDocument();
                    try {
                        HtmlPanel.this.html.setPage(this.url);
                    }
                    catch (IOException ioe) {
                        HtmlPanel.this.html.setDocument(doc);
                        HtmlPanel.this.getToolkit().beep();
                    }
                    finally {
                        this.url = null;
                        SwingUtilities.invokeLater(this);
                    }
                }
            }
        }
    }
}

