/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JScrollPaneAdjuster
implements PropertyChangeListener,
Serializable {
    private JScrollPane pane;
    private transient Adjuster x;
    private transient Adjuster y;

    public JScrollPaneAdjuster(JScrollPane pane) {
        this.pane = pane;
        this.x = new Adjuster(pane.getViewport(), pane.getColumnHeader(), 1);
        this.y = new Adjuster(pane.getViewport(), pane.getRowHeader(), 2);
        pane.addPropertyChangeListener(this);
    }

    public void dispose() {
        this.x.dispose();
        this.y.dispose();
        this.pane.removePropertyChangeListener(this);
        this.pane = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("viewport")) {
            this.x.setViewport((JViewport)e.getNewValue());
            this.y.setViewport((JViewport)e.getNewValue());
        } else if (name.equals("rowHeader")) {
            this.y.setHeader((JViewport)e.getNewValue());
        } else if (name.equals("columnHeader")) {
            this.x.setHeader((JViewport)e.getNewValue());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.x = new Adjuster(this.pane.getViewport(), this.pane.getColumnHeader(), 1);
        this.y = new Adjuster(this.pane.getViewport(), this.pane.getRowHeader(), 2);
    }

    private static class Adjuster
    implements ChangeListener,
    Runnable {
        public static final int X = 1;
        public static final int Y = 2;
        private JViewport viewport;
        private JViewport header;
        private int type;

        public Adjuster(JViewport viewport, JViewport header, int type) {
            this.viewport = viewport;
            this.header = header;
            this.type = type;
            if (header != null) {
                header.addChangeListener(this);
            }
        }

        public void setViewport(JViewport newViewport) {
            this.viewport = newViewport;
        }

        public void setHeader(JViewport newHeader) {
            if (this.header != null) {
                this.header.removeChangeListener(this);
            }
            this.header = newHeader;
            if (this.header != null) {
                this.header.addChangeListener(this);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.viewport == null || this.header == null) {
                return;
            }
            if (this.type == 1) {
                if (this.viewport.getViewPosition().x != this.header.getViewPosition().x) {
                    SwingUtilities.invokeLater(this);
                }
            } else if (this.viewport.getViewPosition().y != this.header.getViewPosition().y) {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            if (this.viewport == null || this.header == null) {
                return;
            }
            Point v = this.viewport.getViewPosition();
            Point h = this.header.getViewPosition();
            if (this.type == 1) {
                if (v.x != h.x) {
                    this.viewport.setViewPosition(new Point(h.x, v.y));
                }
            } else if (v.y != h.y) {
                this.viewport.setViewPosition(new Point(v.x, h.y));
            }
        }

        public void dispose() {
            if (this.header != null) {
                this.header.removeChangeListener(this);
            }
            this.header = null;
            this.viewport = null;
        }
    }
}

