/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJToggleField;

public class LatLongJPanel
extends JPanel {
    public static final int LATITUDE = 0;
    public static final int LONGITUDE = 1;
    public static String[] LAT_LIST = new String[]{"N", "S"};
    public static String[] LONG_LIST = new String[]{"E", "W"};
    int _latLong;
    RmaJComboBox directionCombo;
    RmaJToggleField directionField;
    RmaJIntegerField degreesField;
    RmaJIntegerField minutesField;
    RmaJDecimalField secondsField;

    public LatLongJPanel(int latLong) {
        if (latLong != 0 && latLong != 1) {
            throw new IllegalArgumentException("latLong type is invalid");
        }
        this._latLong = latLong;
        Insets insets = new Insets(0, 0, 0, 0);
        this.setLayout(new GridBagLayout());
        this.directionField = latLong == 0 ? new RmaJToggleField('N', 'S', ' ') : new RmaJToggleField('E', 'W', ' ');
        this.directionField.setAllowOtherCase(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.add((Component)this.directionField, gbc);
        this.degreesField = new RmaJIntegerField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add((Component)this.degreesField, gbc);
        JLabel label = new JLabel("d");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add((Component)label, gbc);
        this.minutesField = new RmaJIntegerField();
        this.minutesField.setMinValue(0);
        this.minutesField.setMaxValue(60);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add((Component)this.minutesField, gbc);
        label = new JLabel("'");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add((Component)label, gbc);
        this.secondsField = new RmaJDecimalField();
        this.secondsField.setMinValue(0.0);
        this.secondsField.setMaxValue(60.0);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add((Component)this.secondsField, gbc);
        label = new JLabel("\"");
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add((Component)label, gbc);
        FontMetrics fm = this.degreesField.getFontMetrics(this.degreesField.getFont());
        int width = fm.stringWidth("8888");
        Dimension d = this.degreesField.getPreferredSize();
        d.width = width;
        this.degreesField.setPreferredSize(d);
        this.minutesField.setPreferredSize(d);
        fm = this.secondsField.getFontMetrics(this.secondsField.getFont());
        width = fm.stringWidth("888.88");
        d = this.secondsField.getPreferredSize();
        d.width = (int)(1.5 * (double)width);
        this.secondsField.setPreferredSize(d);
        this.secondsField.setMinimumSize(d);
        this.secondsField.setMaximumSize(d);
    }

    public void setValue(double dms) {
        if (dms < 0.0) {
            this.directionField.setToggleKeyIndex(1);
            dms *= -1.0;
        } else {
            this.directionField.setToggleKeyIndex(0);
        }
        int degrees = (int)(dms / 1000000.0);
        this.degreesField.setValue(degrees);
        int minutes = (int)((dms -= (double)(degrees * 1000000)) / 1000.0);
        this.minutesField.setValue(minutes);
        double seconds = dms - (double)minutes * 1000.0;
        this.secondsField.setValue(seconds);
    }

    public void enableEdit() {
        this.directionField.setEditable(false);
        this.degreesField.setEditable(false);
        this.minutesField.setEditable(false);
        this.secondsField.setEditable(false);
    }

    public void setDegrees(int degrees) {
        if (degrees < 0) {
            this.directionField.setToggleKeyIndex(1);
            degrees *= -1;
        } else {
            this.directionField.setToggleKeyIndex(0);
        }
        this.degreesField.setValue(degrees);
    }

    public void setMinutes(int minutes) {
        if (minutes < 0) {
            minutes *= -1;
        }
        this.minutesField.setValue(minutes);
    }

    public void setSeconds(double seconds) {
        if (seconds < 0.0) {
            seconds *= -1.0;
        }
        this.secondsField.setValue(seconds);
    }

    public double getValue() {
        double dms = this.secondsField.getValue();
        dms += (double)(this.minutesField.getValue() * 1000);
        dms += (double)(this.degreesField.getValue() * 1000000);
        if (this.directionField.getToggleKeyIndex() == 1) {
            dms *= -1.0;
        }
        return dms;
    }

    public int getDegrees() {
        int idx = this.directionField.getToggleKeyIndex();
        int i = 1;
        if (idx == 1) {
            i = -1;
        }
        return this.degreesField.getValue() * i;
    }

    public int getMinutes() {
        return this.minutesField.getValue();
    }

    public double getSeconds() {
        return this.secondsField.getValue();
    }
}

