/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import rma.swing.DesktopManagerListener;
import rma.swing.MDIDesktopPane;
import rma.swing.event.DesktopManagerEvent;

public class MDIDesktopManager
extends DefaultDesktopManager {
    private MDIDesktopPane desktop;
    private boolean _maximizing;
    List _listenerList = new ArrayList();

    public MDIDesktopManager(MDIDesktopPane desktop) {
        this.desktop = desktop;
    }

    public synchronized void addDekstopManagerListner(DesktopManagerListener listener) {
        if (listener == null || this._listenerList.contains(listener)) {
            return;
        }
        this._listenerList.add(listener);
    }

    public synchronized void removeDesktopManagerListener(DesktopManagerListener listener) {
        this._listenerList.remove(listener);
    }

    private void fireFrameActivated(JInternalFrame frame) {
        DesktopManagerEvent e = new DesktopManagerEvent(this, 0, frame);
        for (int i = 0; i < this._listenerList.size(); ++i) {
            ((DesktopManagerListener)this._listenerList.get(i)).frameActivated(e);
        }
    }

    @Override
    public void dragFrame(JComponent f, int newX, int newY) {
        Rectangle dBounds = f.getParent().getBounds();
        if (newX < 0) {
            newX = 0;
        }
        if (newY < 0) {
            newY = 0;
        }
        super.dragFrame(f, newX, newY);
    }

    @Override
    public void endResizingFrame(JComponent f) {
        super.endResizingFrame(f);
        this.resizeDesktop();
    }

    @Override
    public void endDraggingFrame(JComponent f) {
        super.endDraggingFrame(f);
        this.resizeDesktop();
    }

    public void setNormalSize() {
        JScrollPane scrollPane = this.getScrollPane();
        Insets scrollInsets = this.getScrollPaneInsets();
        if (scrollPane != null) {
            Dimension d = scrollPane.getVisibleRect().getSize();
            if (scrollPane.getBorder() != null) {
                d.setSize(d.getWidth() - (double)scrollInsets.left - (double)scrollInsets.right, d.getHeight() - (double)scrollInsets.top - (double)scrollInsets.bottom);
            }
            double width = d.getWidth();
            double height = d.getHeight();
            if (scrollPane.getVerticalScrollBar().isVisible()) {
                width -= (double)scrollPane.getVerticalScrollBar().getWidth();
            }
            if (scrollPane.getHorizontalScrollBar().isVisible()) {
                height -= (double)scrollPane.getVerticalScrollBar().getWidth();
            }
            d.setSize(width, height);
            this.desktop.setAllSize(d);
            scrollPane.invalidate();
            scrollPane.validate();
        }
    }

    private Insets getScrollPaneInsets() {
        JScrollPane scrollPane = this.getScrollPane();
        if (scrollPane == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.getScrollPane().getBorder().getBorderInsets(scrollPane);
    }

    private JScrollPane getScrollPane() {
        JViewport viewPort;
        if (this.desktop.getParent() instanceof JViewport && (viewPort = (JViewport)this.desktop.getParent()).getParent() instanceof JScrollPane) {
            return (JScrollPane)viewPort.getParent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void maximizeFrame(JInternalFrame f) {
        this._maximizing = true;
        try {
            Rectangle p;
            this.setNormalSize();
            this.desktop.setSize(this.desktop.getPreferredSize());
            JScrollPane scrollPane = this.getScrollPane();
            if (scrollPane != null) {
                scrollPane.getVerticalScrollBar().setVisible(false);
                scrollPane.getHorizontalScrollBar().setVisible(false);
            }
            if (!f.isIcon()) {
                JScrollPane pane = this.getScrollPane();
                if (pane != null) {
                    p = pane.getBounds();
                    Insets insets = pane.getInsets();
                    p.width -= insets.left + insets.right;
                    p.height -= insets.top + insets.bottom;
                } else {
                    p = f.getParent().getBounds();
                }
            } else {
                Container c2 = f.getDesktopIcon().getParent();
                if (c2 == null) {
                    return;
                }
                p = c2.getBounds();
                try {
                    f.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            f.setNormalBounds(f.getBounds());
            this.setBoundsForFrame(f, 0, 0, p.width, p.height);
            try {
                f.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.removeIconFor(f);
        }
        finally {
            this._maximizing = false;
        }
    }

    @Override
    public void activateFrame(JInternalFrame f) {
        super.activateFrame(f);
        this.resizeDesktop();
        this.fireFrameActivated(f);
    }

    @Override
    public void openFrame(JInternalFrame f) {
        super.openFrame(f);
        this.resizeDesktop();
    }

    @Override
    public void closeFrame(JInternalFrame f) {
        super.closeFrame(f);
        this.resizeDesktop();
    }

    @Override
    public void minimizeFrame(JInternalFrame f) {
        super.minimizeFrame(f);
        this.resizeDesktop();
    }

    protected void resizeDesktop() {
        if (this._maximizing) {
            return;
        }
        int x = 0;
        int y = 0;
        JScrollPane scrollPane = this.getScrollPane();
        Insets scrollInsets = this.getScrollPaneInsets();
        if (scrollPane != null) {
            JInternalFrame[] allFrames = this.desktop.getAllFrames();
            for (int i = 0; i < allFrames.length; ++i) {
                if (allFrames[i].isMaximum()) {
                    return;
                }
                if (!allFrames[i].isVisible()) continue;
                if (allFrames[i].getX() + allFrames[i].getWidth() > x) {
                    x = allFrames[i].getX() + allFrames[i].getWidth();
                }
                if (allFrames[i].getY() + allFrames[i].getHeight() <= y) continue;
                y = allFrames[i].getY() + allFrames[i].getHeight();
            }
            Dimension d = scrollPane.getVisibleRect().getSize();
            if (scrollPane.getBorder() != null) {
                d.setSize(d.getWidth() - (double)scrollInsets.left - (double)scrollInsets.right, d.getHeight() - (double)scrollInsets.top - (double)scrollInsets.bottom);
            }
            if ((double)x <= d.getWidth()) {
                x = (int)d.getWidth() - 20;
            }
            if ((double)y <= d.getHeight()) {
                y = (int)d.getHeight() - 20;
            }
            this.desktop.setAllSize(x, y);
            scrollPane.invalidate();
            scrollPane.validate();
        }
    }
}

