/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import rma.swing.MDIDesktopManager;

public class MDIDesktopPane
extends JDesktopPane {
    private static final int XOFFSET = 20;
    private static final int YOFFSET = 20;
    private static final Point START = new Point(5, 5);
    private Point cascadeLocation = new Point(START);
    private MDIDesktopManager manager = new MDIDesktopManager(this);
    protected boolean cascadeFrameOnAdd = true;

    public MDIDesktopPane() {
        this.setDesktopManager(this.manager);
        this.setDragMode(1);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.checkDesktopSize();
    }

    public void removeSelectedWindow() {
        JInternalFrame jif = this.getSelectedFrame();
        if (jif != null) {
            this.remove(jif);
        }
    }

    public void cascade() {
        JInternalFrame[] frames = this.getAllFrames();
        this.resetCascade();
        for (int ii = frames.length - 1; ii >= 0; --ii) {
            if (frames[ii].isIcon()) continue;
            this.cascadeFrame(frames[ii]);
        }
        this.checkDesktopSize();
    }

    private void cascadeFrame(JInternalFrame jif) {
        jif.setLocation(this.cascadeLocation);
        Rectangle jifBounds = jif.getBounds();
        Rectangle visBounds = this.getVisibleRect();
        boolean outOfBounds = false;
        if (jifBounds.getHeight() + jifBounds.getY() > visBounds.getHeight()) {
            this.cascadeLocation.y = MDIDesktopPane.START.y;
            outOfBounds = true;
        }
        if (jifBounds.getWidth() + jifBounds.getX() > visBounds.getWidth()) {
            this.cascadeLocation.x = MDIDesktopPane.START.x;
            outOfBounds = true;
        }
        if (outOfBounds) {
            jif.setLocation(this.cascadeLocation);
        }
        this.cascadeLocation.translate(20, 20);
    }

    private void resetCascade() {
        this.cascadeLocation.setLocation(START);
    }

    public Component add(JInternalFrame frame) {
        Component retval = super.add(frame);
        if (this.cascadeFrameOnAdd) {
            this.cascadeFrame(frame);
        }
        return retval;
    }

    @Override
    public void remove(Component c2) {
        super.remove(c2);
        this.checkDesktopSize();
        if (this.getComponentCount() < 1) {
            this.resetCascade();
        }
    }

    public void setAllSize(Dimension d) {
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.setPreferredSize(d);
    }

    public void setAllSize(int width, int height) {
        this.setAllSize(new Dimension(width, height));
    }

    private void checkDesktopSize() {
        if (this.getParent() != null && this.isVisible()) {
            this.manager.resizeDesktop();
        }
    }

    protected void resizeDesktop() {
        this.manager.resizeDesktop();
    }

    public void nextWindow() {
        if (this.getSelectedFrame() != null) {
            this.selectFrame(true);
        }
    }

    public void previousWindow() {
        if (this.getSelectedFrame() != null) {
            this.selectFrame(false);
        }
    }

    public void setCascadeFrameOnAdd(boolean cascade) {
        this.cascadeFrameOnAdd = cascade;
    }

    public boolean shouldCascadeFrameOnAdd() {
        return this.cascadeFrameOnAdd;
    }
}

