/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.model.UserInterface;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;

public class ProgressIndicator
extends RmaJDialog
implements UserInterface {
    private Window _parent;
    private long _max;
    private Runnable _run;
    private Thread _thread;
    private JProgressBar progressBar;
    private JLabel msgLabel;
    private Runnable _progressUpdater;
    private Runnable _msgUpdater;
    private int _currentValue = 1;
    private String _currentMsg = "";

    public ProgressIndicator(JFrame parent, long max, String title) {
        super((Frame)parent, false);
        this._parent = parent;
        this._max = max;
        this.buildControls(title);
    }

    public ProgressIndicator(JDialog parent, long max, String title) {
        super((Dialog)parent, false);
        this._parent = parent;
        this._max = max;
        this.buildControls(title);
    }

    protected void buildControls(String title) {
        this.setSize(250, 60);
        this.setResizable(false);
        this.setTitle(title);
        this.getContentPane().setLayout(new GridBagLayout());
        this.msgLabel = new JLabel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = RmaInsets.insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.msgLabel, gbc);
        this.progressBar = new JProgressBar();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.5;
        gbc.fill = 1;
        gbc.anchor = 15;
        gbc.insets = RmaInsets.insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.progressBar, gbc);
        if (this._max == -1L) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setMaximum((int)this._max);
            this.progressBar.setValue(this._currentValue);
            this.progressBar.setStringPainted(true);
        }
        this._progressUpdater = new Runnable(){

            @Override
            public void run() {
                ProgressIndicator.this.progressBar.setValue(ProgressIndicator.this._currentValue);
            }
        };
        this._msgUpdater = new Runnable(){

            @Override
            public void run() {
                ProgressIndicator.this.msgLabel.setText(ProgressIndicator.this._currentMsg);
            }
        };
    }

    @Override
    public void setProgress(int i) {
        if (i < 1) {
            i = 1;
        }
        if ((long)i > this._max) {
            i = (int)this._max;
        }
        this._currentValue = i + this.progressBar.getValue();
        SwingUtilities.invokeLater(this._progressUpdater);
        Thread.currentThread();
        Thread.yield();
    }

    public void setRunnable(Runnable run) {
        this._run = run;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this._parent.setCursor(new Cursor(3));
            this.setLocationRelativeTo(this.getParent());
            if (this.getParent().isVisible()) {
                super.setVisible(true);
            }
            if (this._run != null) {
                if (this._thread != null) {
                    this._thread.stop();
                    this._thread = null;
                }
                if (this.getParent().isVisible()) {
                    this._thread = new Thread(this._run);
                    this._thread.setPriority(4);
                    this._thread.start();
                } else {
                    this._run.run();
                }
            }
        } else {
            this._parent.setCursor(Cursor.getDefaultCursor());
            super.setVisible(false);
        }
    }

    public void done(Object obj) {
        this.setVisible(false);
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    @Override
    public void computeComplete() {
        this.done(null);
    }

    @Override
    public void printErrorMessage(String msg) {
        this.printMessage(msg);
    }

    @Override
    public void printWarningMessage(String msg) {
        this.printMessage(msg);
    }

    @Override
    public void printStatus(String statusMsg) {
        this.printMessage(statusMsg);
    }

    @Override
    public void printMessage(String msg) {
        if (!this.isVisible()) {
            System.out.println(msg);
            return;
        }
        msg = msg.replace('\n', ' ');
        this.msgLabel.setText(msg);
        this._currentMsg = msg;
        SwingUtilities.invokeLater(this._msgUpdater);
        Thread.currentThread();
        Thread.yield();
    }

    public void setIndeterminate(boolean indeterminate) {
        this.progressBar.setIndeterminate(indeterminate);
        this.progressBar.setStringPainted(false);
    }

    public void setText(String text) {
        this.progressBar.setString(text);
    }
}

