/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import rma.swing.ReplaceListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectActionListener;

public class ReplaceDialog
extends RmaJDialog {
    protected ReplaceListener _replaceListener;
    protected RmaJTextField _matchTextField;
    protected RmaJTextField _replaceTextField;
    protected RmaJComboBox _searchTypeCombo;
    protected RmaJCheckBox _caseSensitiveCheckBox;
    protected RmaJCheckBox _wholeWordCheckBox;
    protected JButton findNext;
    protected JButton replace;
    protected JButton replaceAll;
    protected static final String UP = "Up";
    protected static final String DOWN = "Down";
    protected Object[] SEARCH_TYPES = new Object[]{"Down", "Up"};
    private JLabel _searchTypeLabel;

    public ReplaceDialog(Frame parent, boolean modal, ReplaceListener replaceListener) {
        super(parent, modal);
        this._replaceListener = replaceListener;
        this.buildControls();
    }

    public ReplaceDialog(Dialog parent, ReplaceListener replaceListener) {
        super(parent, parent.isModal());
        this._replaceListener = replaceListener;
        this.buildControls();
    }

    protected ReplaceDialog(Frame parent, boolean modal) {
        super(parent, modal);
    }

    protected void buildControls() {
        this.setTitle("Replace Text");
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel label = new JLabel("Find what:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(10, 5, 0, 5);
        gbc.anchor = 18;
        this.getContentPane().add((Component)label, gbc);
        this._matchTextField = new RmaJTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 5, 0, 5);
        gbc.anchor = 18;
        gbc.ipadx = 150;
        this.getContentPane().add((Component)this._matchTextField, gbc);
        label = new JLabel("Replace with:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.anchor = 18;
        this.getContentPane().add((Component)label, gbc);
        this._replaceTextField = new RmaJTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 2.0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.anchor = 18;
        gbc.ipadx = 150;
        this.getContentPane().add((Component)this._replaceTextField, gbc);
        this._searchTypeLabel = new JLabel("Direction:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(10, 5, 0, 5);
        gbc.anchor = 18;
        this.getContentPane().add((Component)this._searchTypeLabel, gbc);
        this._searchTypeCombo = new RmaJComboBox<Object>(this.SEARCH_TYPES);
        this._searchTypeCombo.setSelectedIndex(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 5, 0, 5);
        gbc.anchor = 18;
        this.getContentPane().add((Component)this._searchTypeCombo, gbc);
        this._wholeWordCheckBox = new RmaJCheckBox("Match whole word only");
        this._wholeWordCheckBox.setMnemonic('W');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.anchor = 18;
        this.getContentPane().add((Component)this._wholeWordCheckBox, gbc);
        this._caseSensitiveCheckBox = new RmaJCheckBox("Match case");
        this._caseSensitiveCheckBox.setMnemonic('M');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 10, 5);
        gbc.anchor = 18;
        this.getContentPane().add((Component)this._caseSensitiveCheckBox, gbc);
        this.findNext = new JButton("Find Next");
        this.findNext.addActionListener(new ReflectActionListener(this, "findNext"));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.anchor = 18;
        this.getContentPane().add((Component)this.findNext, gbc);
        this.findNext.setEnabled(false);
        this.replace = new JButton("Replace");
        this.replace.addActionListener(new ReflectActionListener(this, "replace"));
        this.getRootPane().setDefaultButton(this.replace);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.anchor = 18;
        this.getContentPane().add((Component)this.replace, gbc);
        this.replace.setEnabled(false);
        this.replaceAll = new JButton("Replace All");
        this.replaceAll.addActionListener(new ReflectActionListener(this, "replaceAll"));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.anchor = 18;
        this.getContentPane().add((Component)this.replaceAll, gbc);
        this.replaceAll.setEnabled(false);
        final JButton close = new JButton("Cancel");
        close.addActionListener(new ReflectActionListener(this, "close"));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 4;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.anchor = 18;
        this.getContentPane().add((Component)close, gbc);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ReplaceDialog.this.setVisible(false);
            }

            @Override
            public void windowOpened(WindowEvent e) {
                ReplaceDialog.this._matchTextField.requestFocusInWindow();
            }
        });
        this._matchTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (ReplaceDialog.this._matchTextField.getText().trim().length() > 0) {
                    ReplaceDialog.this.findNext.setEnabled(true);
                    ReplaceDialog.this.replace.setEnabled(true);
                    ReplaceDialog.this.replaceAll.setEnabled(true);
                } else {
                    ReplaceDialog.this.findNext.setEnabled(false);
                    ReplaceDialog.this.replace.setEnabled(false);
                    ReplaceDialog.this.replaceAll.setEnabled(false);
                }
            }
        });
        KeyStroke key = KeyStroke.getKeyStroke(27, 0);
        AbstractAction findAgainAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                close.doClick(0);
            }
        };
        this.getRootPane().getActionMap().put("close", findAgainAction);
        this.getRootPane().getInputMap(1).put(key, "close");
    }

    public void findNext() {
        try {
            String match = this._matchTextField.getText();
            boolean wholeWord = this._wholeWordCheckBox.isSelected();
            boolean caseSensitive = this._caseSensitiveCheckBox.isSelected();
            Object searchType = this._searchTypeCombo.getSelectedItem();
            boolean found = searchType.equals(UP) ? this._replaceListener.selectLastRecord(match, wholeWord, caseSensitive) : this._replaceListener.selectFirstRecord(match, false, wholeWord, caseSensitive);
            if (!found) {
                JOptionPane.showMessageDialog(this.getParent(), match + " not found");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void replace() {
        this.replace(false);
    }

    public void replaceAll() {
        this.replace(true);
    }

    public void replace(boolean all) {
        try {
            String match = this._matchTextField.getText();
            String replaceText = this._replaceTextField.getText();
            boolean wholeWord = this._wholeWordCheckBox.isSelected();
            boolean caseSensitive = this._caseSensitiveCheckBox.isSelected();
            Object searchType = this._searchTypeCombo.getSelectedItem();
            boolean found = all ? this._replaceListener.replaceAll(match, replaceText, wholeWord, caseSensitive) : (searchType.equals(UP) ? this._replaceListener.replaceLastRecord(match, replaceText, wholeWord, caseSensitive) : this._replaceListener.replaceFirstRecord(match, replaceText, false, wholeWord, caseSensitive));
            if (!found) {
                JOptionPane.showMessageDialog(this.getParent(), match + " not found");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.setVisible(false);
    }

    public void setWholeWordCheckBoxText(String newText) {
        this._wholeWordCheckBox.setText(newText);
    }

    public void setShowOptions(boolean optionsShown) {
        this._searchTypeCombo.setVisible(optionsShown);
        this._caseSensitiveCheckBox.setVisible(optionsShown);
        this._wholeWordCheckBox.setVisible(optionsShown);
        this._caseSensitiveCheckBox.setVisible(optionsShown);
        this._searchTypeLabel.setVisible(optionsShown);
    }
}

