/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import rma.util.RMAIO;

public class RmaColor
extends Color {
    public static final Color darkred = Color.red.darker();
    public static final Color lightred = new Color(255, 90, 90);
    public static final Color darkblue = Color.blue.darker();
    public static final Color lightblue = new Color(0, 200, 255);
    public static final Color darkcyan = Color.cyan.darker();
    public static final Color lightcyan = new Color(150, 255, 255);
    public static final Color darkgreen = Color.green.darker();
    public static final Color lightgreen = new Color(150, 255, 150);
    public static final Color darkmagenta = Color.magenta.darker();
    public static final Color lightmagenta = new Color(255, 125, 255);
    public static final Color darkpink = Color.pink.darker();
    public static final Color lightpink = new Color(255, 210, 210);
    public static final Color darkyellow = Color.yellow.darker();
    public static final Color lightyellow = new Color(255, 255, 150);
    public static final Color darkorange = Color.orange.darker();
    public static final Color lightorange = new Color(255, 200, 125);
    public static final Color purple = new Color(128, 0, 128);
    public static final Color lightpurple = purple.brighter();
    public static final Color darkpurple = purple.darker();
    private static List _colorList;

    public RmaColor(int r, int g, int b) {
        super(r, g, b);
    }

    public RmaColor(int r, int g, int b, int a) {
        super(r, g, b, a);
    }

    public RmaColor(int rgb) {
        super(rgb);
    }

    public RmaColor(int rgba, boolean hasalpha) {
        super(rgba, hasalpha);
    }

    public RmaColor(float r, float g, float b) {
        super(r, g, b);
    }

    public RmaColor(float r, float g, float b, float a) {
        super(r, g, b, a);
    }

    public RmaColor(ColorSpace cspace, float[] components, float alpha) {
        super(cspace, components, alpha);
    }

    public static Color parseColorString(String colorString) {
        if (colorString == null) {
            return null;
        }
        colorString = colorString.toLowerCase();
        Color color = null;
        if ("darkGray".equalsIgnoreCase(colorString)) {
            return darkGray;
        }
        if ("gray".equalsIgnoreCase(colorString)) {
            return Color.gray;
        }
        if ("lightGray".equalsIgnoreCase(colorString)) {
            return Color.lightGray;
        }
        if ("lightred".equalsIgnoreCase(colorString)) {
            return lightred;
        }
        if ("lightblue".equalsIgnoreCase(colorString)) {
            return lightblue;
        }
        if ("lightcyan".equalsIgnoreCase(colorString)) {
            return lightcyan;
        }
        if ("lightgreen".equalsIgnoreCase(colorString)) {
            return lightgreen;
        }
        if ("lightmagenta".equalsIgnoreCase(colorString)) {
            return lightmagenta;
        }
        if ("lightyellow".equalsIgnoreCase(colorString)) {
            return lightyellow;
        }
        if ("lightorange".equalsIgnoreCase(colorString)) {
            return lightorange;
        }
        if ("lightpink".equalsIgnoreCase(colorString)) {
            return lightpink;
        }
        if ("purple".equalsIgnoreCase(colorString)) {
            color = purple;
        } else if (colorString.indexOf("blue") > -1) {
            color = Color.blue;
        } else if (colorString.indexOf("black") > -1) {
            color = Color.black;
        } else if (colorString.indexOf("cyan") > -1) {
            color = Color.cyan;
        } else if (colorString.indexOf("green") > -1) {
            color = Color.green;
        } else if (colorString.indexOf("magenta") > -1) {
            color = Color.magenta;
        } else if (colorString.indexOf("pink") > -1) {
            color = Color.pink;
        } else if (colorString.indexOf("red") > -1) {
            color = Color.red;
        } else if (colorString.indexOf("white") > -1) {
            color = Color.white;
        } else if (colorString.indexOf("yellow") > -1) {
            color = Color.yellow;
        } else if (colorString.indexOf("orange") > -1) {
            color = orange;
        } else if (colorString.indexOf("purple") > -1) {
            color = purple;
        } else {
            if (colorString.indexOf(",") > -1) {
                return RmaColor.parseRGBString(colorString);
            }
            try {
                Integer.parseInt(colorString);
                color = Color.decode(colorString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (colorString.startsWith("dark")) {
            color = color.darker();
        } else if (colorString.startsWith("bright") || colorString.startsWith("light")) {
            color = color.brighter();
        }
        return color;
    }

    public static String color2String(Color c2) {
        return RmaColor.color2String(c2, true);
    }

    public static String color2String(Color c2, boolean returnRGBString) {
        if (c2 == null) {
            return null;
        }
        if (c2.equals(Color.red)) {
            return "red";
        }
        if (c2.equals(Color.blue)) {
            return "blue";
        }
        if (c2.equals(Color.black)) {
            return "black";
        }
        if (c2.equals(Color.cyan)) {
            return "cyan";
        }
        if (c2.equals(Color.green)) {
            return "green";
        }
        if (c2.equals(Color.magenta)) {
            return "magenta";
        }
        if (c2.equals(Color.pink)) {
            return "pink";
        }
        if (c2.equals(Color.white)) {
            return "white";
        }
        if (c2.equals(Color.yellow)) {
            return "yellow";
        }
        if (c2.equals(Color.orange)) {
            return "orange";
        }
        if (c2.equals(purple)) {
            return "purple";
        }
        if (c2.equals(Color.darkGray)) {
            return "darkGray";
        }
        if (c2.equals(Color.gray)) {
            return "gray";
        }
        if (c2.equals(Color.lightGray)) {
            return "lightGray";
        }
        if (c2.equals(darkred)) {
            return "darkred";
        }
        if (c2.equals(darkblue)) {
            return "darkblue";
        }
        if (c2.equals(darkcyan)) {
            return "darkcyan";
        }
        if (c2.equals(darkgreen)) {
            return "darkgreen";
        }
        if (c2.equals(darkmagenta)) {
            return "darkmagenta";
        }
        if (c2.equals(darkpink)) {
            return "darkpink";
        }
        if (c2.equals(darkyellow)) {
            return "darkyellow";
        }
        if (c2.equals(darkorange)) {
            return "darkorange";
        }
        if (c2.equals(darkpurple)) {
            return "darkpurple";
        }
        if (c2.equals(lightred)) {
            return "lightred";
        }
        if (c2.equals(lightblue)) {
            return "lightblue";
        }
        if (c2.equals(lightcyan)) {
            return "lightcyan";
        }
        if (c2.equals(lightgreen)) {
            return "lightgreen";
        }
        if (c2.equals(lightmagenta)) {
            return "lightmagenta";
        }
        if (c2.equals(lightpink)) {
            return "lightpink";
        }
        if (c2.equals(lightyellow)) {
            return "lightyellow";
        }
        if (c2.equals(lightorange)) {
            return "lightorange";
        }
        if (c2.equals(lightpurple)) {
            return "lightpurple";
        }
        if (returnRGBString) {
            return RmaColor.getRGBString(c2);
        }
        return "Custom";
    }

    public static String getRGBString(Color c2) {
        int r = c2.getRed();
        int g = c2.getGreen();
        int b = c2.getBlue();
        int a = c2.getAlpha();
        return r + "," + g + "," + b + "," + a;
    }

    public static Color parseRGBString(String rgbaStr) {
        if (rgbaStr == null) {
            return Color.black;
        }
        StringTokenizer strTok = new StringTokenizer(rgbaStr, ",", false);
        int a = 255;
        if (strTok.countTokens() < 3) {
            return Color.black;
        }
        int r = RMAIO.parseInt(strTok.nextToken());
        int g = RMAIO.parseInt(strTok.nextToken());
        int b = RMAIO.parseInt(strTok.nextToken());
        if (strTok.hasMoreTokens()) {
            a = RMAIO.parseInt(strTok.nextToken());
        }
        return new Color(r, g, b, a);
    }

    @Override
    public String toString() {
        return RmaColor.color2String(this, false);
    }

    public static List getColorList() {
        if (_colorList == null) {
            _colorList = new ArrayList(30);
            _colorList.add(RED);
            _colorList.add(BLUE);
            _colorList.add(CYAN);
            _colorList.add(GREEN);
            _colorList.add(MAGENTA);
            _colorList.add(PINK);
            _colorList.add(YELLOW);
            _colorList.add(ORANGE);
            _colorList.add(purple);
            _colorList.add(darkred);
            _colorList.add(darkblue);
            _colorList.add(darkcyan);
            _colorList.add(darkgreen);
            _colorList.add(darkmagenta);
            _colorList.add(darkpink);
            _colorList.add(darkyellow);
            _colorList.add(darkorange);
            _colorList.add(darkpurple);
            _colorList.add(lightred);
            _colorList.add(lightblue);
            _colorList.add(lightcyan);
            _colorList.add(lightgreen);
            _colorList.add(lightmagenta);
            _colorList.add(lightpink);
            _colorList.add(lightyellow);
            _colorList.add(lightorange);
            _colorList.add(lightpurple);
        }
        ArrayList l = new ArrayList(_colorList.size());
        l.addAll(_colorList);
        return l;
    }
}

