/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.ComboBoxEditor;
import javax.swing.border.Border;
import rma.lang.Modifiable;
import rma.swing.EditableComponent;
import rma.swing.FormManagementListener;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTextField;
import rma.swing.RmaValidComponent;

public class RmaComboBoxEditor
implements ComboBoxEditor,
RmaValidComponent,
FocusListener,
MouseMotionListener,
FormManagementListener,
Modifiable,
EditableComponent {
    protected RmaJTextField editor;
    protected RmaJComboBox _comboBox;

    public RmaComboBoxEditor(RmaJComboBox comboBox) {
        this._comboBox = comboBox;
        this.editor = new BorderlessTextField("", 9);
        this.editor.setBorder(null);
        this.addListeners();
    }

    protected void addListeners() {
        this.editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (RmaJTextField.isCursorKey(e.getKeyCode())) {
                    return;
                }
                Object item = RmaComboBoxEditor.this.getItem();
                if (item != null && !item.equals(RmaComboBoxEditor.this._comboBox.getSelectedItem())) {
                    RmaComboBoxEditor.this._comboBox.actionPerformed(new ActionEvent(RmaComboBoxEditor.this.editor, 0, ""));
                }
            }
        });
    }

    @Override
    public void setIsEditable(boolean b) {
        this.editor.setIsEditable(b);
    }

    @Override
    public boolean isModified() {
        return this.editor.isModified();
    }

    @Override
    public void setModified(boolean bool) {
        this.editor.setModified(bool);
    }

    @Override
    public void clearPerformed() {
        this.editor.clearPerformed();
    }

    @Override
    public boolean isValid(boolean showError) {
        return this.editor.isValid(showError);
    }

    @Override
    public Component getEditorComponent() {
        return this.editor;
    }

    @Override
    public void setItem(Object anObject) {
        if (anObject != null) {
            this.editor.setText(anObject.toString());
        } else {
            this.editor.setText("");
        }
    }

    @Override
    public Object getItem() {
        return this.editor.getText();
    }

    @Override
    public void selectAll() {
        this.editor.selectAll();
        this.editor.requestFocus();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.editor.focusGained(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.editor.focusLost(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.editor.mouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.editor.mouseMoved(e);
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.editor.addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.editor.removeActionListener(l);
    }

    static class BorderlessTextField
    extends RmaJTextField {
        public BorderlessTextField(String value, int n) {
            super(value, n);
        }

        @Override
        public void setBorder(Border b) {
        }
    }
}

