/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import com.google.common.flogger.FluentLogger;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import rma.swing.CompositeIconFactory;

public final class RmaImage {
    public static MediaTracker mTracker = new MediaTracker(new JLabel());
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();

    @Deprecated
    public static Image loadURLImage(Component parent, String urlstr) {
        return RmaImage.loadURLImage(urlstr);
    }

    public static Image loadURLImage(String urlstr) {
        if (urlstr == null || urlstr.length() == 0) {
            return null;
        }
        Image image = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL url = cl.getResource(urlstr);
            if (url == null) {
                File f = new File(urlstr);
                url = f.toURI().toURL();
            }
            image = url.getFile() != null && url.getFile().toLowerCase().endsWith(".bmp") ? RmaImage.loadbitmap(url) : RmaImage.loadImageFromUrl(url);
        }
        catch (Exception ex) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)ex)).log("Error loading URL Image: " + urlstr);
        }
        return image;
    }

    public static ImageIcon getImageIcon(String name) {
        Image image = RmaImage.loadURLImage(name);
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }

    public static ImageIcon getImageIcon(URL url) {
        Image image = RmaImage.loadImageFromUrl(url);
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }

    public static Image loadbitmap(URL url) {
        try {
            return ImageIO.read(url);
        }
        catch (IOException e) {
            FluentLogger.Api api = (FluentLogger.Api)LOGGER.atWarning();
            if (((FluentLogger.Api)LOGGER.atFine()).isEnabled()) {
                api = (FluentLogger.Api)api.withCause((Throwable)e);
            }
            api.log("Caught exception in loadbitmap!");
            return null;
        }
    }

    private static Image loadImageFromUrl(URL url) {
        return Toolkit.getDefaultToolkit().getImage(url);
    }

    public static CompositeIconFactory getCompositeIconFactory(String name, int width, int height) {
        ImageIcon img = RmaImage.getImageIcon(name);
        if (img == null) {
            return null;
        }
        return new CompositeIconFactory(img.getImage(), width, height);
    }

    public static synchronized Icon getDisabledIcon(Icon icon) {
        Image img;
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            img = ((ImageIcon)icon).getImage();
        } else {
            img = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Graphics g = img.getGraphics();
            icon.paintIcon(null, g, 0, 0);
        }
        img = GrayFilter.createDisabledImage(img);
        ImageIcon dis_icon = new ImageIcon(img);
        return dis_icon;
    }

    public static synchronized Image getDisabledImage(Image image) {
        if (image == null) {
            return null;
        }
        Image dis_img = GrayFilter.createDisabledImage(image);
        RmaImage.waitForImage(dis_img);
        return dis_img;
    }

    private static void waitForImage(Image img) {
        try {
            mTracker.addImage(img, 0);
            mTracker.waitForID(0);
            mTracker.removeImage(img, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

