/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.client.LookAndFeel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventListener;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import rma.lang.Modifiable;
import rma.swing.RmaInsets;
import rma.swing.RmaJIntegerField;
import rma.swing.text.IntegerDocument;
import rma.util.RMAUtil;

public class RmaIpAddressPanel
extends JPanel
implements Modifiable {
    private RmaJIntegerField _firstOctetFld;
    private RmaJIntegerField _secondOctetFld;
    private RmaJIntegerField _thirdOctetFld;
    private RmaJIntegerField _forthOctetFld;
    private KeyListener _kl;
    private FocusListener _fl;
    private RmaJIntegerField[] _fields = new RmaJIntegerField[4];
    private int _currentFld = 0;
    private boolean _modified;
    private EventListenerList _listenerList = new EventListenerList();

    public RmaIpAddressPanel() {
        super(new GridBagLayout());
        this._fl = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                RmaJIntegerField fl = (RmaJIntegerField)e.getSource();
                fl.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                Component c2 = e.getOppositeComponent();
                boolean focusInField = false;
                for (int i = 0; i < RmaIpAddressPanel.this._fields.length; ++i) {
                    if (RmaIpAddressPanel.this._fields[i] != c2) continue;
                    focusInField = true;
                    break;
                }
                if (!focusInField) {
                    EventListener[] listeners = RmaIpAddressPanel.this._listenerList.getListeners(FocusListener.class);
                    if (listeners == null || listeners.length == 0) {
                        return;
                    }
                    FocusEvent newE = new FocusEvent(RmaIpAddressPanel.this, e.getID());
                    for (int i = listeners.length - 1; i >= 0; --i) {
                        ((FocusListener)listeners[i]).focusLost(newE);
                    }
                }
            }
        };
        this._kl = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                EventListener[] listeners = RmaIpAddressPanel.this._listenerList.getListeners(KeyListener.class);
                if (listeners == null || listeners.length == 0) {
                    return;
                }
                KeyEvent newE = new KeyEvent(RmaIpAddressPanel.this, e.getID(), e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar());
                for (int i = listeners.length - 1; i >= 0; --i) {
                    ((KeyListener)listeners[i]).keyTyped(newE);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                EventListener[] listeners = RmaIpAddressPanel.this._listenerList.getListeners(KeyListener.class);
                if (listeners == null || listeners.length == 0) {
                    return;
                }
                KeyEvent newE = new KeyEvent(RmaIpAddressPanel.this, e.getID(), e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar());
                for (int i = listeners.length - 1; i >= 0; --i) {
                    ((KeyListener)listeners[i]).keyPressed(newE);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                EventListener[] listeners;
                Object obj = e.getSource();
                if (!Character.isDigit(e.getKeyChar())) {
                    return;
                }
                RmaJIntegerField fld = (RmaJIntegerField)obj;
                if (fld.isValid(false) && fld.getText().length() == 3) {
                    if (fld == RmaIpAddressPanel.this._firstOctetFld) {
                        RmaIpAddressPanel.this._secondOctetFld.requestFocus();
                    } else if (fld == RmaIpAddressPanel.this._secondOctetFld) {
                        RmaIpAddressPanel.this._thirdOctetFld.requestFocus();
                    } else if (fld == RmaIpAddressPanel.this._thirdOctetFld) {
                        RmaIpAddressPanel.this._forthOctetFld.requestFocus();
                    }
                }
                if ((listeners = RmaIpAddressPanel.this._listenerList.getListeners(KeyListener.class)) == null || listeners.length == 0) {
                    return;
                }
                KeyEvent newE = new KeyEvent(RmaIpAddressPanel.this, e.getID(), e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar());
                for (int i = listeners.length - 1; i >= 0; --i) {
                    ((KeyListener)listeners[i]).keyReleased(newE);
                }
            }
        };
        Insets labelInsets = RmaInsets.insets(5, 2, 0, 2);
        Insets fldInsets = RmaInsets.insets(0, 0, 0, 0);
        this._firstOctetFld = this.createField();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = fldInsets;
        this.add((Component)this._firstOctetFld, gbc);
        JLabel label = new JLabel(".");
        gbc.gridx = 1;
        gbc.insets = labelInsets;
        this.add((Component)label, gbc);
        this._secondOctetFld = this.createField();
        gbc.gridx = 2;
        gbc.insets = fldInsets;
        this.add((Component)this._secondOctetFld, gbc);
        label = new JLabel(".");
        gbc.gridx = 3;
        gbc.insets = labelInsets;
        this.add((Component)label, gbc);
        this._thirdOctetFld = this.createField();
        gbc.gridx = 4;
        gbc.insets = fldInsets;
        this.add((Component)this._thirdOctetFld, gbc);
        label = new JLabel(".");
        gbc.gridx = 5;
        gbc.insets = labelInsets;
        this.add((Component)label, gbc);
        this._forthOctetFld = this.createField();
        gbc.gridx = 6;
        gbc.insets = fldInsets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this._forthOctetFld, gbc);
    }

    private RmaJIntegerField createField() {
        RmaJIntegerField fld = new RmaJIntegerField();
        ((IntegerDocument)fld.getDocument()).setAllowsNegativeNumbers(false);
        fld.addKeyListener(this._kl);
        fld.setMinValue(0);
        fld.setMaxValue(257);
        fld.setColumns(5);
        fld.addFocusListener(this._fl);
        this._fields[this._currentFld++] = fld;
        return fld;
    }

    public void setEditable(boolean b) {
        for (int i = 0; i < this._fields.length; ++i) {
            this._fields[i].setEditable(b);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        for (int i = 0; i < this._fields.length; ++i) {
            this._fields[i].setEnabled(b);
        }
    }

    public String getText() {
        StringBuffer buf = new StringBuffer(15);
        buf.append(this._firstOctetFld.getValue());
        buf.append(".");
        buf.append(this._secondOctetFld.getValue());
        buf.append(".");
        buf.append(this._thirdOctetFld.getValue());
        buf.append(".");
        buf.append(this._forthOctetFld.getValue());
        return buf.toString();
    }

    public void clearPanel() {
        this.clearPanel(0);
    }

    private void clearPanel(int start) {
        for (int i = start; i < this._fields.length; ++i) {
            this._fields[i].setText("");
        }
    }

    public void setText(String text) {
        if (text == null && text.length() == 0) {
            this.clearPanel();
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(text, ".");
        if (!tokenizer.hasMoreTokens()) {
            this.clearPanel();
            return;
        }
        this._firstOctetFld.setText(tokenizer.nextToken());
        if (!tokenizer.hasMoreTokens()) {
            this.clearPanel(1);
            return;
        }
        this._secondOctetFld.setText(tokenizer.nextToken());
        if (!tokenizer.hasMoreTokens()) {
            this.clearPanel(2);
            return;
        }
        this._thirdOctetFld.setText(tokenizer.nextToken());
        if (!tokenizer.hasMoreTokens()) {
            this.clearPanel(3);
            return;
        }
        this._forthOctetFld.setText(tokenizer.nextToken());
    }

    public void setFirstOctet(String text) {
        this._firstOctetFld.setText(text);
    }

    public void setSecondOctet(String text) {
        this._secondOctetFld.setText(text);
    }

    public void setThirdOctet(String text) {
        this._thirdOctetFld.setText(text);
    }

    public void setForthOctet(String text) {
        this._forthOctetFld.setText(text);
    }

    public static void main(String[] args) {
        LookAndFeel.setLookAndFeel();
        JFrame frame = new JFrame();
        RmaIpAddressPanel panel = new RmaIpAddressPanel();
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    @Override
    public void setModified(boolean modified) {
        this._modified = modified;
        if (this._modified) {
            RMAUtil.setParentModified(this);
        } else {
            RMAUtil.setChildrenUnmodified(this);
        }
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        this._listenerList.add(KeyListener.class, l);
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        super.addFocusListener(l);
        if (l == null || this._listenerList == null) {
            return;
        }
        this._listenerList.add(FocusListener.class, l);
    }
}

