/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.Document;
import rma.swing.RmaJTextField;
import rma.swing.text.MilitaryTimeDocument;
import rma.swing.text.RmaMilitaryTimeVerifier;

public class RmaJ24HourTimeField
extends RmaJTextField {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private NumberFormat numberFormatter = NumberFormat.getNumberInstance(Locale.US);
    private MilitaryTimeDocument mtd;

    public RmaJ24HourTimeField() {
        this.numberFormatter.setGroupingUsed(false);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RmaJ24HourTimeField.this.selectAll();
                    }
                });
            }
        });
        this.setHorizontalAlignment(4);
        this.setInputVerifier(RmaMilitaryTimeVerifier.getVerifier());
        Font f = UIManager.getFont("NumericField.font");
        if (f != null) {
            this.setFont(f);
        }
    }

    public RmaJ24HourTimeField(int value, int columns) {
        super(columns);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RmaJ24HourTimeField.this.selectAll();
                    }
                });
            }
        });
        this.setHorizontalAlignment(4);
        this.setValue(value);
        this.setInputVerifier(RmaMilitaryTimeVerifier.getVerifier());
        Font f = UIManager.getFont("NumericField.font");
        if (f != null) {
            this.setFont(f);
        }
    }

    public int getValue() {
        int retVal = 0;
        try {
            retVal = this.numberFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return retVal;
    }

    public Integer getTextAsInt() {
        return new Integer(this.getValue());
    }

    public void setValue(int value) {
        this.setText(this.numberFormatter.format(value));
    }

    @Override
    protected Document createDefaultModel() {
        this.mtd = new MilitaryTimeDocument();
        return this.mtd;
    }

    public MilitaryTimeDocument getMilitaryTimeDocument() {
        return this.mtd;
    }

    @Override
    protected boolean validateData(boolean showError) {
        return RmaMilitaryTimeVerifier.getVerifier().verify(this);
    }

    public void setAllowMinutes(boolean b) {
        this.mtd.setAllowsMinutes(b);
    }

    public boolean getAllowsMinutes() {
        return this.mtd.getAllowsMinutes();
    }
}

