/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.appInterface.AppDaddy;
import hec.event.AttributeChangedListener;
import hec.map.MapGlyph;
import hec.map.ModeDrawingAttributeSet;
import hec.map.ModelDrawingAttributeSet;
import hec.map.appInterface.MapApplicationFrame;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import rma.swing.RmaGlyphButtonInfo;
import rma.swing.RmaJToolbarButton;
import rma.util.RMAIO;

public class RmaJAttributeToolbarButton
extends RmaJToolbarButton
implements ActionListener,
AttributeChangedListener {
    private static final String DRAW_PROP_LABEL = "Drawing Properties";
    ModelDrawingAttributeSet _modelDas;
    JPopupMenu _popup;
    private String _modeName;
    private MouseAdapter _mouseAdapter;

    public RmaJAttributeToolbarButton(RmaGlyphButtonInfo buttonInfo, String modeName) {
        super(buttonInfo);
        this._modeName = modeName;
        String attrSetName = buttonInfo.getAttributeSetName();
        if (attrSetName == null) {
            return;
        }
        ModeDrawingAttributeSet modeDas = ModeDrawingAttributeSet.getModeAttributeSet(this._modeName);
        if (modeDas == null) {
            return;
        }
        if (modeDas.isExistingAttributeSet(attrSetName)) {
            this._modelDas = modeDas.getModelAttributeSet(attrSetName);
            this._modelDas.addAttributeChangedListener(this);
        }
        this._mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && RmaJAttributeToolbarButton.this.isEnabled() && RmaJAttributeToolbarButton.this.isSelected()) {
                    RmaJAttributeToolbarButton.this.showPopupMenu(e.getPoint());
                }
            }
        };
        this.addMouseListener(this._mouseAdapter);
    }

    public void removeListeners() {
        if (this._modelDas != null) {
            this._modelDas.removeAttributeChangeListener(this);
        }
        this.removeMouseListener(this._mouseAdapter);
    }

    private void showPopupMenu(Point p) {
        if (!this._btnInfo.getGlyphElement().equalsIgnoreCase("shown")) {
            return;
        }
        MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
        MapGlyph glyph = frame.getMapPanel().findGlyphOfClass(this._btnInfo.getMapGlyphClass());
        this._popup = null;
        this._popup = new JPopupMenu();
        if (this._modelDas != null) {
            this.addMenuItems(this._modelDas, this._popup);
        } else if (glyph != null) {
            int size;
            Vector<MapGlyph> v = glyph.glyphVector();
            if (v != null && (size = v.size()) > 0) {
                this._modelDas = null;
                for (int i = 0; i < size; ++i) {
                    ModelDrawingAttributeSet aset;
                    MapGlyph childGlyph = v.get(i);
                    if (childGlyph == null || (aset = childGlyph.getAttributeSet()) == null) continue;
                    JMenu menu = new JMenu(aset.getName());
                    this._popup.add(menu);
                    this.addMenuItems(aset, menu);
                }
            } else if (this._modelDas != null) {
                this.addMenuItems(this._modelDas, this._popup);
            }
        }
        if (this._popup.getComponentCount() > 0) {
            this._popup.show(this, (int)p.getX(), (int)p.getY());
        }
    }

    private void addMenuItems(ModelDrawingAttributeSet aset, JMenu menu) {
        JMenuItem menuItem;
        Hashtable<String, Boolean> h = aset.getAttributes();
        Enumeration<String> e = h.keys();
        String asetName = aset.getName();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            boolean checked = aset.isAttributeShown(key);
            menuItem = new JCheckBoxMenuItem(key, checked);
            menuItem.setName(asetName);
            menuItem.addActionListener(this);
            menu.add(menuItem);
        }
        if (aset.getDrawPropDialogClassname() != null) {
            if (menu.getMenuComponentCount() > 0) {
                menu.addSeparator();
            }
            menuItem = new JMenuItem(DRAW_PROP_LABEL);
            menuItem.setActionCommand(aset.getDrawPropDialogClassname());
            menuItem.addActionListener(this);
            menu.add(menuItem);
        }
    }

    private void addMenuItems(ModelDrawingAttributeSet aset, JPopupMenu popup) {
        JMenuItem menuItem;
        Hashtable<String, Boolean> h = aset.getAttributes();
        Enumeration<String> e = h.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            boolean checked = aset.isAttributeShown(key);
            menuItem = new JCheckBoxMenuItem(key, checked);
            menuItem.addActionListener(this);
            popup.add(menuItem);
        }
        if (this._modelDas.getDrawPropDialogClassname() != null) {
            if (popup.getComponentCount() > 0) {
                popup.addSeparator();
            }
            menuItem = new JMenuItem(DRAW_PROP_LABEL);
            menuItem.setActionCommand(aset.getDrawPropDialogClassname());
            menuItem.addActionListener(this);
            popup.add(menuItem);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem mi;
        Object obj = e.getSource();
        ModelDrawingAttributeSet modelDas = null;
        if (this._modelDas == null) {
            if (obj instanceof JMenuItem) {
                mi = (JMenuItem)obj;
                ModeDrawingAttributeSet modeDas = ModeDrawingAttributeSet.getModeAttributeSet(this._modeName);
                if (modeDas == null) {
                    return;
                }
                modelDas = modeDas.getModelAttributeSet(mi.getName());
            }
        } else {
            modelDas = this._modelDas;
        }
        if (modelDas == null) {
            return;
        }
        if (obj instanceof JCheckBoxMenuItem) {
            mi = (JCheckBoxMenuItem)obj;
            String key = mi.getText();
            boolean checked = mi.isSelected();
            modelDas.setAttribute(key, checked);
            MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
            frame.getMapPanel().paintMap();
        } else if (obj instanceof JMenuItem) {
            mi = (JMenuItem)obj;
            mi.getText().equals(DRAW_PROP_LABEL);
            modelDas.displayDrawPropDialogClass((Frame)((Object)AppDaddy.getFrame()), false);
        }
    }

    public void closeDrawPropDialog() {
        if (this._modelDas == null) {
            return;
        }
        this._modelDas.closeDrawPropDialog();
    }

    @Override
    public void attributeChanged(String model, String attrName, boolean shown) {
        if (!model.equals(this.getGlyphButtonInfo().getAttributeSetName())) {
            return;
        }
        if (attrName.equals(this._btnInfo.getGlyphElement()) && shown != this.isSelected()) {
            this.doClick();
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (e.isAltDown() && e.isControlDown() && e.isShiftDown()) {
            return RMAIO.toHtmlString(this.paramString());
        }
        return super.getToolTipText(e);
    }

    @Override
    public String paramString() {
        return "AttributeSet:" + this._modelDas + "\nModeName=" + this._modeName + "\nButtonInfo:" + this._btnInfo.paramString();
    }
}

