/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.heclib.util.HecTime;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import rma.swing.RmaInsets;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJDateChooserDialog;
import rma.swing.RmaJTextField;
import rma.swing.text.RmaDocument;

public class RmaJCalendarExField
extends RmaJCalendarField {
    HecTime _hecTime = new HecTime();
    HecTime _defaultTime = new HecTime();
    boolean _showYear = true;

    public RmaJCalendarExField() {
        this._defaultTime.setCurrent();
        this.addFocusListener(this);
    }

    public RmaJCalendarExField(boolean showYear) {
        this._showYear = showYear;
        this._defaultTime.setCurrent();
        this.addFocusListener(this);
    }

    @Override
    protected Document createDefaultModel() {
        return new RmaDocument();
    }

    @Override
    public boolean isValid(boolean b) {
        return true;
    }

    @Override
    protected boolean validateData(boolean showError) {
        return true;
    }

    @Override
    protected void configure() {
        this.setHorizontalAlignment(4);
    }

    @Override
    public void displayChooserDialog() {
        Date jdate;
        int stat;
        if (!this.isEditable() || !this.isEnabled()) {
            return;
        }
        if (this._chooserDialog == null) {
            Window c2 = SwingUtilities.windowForComponent(this);
            this._chooserDialog = c2 instanceof Frame ? new RmaJDateChooserDialog((Frame)c2, true) : new RmaJDateChooserDialog((Dialog)c2, true);
        }
        RmaJCalendarField cf = new RmaJCalendarField();
        String text = this.getText();
        this._hecTime.set(this._defaultTime);
        if (text != null && text.length() > 6 && (stat = this._hecTime.setDate(text)) == 0 && (jdate = this._hecTime.getJavaDate(0)) != null) {
            cf.setDate(jdate);
        }
        this._chooserDialog.setDateField(cf);
        this._chooserDialog.setSelectedDate(this._hecTime);
        this._chooserDialog.setVisible(true);
        if (this._chooserDialog.isCanceled()) {
            return;
        }
        String date = this._chooserDialog.getSelectedHecTime().date(7);
        this.setText(date);
        this.requestFocusInWindow();
    }

    @Override
    public void setText(String t) {
        if (!this._showYear && t.length() >= 9) {
            t = t.substring(0, t.length() - 4);
        }
        super.setText(t);
    }

    public void setDefaultDate(HecTime defaultTime) {
        this._defaultTime.set(defaultTime);
    }

    public void setDefaultDate(HecTime defaultTime, boolean showDefault) {
        this._defaultTime.set(defaultTime);
        if (showDefault && this._defaultTime.isDateDefined()) {
            this.setText(this._defaultTime.date(7));
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        this.dateUpdated();
    }

    protected void dateUpdated() {
        String date = this.getText().trim();
        if (date.length() > 4) {
            HecTime htime;
            int len;
            int idx = date.indexOf(45);
            if (idx > 0 && idx + 2 == (len = date.length())) {
                String firstPart = date.substring(0, idx + 1);
                String secondPart = date.substring(idx + 1);
                date = firstPart.concat("0").concat(secondPart);
            }
            if ((htime = new HecTime(date)).isDateDefined()) {
                this.setText(htime.date(7));
            }
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        frame.getContentPane().add((Component)new RmaJCalendarExField(), gbc);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.001;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        frame.getContentPane().add((Component)new RmaJTextField(), gbc);
        frame.setSize(200, 200);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

