/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import rma.swing.DateChooserField;
import rma.swing.RmaJDateChooserDialog;
import rma.swing.RmaJDateField;

public class RmaJCalendarField
extends RmaJDateField
implements DateChooserField {
    private static final String uiClassID = "DateFieldUI";
    protected RmaJDateChooserDialog _chooserDialog = null;
    JButton _ellipsesButton = null;
    private boolean _enableCalenderTool = true;
    private boolean _truncateDefaultTime;
    private String _defaultDateTimeStr;

    public RmaJCalendarField() {
    }

    public RmaJCalendarField(String format, String text) {
        super(format, text);
    }

    public void setTruncateDefaultTime(boolean tf) {
        this._truncateDefaultTime = tf;
    }

    public boolean getTruncateDefaultTime() {
        return this._truncateDefaultTime;
    }

    public void enableCalenderTool(boolean enable) {
        this._enableCalenderTool = enable;
    }

    @Override
    public boolean isCalenderToolEnabled() {
        return this._enableCalenderTool;
    }

    @Override
    protected void configure() {
        super.configure();
        this.setMouseListener();
    }

    private void setMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (!RmaJCalendarField.this._enableCalenderTool) {
                        return;
                    }
                    RmaJCalendarField.this.displayChooserDialog();
                }
            }
        });
    }

    @Override
    public void displayChooserDialog() {
        if (!this.isEditable() || !this.isEnabled()) {
            return;
        }
        if (this._chooserDialog == null) {
            Window c2 = SwingUtilities.windowForComponent(this);
            this._chooserDialog = c2 instanceof Frame ? new RmaJDateChooserDialog((Frame)c2, true) : new RmaJDateChooserDialog((Dialog)c2, true);
        }
        this._chooserDialog.setTimeVisible(this.isTimeVisible());
        this._chooserDialog.setDateField(this);
        Calendar calendar = this.getCalendar();
        if (this._truncateDefaultTime) {
            // empty if block
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        try {
            Date jdate;
            DateFormat dateFormat = this.getDateFormat();
            dateFormat.setTimeZone(calendar.getTimeZone());
            String dateTime = this.getText();
            if (dateTime.isEmpty() && this._defaultDateTimeStr != null) {
                dateTime = this._defaultDateTimeStr;
            }
            if ((jdate = dateFormat.parse(dateTime)) != null) {
                calendar.setTime(jdate);
            }
        }
        catch (ParseException dateFormat) {
            // empty catch block
        }
        this._chooserDialog.setSelectedDate(calendar);
        this._chooserDialog.setVisible(true);
        if (this._chooserDialog.isCanceled()) {
            return;
        }
        String date = this._chooserDialog.getSelectedHecTime().date(104);
        Calendar cal = this._chooserDialog.getSelectedDate();
        this.setDate(cal);
    }

    protected Calendar getCalendar() {
        return new GregorianCalendar();
    }

    protected boolean isTimeVisible() {
        return false;
    }

    protected void setDate(Calendar cal) {
        Object date = cal.getTime().toString();
        switch (this.getDateDocument().getFormat()) {
            case 9: {
                date = ((String)date).substring(8, 10) + ((String)date).substring(4, 7) + ((String)date).substring(((String)date).length() - 4);
                this.setText((String)date);
                this.setModified(true);
                break;
            }
            case 5: {
                date = ((String)date).substring(8, 10) + ((String)date).substring(4, 7);
                this.setText((String)date);
                this.setModified(true);
                break;
            }
            case 3: {
                date = ((String)date).substring(4, 7);
                this.setText((String)date);
                this.setModified(true);
                break;
            }
            case 4: {
                date = ((String)date).substring(24, 28);
                this.setText((String)date);
                this.setModified(true);
                break;
            }
            case 7: {
                date = ((String)date).substring(4, 7) + ((String)date).substring(24, 28);
                this.setText((String)date);
                this.setModified(true);
            }
        }
        this.requestFocusInWindow();
    }

    @Override
    public void setText(String txt) {
        this.setIgnoreModifiedEvents(true);
        try {
            super.setText(txt);
            this.setModified(true);
        }
        finally {
            this.setIgnoreModifiedEvents(false);
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setDefaultTime(String dateAndTime) {
        this._defaultDateTimeStr = dateAndTime;
    }

    public String getDefaultTime() {
        return this._defaultDateTimeStr;
    }

    static {
        UIManager.put(uiClassID, "rma.swing.plaf.basic.BasicDateFieldUI");
    }
}

