/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.data.Units;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import rma.lang.Modifiable;
import rma.services.units.UnitsComponent;
import rma.swing.EditableComponent;
import rma.swing.FormManagementListener;
import rma.swing.RmaJLabel;
import rma.swing.RmaValidComponent;
import rma.util.RMAUtil;

public class RmaJCheckBox
extends JCheckBox
implements ItemListener,
FormManagementListener,
RmaValidComponent,
Modifiable,
EditableComponent,
UnitsComponent {
    private boolean _modified = false;
    private boolean _modifiable = true;
    private Color _changeColor = null;
    private int _unitSystem;
    String _templateLabel = "";
    protected Component _labelFor = null;
    static final String LABELED_BY_PROPERTY = "labeledBy";

    public RmaJCheckBox() {
    }

    public RmaJCheckBox(String text, boolean selected) {
        super(text, selected);
        this._templateLabel = text;
        this.addItemListener(this);
    }

    public RmaJCheckBox(String text, Icon icon) {
        super(text, icon);
        this._templateLabel = text;
        this.addItemListener(this);
    }

    public RmaJCheckBox(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this._templateLabel = text;
        this.addItemListener(this);
    }

    public RmaJCheckBox(String text) {
        super(text);
        this._templateLabel = text;
        this.addItemListener(this);
    }

    public RmaJCheckBox(Icon icon) {
        super(icon);
        this.addItemListener(this);
    }

    public RmaJCheckBox(Icon icon, boolean selected) {
        super(icon, selected);
        this.addItemListener(this);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this._templateLabel = text;
    }

    @Override
    public void clearPerformed() {
    }

    @Override
    public boolean isValid(boolean showError) {
        return true;
    }

    @Override
    public void setSelected(boolean selected) {
        this.removeItemListener(this);
        super.setSelected(selected);
        this.addItemListener(this);
    }

    @Override
    public void setDisplayScaleFactor(int paramId, double scaleFactor) {
    }

    public int getDisplayUnitSystem() {
        return this._unitSystem;
    }

    @Override
    public void setDisplayUnitsSystem(int unitSystem) {
        if (!Units.isValidUnitsSystem(unitSystem)) {
            throw new IllegalArgumentException("Invalid Unit System");
        }
        this._unitSystem = unitSystem;
        Component c2 = this.getLabelFor();
        if (c2 != null && c2 instanceof UnitsComponent && this._templateLabel.length() > 0) {
            UnitsComponent uc = (UnitsComponent)((Object)c2);
            super.setText(RmaJLabel.replaceUnitsTemplate(this._templateLabel, uc.getDisplayUnitsString(this._unitSystem)));
        }
    }

    @Override
    public String getDisplayUnitsString(int unitSystem) {
        Component c2 = this.getLabelFor();
        if (c2 == null || !(c2 instanceof UnitsComponent)) {
            return "";
        }
        return ((UnitsComponent)((Object)c2)).getDisplayUnitsString(this._unitSystem);
    }

    public void setLabelFor(Component c2) {
        Component oldC = this._labelFor;
        this._labelFor = c2;
        this.firePropertyChange("labelFor", oldC, c2);
        if (oldC instanceof JComponent) {
            ((JComponent)oldC).putClientProperty(LABELED_BY_PROPERTY, null);
        }
        if (c2 instanceof JComponent) {
            ((JComponent)c2).putClientProperty(LABELED_BY_PROPERTY, this);
        }
    }

    public Component getLabelFor() {
        return this._labelFor;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.setModified(true);
    }

    @Override
    public void setModified(boolean b) {
        this._modified = b;
        if (b) {
            RMAUtil.setParentModified(this);
            if (this._changeColor != null) {
                this.setForeground(this._changeColor);
            }
        } else if (this._changeColor != null && this._changeColor == this.getForeground()) {
            this.setForeground(UIManager.getColor("CheckBox.foreground"));
        }
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setIsEditable(boolean b) {
        if (this._modifiable) {
            this.setEnabled(b);
        }
    }

    public void setModifiable(boolean b) {
        this._modifiable = b;
    }

    public void setChangeColor(Color changeColor) {
        this._changeColor = changeColor;
        if (!this._modifiable) {
            this.setModifiable(true);
        }
    }
}

