/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import rma.swing.RmaJList;
import rma.swing.event.CheckBoxToggleEvent;
import rma.swing.event.CheckBoxToggleListener;
import rma.swing.list.CheckListRenderer;
import rma.swing.list.CheckableListItem;
import rma.swing.list.RmaListModel;

public class RmaJCheckBoxList
extends RmaJList {
    int _lastIndex = -1;
    Rectangle iconRect;

    public RmaJCheckBoxList() {
        this.init(null);
    }

    public RmaJCheckBoxList(Vector listData) {
        this.init(this.createData(listData));
    }

    public RmaJCheckBoxList(Object[] listData) {
        this.init(this.createData(listData));
    }

    protected void init(CheckableListItem[] data) {
        Icon icon = UIManager.getIcon("CheckBox.icon");
        this.iconRect = new Rectangle(0, 0, icon.getIconWidth(), icon.getIconHeight());
        if (data != null) {
            super.setModel(new RmaListModel<CheckableListItem>(false, data));
        } else {
            super.setModel(new RmaListModel(false));
        }
        this.setCellRenderer(new CheckListRenderer());
        this.setSelectionMode(0);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmaJCheckBoxList.this.toggle(RmaJCheckBoxList.this.getSelectedIndex());
            }
        }, KeyStroke.getKeyStroke(32, 0, true), 1);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (RmaJCheckBoxList.this.isEnabled() && SwingUtilities.isLeftMouseButton(e)) {
                    Point p = e.getPoint();
                    int width = (int)(RmaJCheckBoxList.this.iconRect.getWidth() + (double)((CheckListRenderer)RmaJCheckBoxList.this.getCellRenderer()).getMargin().left + 2.0);
                    int index = RmaJCheckBoxList.this.locationToIndex(e.getPoint());
                    if (index > -1 && p.getX() <= (double)width) {
                        RmaJCheckBoxList.this.toggle(index);
                    }
                }
            }
        });
    }

    public void toggle(int index) {
        if (index < 0 || index >= this.getModel().getSize()) {
            return;
        }
        CheckableListItem item = (CheckableListItem)this.getModel().getElementAt(index);
        if (item == null) {
            return;
        }
        item.setSelected(!item.isSelected());
        Rectangle rect = this.getCellBounds(index, index);
        this.fireCheckBoxToggled(index, item.isSelected());
        this.repaint(rect);
    }

    public void setSelected(int index, boolean selected) {
        if (index < 0 || index >= this.getModel().getSize()) {
            return;
        }
        CheckableListItem item = (CheckableListItem)this.getModel().getElementAt(index);
        if (item == null) {
            return;
        }
        item.setSelected(selected);
        this.fireCheckBoxToggled(index, selected);
        Rectangle rect = this.getCellBounds(index, index);
        this.repaint(rect);
    }

    public boolean isSelectedValue(int index) {
        if (index < 0 || index >= this.getModel().getSize()) {
            return false;
        }
        Object obj = ((RmaListModel)this.getModel()).elementAt(index);
        if (obj instanceof CheckableListItem) {
            return ((CheckableListItem)obj).isSelected();
        }
        return false;
    }

    public boolean isSelectedValue(Object obj) {
        if (obj == null) {
            return false;
        }
        Vector v = ((RmaListModel)this.getModel()).getVector();
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            CheckableListItem item;
            Object vObj = v.elementAt(i);
            if (!(vObj instanceof CheckableListItem) || (item = (CheckableListItem)vObj).getObject() != obj && !item.getObject().equals(obj)) continue;
            return item.isSelected();
        }
        return false;
    }

    public Object getValueAt(int index) {
        if (index < 0 || index >= this.getModel().getSize()) {
            return null;
        }
        Object obj = ((RmaListModel)this.getModel()).elementAt(index);
        if (obj instanceof CheckableListItem) {
            return ((CheckableListItem)obj).getObject();
        }
        return obj;
    }

    public boolean contains(Object obj) {
        if (obj == null) {
            return false;
        }
        Vector v = ((RmaListModel)this.getModel()).getVector();
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            Object vObj = v.elementAt(i);
            if (!(vObj instanceof CheckableListItem) || ((CheckableListItem)vObj).getObject() != obj && !((CheckableListItem)vObj).getObject().equals(obj)) continue;
            return true;
        }
        return false;
    }

    public Object removeValueAt(int index) {
        Object obj = this.getValueAt(index);
        if (obj != null) {
            ((RmaListModel)this.getModel()).removeElementAt(index);
        }
        return obj;
    }

    public void insertValueAt(Object obj, int index) {
        if (index < 0 || obj == null) {
            return;
        }
        if (!(obj instanceof CheckableListItem)) {
            obj = new CheckableListItem(obj);
        }
        if (index > this.getModel().getSize()) {
            ((RmaListModel)this.getModel()).addElement(obj);
        } else {
            ((RmaListModel)this.getModel()).insertElementAt(obj, index);
        }
    }

    public boolean spinUp(int index) {
        return this.spin(index, true);
    }

    public boolean spinDown(int index) {
        return this.spin(index, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean spin(int index, boolean moveUp) {
        if (index < 0 || index >= this.getModel().getSize()) {
            return false;
        }
        if (moveUp && index > 0) {
            Object obj = ((RmaListModel)this.getModel()).elementAt(index);
            if (obj == null) {
                return false;
            }
            ((RmaListModel)this.getModel()).removeElementAt(index);
            if (obj == null) return false;
            this.insertValueAt(obj, --index);
            return true;
        } else {
            if (moveUp || index >= this.getModel().getSize() - 1) return false;
            Object obj = ((RmaListModel)this.getModel()).elementAt(index);
            if (obj == null) {
                return false;
            }
            ((RmaListModel)this.getModel()).removeElementAt(index);
            if (obj == null) return false;
            this.insertValueAt(obj, ++index);
        }
        return true;
    }

    @Override
    public Object getSelectedValue() {
        Object selObj = super.getSelectedValue();
        if (selObj != null && selObj instanceof CheckableListItem) {
            return ((CheckableListItem)selObj).getObject();
        }
        return selObj;
    }

    @Override
    public Object[] getSelectedValues() {
        Object[] selObjs = super.getSelectedValues();
        if (selObjs != null && selObjs.length > 0) {
            for (int i = 0; i < selObjs.length; ++i) {
                if (!(selObjs[i] instanceof CheckableListItem)) continue;
                selObjs[i] = ((CheckableListItem)selObjs[i]).getObject();
            }
        }
        return selObjs;
    }

    public Object[] getCheckedValues() {
        int size = ((RmaListModel)this.getModel()).getSize();
        Object[] tmpObjs = new Object[size];
        int idx = 0;
        for (int i = 0; i < size; ++i) {
            Object obj = ((RmaListModel)this.getModel()).elementAt(i);
            if (!(obj instanceof CheckableListItem) || !((CheckableListItem)obj).isSelected()) continue;
            tmpObjs[idx++] = ((CheckableListItem)obj).getObject();
        }
        Object[] checkedObjs = new Object[idx];
        System.arraycopy(tmpObjs, 0, checkedObjs, 0, idx);
        return checkedObjs;
    }

    public int[] getCheckedIndexes() {
        int size = ((RmaListModel)this.getModel()).getSize();
        int[] tmpObjs = new int[size];
        int idx = 0;
        for (int i = 0; i < size; ++i) {
            Object obj = ((RmaListModel)this.getModel()).elementAt(i);
            if (!(obj instanceof CheckableListItem) || !((CheckableListItem)obj).isSelected()) continue;
            tmpObjs[idx++] = i;
        }
        int[] checkedObjs = new int[idx];
        System.arraycopy(tmpObjs, 0, checkedObjs, 0, idx);
        return checkedObjs;
    }

    public void setModel() {
    }

    @Override
    public void setListData(Vector listData) {
        ((RmaListModel)this.getModel()).removeAllElements();
        ((RmaListModel)this.getModel()).addAll(this.createData(listData));
    }

    @Override
    public void setListData(Object[] listData) {
        ((RmaListModel)this.getModel()).removeAllElements();
        ((RmaListModel)this.getModel()).addAll(this.createData(listData));
    }

    public void addItem(Object listItem) {
        if (listItem instanceof CheckableListItem) {
            Object obj = listItem;
        } else {
            CheckableListItem obj = new CheckableListItem(listItem);
        }
        ((RmaListModel)this.getModel()).addElement(listItem);
    }

    private CheckableListItem[] createData(Object[] objs) {
        int n = objs.length;
        CheckableListItem[] items = new CheckableListItem[n];
        for (int i = 0; i < n; ++i) {
            items[i] = objs[i] instanceof CheckableListItem ? (CheckableListItem)objs[i] : new CheckableListItem(objs[i]);
        }
        return items;
    }

    private CheckableListItem[] createData(Vector objs) {
        int n = objs.size();
        CheckableListItem[] items = new CheckableListItem[n];
        for (int i = 0; i < n; ++i) {
            Object obj = objs.elementAt(i);
            items[i] = obj instanceof CheckableListItem ? (CheckableListItem)obj : new CheckableListItem(obj);
        }
        return items;
    }

    protected void fireCheckBoxToggled(int index, boolean selected) {
        Object[] listeners = this.listenerList.getListenerList();
        CheckBoxToggleEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CheckBoxToggleListener.class) continue;
            if (e == null) {
                e = new CheckBoxToggleEvent(this, index, selected);
            }
            ((CheckBoxToggleListener)listeners[i + 1]).checkBoxToggled(e);
        }
    }

    public void addCheckBoxToggleListener(CheckBoxToggleListener l) {
        this.listenerList.add(CheckBoxToggleListener.class, l);
    }

    public void removeCheckBoxToggleListener(CheckBoxToggleListener l) {
        this.listenerList.remove(CheckBoxToggleListener.class, l);
    }

    @Override
    public void setEnabled(boolean b) {
        if (!b) {
            this.clearSelection();
        }
        super.setEnabled(b);
    }
}

