/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import rma.lang.Modifiable;
import rma.swing.EditableComponent;
import rma.swing.FormManagementListener;
import rma.swing.RmaValidComponent;
import rma.util.RMAUtil;

public class RmaJColorButton
extends JButton
implements ActionListener,
FormManagementListener,
RmaValidComponent,
Modifiable,
EditableComponent {
    protected Color _color = Color.gray;
    private boolean _modified;
    private boolean _modifiable = true;
    private int _colorWidth = 12;
    private int _colorHeight = 12;
    private String _chooserTitle;

    public RmaJColorButton() {
        this.addActionListener(this);
        this.setColor(this.getBackground());
    }

    public RmaJColorButton(boolean enableColorChooser) {
        if (enableColorChooser) {
            this.addActionListener(this);
        }
        this.setColor(this.getBackground());
    }

    public RmaJColorButton(Color c2) {
        this.addActionListener(this);
        this.setColor(c2);
    }

    public void setColorIconWidth(int w) {
        this._colorWidth = w;
    }

    public int getColorIconWidth() {
        return this._colorWidth;
    }

    public void setColorIconHeight(int h) {
        this._colorHeight = h;
    }

    public int getColorIconHeight() {
        return this._colorHeight;
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color c2) {
        this._color = c2;
        this.setIcon(this.getColorIcon(this._color));
        this.fireStateChanged();
    }

    protected ImageIcon getColorIcon(Color c2) {
        int rgb = c2 == null ? this.getBackground().getRGB() : c2.getRGB();
        int w = this._colorWidth;
        int h = this._colorHeight;
        int[] pix = new int[h * w];
        for (int ii = 0; ii < pix.length; ++ii) {
            pix[ii] = rgb;
        }
        MemoryImageSource mis = new MemoryImageSource(w, h, pix, 0, w);
        Image img = Toolkit.getDefaultToolkit().createImage(mis);
        ImageIcon imgIcon = new ImageIcon(img);
        return imgIcon;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Window w = SwingUtilities.windowForComponent(this);
        Color newColor = null;
        newColor = RMAUtil.colorChooser(w, this._color, this._chooserTitle);
        this.setColor(newColor);
        this.setModified(true);
    }

    @Override
    public void setModified(boolean b) {
        this._modified = b;
        if (b) {
            RMAUtil.setParentModified(this);
        }
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setIsEditable(boolean b) {
        if (this._modifiable) {
            this.setEnabled(b);
        }
    }

    public void setModifiable(boolean b) {
        this._modifiable = b;
    }

    @Override
    public void clearPerformed() {
    }

    @Override
    public boolean isValid(boolean showError) {
        return true;
    }

    public void setChooserTitle(String title) {
        this._chooserTitle = title;
    }

    public String getChooserTitle() {
        return this._chooserTitle;
    }
}

