/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import rma.swing.EditableComponent;
import rma.swing.FormManagementListener;
import rma.swing.RmaValidComponent;

public class RmaJColorChooserButton
extends JButton
implements ActionListener,
FormManagementListener,
RmaValidComponent,
EditableComponent {
    private Color _color;
    private final JColorChooser _colorChooser = new JColorChooser();
    private PropertyChangeListener _sampleListener;
    public static final String PROPERTY_COLOR = "RmaJColorChooserButton.Property.Color";
    private static final int WIDTH = 12;
    private static final int HEIGHT = 12;

    public RmaJColorChooserButton() {
        this.addActionListener(this);
        this.setColor(this.getBackground());
    }

    public RmaJColorChooserButton(Color color) {
        this();
        this.setColor(color);
    }

    public void addSampleListener(PropertyChangeListener listener) {
        this._sampleListener = listener;
    }

    public PropertyChangeListener getSampleListener() {
        return this._sampleListener;
    }

    public void setColor(Color c2) {
        this._color = c2;
        this.setIcon(this.getColorIcon(this._color));
        this.fireStateChanged();
    }

    public Color getColor() {
        return this._color;
    }

    protected ImageIcon getColorIcon(Color c2) {
        int rgb = c2 == null ? this.getBackground().getRGB() : c2.getRGB();
        int[] pix = new int[144];
        for (int ii = 0; ii < pix.length; ++ii) {
            pix[ii] = rgb;
        }
        MemoryImageSource mis = new MemoryImageSource(12, 12, pix, 0, 12);
        Image img = Toolkit.getDefaultToolkit().createImage(mis);
        return new ImageIcon(img);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ActionListener okListener = evt -> {
            if (this._sampleListener != null) {
                PropertyChangeEvent colorEvent = new PropertyChangeEvent(this, PROPERTY_COLOR, this.getColor(), this._colorChooser.getColor());
                this._sampleListener.propertyChange(colorEvent);
            }
            this.setColor(this._colorChooser.getColor());
        };
        ActionListener cancelListener = evt -> {};
        JDialog chooserDialog = JColorChooser.createDialog(this, "Choose a New Color", true, this._colorChooser, okListener, cancelListener);
        chooserDialog.setResizable(false);
        chooserDialog.setVisible(true);
    }

    @Override
    public void clearPerformed() {
    }

    @Override
    public boolean isValid(boolean showError) {
        return true;
    }

    @Override
    public void setIsEditable(boolean b) {
        this.setEnabled(b);
    }
}

