/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import rma.swing.RmaJComboBox;
import rma.swing.list.RmaListModel;
import rma.swing.table.RmaColorRenderer;
import rma.text.ColorFormatter;

public class RmaJColorComboBox2
extends RmaJComboBox {
    private Object[] _modelList = new Object[ColorFormatter.colorNames.length];
    private Object[] _lineCustomColor = new Object[]{Color.white, "Custom"};
    private RmaListModel _comboModel;
    private static JColorChooser _colorChooser;
    private ColorItemListener _itemListener;

    public RmaJColorComboBox2() {
        for (int i = 0; i < ColorFormatter.colorNames.length; ++i) {
            this._modelList[i] = new Object[]{ColorFormatter.colors[i], ColorFormatter.colorNames[i]};
        }
        this._comboModel = new RmaListModel<Object>(false, this._modelList);
        super.setModel(this._comboModel);
        this.setRenderer(new RmaColorRenderer());
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item instanceof Color) {
            this.setSelectedColor((Color)item);
        } else if (item instanceof String) {
            this.setSelectedColorName((String)item);
        } else {
            super.setSelectedItem(item);
        }
    }

    public void setModel() {
    }

    public void setAllowsCustomColor(boolean allowCustom) {
        if (allowCustom) {
            if (this._comboModel.getIndexOf(this._lineCustomColor) == -1) {
                this.addItem(this._lineCustomColor);
                this._itemListener = new ColorItemListener();
                this.addItemListener(this._itemListener);
            }
        } else {
            this._comboModel.removeElement(this._lineCustomColor);
            if (this._itemListener != null) {
                this.removeItemListener(this._itemListener);
            }
        }
    }

    public Color getSelectedColor() {
        Object o = this.getSelectedItem();
        if (o instanceof Object[]) {
            Object[] oa = (Object[])o;
            return (Color)oa[0];
        }
        return null;
    }

    public String getSelectedColorName() {
        Object o = this.getSelectedItem();
        if (o instanceof Object[]) {
            Object[] oa = (Object[])o;
            return (String)oa[1];
        }
        return "Custom";
    }

    public void setSelectedColorName(String name) {
        Vector v = this._comboModel.getVector();
        for (int i = 0; i < v.size(); ++i) {
            Object[] ia = (Object[])v.get(i);
            if (!ia[1].equals(name)) continue;
            if (this._itemListener != null) {
                this.removeItemListener(this._itemListener);
            }
            this.setSelectedIndex(i);
            if (this._itemListener == null) break;
            this.addItemListener(this._itemListener);
            break;
        }
    }

    public void setSelectedColor(Color color) {
        Vector v = this._comboModel.getVector();
        for (int i = 0; i < v.size(); ++i) {
            Object[] ia = (Object[])v.get(i);
            if (!ia[0].equals(color)) continue;
            if (this._itemListener != null) {
                this.removeItemListener(this._itemListener);
            }
            this.setSelectedIndex(i);
            if (this._itemListener != null) {
                this.addItemListener(this._itemListener);
            }
            return;
        }
        if (this._itemListener != null) {
            this._lineCustomColor[0] = color;
            if (this._itemListener != null) {
                this.removeItemListener(this._itemListener);
            }
            this.setSelectedIndex(this.getItemCount() - 1);
            if (this._itemListener != null) {
                this.addItemListener(this._itemListener);
            }
        }
    }

    @Override
    public String getToolTipText() {
        Object o = this.getSelectedItem();
        if (o instanceof Object[]) {
            Object[] oa = (Object[])o;
            return (String)oa[1];
        }
        if (o != null) {
            return "Custom";
        }
        return null;
    }

    private void colorSelected() {
        JDialog dlg = JColorChooser.createDialog(this, "Choose A Color", true, this.getColorChooser(), new LineCustomColorOKListener(), null);
        dlg.setVisible(true);
    }

    private JColorChooser getColorChooser() {
        if (_colorChooser == null) {
            _colorChooser = new JColorChooser();
        }
        _colorChooser.setColor(this.getSelectedColor());
        return _colorChooser;
    }

    private class ColorItemListener
    implements ItemListener {
        private ColorItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                return;
            }
            if (RmaJColorComboBox2.this.getSelectedItem() == RmaJColorComboBox2.this._lineCustomColor) {
                RmaJColorComboBox2.this.colorSelected();
            }
        }
    }

    private class LineCustomColorOKListener
    implements ActionListener {
        private LineCustomColorOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RmaJColorComboBox2.this.removeItemListener(RmaJColorComboBox2.this._itemListener);
            RmaJColorComboBox2.this._comboModel.removeElement(RmaJColorComboBox2.this._lineCustomColor);
            RmaJColorComboBox2.this._lineCustomColor[0] = _colorChooser.getColor();
            RmaJColorComboBox2.this.addItem(RmaJColorComboBox2.this._lineCustomColor);
            RmaJColorComboBox2.this.setSelectedIndex(RmaJColorComboBox2.this.getItemCount() - 1);
            RmaJColorComboBox2.this.addItemListener(RmaJColorComboBox2.this._itemListener);
            RmaJColorComboBox2.this.revalidate();
            RmaJColorComboBox2.this.repaint();
        }
    }
}

