/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import rma.lang.Modifiable;
import rma.swing.EditableComponent;
import rma.swing.FormManagementListener;
import rma.swing.RmaValidComponent;
import rma.util.RMAUtil;

public class RmaJComboBox<E>
extends JComboBox<E>
implements RmaValidComponent,
FormManagementListener,
ItemListener,
Modifiable,
EditableComponent {
    boolean _fixedSize = true;
    Dimension _preferredSize = null;
    Dimension _maxSize = null;
    Dimension _minSize = null;
    private boolean _modified = false;
    private boolean _modifiable = false;
    private Color _changeColor = null;
    private boolean _listenToFormManager = false;
    private boolean _toolTipTextOverridden = false;

    public RmaJComboBox(Vector<E> items) {
        super(items);
        this.init();
    }

    public RmaJComboBox() {
        this.init();
    }

    public RmaJComboBox(ComboBoxModel<E> aModel) {
        super(aModel);
        this.init();
    }

    public RmaJComboBox(E[] items) {
        super(items);
        this.init();
    }

    protected void init() {
        AbstractAction copyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmaJComboBox.this.copy();
            }
        };
        this.getActionMap().put("Copy", copyAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(67, 128), "Copy");
    }

    public void copy() {
        Object sel = this.getSelectedItem();
        if (sel == null) {
            return;
        }
        String str = sel.toString();
        if (str == null) {
            return;
        }
        StringSelection contents = new StringSelection(str);
        Clipboard cb = this.getToolkit().getSystemClipboard();
        try {
            cb.setContents(contents, null);
        }
        catch (Exception e) {
            System.out.println("copy:Exception " + e);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getSource() == this && event.getStateChange() == 1) {
            this.setModified(true);
        }
    }

    @Override
    public void removeAllItems() {
        if (this.getItemCount() > 0) {
            super.removeAllItems();
        }
    }

    private void setBorder() {
        Border border = UIManager.getBorder("TextField.border");
        super.setBorder(border);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._fixedSize) {
            if (this._preferredSize == null) {
                this._preferredSize = super.getPreferredSize();
            }
            return this._preferredSize;
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this._fixedSize) {
            if (this._maxSize == null) {
                this._maxSize = super.getMaximumSize();
            }
            return this._maxSize;
        }
        return super.getMaximumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this._fixedSize) {
            if (this._minSize == null) {
                this._minSize = super.getMinimumSize();
            }
            return this._minSize;
        }
        return super.getMinimumSize();
    }

    @Override
    public void setSelectedIndex(int anIndex) {
        super.setSelectedIndex(anIndex);
        this.setToolTipText();
    }

    @Override
    public void setSelectedItem(Object anObject) {
        super.setSelectedItem(anObject);
        this.setToolTipText();
    }

    @Override
    public void setToolTipText(String s) {
        this._toolTipTextOverridden = s != null;
        super.setToolTipText(s);
    }

    protected void setToolTipText() {
        if (this._toolTipTextOverridden) {
            return;
        }
        Object obj = this.getSelectedItem();
        if (obj != null) {
            super.setToolTipText(obj.toString());
        } else {
            super.setToolTipText(null);
        }
    }

    public void setFixedSize(boolean b) {
        this._fixedSize = b;
    }

    public boolean getFixedSize() {
        return this._fixedSize;
    }

    public void addItemExclusive(E obj) {
        boolean found = false;
        for (int index = 0; index < this.getItemCount(); ++index) {
            if (!obj.equals(this.getItemAt(index))) continue;
            found = true;
        }
        if (!found) {
            this.addItem(obj);
        }
    }

    @Override
    public boolean isValid(boolean showErr) {
        return true;
    }

    public void setListenToFormManager(boolean b) {
        this._listenToFormManager = b;
    }

    @Override
    public void clearPerformed() {
        if (this._listenToFormManager) {
            this.removeAllItems();
        }
    }

    public void setModifiable(boolean m) {
        if (!this._modifiable && m) {
            this._modifiable = true;
            this.addItemListener(this);
        } else if (!m) {
            this._modifiable = false;
            this.removeItemListener(this);
        }
    }

    @Override
    public void setModified(boolean b) {
        this._modified = b;
        if (b) {
            RMAUtil.setParentModified(this);
            if (this._changeColor != null) {
                this.setForeground(this._changeColor);
            }
        } else if (this._changeColor != null && this.getForeground().equals(this._changeColor)) {
            this.setForeground(UIManager.getColor("ComboBox.foreground"));
        }
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    public void setChangeColor(Color changeColor) {
        this._changeColor = changeColor;
        if (!this._modifiable) {
            this.setModifiable(true);
        }
    }

    @Override
    public void setIsEditable(boolean b) {
        if (this._modifiable) {
            this.setEnabled(b);
        }
    }
}

