/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.DefaultJPanel;
import rma.swing.border.RmaCompTitledBorder;

public class RmaJCompTitledPanel
extends DefaultJPanel {
    protected RmaCompTitledBorder _border;
    protected JComponent _component;
    protected JPanel _contentPane;
    protected boolean _transmittingAllowed;
    protected Component _transmitter;
    protected boolean _contentPaneCheckingEnabled = false;

    public RmaJCompTitledPanel() {
        this(new JLabel("Title"));
    }

    public RmaJCompTitledPanel(JComponent component) {
        this._component = component;
        this._border = new RmaCompTitledBorder(this._component);
        this.setBorder(this._border);
        this._contentPane = new JPanel();
        super.setLayout(null);
        this.add(this._component);
        this.add(this._contentPane);
        this._transmittingAllowed = false;
        this._transmitter = null;
        this._contentPaneCheckingEnabled = true;
    }

    public JComponent getTitleComponent() {
        return this._component;
    }

    public void setTitleComponent(JComponent newComponent) {
        this._contentPaneCheckingEnabled = false;
        this.remove(this._component);
        this.add(newComponent);
        this._contentPaneCheckingEnabled = true;
        this._border.setTitleComponent(newComponent);
        this._component = newComponent;
    }

    public JPanel getContentPane() {
        return this._contentPane;
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        Rectangle rect = this.getBounds();
        rect.x = 0;
        rect.y = 0;
        Rectangle compR = this._border.getComponentRect(rect, insets);
        this._component.setBounds(compR);
        rect.x += insets.left;
        rect.y += insets.top;
        rect.width -= insets.left + insets.right;
        rect.height -= insets.top + insets.bottom;
        this._contentPane.setBounds(rect);
    }

    public void setTransmittingAllowed(boolean enable) {
        this._transmittingAllowed = enable;
    }

    public boolean getTransmittingAllowed() {
        return this._transmittingAllowed;
    }

    public void setTransmitter(Component transmitter) {
        this._transmitter = transmitter;
    }

    public Component getTransmitter() {
        return this._transmitter;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (this._transmittingAllowed && this._transmitter != null) {
            this._transmitter.setEnabled(enable);
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.isContentPaneCheckingEnabled()) {
            throw this.createContentPaneException("add");
        }
        super.addImpl(comp, constraints, index);
    }

    @Override
    public void setLayout(LayoutManager manager) {
        if (this.isContentPaneCheckingEnabled()) {
            throw this.createContentPaneException("setLayout");
        }
        super.setLayout(manager);
    }

    private Error createContentPaneException(String op) {
        String type = this.getClass().getName();
        return new Error("Do not use " + type + "." + op + "() use " + type + ".getContentPane()." + op + "() instead");
    }

    protected boolean isContentPaneCheckingEnabled() {
        return this._contentPaneCheckingEnabled;
    }

    protected void setContentPaneCheckingEnabled(boolean enabled) {
        this._contentPaneCheckingEnabled = enabled;
    }

    @Override
    public void fillPanel() {
    }

    public void refresh() {
    }

    @Override
    public boolean savePanel() {
        return true;
    }
}

