/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.heclib.util.HecTime;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.DateChooser;
import rma.swing.RmaInsets;
import rma.swing.RmaJ24HourTimeField;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJDialog;
import rma.util.RMAIO;

public class RmaJDateChooserDialog
extends RmaJDialog {
    private static final String DATE_TITLE = "Select Date";
    private static final String DATE_TIME_TITLE = "Select Date & Time";
    DateChooser _chooserPanel;
    protected ButtonCmdPanel _cmdPanel;
    private JLabel _timeLabel;
    boolean _canceled = true;
    private RmaJ24HourTimeField _timeField;
    private JPanel _timePanel;

    public RmaJDateChooserDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this._chooserPanel = new DateChooser();
        this.buildControls(null);
    }

    public RmaJDateChooserDialog(Frame parent, boolean modal, Calendar date) {
        super(parent, modal);
        this.buildControls(date);
    }

    public RmaJDateChooserDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.buildControls(null);
    }

    public RmaJDateChooserDialog(Dialog parent, boolean modal, Calendar date) {
        super(parent, modal);
        this.buildControls(date);
    }

    private void buildControls(Calendar date) {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(DATE_TITLE);
        this._chooserPanel = new DateChooser(date);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.getContentPane().add((Component)this._chooserPanel, gbc);
        this._timePanel = new JPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.01;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0000;
        this.getContentPane().add((Component)this._timePanel, gbc);
        this._timeLabel = new JLabel("Time:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._timePanel.add((Component)this._timeLabel, gbc);
        this._timeField = new RmaJ24HourTimeField();
        this._timeLabel.setLabelFor(this._timeField);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this._timePanel.add((Component)this._timeField, gbc);
        this._timePanel.setVisible(false);
        this._cmdPanel = this.createButtonCmdPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 5, 5);
        this.getContentPane().add((Component)this._cmdPanel, gbc);
        if (date != null) {
            int hour = date.get(11);
            int min = date.get(12);
            this._timeField.setText(String.valueOf(hour) + String.valueOf(min));
        }
        this.pack();
        Dimension d = this.getSize();
        d.width -= 25;
        this.setSize(d);
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                if (e.getID() == 8) {
                    RmaJDateChooserDialog.this._canceled = false;
                    RmaJDateChooserDialog.this.setVisible(false);
                } else if (e.getID() == 4) {
                    RmaJDateChooserDialog.this._canceled = true;
                    RmaJDateChooserDialog.this.setVisible(false);
                }
            }
        });
    }

    protected ButtonCmdPanel createButtonCmdPanel() {
        return new ButtonCmdPanel(12);
    }

    public void setDateField(JTextField dateField) {
        if (dateField != null && dateField instanceof RmaJCalendarField) {
            RmaJCalendarField dtField = (RmaJCalendarField)dateField;
            GregorianCalendar cal = new GregorianCalendar();
            Date date = dtField.getDate();
            if (date != null) {
                cal.setTime(date);
                this.setSelectedDate(cal);
            }
        }
    }

    public void setTimeVisible(boolean visible) {
        this._timePanel.setVisible(visible);
        this.invalidate();
        this.validate();
        this.pack();
        if (visible) {
            this.setTitle(DATE_TIME_TITLE);
        } else {
            this.setTitle(DATE_TITLE);
        }
    }

    public boolean isTimeVisible() {
        return this._timePanel.isVisible();
    }

    public String getTime() {
        if (this.isTimeVisible()) {
            return this._timeField.getText();
        }
        return "";
    }

    public Calendar getSelectedDate() {
        Calendar cal = this._chooserPanel.getSelectedDate();
        if (this._timePanel.isVisible()) {
            String txt = this._timeField.getText();
            String hrStr = txt.substring(0, 2);
            String minStr = txt.substring(2);
            int hr = RMAIO.parseInt(hrStr);
            int min = RMAIO.parseInt(minStr);
            cal.set(11, hr);
            cal.set(12, min);
            cal.set(13, 0);
            cal.set(14, 0);
        }
        return cal;
    }

    public HecTime getSelectedHecTime() {
        Calendar cal = this._chooserPanel.getSelectedDate();
        HecTime time = new HecTime(cal);
        if (this._timePanel.isVisible()) {
            time.setTime(this._timeField.getText());
        }
        return time;
    }

    public void setSelectedDate(Calendar cal) {
        String hourStr;
        this._chooserPanel.setSelectedDate(cal);
        int hour = cal.get(11);
        int min = cal.get(12);
        String minStr = String.valueOf(min);
        if (minStr.length() == 1) {
            minStr = "0".concat(minStr);
        }
        if ((hourStr = String.valueOf(hour)).length() == 1) {
            hourStr = "0".concat(hourStr);
        }
        String time = hourStr.concat(minStr);
        this._timeField.setText(time);
    }

    public void setSelectedDate(HecTime time) {
        if (time != null) {
            this._chooserPanel.setSelectedDate(new GregorianCalendar(time.year(), time.month() - 1, time.day()));
        }
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void setOkButtonText(String text) {
        this._cmdPanel.getButton(8).setText(text);
    }

    public static void main(String[] args) {
        RmaJDateChooserDialog dlg = new RmaJDateChooserDialog((Dialog)new JDialog(), false);
        dlg.setVisible(true);
    }
}

