/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.text.Document;
import rma.swing.RmaJTextField;
import rma.swing.text.DateDocument;
import rma.swing.text.RmaDateVerifier;

public class RmaJDateField
extends RmaJTextField {
    public static final String DDMMMYYYY = "DDMMMYYYY";
    public static final String DDMMM = "DDMMM";
    public static final String MMM = "MMM";
    public static final String YYYY = "YYYY";
    public static final String MMMYYYY = "MMMYYYY";
    protected DateDocument dd;
    protected String _format;

    public RmaJDateField() {
        this.configure();
    }

    public RmaJDateField(String format, String text) {
        this.setFormat(format);
        this.configure();
        this.setText(text);
    }

    protected void configure() {
        this.setHorizontalAlignment(4);
        this.setInputVerifier(RmaDateVerifier.getVerifier());
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                String newDate;
                if (e.getKeyChar() == '+') {
                    String newDate2 = ((DateDocument)RmaJDateField.this.getDocument()).incrementDate(1);
                    if (newDate2 != null) {
                        RmaJDateField.this.setText(newDate2);
                    }
                } else if (e.getKeyChar() == '-' && (newDate = ((DateDocument)RmaJDateField.this.getDocument()).incrementDate(-1)) != null) {
                    RmaJDateField.this.setText(newDate);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    @Override
    protected Document createDefaultModel() {
        this.dd = new DateDocument(DDMMMYYYY);
        this._format = DDMMMYYYY;
        return this.dd;
    }

    public DateDocument getDateDocument() {
        return this.dd;
    }

    public String getFormat() {
        return this._format;
    }

    public void setFormat(String format) {
        this.dd.setFormat(format);
        this._format = format;
    }

    @Override
    protected boolean validateData(boolean showError) {
        return RmaDateVerifier.getVerifier().verify(this, showError);
    }

    protected DateFormat getDateFormat() {
        switch (this.getDateDocument().getFormat()) {
            case 9: {
                return new SimpleDateFormat("ddMMMyyyy");
            }
            case 5: {
                return new SimpleDateFormat("ddMMM");
            }
            case 3: {
                return new SimpleDateFormat(MMM);
            }
            case 4: {
                return new SimpleDateFormat("yyyy");
            }
            case 7: {
                return new SimpleDateFormat("MMMyyyy");
            }
        }
        return null;
    }

    public Date getDate() {
        DateFormat format = this.getDateFormat();
        if (format == null) {
            return null;
        }
        return format.parse(this.getText(), new ParsePosition(0));
    }

    public void setDate(Date date) {
        DateFormat format = this.getDateFormat();
        if (format == null) {
            return;
        }
        this.setText(format.format(date));
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)new RmaJDateField(), "Center");
        frame.setVisible(true);
    }
}

