/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import rma.swing.RmaInsets;
import rma.swing.RmaJCalendarField;
import rma.swing.text.DateTimeDocument;

public class RmaJDateTimeField
extends RmaJCalendarField {
    public RmaJDateTimeField() {
        this.init();
    }

    public RmaJDateTimeField(String date, String time) {
        this.init();
        this.setText(date + " " + time);
    }

    @Override
    public String getFormat() {
        return "DDMMMYYYY HHmm";
    }

    protected void init() {
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                int len;
                if (e.isTemporary()) {
                    return;
                }
                String txt = RmaJDateTimeField.this.getText();
                int idx = txt.indexOf(32);
                if (idx > -1 && (len = txt.length()) - idx == 3) {
                    try {
                        RmaJDateTimeField.this.dd.insertString(10, " ", null);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
        String str = this.getFormat();
        this.setToolTipText(str);
    }

    @Override
    protected boolean isTimeVisible() {
        return true;
    }

    @Override
    protected Document createDefaultModel() {
        this.dd = new DateTimeDocument();
        return this.dd;
    }

    @Override
    protected void setDate(Calendar cal) {
        DateFormat fmt = this.getDateFormat();
        fmt.setTimeZone(cal.getTimeZone());
        String dt = fmt.format(cal.getTime());
        this.setText(dt);
        this.setModified(true);
        this.requestFocusInWindow();
    }

    @Override
    protected DateFormat getDateFormat() {
        return new SimpleDateFormat("ddMMMyyyy HHmm");
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new GridBagLayout());
        RmaJDateTimeField field = new RmaJDateTimeField("02Dec2010", "1418");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.01;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        frame.getContentPane().add((Component)field, gbc);
        JTextField fld = new JTextField();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        frame.getContentPane().add((Component)fld, gbc);
        frame.setSize(200, 100);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

