/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.data.DataSetException;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.Units;
import hec.heclib.util.HecDouble;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.UIManager;
import javax.swing.text.Document;
import rma.services.units.UnitsComponent;
import rma.swing.RmaJTextField;
import rma.swing.text.DecimalNumberDocument;
import rma.swing.text.RmaDecimalVerifier;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class RmaJDecimalField
extends RmaJTextField
implements UnitsComponent {
    private Toolkit toolkit;
    private DecimalFormat decimalFormatter;
    private DecimalNumberDocument dnd = new DecimalNumberDocument();
    private String m_origText = null;
    private double _minValue = Double.NEGATIVE_INFINITY;
    private double _maxValue = Double.NEGATIVE_INFINITY;
    protected boolean _precisionSet = false;
    protected double _value = Double.NEGATIVE_INFINITY;
    protected ParamDouble _paramValue = null;
    protected double _scaleFactor = 1.0;
    protected int _paramScaleId = Integer.MIN_VALUE;
    protected int _displayUnitsSystem = 1;
    protected boolean _needsConversion = false;
    boolean _ignoreParameterRoundOnRetrieve = false;
    boolean _useDecimalFormatForParameters = false;

    public RmaJDecimalField() {
        this.toolkit = Toolkit.getDefaultToolkit();
        this.decimalFormatter = this.getDecimalFormatter();
        this.setHorizontalAlignment(4);
        this.setInputVerifier(RmaDecimalVerifier.getVerifier());
        Font f = UIManager.getFont("NumericField.font");
        if (f != null) {
            this.setFont(f);
        }
    }

    public RmaJDecimalField(int value) {
        this();
        this.setValue(value);
    }

    public RmaJDecimalField(int value, int columns) {
        super(columns);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.decimalFormatter = this.getDecimalFormatter();
        this.setHorizontalAlignment(4);
        this.setInputVerifier(RmaDecimalVerifier.getVerifier());
        this.setValue(value);
        Font f = UIManager.getFont("NumericField.font");
        if (f != null) {
            this.setFont(f);
        }
    }

    public DecimalFormat getDecimalFormatter() {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getNumberInstance(Locale.US);
        df.setGroupingUsed(false);
        return df;
    }

    public void setDecimalFormat(DecimalFormat df) {
        if (df == null) {
            return;
        }
        this.decimalFormatter = df;
    }

    private double getNonParamValue() {
        double retVal = 0.0;
        if (!this.isModified() && this._value != Double.NEGATIVE_INFINITY) {
            return this._value;
        }
        try {
            retVal = this.decimalFormatter.parse(this.getText()).doubleValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return retVal;
    }

    public boolean ignoreParameterRoundOnRetrieve() {
        return this._ignoreParameterRoundOnRetrieve;
    }

    public void setIgnoreParameterRoundOnRetrive(boolean b) {
        this._ignoreParameterRoundOnRetrieve = b;
    }

    public ParamDouble getParamValue() {
        if (this._paramValue == null) {
            return null;
        }
        if (!this.isModified()) {
            return this._paramValue;
        }
        ParamDouble pd2 = null;
        ParamDouble pd = new ParamDouble();
        pd.setValue(this.getText());
        if (this._scaleFactor != 1.0 && this._scaleFactor != 0.0 && this._paramScaleId == this._paramValue.getParameterId()) {
            pd.scaleValue(1.0 / this._scaleFactor);
        }
        if (this._paramValue.getParameterId() == Integer.MIN_VALUE || this._paramValue.getParameterId() == -1) {
            pd.setUnitSystem(this._paramValue.getUnitSystem());
            pd.setParameterId(this._paramValue.getParameterId());
            return pd;
        }
        if (this._paramValue.getUnitSystem() != this._displayUnitsSystem) {
            String displayUnits = null;
            String dataUnits = null;
            try {
                displayUnits = Parameter.getUnitsStringForSystem(this._paramValue.getParameterId(), this._displayUnitsSystem);
                dataUnits = Parameter.getUnitsStringForSystem(this._paramValue.getParameterId(), this._paramValue.getUnitSystem());
            }
            catch (Exception e) {
                return pd;
            }
            try {
                pd2 = Units.convertUnits(pd, displayUnits, dataUnits);
                pd2.setUnitSystem(this._paramValue.getUnitSystem());
                pd2.setParameterId(this._paramValue.getParameterId());
            }
            catch (DataSetException e) {
                System.out.println("EXCEPTION <RMADecimalField.getValue()> : " + e.getMessage());
            }
            return pd2;
        }
        pd.setUnitSystem(this._paramValue.getUnitSystem());
        pd.setParameterId(this._paramValue.getParameterId());
        return pd;
    }

    public double getValue() {
        if (this._paramValue == null || this._paramValue.getParameterId() == Integer.MIN_VALUE) {
            this._value = this.getNonParamValue();
            return this._value;
        }
        ParamDouble pd = this.getParamValue();
        if (pd == null) {
            this._value = this.getNonParamValue();
            return this._value;
        }
        this._paramValue = pd;
        return pd.getValue();
    }

    public HecDouble getHecDouble() {
        if (this.getText().length() == 0) {
            return new HecDouble();
        }
        return new HecDouble(this.getText());
    }

    public double getValueUndefined(double undefinedValue) {
        double retVal = undefinedValue;
        try {
            retVal = this.decimalFormatter.parse(this.getText()).doubleValue();
            retVal = this.getValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return retVal;
    }

    public double getValueUndefined() {
        return this.getValueUndefined(Double.NEGATIVE_INFINITY);
    }

    public void setPrecisionSet(boolean sps) {
        this._precisionSet = sps;
    }

    public void setPrecision(int precision) {
        this.decimalFormatter.setMaximumFractionDigits(precision);
        this.decimalFormatter.setMinimumFractionDigits(precision);
        if (precision < 1) {
            this.decimalFormatter.setDecimalSeparatorAlwaysShown(false);
        } else {
            this.decimalFormatter.setDecimalSeparatorAlwaysShown(true);
        }
        this._precisionSet = true;
    }

    public Double getTextAsDbl() {
        return new Double(this.getValue());
    }

    public void setValue(int value) {
        this._value = value;
        this.setText(this.decimalFormatter.format(value));
    }

    public void setValue(ParamDouble value) {
        ParamDouble oldVal = this._paramValue;
        try {
            this._paramValue = (ParamDouble)value.clone();
            this._needsConversion = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this._precisionSet && this._paramValue.isPrecisionSet()) {
            this.setPrecision(this._paramValue.getPrecision());
        }
        if (RMAConst.isUndefinedValue(this._paramValue.getValue())) {
            this.setText("");
            return;
        }
        this._value = this._paramValue.getValue();
        this.convertAndDisplayParamValue(this._paramValue, this._paramValue.getUnitSystem(), this._displayUnitsSystem);
        if (RmaJDecimalField.hasParameterChange(oldVal, value)) {
            this.setDisplayUnitsSystemOnLabeledBy();
        }
    }

    private static boolean hasParameterChange(ParamDouble oldVal, ParamDouble value) {
        boolean bothNull;
        boolean hadUnitsChange = false;
        boolean bl = bothNull = oldVal == null && value == null;
        if (!bothNull) {
            boolean eitherNull = oldVal == null || value == null;
            hadUnitsChange = eitherNull || oldVal.getParameterId() != value.getParameterId();
        }
        return hadUnitsChange;
    }

    public void setDisplayUnitsSystemOnLabeledBy() {
        Object clientProperty = this.getClientProperty("labeledBy");
        if (clientProperty instanceof UnitsComponent) {
            UnitsComponent rmaJLabel = (UnitsComponent)clientProperty;
            rmaJLabel.setDisplayUnitsSystem(this._displayUnitsSystem);
        }
    }

    public void setValue(HecDouble value) {
        this._value = value.value();
        if (value.precisionSet()) {
            this.setPrecision(value.precision());
        }
    }

    public void setValue(double value) {
        this._value = value;
        if (!RMAConst.isValidValue(value)) {
            this.setText("");
            return;
        }
        if (value == 0.0) {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append('0');
            int precision = this.decimalFormatter.getMinimumFractionDigits();
            if (precision > 0) {
                strBuf.append('.');
                for (int i = 0; i < precision; ++i) {
                    strBuf.append('0');
                }
            }
            this.setText(strBuf.toString());
        } else {
            this.setText(this.decimalFormatter.format(value));
        }
    }

    @Override
    protected Document createDefaultModel() {
        DecimalNumberDocument doc = new DecimalNumberDocument();
        return doc;
    }

    public void setMinValue(double min) {
        this._minValue = min;
    }

    public double getMinValue() {
        return this._minValue;
    }

    public void setMaxValue(double max) {
        this._maxValue = max;
    }

    public double getMaxValue() {
        return this._maxValue;
    }

    @Override
    protected boolean validateData(boolean showErrorMsg) {
        this.getTableMinMax();
        return RmaDecimalVerifier.getVerifier().verify(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.isTemporary()) {
            return;
        }
        this.getTableMinMax();
    }

    public void getTableMinMax() {
        if (this._minMaxTable == null || this._minMaxTableCol < 0) {
            return;
        }
        Object[] minMax = this._minMaxTable.getMinMax(this._minMaxTableCol);
        try {
            double min = new Double(minMax[0].toString());
            this.setMinValue(min);
            double max = new Double(minMax[1].toString());
            this.setMaxValue(max);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void setModified(boolean b) {
        if (b) {
            this._value = Double.NEGATIVE_INFINITY;
            this._needsConversion = true;
        }
        super.setModified(b);
    }

    @Override
    public String getToolTipText() {
        if (this._value != Double.NEGATIVE_INFINITY && !this.getText().equals("" + this._value)) {
            return "" + this._value;
        }
        return super.getToolTipText();
    }

    @Override
    public String getDisplayUnitsString(int unitSystem) {
        if (this._paramValue == null || this._paramValue.getParameterId() == Integer.MIN_VALUE || this._paramValue.getParameterId() == -1) {
            return "";
        }
        int paramId = this._paramValue.getParameterId();
        Object label = Parameter.getUnitsStringForSystem(paramId, unitSystem);
        if (paramId == Parameter.PARAMID_CURENCY && this._paramScaleId == paramId && this._scaleFactor != 1.0) {
            label = (String)label + Math.round(1.0 / this._scaleFactor);
        }
        return label;
    }

    @Override
    public void setDisplayScaleFactor(int paramId, double scaleFactor) {
        this._paramScaleId = paramId;
        this._scaleFactor = scaleFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisplayUnitsSystem(int ut) {
        ParamDouble convertMePd = null;
        if (this._paramValue == null || this._paramValue.getParameterId() == Integer.MIN_VALUE || this._paramValue.getParameterId() == -1) {
            this._displayUnitsSystem = ut;
            return;
        }
        if (this._needsConversion) {
            convertMePd = this.getParamValue();
            if (convertMePd == null || !RMAConst.isValidValue(convertMePd.getValue())) {
                this._displayUnitsSystem = ut;
                return;
            }
        } else if (!RMAConst.isValidValue(this._paramValue.getValue())) {
            this._displayUnitsSystem = ut;
            return;
        }
        this.getDocument().removeDocumentListener(this);
        try {
            if (!this.isModified()) {
                if (ut == this._paramValue.getUnitSystem()) {
                    if (this._useDecimalFormatForParameters) {
                        double scale = this._paramValue.getParameterId() == this._paramScaleId ? this._scaleFactor : 1.0;
                        this.setText(this.decimalFormatter.format(this._paramValue.getValue() * scale));
                    } else {
                        double scale = this._paramValue.getParameterId() == this._paramScaleId ? this._scaleFactor : 1.0;
                        boolean precisionSet = this._paramValue.isPrecisionSet();
                        String txt = precisionSet ? RMAIO.setPrecision2(this._paramValue.getValue() * scale, this._paramValue.getPrecision()) : RMAIO.toTable(this._paramValue.getValue());
                        this.setText(txt);
                    }
                    this._displayUnitsSystem = ut;
                    return;
                }
                convertMePd = this._paramValue;
            } else {
                if (this._displayUnitsSystem == ut) {
                    return;
                }
                if (convertMePd == null) {
                    convertMePd = this.getParamValue();
                }
            }
            this._displayUnitsSystem = ut;
            this.convertAndDisplayParamValue(convertMePd, convertMePd.getUnitSystem(), this._displayUnitsSystem);
        }
        finally {
            this.getDocument().addDocumentListener(this);
        }
    }

    public void convertAndDisplayParamValue(ParamDouble pd, int fromUs, int toUS) {
        if (pd != null && !RMAConst.isValidValue(pd.getValue())) {
            this.setText("");
            return;
        }
        String oldUnits = null;
        String newUnits = null;
        try {
            oldUnits = Parameter.getUnitsStringForSystem(pd.getParameterId(), fromUs);
            newUnits = Parameter.getUnitsStringForSystem(pd.getParameterId(), toUS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (oldUnits == null || newUnits == null) {
            return;
        }
        try {
            ParamDouble pd3;
            double multFactor = Units.getScalarFactor(oldUnits, newUnits);
            if (multFactor <= 0.0) {
                multFactor = 1.0;
            }
            if (pd.getParameterId() == -1 || oldUnits.equals(newUnits)) {
                try {
                    pd3 = (ParamDouble)pd.clone();
                }
                catch (CloneNotSupportedException ce) {
                    return;
                }
                multFactor = 1.0;
            } else {
                pd3 = Units.convertUnits(pd, oldUnits, newUnits);
            }
            int tempPrec = pd3.getPrecision();
            int errorfactor = 0;
            if (multFactor > 1.0) {
                while (multFactor > 1.0) {
                    ++errorfactor;
                    multFactor /= 10.0;
                }
            } else if (multFactor > 0.0 && multFactor < 1.0) {
                while (multFactor < 1.0) {
                    ++errorfactor;
                    multFactor *= 10.0;
                }
            }
            int prec = 0;
            prec = pd3.getPrecision() + errorfactor;
            if (prec < 0) {
                prec = pd3.getPrecision();
            }
            double val = 0.0;
            if (this._useDecimalFormatForParameters) {
                this.setText(this.decimalFormatter.format(pd3.getValue()));
            } else {
                double scale = pd.getParameterId() == this._paramScaleId ? this._scaleFactor : 1.0;
                val = prec >= 0 ? RMAIO.round(pd3.getValue() * scale, prec) : pd3.getValue();
                this.setText(RMAIO.toTable(val));
            }
        }
        catch (DataSetException e) {
            System.out.println("EXCEPTION <RMADecimalField.setDisplayUnitsSystem()> : " + e.getMessage());
            return;
        }
    }

    public void setUseDecimalFormatForParameters(boolean b) {
        this._useDecimalFormatForParameters = b;
    }

    public boolean useDecimalFormatForParameters() {
        return this._useDecimalFormatForParameters;
    }

    @Override
    public void setText(String text) {
        this.m_origText = text;
        super.setText(text);
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        String string = null;
        try {
            Document doc = this.getDocument();
            string = doc.getText(0, doc.getLength());
        }
        catch (Exception e) {
            System.out.println("Exception when getting value from the document in the " + this.getClass().getName());
            System.out.println(e.getMessage());
            return false;
        }
        if (this.m_origText == null && string != null && string.length() > 0) {
            return true;
        }
        if (this.m_origText == null && (string == null || string.length() == 0)) {
            return false;
        }
        if (this.m_origText != null && this.m_origText.length() > 0 && (string == null || string.length() == 0)) {
            return true;
        }
        return !this.m_origText.equals(string);
    }
}

