/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import rma.swing.RmaJTextArea;
import rma.swing.TextEditDlg;
import rma.util.RMAIO;

public class RmaJDescriptionField
extends RmaJTextArea {
    private static final String uiClassID = "DescFieldUI";
    private Toolkit toolkit;
    String _format;
    TextEditDlg _chooserDialog = null;
    JButton _ellipsesButton = null;
    String _text = "";
    String _fldToolTipText;
    String _title = "Enter Description";
    String _noEditTitle = "Description";

    public RmaJDescriptionField() {
        this.configure();
    }

    public RmaJDescriptionField(String text) {
        this();
        this.setText(text);
    }

    public RmaJDescriptionField(String text, int cols) {
        this();
        this.setColumns(cols);
        this.setText(text);
    }

    private void configure() {
        this.toolkit = Toolkit.getDefaultToolkit();
        this.setMouseListener();
        this.setAutoscrolls(true);
        this.setToolTipText("");
        LookAndFeel.installProperty(this, "focusTraversalKeysForward", null);
        LookAndFeel.installProperty(this, "focusTraversalKeysBackward", null);
    }

    private void setMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RmaJDescriptionField.this.displayChooserDialog();
                }
            }
        });
    }

    public void setChooserDialogTitle(String title) {
        this._title = title != null ? title : "";
    }

    @Override
    public void setText(String s) {
        super.setText(s);
        if (s == null) {
            return;
        }
        if (this._chooserDialog != null && this._chooserDialog.isVisible()) {
            this._chooserDialog.setText(s);
        }
        if (!s.isEmpty()) {
            this.setCaretPosition(0);
            if (s.indexOf("\n") > -1) {
                this._fldToolTipText = RMAIO.toHtmlString(s);
                this.setToolTipText(this._fldToolTipText);
            }
        } else {
            this._fldToolTipText = null;
            this.setToolTipText(this._fldToolTipText);
        }
    }

    @Override
    public void append(String s) {
        super.append(s);
        if (this._chooserDialog != null && this._chooserDialog.isVisible()) {
            this._chooserDialog.appendText(s);
        }
        this.setCaretPosition(0);
    }

    @Override
    public void setRows(int rows) {
    }

    public void displayChooserDialog() {
        if (this._chooserDialog == null) {
            Window c2 = SwingUtilities.windowForComponent(this);
            this._chooserDialog = c2 instanceof Frame ? new TextEditDlg((Frame)c2, true) : new TextEditDlg((Dialog)c2, true);
        }
        this._chooserDialog.setText(this.getText());
        boolean canEdit = this.isEnabled() & this.isEditable();
        this._chooserDialog.setEditable(canEdit);
        if (canEdit) {
            this._chooserDialog.setTitle(this._title);
        } else {
            this._chooserDialog.setTitle(this._noEditTitle);
        }
        this._chooserDialog.setVisible(true);
        if (this._chooserDialog.isCanceled()) {
            return;
        }
        this.setText(this._chooserDialog.getText());
        this.setModified(true);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public boolean isManagingFocus() {
        return false;
    }

    @Override
    public void paste() {
        String oldTxt = this.getText();
        super.paste();
        String newTxt = this.getText();
        if (!oldTxt.equals(newTxt)) {
            this.setModified(true);
        }
    }

    static {
        UIManager.put(uiClassID, "rma.swing.plaf.basic.BasicDescFieldUI");
    }
}

