/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import rma.lang.Modifiable;
import rma.services.ServiceLookup;
import rma.services.units.UnitsDisplayService;
import rma.swing.ButtonCmdPanel;
import rma.swing.EditableComponent;
import rma.swing.RmaSwingUtilities;
import rma.util.RMAUtil;

public class RmaJDialog
extends JDialog
implements ComponentListener,
Modifiable {
    static Vector<RmaJDialog> _openDialogs = new Vector();
    private int defaultX = 0;
    private int defaultY = 0;
    private boolean _snapToDefaultSize = false;
    private boolean printLocation = false;
    private boolean _modified = false;
    private ButtonCmdPanel _cmdPanel = null;
    private boolean _enterRegistered;
    private boolean _escapeRegistered;
    private JButton _okButton = null;
    private JButton _cancelButton = null;
    private JButton _applyButton = null;
    private String _okButtonString = "OK";
    private String _cancelButtonString = "Cancel";
    private boolean _ignoreModifiedEvents = false;
    private boolean _editable = true;
    private boolean _systemClosable = true;
    private Action _enterKeyAction;
    private Action _escapeKeyAction;
    protected boolean _fComponentsAdjusted = false;
    protected FocusListener _buttonFL = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (RmaJDialog.this._okButton != null) {
                RmaJDialog.this.getRootPane().setDefaultButton(RmaJDialog.this._okButton);
            }
        }
    };
    private boolean _lookedForCmdPanel;

    public RmaJDialog(Frame owner, String title) {
        super(owner, title);
        this.setContainerListener();
    }

    public RmaJDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.setContainerListener();
    }

    public RmaJDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.setContainerListener();
    }

    public RmaJDialog(Dialog owner, String title) {
        super(owner, title);
        this.setContainerListener();
    }

    public RmaJDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.setContainerListener();
    }

    public RmaJDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.setContainerListener();
    }

    public RmaJDialog(Window owner, boolean modal) {
        super(owner, modal ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        this.setContainerListener();
    }

    public RmaJDialog() {
        this.setContainerListener();
    }

    public RmaJDialog(Frame owner) {
        super(owner);
        this.setContainerListener();
    }

    public RmaJDialog(Dialog owner) {
        super(owner);
        this.setContainerListener();
    }

    public RmaJDialog(Window owner) {
        super(owner);
        this.setContainerListener();
    }

    public RmaJDialog(Window owner, String title) {
        super(owner, title);
        this.setContainerListener();
    }

    public RmaJDialog(Window owner, String title, boolean modal) {
        super(owner, title, modal ? Dialog.ModalityType.DOCUMENT_MODAL : Dialog.ModalityType.MODELESS);
        this.setContainerListener();
    }

    public RmaJDialog(Window owner, String title, Dialog.ModalityType mt) {
        super(owner, title, mt);
        this.setContainerListener();
    }

    private void setContainerListener() {
        this.getContentPane().addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (e.getChild() instanceof ButtonCmdPanel) {
                    RmaJDialog.this._cmdPanel = (ButtonCmdPanel)e.getChild();
                    RmaJDialog.this._cmdPanel.setApplyEnabled(false);
                }
            }
        });
        this.getRootPane().setToolTipText("");
    }

    @Override
    protected JRootPane createRootPane() {
        return new JRootPane(){

            @Override
            public String getToolTipText(MouseEvent e) {
                if (e.isShiftDown() && e.isControlDown() && e.isAltDown()) {
                    Dimension d = this.getSize();
                    Object clsName = RmaJDialog.this.getClass().getName();
                    URL url = this.getClass().getClassLoader().getResource(((String)clsName).replace('.', '/') + ".class");
                    Class<?> superCls = RmaJDialog.this.getClass();
                    do {
                        if ((superCls = superCls.getSuperclass()) == null) continue;
                        if (superCls.getName().endsWith("RMAJDialog")) break;
                        clsName = (String)clsName + ",<br>" + superCls.getName();
                    } while (superCls != null);
                    String tt = "<html>[" + (String)clsName + "]<br>Loaded from:" + url + "<br>Size=" + d.getWidth() + "," + d.getHeight() + "</html>";
                    return tt;
                }
                return null;
            }
        };
    }

    public boolean validateComponents() {
        return this.validateComponents(this);
    }

    public boolean validateComponents(Container c2) {
        return RmaSwingUtilities.validateComponents(c2);
    }

    public void clearForm() {
        this.clearForm(this);
    }

    public void clearForm(Container c2) {
        RmaSwingUtilities.clearForm(c2);
    }

    public void setDefaultHeight(int height) {
        this.defaultY = height;
        this.removeComponentListener(this);
        this.addComponentListener(this);
    }

    public void setDefaultWidth(int width) {
        this.defaultX = width;
        this.removeComponentListener(this);
        this.addComponentListener(this);
    }

    public void setDefaultSize(int width, int height) {
        this.defaultX = width;
        this.defaultY = height;
        this.removeComponentListener(this);
        this.addComponentListener(this);
    }

    public void setPrintLocations(boolean yesNo) {
        this.printLocation = yesNo;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Component comp = e.getComponent();
        boolean needMin = false;
        Dimension csize = comp.getSize();
        Dimension thisSize = this.getSize();
        if (this.printLocation) {
            System.out.println(csize.toString());
        }
        if (this._snapToDefaultSize) {
            this.setSize(this.defaultX, this.defaultY);
            return;
        }
        int newWidth = thisSize.width;
        int newHeight = thisSize.height;
        if (csize.width < this.defaultX) {
            newWidth = this.defaultX;
            needMin = true;
        }
        if (csize.height < this.defaultY) {
            newHeight = this.defaultY;
            needMin = true;
        }
        if (needMin) {
            this.setSize(newWidth, newHeight);
        }
    }

    public boolean getSnapToDefaultSize() {
        return this._snapToDefaultSize;
    }

    public void setSnapToDefaultSize(boolean snapToDefaultSize) {
        this._snapToDefaultSize = snapToDefaultSize;
    }

    public void setIgnoreModifiedEvents(boolean b) {
        this._ignoreModifiedEvents = b;
    }

    public boolean isIgnoreModifiedEvents() {
        return this._ignoreModifiedEvents;
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setModified(boolean modified) {
        if (this._ignoreModifiedEvents) {
            return;
        }
        this._modified = modified;
        if (!modified) {
            RMAUtil.setChildrenUnmodified(this.getContentPane());
        }
        if (this._cmdPanel == null && !this._lookedForCmdPanel) {
            this.findCmdPanel();
        }
        if (this._cmdPanel != null && this._editable && this.canApplyBeEnabled()) {
            this._cmdPanel.setApplyEnabled(this._modified);
        }
    }

    private void findCmdPanel() {
        if (this._lookedForCmdPanel) {
            return;
        }
        Component[] comps = this.getContentPane().getComponents();
        for (int i = comps.length - 1; i >= 0; --i) {
            this._cmdPanel = this.findComponentOfClass((JComponent)comps[i], ButtonCmdPanel.class);
            if (this._cmdPanel != null) break;
        }
        this._lookedForCmdPanel = true;
    }

    private ButtonCmdPanel findComponentOfClass(JComponent comp, Class<ButtonCmdPanel> class1) {
        if (comp == null) {
            return null;
        }
        Component[] c2 = comp.getComponents();
        for (int i = 0; i < c2.length; ++i) {
            ButtonCmdPanel bcp;
            if (c2[i] instanceof ButtonCmdPanel) {
                return (ButtonCmdPanel)c2[i];
            }
            if (!(c2[i] instanceof JPanel) || (bcp = this.findComponentOfClass((JComponent)c2[i], class1)) == null) continue;
            return bcp;
        }
        return null;
    }

    protected boolean canApplyBeEnabled() {
        return true;
    }

    public void setEditable(boolean b) {
        this._editable = b;
        this.setComponentsEditable(this._editable);
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setLocation() {
        this.setLocationRelativeTo(this.getParent());
    }

    protected void registerEscapeKey(boolean register) {
        if (register && !this._escapeRegistered) {
            this._escapeKeyAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RmaJDialog.this.escapeKeyPressed();
                }
            };
            this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0, true), "escapeKey");
            this.getRootPane().getActionMap().put("escapeKey", this._escapeKeyAction);
            this._escapeRegistered = true;
        } else if (!register) {
            this.getRootPane().getInputMap().remove(KeyStroke.getKeyStroke(27, 0, true));
            this.getRootPane().getActionMap().remove("escapeKey");
            this._escapeRegistered = false;
        }
    }

    protected void registerEnterKey(boolean register) {
        if (register && !this._enterRegistered) {
            this._enterKeyAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RmaJDialog.this.enterKeyPressed();
                }
            };
            this.getRootPane().getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "enterKey");
            this.getRootPane().getActionMap().put("enterKey", this._enterKeyAction);
            this._enterRegistered = true;
        } else if (!register && this._enterKeyAction != null) {
            this.getRootPane().getInputMap().remove(KeyStroke.getKeyStroke(10, 0, true));
            this.getRootPane().getActionMap().remove("enterKey");
            this._enterRegistered = false;
        }
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this._fComponentsAdjusted) {
            return;
        }
        this.setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            components[i].setLocation(p);
        }
        this._fComponentsAdjusted = true;
        this.findButtons();
    }

    protected void enterKeyPressed() {
        JButton b = this.getRootPane().getDefaultButton();
        if (b != null) {
            b.doClick();
        }
    }

    public void escapeKeyPressed() {
        if (this._cancelButton != null) {
            this._cancelButton.doClick();
        }
    }

    private void findButtons() {
        Vector buttons = new Vector();
        this.getComps(buttons, this);
        for (int i = 0; i < buttons.size(); ++i) {
            ((JButton)buttons.elementAt(i)).addFocusListener(this._buttonFL);
        }
        if (this._okButton != null) {
            this.getRootPane().setDefaultButton(this._okButton);
        }
    }

    private void getComps(Vector v, Container container) {
        Component[] comps = container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof JButton) {
                JButton button = (JButton)comps[i];
                String buttonText = button.getText();
                if (buttonText != null) {
                    if (buttonText.equals(this._okButtonString)) {
                        this._okButton = (JButton)comps[i];
                    } else if (buttonText.equals(this._cancelButtonString)) {
                        this._cancelButton = (JButton)comps[i];
                    } else if (buttonText.equals("Apply")) {
                        this._applyButton = (JButton)comps[i];
                    }
                }
                v.addElement(comps[i]);
                continue;
            }
            if (!(comps[i] instanceof Container)) continue;
            this.getComps(v, (Container)comps[i]);
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            if (this._okButton != null) {
                this.getRootPane().setDefaultButton(this._okButton);
            }
            _openDialogs.addElement(this);
            UnitsDisplayService uds = ServiceLookup.getUnitsDisplayService();
            uds.addContainer(this);
            ServiceLookup.getTimeZoneDisplayService().addContainer(this);
        } else {
            _openDialogs.removeElement(this);
            UnitsDisplayService uds = ServiceLookup.getUnitsDisplayService();
            uds.removeContainer(this);
            ServiceLookup.getTimeZoneDisplayService().removeContainer(this);
        }
        super.setVisible(b);
    }

    public boolean ok() {
        return this.clickButton(this._okButton);
    }

    public boolean apply() {
        return this.clickButton(this._applyButton);
    }

    public boolean cancel() {
        return this.clickButton(this._cancelButton);
    }

    public void setOKButtonSearchString(String name) {
        this._okButtonString = name;
    }

    public String getOKButtonSearchString() {
        return this._okButtonString;
    }

    public void setCancelButtonSearchString(String name) {
        this._cancelButtonString = name;
    }

    public String getCancelButtonSearchString() {
        return this._cancelButtonString;
    }

    public void setComponentsEditable(boolean b) {
        Component[] comps = this.getContentPane().getComponents();
        if (comps == null) {
            return;
        }
        this.setComponentsEditable(comps, b);
    }

    public void setComponentsEditable(Component[] comps, boolean editable) {
        if (comps == null) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            Component c2 = comps[i];
            if (c2 instanceof EditableComponent) {
                ((EditableComponent)((Object)c2)).setIsEditable(editable);
                continue;
            }
            if (!(c2 instanceof Container)) continue;
            this.setComponentsEditable(((Container)c2).getComponents(), editable);
        }
    }

    protected boolean clickButton(AbstractButton button) {
        if (button != null && button.isEnabled()) {
            button.doClick();
            return true;
        }
        return false;
    }

    public boolean clickButton(String buttonText) {
        if (buttonText == null || buttonText.length() < 1) {
            return false;
        }
        JButton button = (JButton)RMAUtil.findButtonFromText(JButton.class, buttonText, this.getContentPane());
        if (button == null) {
            System.out.println("Failed to find button " + buttonText);
        }
        return this.clickButton(button);
    }

    public boolean clickRadioButton(String buttonText, boolean selected) {
        if (buttonText == null || buttonText.length() < 1) {
            return false;
        }
        JRadioButton button = (JRadioButton)RMAUtil.findButtonFromText(JRadioButton.class, buttonText, this.getContentPane());
        if (button == null) {
            System.out.println("Failed to find RadioButton " + buttonText);
        }
        if (button.isSelected() == selected) {
            return true;
        }
        return this.clickButton(button);
    }

    public boolean clickCheckBox(String buttonText, boolean selected) {
        if (buttonText == null || buttonText.length() < 1) {
            return false;
        }
        JCheckBox button = (JCheckBox)RMAUtil.findButtonFromText(JCheckBox.class, buttonText, this.getContentPane());
        if (button == null) {
            System.out.println("Failed to find CheckBox " + buttonText);
        }
        if (button.isSelected() == selected) {
            return true;
        }
        return this.clickButton(button);
    }

    public static RmaJDialog getWindow(String title) {
        int size = _openDialogs.size();
        RmaJDialog dialog = null;
        for (int i = 0; i < size; ++i) {
            dialog = _openDialogs.elementAt(i);
            if (!title.equalsIgnoreCase(dialog.getTitle())) continue;
            return dialog;
        }
        return null;
    }

    public static Vector<RmaJDialog> getOpenWindows() {
        return (Vector)_openDialogs.clone();
    }

    public static <T extends RmaJDialog> List<T> getOpenWindowsOfClass(Class<T> cls) {
        ArrayList<RmaJDialog> dlgsOfClass = new ArrayList<RmaJDialog>();
        if (cls != null) {
            for (int i = 0; i < _openDialogs.size(); ++i) {
                RmaJDialog dlg = _openDialogs.get(i);
                if (dlg == null || !cls.isAssignableFrom(dlg.getClass())) continue;
                dlgsOfClass.add(dlg);
            }
        }
        return dlgsOfClass;
    }

    @Deprecated
    public static void setTimeZone(TimeZone tz) {
        ServiceLookup.getTimeZoneDisplayService().setTimeZone(tz);
    }

    @Deprecated
    public static TimeZone getTimeZone() {
        return ServiceLookup.getTimeZoneDisplayService().getTimeZone();
    }

    @Deprecated
    public static int getUnitSystem() {
        return ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem();
    }

    @Deprecated
    public static void setDisplayScale(int paramId, double scale) {
        ServiceLookup.getUnitsDisplayService().setDisplayScaleFactor(paramId, scale);
    }

    @Deprecated
    public boolean updateDisplayScale(Container c2) {
        ServiceLookup.getUnitsDisplayService().updateDisplayScale(c2);
        return true;
    }

    @Deprecated
    public static void setUnitSystem(int unitSystem) {
        ServiceLookup.getUnitsDisplayService().setDisplayUnitSystem(unitSystem);
    }

    @Deprecated
    public boolean updateUnitSystem(Container c2) {
        ServiceLookup.getUnitsDisplayService().updateUnitSystem(c2);
        return true;
    }

    @Deprecated
    public boolean updateTimeZone(Container c2) {
        ServiceLookup.getTimeZoneDisplayService().updateTimeZone(c2);
        return true;
    }

    public void setSystemClosable(boolean b) {
        this._systemClosable = b;
    }

    public boolean isSystemClosable() {
        return this._systemClosable;
    }

    public static RmaJDialog getModalDialog() {
        for (int i = _openDialogs.size() - 1; i >= 0; --i) {
            RmaJDialog dialog = _openDialogs.get(i);
            if (!dialog.isModal()) continue;
            return dialog;
        }
        return null;
    }

    public static RmaJDialog getActiveDialog() {
        for (int i = 0; i < _openDialogs.size(); ++i) {
            RmaJDialog dlg = _openDialogs.get(i);
            if (dlg == null || !dlg.isActive()) continue;
            return dlg;
        }
        return null;
    }
}

