/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Toolkit;
import javax.swing.text.Document;
import rma.swing.RmaJTextField;
import rma.swing.text.DssPathnamePartDocument;

public class RmaJDssPathPartField
extends RmaJTextField {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private DssPathnamePartDocument dpd;

    public RmaJDssPathPartField() {
        this.setMaxLength(64);
    }

    public RmaJDssPathPartField(String path, int columns) {
        super(path, columns);
        this.setMaxLength(64);
    }

    @Override
    protected Document createDefaultModel() {
        this.dpd = new DssPathnamePartDocument();
        return this.dpd;
    }

    @Override
    protected boolean validateData(boolean showError) {
        int len = this.dpd.getLength();
        boolean error = false;
        Object errorStr = "";
        if (len == 0 && !this.isEmptyOk()) {
            errorStr = "Field must not be empty ";
            error = true;
        } else {
            String text = this.getText();
            String s = this.dpd.checkValidChars(text, 0, false);
            if (!s.equals(text)) {
                errorStr = "Invalid DSS Pathname Part " + text;
                error = true;
            }
        }
        if (error) {
            if (showError) {
                this.removeFocusListener(this);
                this.errorMsg((String)errorStr);
                this.addFocusListener(this);
            }
            return false;
        }
        return true;
    }
}

