/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import rma.lang.Modifiable;
import rma.swing.FontChooser;
import rma.util.RMAUtil;

public class RmaJFontButton
extends JButton
implements Modifiable {
    boolean _modified = false;
    private String _toolTip;

    public RmaJFontButton(String s) {
        super(s);
        this.setToolTipText("");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmaJFontButton.this.displayFontDialog();
            }
        });
    }

    public void setFont(String s) {
        Font f = Font.getFont(s, this.getFont());
        super.setFont(f);
        this._toolTip = null;
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this._toolTip = null;
    }

    @Override
    public void setModified(boolean b) {
        this._modified = b;
        if (b) {
            RMAUtil.setParentModified(this);
        }
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.height = 30;
        return d;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this._toolTip != null) {
            return this._toolTip;
        }
        Font f = this.getFont();
        this._toolTip = RMAUtil.getFontString(f);
        return this._toolTip;
    }

    protected void displayFontDialog() {
        Window parent = SwingUtilities.windowForComponent(this);
        FontChooser fc = null;
        fc = parent instanceof Dialog ? new FontChooser((Dialog)parent, "Font Chooser", true, this.getFont()) : new FontChooser((Frame)parent, "Font Chooser", true, this.getFont());
        Font selectedFont = fc.getSelectedFont();
        if (selectedFont == null) {
            return;
        }
        this.setFont(selectedFont);
        this.setModified(true);
    }
}

