/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Method;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import rma.lang.Modifiable;
import rma.services.ServiceLookup;
import rma.swing.ButtonCmdPanel;
import rma.swing.EditableComponent;
import rma.swing.FormManagementListener;
import rma.swing.RmaInsets;
import rma.swing.RmaValidComponent;
import rma.util.RMAUtil;

public class RmaJFrame
extends JFrame
implements ComponentListener,
Modifiable {
    private boolean _ignoreModifiedEvents = false;
    private int _defaultX = 0;
    private int _defaultY = 0;
    private boolean _printLocation = false;
    private boolean _modified = false;
    private ButtonCmdPanel _cmdPanel = null;
    private boolean _enterRegistered;
    private boolean _escapeRegistered;
    private JButton _okButton = null;
    private JButton _cancelButton = null;
    private JButton _applyButton = null;
    private boolean _systemClosable = true;
    private boolean _editable = true;
    private static Vector<RmaJFrame> _openFrames = new Vector();
    private static Image _defaultFrameIcon = null;
    private static WindowListener _frameWindowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            if (e.getWindow() instanceof RmaJFrame) {
                RmaJFrame.removeVisibleFrame((RmaJFrame)e.getWindow());
            }
        }
    };
    private static MouseAdapter _popupMouseAdapter = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            if ((e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) && e.isAltDown() && e.isControlDown() && e.isShiftDown()) {
                JPopupMenu menu = new JPopupMenu();
                JMenuItem menuItem = new JMenuItem("Frames");
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RmaJFrame.displayFramesAction();
                    }
                });
                menu.add(menuItem);
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    };

    public RmaJFrame() {
        this.getContentPane().addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (e.getChild() instanceof ButtonCmdPanel) {
                    RmaJFrame.this._cmdPanel = (ButtonCmdPanel)e.getChild();
                    RmaJFrame.this._cmdPanel.setApplyEnabled(false);
                }
            }
        });
    }

    public RmaJFrame(String title) {
        this();
        this.setTitle(title);
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rp = new JRootPane(){

            @Override
            public String getToolTipText(MouseEvent e) {
                if (e.isShiftDown() && e.isControlDown() && e.isAltDown()) {
                    Dimension d = this.getSize();
                    Point p = this.getLocation();
                    String tt = "<html>[" + RmaJFrame.this.getClass().getName() + "]<br>Size=" + d.getWidth() + "," + d.getHeight() + "<br>Pos=" + p.x + "," + p.y + "</html>";
                    return tt;
                }
                return null;
            }
        };
        rp.addMouseListener(_popupMouseAdapter);
        rp.setToolTipText("");
        return rp;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            RmaJFrame.addVisibleFrame(this);
            ServiceLookup.getUnitsDisplayService().addContainer(this);
            ServiceLookup.getTimeZoneDisplayService().addContainer(this);
            if (this.getIconImage() == null && _defaultFrameIcon != null) {
                this.setIconImage(_defaultFrameIcon);
            }
        } else {
            RmaJFrame.removeVisibleFrame(this);
            ServiceLookup.getUnitsDisplayService().removeContainer(this);
            ServiceLookup.getTimeZoneDisplayService().removeContainer(this);
        }
        super.setVisible(b);
    }

    public static void setDefaultIconImage(Image icon) {
        _defaultFrameIcon = icon;
    }

    public static Image getDefaultIconImage() {
        return _defaultFrameIcon;
    }

    public void setLocation() {
        int iy;
        int ix;
        Container parent = this.getParent();
        if (parent == null) {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dd = this.getSize();
            ix = (d.width - dd.width) / 2;
            iy = (d.height - dd.height) / 2;
        } else {
            Rectangle bounds = parent.getBounds();
            Rectangle abounds = this.getBounds();
            ix = bounds.x + (bounds.width - abounds.width) / 2;
            iy = bounds.y + (bounds.height - abounds.height) / 2;
        }
        if (iy < 10) {
            iy = 10;
        }
        if (ix < 10) {
            ix = 10;
        }
        this.setLocation(ix, iy);
    }

    public boolean validateComponents() {
        return this.validateComponents(this);
    }

    public boolean validateComponents(Container c2) {
        if (c2 == null) {
            return true;
        }
        Component[] comps = c2.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof RmaValidComponent ? !((RmaValidComponent)((Object)comps[i])).isValid(true) : comps[i] instanceof Container && !this.validateComponents((Container)comps[i]))) continue;
            return false;
        }
        return true;
    }

    public void clearForm() {
        try {
            Class<?> formManagementListener = Class.forName("rma.swing.FormManagementListener");
            Method m = formManagementListener.getMethod("clearPerformed", new Class[0]);
            this.invokeFormManagementMethod(this, m, new Object[0]);
        }
        catch (Exception e) {
            System.out.println("Exception ClearForm(): " + e.getMessage());
        }
    }

    public void clearForm(Container c2) {
        try {
            Class<?> formManagementListener = Class.forName("rma.swing.FormManagementListener");
            Method m = formManagementListener.getMethod("clearPerformed", new Class[0]);
            this.invokeFormManagementMethod(this, m, new Object[0]);
        }
        catch (Exception e) {
            System.out.println("Exception ClearForm(Container): " + e.getMessage());
        }
    }

    public void invokeFormManagementMethod(Container c2, Method m, Object[] args) {
        if (c2 == null || m == null || args == null) {
            return;
        }
        Component[] comps = c2.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof FormManagementListener) {
                try {
                    m.invoke((Object)((FormManagementListener)((Object)comps[i])), args);
                }
                catch (Exception e) {
                    System.out.println("Exception Invoke FormManage Method: " + e.getMessage());
                }
                continue;
            }
            if (!(comps[i] instanceof Container)) continue;
            this.invokeFormManagementMethod((Container)comps[i], m, args);
        }
    }

    @Deprecated
    public static void setDisplayScale(int paramId, double scale) {
        ServiceLookup.getUnitsDisplayService().setDisplayScaleFactor(paramId, scale);
    }

    @Deprecated
    public boolean updateDisplayScale(Container c2) {
        ServiceLookup.getUnitsDisplayService().updateDisplayScale(c2);
        return true;
    }

    public void setDefaultSize(int x, int y) {
        this._defaultX = x;
        this._defaultY = y;
        this.removeComponentListener(this);
        this.addComponentListener(this);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Component comp = e.getComponent();
        boolean needMin = false;
        Dimension csize = comp.getSize();
        Dimension thisSize = this.getSize();
        if (this._printLocation) {
            System.out.println(csize.toString());
        }
        int newWidth = thisSize.width;
        int newHeight = thisSize.height;
        if (csize.width < this._defaultX) {
            newWidth = this._defaultX;
            needMin = true;
        }
        if (csize.height < this._defaultY) {
            newHeight = this._defaultY;
            needMin = true;
        }
        if (needMin) {
            this.setSize(newWidth, newHeight);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    public void setIgnoreModifiedEvents(boolean b) {
        this._ignoreModifiedEvents = b;
    }

    public boolean isIgnoringModifiedEvents() {
        return this._ignoreModifiedEvents;
    }

    @Override
    public void setModified(boolean modified) {
        if (this._ignoreModifiedEvents) {
            return;
        }
        this._modified = modified;
        if (!modified) {
            RMAUtil.setChildrenUnmodified(this.getContentPane());
        }
        if (this._cmdPanel != null && this._editable) {
            this._cmdPanel.setApplyEnabled(this._modified);
        }
    }

    protected boolean clickButton(AbstractButton button) {
        if (button != null && button.isEnabled()) {
            button.doClick();
            return true;
        }
        return false;
    }

    public boolean clickButton(String buttonText) {
        if (buttonText == null || buttonText.length() < 1) {
            return false;
        }
        JButton button = (JButton)RMAUtil.findButtonFromText(JButton.class, buttonText, this.getContentPane());
        if (button == null) {
            System.out.println("Failed to find button " + buttonText);
        }
        return this.clickButton(button);
    }

    public boolean clickRadioButton(String buttonText, boolean selected) {
        if (buttonText == null || buttonText.length() < 1) {
            return false;
        }
        JRadioButton button = (JRadioButton)RMAUtil.findButtonFromText(JRadioButton.class, buttonText, this.getContentPane());
        if (button == null) {
            System.out.println("Failed to find RadioButton " + buttonText);
        }
        if (button.isSelected() == selected) {
            return true;
        }
        return this.clickButton(button);
    }

    public boolean clickCheckBox(String buttonText, boolean selected) {
        if (buttonText == null || buttonText.length() < 1) {
            return false;
        }
        JCheckBox button = (JCheckBox)RMAUtil.findButtonFromText(JCheckBox.class, buttonText, this.getContentPane());
        if (button == null) {
            System.out.println("Failed to find CheckBox " + buttonText);
        }
        if (button.isSelected() == selected) {
            return true;
        }
        return this.clickButton(button);
    }

    public static RmaJFrame getWindow(String title) {
        int size = _openFrames.size();
        RmaJFrame frame = null;
        for (int i = 0; i < size; ++i) {
            frame = _openFrames.elementAt(i);
            if (!title.equalsIgnoreCase(frame.getTitle())) continue;
            return frame;
        }
        return null;
    }

    public static Vector<RmaJFrame> getOpenWindows() {
        Vector clone = (Vector)_openFrames.clone();
        return clone;
    }

    public static Window getTopWindow() {
        Window[] windows = Dialog.getWindows();
        if (windows != null) {
            for (int i = 0; i < windows.length; ++i) {
                Window w = windows[i];
                if (w.getFocusOwner() == null) continue;
                return w;
            }
        }
        return null;
    }

    public void stayOpen() {
        while (true) {
            try {
                while (true) {
                    if (!this.isVisible()) {
                        return;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    @Deprecated
    public static void setTimeZone(TimeZone tz) {
        ServiceLookup.getTimeZoneDisplayService().setTimeZone(tz);
    }

    @Deprecated
    public static TimeZone getTimeZone() {
        return ServiceLookup.getTimeZoneDisplayService().getTimeZone();
    }

    @Deprecated
    public int getUnitDisplaySystem() {
        return ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem();
    }

    @Deprecated
    public static int getUnitSystem() {
        return ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem();
    }

    @Deprecated
    public static void setUnitSystem(int unitSystem) {
        ServiceLookup.getUnitsDisplayService().setDisplayUnitSystem(unitSystem);
    }

    @Deprecated
    public boolean updateUnitSystem(Container c2) {
        ServiceLookup.getUnitsDisplayService().updateUnitSystem(c2);
        return true;
    }

    @Deprecated
    public boolean updateTimeZone(Container c2) {
        ServiceLookup.getTimeZoneDisplayService().updateTimeZone(c2);
        return true;
    }

    @Deprecated
    protected boolean updateTimeZone(Container c2, TimeZone timezone) {
        ServiceLookup.getTimeZoneDisplayService().updateTimeZone(c2, timezone);
        return true;
    }

    public void setSystemClosable(boolean b) {
        this._systemClosable = b;
    }

    public boolean isSystemClosable() {
        return this._systemClosable;
    }

    protected void registerEscapeKey(boolean register) {
        if (register && !this._escapeRegistered) {
            ((JComponent)this.getRootPane().getContentPane()).registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RmaJFrame.this.escapeKeyPressed();
                }
            }, KeyStroke.getKeyStroke(27, 0, true), 1);
            this._escapeRegistered = true;
        } else if (!register) {
            ((JComponent)this.getRootPane().getContentPane()).unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, true));
            this._escapeRegistered = false;
        }
    }

    protected void registerEnterKey(boolean register) {
        if (register && !this._enterRegistered) {
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RmaJFrame.this.enterKeyPressed();
                }
            }, KeyStroke.getKeyStroke(10, 0, true), 1);
            this._enterRegistered = true;
        } else if (!register) {
            this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, true));
            this._enterRegistered = false;
        }
    }

    protected void enterKeyPressed() {
        JButton b = this.getRootPane().getDefaultButton();
        if (b != null) {
            b.doClick();
        }
    }

    public void escapeKeyPressed() {
        if (this._cancelButton != null) {
            this._cancelButton.doClick();
        }
    }

    public void setEditable(boolean b) {
        this._editable = b;
        this.setComponentsEditable(this._editable);
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setComponentsEditable(boolean b) {
        Component[] comps = this.getContentPane().getComponents();
        if (comps == null) {
            return;
        }
        this.setComponentsEditable(comps, b);
    }

    public void setComponentsEditable(Component[] comps, boolean editable) {
        if (comps == null) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            Component c2 = comps[i];
            if (c2 instanceof EditableComponent) {
                ((EditableComponent)((Object)c2)).setIsEditable(editable);
                continue;
            }
            if (!(c2 instanceof Container)) continue;
            this.setComponentsEditable(((Container)c2).getComponents(), editable);
        }
    }

    private static void addVisibleFrame(RmaJFrame frame) {
        if (!_openFrames.contains(frame)) {
            _openFrames.addElement(frame);
            frame.addWindowListener(_frameWindowListener);
        }
    }

    private static void removeVisibleFrame(RmaJFrame dlg) {
        if (!_openFrames.removeElement(dlg)) {
            // empty if block
        }
        if (dlg != null) {
            dlg.removeWindowListener(_frameWindowListener);
        }
    }

    private static void displayFramesAction() {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new GridBagLayout());
        DefaultListModel<FrameWrapper> m = new DefaultListModel<FrameWrapper>();
        for (int i = 0; i < _openFrames.size(); ++i) {
            m.addElement(new FrameWrapper(_openFrames.get(i)));
        }
        JList l = new JList(m);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        frame.getContentPane().add((Component)new JScrollPane(l), gbc);
        frame.setDefaultCloseOperation(2);
        frame.setSize(200, 200);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    private static class FrameWrapper {
        private JFrame _frame;

        public FrameWrapper(JFrame frame) {
            this._frame = frame;
        }

        public String toString() {
            return this._frame.getTitle();
        }
    }
}

