/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.data.DataSetException;
import hec.data.ParamInteger;
import hec.data.Parameter;
import hec.data.Units;
import java.awt.Font;
import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.UIManager;
import javax.swing.text.Document;
import rma.services.units.UnitsComponent;
import rma.swing.RmaJTextField;
import rma.swing.text.IntegerDocument;
import rma.swing.text.RmaIntegerVerifier;

public class RmaJIntegerField
extends RmaJTextField
implements UnitsComponent {
    private Toolkit toolkit;
    private DecimalFormat decimalFormatter;
    private IntegerDocument ind = new IntegerDocument();
    private int _minValue = Integer.MIN_VALUE;
    private int _maxValue = Integer.MIN_VALUE;
    private int _value = Integer.MIN_VALUE;
    private int _displayUnitsType = 0;
    private int _displayUnitsSystem = 0;
    private int _paramId = Integer.MIN_VALUE;
    private int _dataUnitsSystem = 0;

    public RmaJIntegerField() {
        this.toolkit = Toolkit.getDefaultToolkit();
        this.decimalFormatter = (DecimalFormat)DecimalFormat.getNumberInstance(Locale.US);
        this.decimalFormatter.setGroupingUsed(false);
        this.setHorizontalAlignment(4);
        this.setInputVerifier(RmaIntegerVerifier.getVerifier());
        Font f = UIManager.getFont("NumericField.font");
        if (f != null) {
            this.setFont(f);
        }
    }

    public RmaJIntegerField(int value, int columns) {
        super(columns);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.decimalFormatter = (DecimalFormat)DecimalFormat.getNumberInstance(Locale.US);
        this.decimalFormatter.setGroupingUsed(false);
        this.setHorizontalAlignment(4);
        this.setInputVerifier(RmaIntegerVerifier.getVerifier());
        Font f = UIManager.getFont("NumericField.font");
        if (f != null) {
            this.setFont(f);
        }
        this.setValue(value);
    }

    private double getNonParamValueAsDouble() {
        double retVal = 0.0;
        if (!this.isModified() && this._value != Integer.MIN_VALUE) {
            return this._value;
        }
        try {
            this._value = (int)this.decimalFormatter.parse(this.getText()).doubleValue();
        }
        catch (ParseException e) {
            this._value = Integer.MIN_VALUE;
        }
        return this._value;
    }

    public int getValueUndefined(int undefinedValue) {
        double retVal = undefinedValue;
        try {
            retVal = this.decimalFormatter.parse(this.getText()).doubleValue();
            retVal = this.getValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return (int)retVal;
    }

    public int getValueUndefined() {
        return this.getValueUndefined(Integer.MIN_VALUE);
    }

    private double getParamValueAsDouble() {
        double retVal = 0.0;
        if (!this.isModified() && this._value != Integer.MIN_VALUE) {
            if (this._dataUnitsSystem != this._displayUnitsSystem) {
                double[] x = new double[]{this._value};
                String oldUnits = Parameter.getUnitsStringForSystem(this._paramId, this._displayUnitsSystem);
                String newUnits = Parameter.getUnitsStringForSystem(this._paramId, this._dataUnitsSystem);
                try {
                    Units.convertUnits(x, oldUnits, newUnits);
                    retVal = x[0];
                }
                catch (DataSetException e) {
                    System.out.println("EXCEPTION <RMAIntegerField.getParamValueAsDouble()> : " + e.getMessage());
                }
            }
            return retVal;
        }
        try {
            retVal = this.decimalFormatter.parse(this.getText()).doubleValue();
            if (this._dataUnitsSystem != this._displayUnitsSystem) {
                double[] x = new double[]{retVal};
                String oldUnits = Parameter.getUnitsStringForSystem(this._paramId, this._displayUnitsSystem);
                String newUnits = Parameter.getUnitsStringForSystem(this._paramId, this._dataUnitsSystem);
                try {
                    Units.convertUnits(x, oldUnits, newUnits);
                    retVal = x[0];
                }
                catch (DataSetException e) {
                    System.out.println("EXCEPTION <RMAIntegerField.getParamValueAsDouble()> : " + e.getMessage());
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this._value = (int)retVal;
        return retVal;
    }

    public int getValue() {
        return (int)this.getValueAsDbl();
    }

    public double getValueAsDbl() {
        if (this._paramId == Integer.MIN_VALUE) {
            return this.getNonParamValueAsDouble();
        }
        return this.getParamValueAsDouble();
    }

    public Double getTextAsDbl() {
        return new Double(this.getValueAsDbl());
    }

    public Integer getTextAsInteger() {
        return new Integer(this.getValue());
    }

    public void setValue(ParamInteger param) {
        this.setValue(param.getValue());
        this._paramId = param.getParameterId();
        this._displayUnitsSystem = param.getUnitSystem();
    }

    public void setValue(int value) {
        this._value = value;
        if (value == Integer.MIN_VALUE) {
            this.setText("");
            return;
        }
        this.setText(this.decimalFormatter.format(value));
    }

    @Override
    public void setText(String text) {
        if (text != null) {
            text = text.trim();
        }
        super.setText(text);
    }

    public void setValue(double value) {
        this._value = (int)value;
        if (value == Double.NEGATIVE_INFINITY) {
            this.setText("");
            return;
        }
        this.setText(this.decimalFormatter.format(value));
    }

    @Override
    protected Document createDefaultModel() {
        return new IntegerDocument();
    }

    public void setMinValue(int min) {
        this._minValue = min;
    }

    public int getMinValue() {
        return this._minValue;
    }

    public void setMaxValue(int max) {
        this._maxValue = max;
    }

    public int getMaxValue() {
        return this._maxValue;
    }

    @Override
    protected boolean validateData(boolean showErrorMsg) {
        return RmaIntegerVerifier.getVerifier().verify(this);
    }

    @Override
    public String getDisplayUnitsString(int unitSystem) {
        if (this._paramId == Integer.MIN_VALUE) {
            return "";
        }
        return Parameter.getUnitsStringForSystem(this._paramId, unitSystem);
    }

    @Override
    public void setDisplayScaleFactor(int paramId, double scaleFactor) {
    }

    @Override
    public void setDisplayUnitsSystem(int ut) {
        int oldDisplayUnitSystem = this._displayUnitsSystem;
        this._displayUnitsSystem = ut;
        if (this._paramId == Integer.MIN_VALUE) {
            return;
        }
        int retVal = 0;
        if (this.isModified()) {
            try {
                retVal = this.getValue();
            }
            catch (Exception exception) {}
        } else {
            if ((double)this._value == Double.NEGATIVE_INFINITY) {
                return;
            }
            retVal = this._value;
        }
        String oldUnits = Parameter.getUnitsStringForSystem(this._paramId, oldDisplayUnitSystem);
        String newUnits = Parameter.getUnitsStringForSystem(this._paramId, this._displayUnitsSystem);
        double[] valArry = new double[]{retVal};
        try {
            Units.convertUnits(valArry, oldUnits, newUnits);
            this.setValue(valArry[0]);
        }
        catch (DataSetException e) {
            System.out.println("EXCEPTION <RMAIntegerField.setDisplayUnitsSystem()> : " + e.getMessage());
        }
    }

    @Override
    public void setMaxLength(int length) {
        Document intDoc = this.getDocument();
        if (intDoc instanceof IntegerDocument) {
            ((IntegerDocument)intDoc).setLength(length);
            return;
        }
        super.setMaxLength(length);
    }
}

