/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.data.Units;
import hec.heclib.util.HecTime;
import java.awt.Component;
import java.awt.Graphics;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import rma.services.tz.TimeZoneComponent;
import rma.services.units.UnitsComponent;
import rma.swing.RmaJDialog;

public class RmaJLabel
extends JLabel
implements UnitsComponent,
TimeZoneComponent {
    String _templateLabel = "";
    int _unitSystem;
    String _unitsLabel;
    public static final String PAREN_UNITS_LABEL = "%R";
    public static final String LONG_UNITS_LABEL = "%L";
    public static final String SHORT_UNITS_LABEL = "%S";
    protected HecTime _hecTime;
    protected TimeZone _dataTimeZone;
    protected TimeZone _displayTimeZone;
    protected SimpleDateFormat _dateFormat = null;
    protected String _text;

    public RmaJLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this._templateLabel = text;
    }

    public RmaJLabel(String text, int horizontalAlignment) {
        this(text, null, horizontalAlignment);
    }

    public RmaJLabel(String text) {
        this(text, null, 10);
    }

    public RmaJLabel(Icon image, int horizontalAlignment) {
        this(null, image, horizontalAlignment);
    }

    public RmaJLabel(Icon image) {
        this(null, image, 0);
    }

    public RmaJLabel() {
        this("", null, 10);
    }

    public RmaJLabel(String text, HecTime time, TimeZone dataTimeZone, String dateFmt) {
        super(text);
        this._text = text;
        this._hecTime = time;
        this._dataTimeZone = dataTimeZone;
        this._displayTimeZone = RmaJDialog.getTimeZone();
        if (this._displayTimeZone == null) {
            this._displayTimeZone = TimeZone.getDefault();
        }
        dateFmt = dateFmt.replace('D', 'd').replace('Y', 'y');
        this._dateFormat = new SimpleDateFormat(dateFmt);
        this._dateFormat.setTimeZone(this._displayTimeZone);
        if (this._hecTime != null && this._dataTimeZone != null) {
            Date date = this._hecTime.getJavaDate(this._dataTimeZone.getRawOffset() / 60000);
            this.setText(text + this._dateFormat.format(date));
        }
    }

    public void setTime(HecTime time) {
        if (time == null) {
            this._hecTime.setUndefined();
        } else {
            this._hecTime.set(time);
        }
        Date date = this._hecTime.getJavaDate(this._dataTimeZone.getRawOffset() / 60000);
        this.setText(this._text + this._dateFormat.format(date));
    }

    @Override
    public void paint(Graphics g) {
        Component c2 = this.getLabelFor();
        if (c2 != null && c2 instanceof UnitsComponent) {
            String lbl = this.getText();
            super.setText(lbl);
        }
        super.paint(g);
    }

    public void setTemplateLabel(String text) {
        super.setText(text);
        this._templateLabel = text;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this._templateLabel = text;
    }

    @Override
    public void setDisplayScaleFactor(int paramId, double scaleFactor) {
    }

    public int getDisplayUnitSystem() {
        return this._unitSystem;
    }

    @Override
    public void setDisplayUnitsSystem(int unitSystem) {
        if (!Units.isValidUnitsSystem(unitSystem)) {
            throw new IllegalArgumentException("Invalid Unit System");
        }
        this._unitSystem = unitSystem;
        Component c2 = this.getLabelFor();
        if (c2 != null && c2 instanceof UnitsComponent && this._templateLabel.length() > 0) {
            UnitsComponent uc = (UnitsComponent)((Object)c2);
            super.setText(RmaJLabel.replaceUnitsTemplate(this._templateLabel, uc.getDisplayUnitsString(this._unitSystem)));
        }
    }

    public String getTemplateLabel() {
        return this._templateLabel;
    }

    public static String replaceUnitsTemplate(String template, String unitsLbl) {
        if (template == null || unitsLbl == null) {
            return template;
        }
        int indexL = -1;
        int indexS = -1;
        int indexR = -1;
        indexL = template.indexOf(LONG_UNITS_LABEL);
        if (indexL == -1 && (indexS = template.indexOf(SHORT_UNITS_LABEL)) == -1 && (indexR = template.indexOf(PAREN_UNITS_LABEL)) == -1) {
            return template;
        }
        StringBuffer sb = new StringBuffer(template);
        if (indexL >= 0) {
            sb.replace(indexL, indexL + 2, "");
            sb.insert(indexL, unitsLbl);
            return sb.toString();
        }
        if (indexS >= 0) {
            sb.replace(indexS, indexS + 2, "");
            sb.insert(indexS, unitsLbl);
            return sb.toString();
        }
        if (indexR >= 0) {
            sb.replace(indexR, indexR + 2, "");
            if (!unitsLbl.isEmpty()) {
                sb.insert(indexR, "(" + unitsLbl + ")");
            }
            return sb.toString();
        }
        return template;
    }

    @Override
    public String getDisplayUnitsString(int unitSystem) {
        Component c2 = this.getLabelFor();
        if (c2 == null || !(c2 instanceof UnitsComponent)) {
            return "";
        }
        return ((UnitsComponent)((Object)c2)).getDisplayUnitsString(this._unitSystem);
    }

    public void setDataTimeZone(TimeZone tz) {
        if (this._hecTime == null || this._displayTimeZone == null) {
            return;
        }
        if (tz.equals(this._dataTimeZone)) {
            return;
        }
        this._dataTimeZone = (TimeZone)tz.clone();
        this._dateFormat.setTimeZone(this._displayTimeZone);
        Date date = this._hecTime.getJavaDate(this._dataTimeZone.getRawOffset() / 60000);
        this.setText(this._text + this._dateFormat.format(date));
    }

    @Override
    public void setTimeZone(TimeZone tz) {
        if (this._hecTime == null || this._dataTimeZone == null) {
            return;
        }
        if (tz.equals(this._displayTimeZone)) {
            return;
        }
        this._displayTimeZone = (TimeZone)tz.clone();
        this._dateFormat.setTimeZone(this._displayTimeZone);
        Date date = this._hecTime.getJavaDate(this._dataTimeZone.getRawOffset() / 60000);
        this.setText(this._text + this._dateFormat.format(date));
    }

    @Override
    public TimeZone getTimeZone() {
        return this._displayTimeZone;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        HecTime hTime = new HecTime();
        hTime.set("10Jan2000", "2400");
        RmaJLabel label = new RmaJLabel("---> ", hTime, TimeZone.getDefault(), "ddMMMyyyy HHmm");
        frame.getContentPane().add((Component)label, "Center");
        frame.setLocation(250, 250);
        frame.setSize(250, 250);
        frame.setVisible(true);
    }
}

