/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import rma.lang.Modifiable;
import rma.swing.EditableComponent;
import rma.swing.FormManagementListener;
import rma.swing.list.RmaListModel;
import rma.util.RMAUtil;

public class RmaJList<E>
extends JList<E>
implements FormManagementListener,
EditableComponent,
Modifiable {
    KeySelectionManager _keySelectionManager;
    KeyListener _keyListener;
    boolean _modified = false;

    public RmaJList(Vector<? extends E> listData) {
        super(listData);
        this.installKeyListener();
    }

    public RmaJList() {
        this.installKeyListener();
    }

    public RmaJList(ListModel<E> dataModel) {
        super(dataModel);
        this.installKeyListener();
    }

    public RmaJList(E[] listData) {
        super(listData);
        this.installKeyListener();
    }

    @Override
    public void clearPerformed() {
        ListModel model = this.getModel();
        if (model instanceof RmaListModel) {
            ((RmaListModel)model).getVector().clear();
        } else if (model instanceof DefaultListModel) {
            ((DefaultListModel)model).clear();
        } else {
            this.setListData(new Vector(1));
        }
    }

    private void installKeyListener() {
        this._keyListener = this.createKeyListener();
        if (this._keyListener != null) {
            this.addKeyListener(this._keyListener);
        }
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected KeySelectionManager createDefaultKeySelectionManager() {
        return new DefaultKeySelectionManager();
    }

    public boolean selectWithKeyChar(char keyChar) {
        if (this._keySelectionManager == null) {
            this._keySelectionManager = this.createDefaultKeySelectionManager();
        }
        if (this.getModel() instanceof AbstractListModel) {
            int index = this._keySelectionManager.selectionForKey(keyChar, (AbstractListModel)this.getModel());
            if (index != -1) {
                this.setSelectedIndex(index);
                this.ensureIndexIsVisible(index);
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean isNavigationKey(int keyCode) {
        KeyStroke kpUp = KeyStroke.getKeyStroke("KP_UP");
        KeyStroke kpDown = KeyStroke.getKeyStroke("KP_DOWN");
        return keyCode == 38 || keyCode == 40 || keyCode == (kpUp != null ? kpUp.getKeyCode() : -1) || keyCode == (kpDown != null ? kpDown.getKeyCode() : -1);
    }

    @Override
    public void setIsEditable(boolean b) {
        this.setEnabled(b);
    }

    @Override
    public void setModified(boolean b) {
        this._modified = b;
        if (b) {
            RMAUtil.setParentModified(this);
        }
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    public int getItemCount() {
        return this.getModel().getSize();
    }

    public E getValueAt(int idx) {
        E retval = null;
        if (idx >= 0 && idx < this.getItemCount()) {
            retval = this.getModel().getElementAt(idx);
        }
        return retval;
    }

    public class KeyHandler
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent e) {
            if (RmaJList.this.isEnabled() && !RmaJList.this.isNavigationKey(e.getKeyCode()) && this.isTypeAheadKey(e) && RmaJList.this.selectWithKeyChar(e.getKeyChar())) {
                e.consume();
            }
        }

        boolean isTypeAheadKey(KeyEvent e) {
            return !e.isAltDown() && !e.isControlDown() && !e.isMetaDown();
        }
    }

    class DefaultKeySelectionManager
    implements KeySelectionManager,
    Serializable {
        DefaultKeySelectionManager() {
        }

        @Override
        public int selectionForKey(char aKey, AbstractListModel aModel) {
            int i;
            int c2;
            String v;
            int currentSelection = -1;
            Object selectedItem = RmaJList.this.getSelectedValue();
            if (selectedItem != null) {
                v = selectedItem.toString();
                c2 = aModel.getSize();
                for (i = 0; i < c2; ++i) {
                    if (!v.equals(aModel.getElementAt(i).toString())) continue;
                    currentSelection = i;
                    break;
                }
            }
            String pattern = ("" + aKey).toLowerCase();
            aKey = pattern.charAt(0);
            c2 = aModel.getSize();
            for (i = ++currentSelection; i < c2; ++i) {
                v = aModel.getElementAt(i).toString().toLowerCase();
                if (v.length() <= 0 || v.charAt(0) != aKey) continue;
                return i;
            }
            for (i = 0; i < currentSelection; ++i) {
                v = aModel.getElementAt(i).toString().toLowerCase();
                if (v.length() <= 0 || v.charAt(0) != aKey) continue;
                return i;
            }
            return -1;
        }
    }

    public static interface KeySelectionManager {
        public int selectionForKey(char var1, AbstractListModel var2);
    }
}

