/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.lang.Modifiable;
import rma.swing.RmaJLatitudeComponent;
import rma.swing.RmaJLongitudeComponent;
import rma.swing.RmaJSpinner;
import rma.swing.RmaSpinnerNumberEditor;
import rma.swing.RmaSpinnerNumberModel;
import rma.util.RMAIO;
import rma.util.RMAUtil;

public abstract class RmaJLocationComponent
extends JPanel
implements Modifiable {
    public static final Double neg0 = -0.0;
    protected RmaJSpinner jSpinBoxDeg;
    protected RmaJSpinner jSpinBoxMin;
    protected RmaJSpinner jSpinBoxSec;
    protected int _minDeg;
    protected int _maxDeg;
    protected boolean _enabled = true;
    protected String componentName = null;
    private boolean _modified = false;
    private RmaSpinnerNumberModel _degreesModel;
    private RmaSpinnerNumberModel _minutesModel;
    private RmaSpinnerNumberModel _secondsModel;
    private JLabel labelDegree;
    private JLabel labelMinute;
    private JLabel labelSecond;
    public static final String UNDEFINED = "UNDEFINED";

    public RmaJLocationComponent(String str, int minDegrees, int maxDegrees) {
        this();
        this._minDeg = minDegrees;
        this._maxDeg = maxDegrees;
        this._degreesModel = new RmaSpinnerNumberModel((Number)0, Double.valueOf(this._minDeg), Double.valueOf(this._maxDeg), (Number)1.0);
        this._minutesModel = new RmaSpinnerNumberModel(0, 0, 59, 1);
        this._secondsModel = new RmaSpinnerNumberModel(0.0, 0.0, 59.99, 1.0);
        this.jSpinBoxDeg.setModel(this._degreesModel);
        this.jSpinBoxMin.setModel(this._minutesModel);
        this.jSpinBoxSec.setModel(this._secondsModel);
        RmaSpinnerNumberEditor degEditor = new RmaSpinnerNumberEditor(this.jSpinBoxDeg);
        this.jSpinBoxDeg.setEditor(degEditor);
        RmaSpinnerNumberEditor minEditor = new RmaSpinnerNumberEditor(this.jSpinBoxMin);
        this.jSpinBoxMin.setEditor(minEditor);
        RmaSpinnerNumberEditor secEditor = new RmaSpinnerNumberEditor(this.jSpinBoxSec);
        this.jSpinBoxSec.setEditor(secEditor);
        this.setRMAText(str);
    }

    public RmaJLocationComponent() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.jSpinBoxDeg = new RmaJSpinner();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 2);
        gbc.anchor = 18;
        ((GridBagLayout)this.getLayout()).setConstraints(this.jSpinBoxDeg, gbc);
        this.add(this.jSpinBoxDeg);
        this.labelDegree = new JLabel("\u00b0");
        this.labelDegree.setVisible(false);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 2);
        gbc.anchor = 18;
        ((GridBagLayout)this.getLayout()).setConstraints(this.labelDegree, gbc);
        this.add(this.labelDegree);
        this.jSpinBoxMin = new RmaJSpinner();
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 2);
        gbc.anchor = 18;
        ((GridBagLayout)this.getLayout()).setConstraints(this.jSpinBoxMin, gbc);
        this.add(this.jSpinBoxMin);
        this.labelMinute = new JLabel("'");
        this.labelMinute.setVisible(false);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 2);
        gbc.anchor = 18;
        ((GridBagLayout)this.getLayout()).setConstraints(this.labelMinute, gbc);
        this.add(this.labelMinute);
        this.jSpinBoxSec = new RmaJSpinner();
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        ((GridBagLayout)this.getLayout()).setConstraints(this.jSpinBoxSec, gbc);
        this.add(this.jSpinBoxSec);
        this.labelSecond = new JLabel("\"");
        this.labelSecond.setVisible(false);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 2);
        gbc.anchor = 18;
        gbc.weightx = 0.0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.labelSecond, gbc);
        this.add(this.labelSecond);
        JPanel panel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 2);
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        ((GridBagLayout)this.getLayout()).setConstraints(panel, gbc);
        this.add(panel);
    }

    public double doubleValue() {
        Number degressNum = this._degreesModel.getNumber();
        Number minutesNum = this._minutesModel.getNumber();
        Number secondsNum = this._secondsModel.getNumber();
        if (degressNum == null) {
            return -3.4028234663852886E38;
        }
        double deg = degressNum.doubleValue();
        double min = 0.0;
        if (minutesNum != null) {
            min = minutesNum.doubleValue();
        }
        double sec = 0.0;
        if (secondsNum != null) {
            sec = secondsNum.doubleValue();
        }
        if (deg > 0.0) {
            return deg + min / 60.0 + sec / 3600.0;
        }
        if (deg < 0.0) {
            return deg - min / 60.0 - sec / 3600.0;
        }
        if (neg0.equals(degressNum)) {
            return deg - min / 60.0 - sec / 3600.0;
        }
        return deg + min / 60.0 + sec / 3600.0;
    }

    public void clear() {
        this.jSpinBoxDeg.clearPerformed();
        this.jSpinBoxMin.clearPerformed();
        this.jSpinBoxSec.clearPerformed();
    }

    public void setValue(double d) {
        StringBuffer rmaText = new StringBuffer(10);
        if (d > (double)this._maxDeg || d < (double)this._minDeg) {
            this.clear();
        } else {
            if (d < 0.0) {
                rmaText.append("-");
            }
            boolean wasNeg = d < 0.0;
            d = Math.abs(d);
            int deg = (int)d;
            double dmin = (d - (double)deg) * 60.0;
            int min = (int)dmin;
            double sec = (dmin - (double)min) * 60.0;
            if ((sec = RMAIO.round(sec, 2)) >= 60.0) {
                sec = 0.0;
                if (++min >= 60) {
                    min = 0;
                    if (++deg >= this._maxDeg) {
                        deg = this._minDeg;
                    }
                }
            }
            if (wasNeg && deg == 0) {
                this.jSpinBoxDeg.setValue(neg0);
                this.jSpinBoxMin.setValue(min);
                this.jSpinBoxSec.setValue(sec);
                return;
            }
            if (wasNeg && deg > 0) {
                deg = -1 * deg;
            }
            this.jSpinBoxDeg.setValue(deg);
            this.jSpinBoxMin.setValue(min);
            this.jSpinBoxSec.setValue(sec);
        }
    }

    public void setRMAText(String text) {
        if (text.equals(UNDEFINED)) {
            this.clear();
        } else {
            text = text.trim().toLowerCase();
            int min = 0;
            double sec = 0.0;
            int indexd = text.indexOf("d");
            int indexm = text.indexOf("m");
            int indexs = text.indexOf("s");
            String textd = text.substring(0, indexd);
            String textm = text.substring(indexd + 1, indexm);
            String texts = text.substring(indexm + 1, indexs);
            try {
                Double deg = Double.parseDouble(textd);
                min = Integer.parseInt(textm);
                sec = Double.parseDouble(texts);
                this.jSpinBoxDeg.setValue(deg);
                this.jSpinBoxMin.setValue(min);
                this.jSpinBoxSec.setValue(sec);
            }
            catch (NumberFormatException e) {
                Logger logger = Logger.getLogger(RmaJLocationComponent.class.getName());
                logger.log(Level.FINE, "Error parsing DMS text value.", e);
                this.clear();
            }
        }
    }

    public String getRMAText() {
        Object texts;
        Number degressNum = this._degreesModel.getNumber();
        Number minutesNum = this._minutesModel.getNumber();
        Number secondsNum = this._secondsModel.getNumber();
        if (degressNum == null) {
            return UNDEFINED;
        }
        String textd = neg0.equals(degressNum) ? "-0" : Integer.toString(degressNum.intValue());
        Object textm = minutesNum != null ? Integer.toString(minutesNum.intValue()) : "";
        Object object = texts = secondsNum != null ? Double.toString(secondsNum.doubleValue()) : "";
        while (((String)textm).length() <= 1) {
            textm = "0" + (String)textm;
        }
        while (((String)texts).length() <= 1) {
            texts = "0" + (String)texts;
        }
        StringBuffer text = new StringBuffer(textd);
        text.append("d" + (String)textm);
        text.append("m" + (String)texts);
        text.append("s");
        return text.toString();
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String str) {
        this.componentName = str;
    }

    @Override
    public void setEnabled(boolean enable) {
        this._enabled = enable;
        this.jSpinBoxDeg.setEnabled(enable);
        this.jSpinBoxMin.setEnabled(enable);
        this.jSpinBoxSec.setEnabled(enable);
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setModified(boolean b) {
        this._modified = b;
        if (b) {
            RMAUtil.setParentModified(this);
        } else {
            RMAUtil.setChildrenUnmodified(this);
        }
    }

    public void setChangeColor(Color changeColor) {
        this.jSpinBoxDeg.setChangeColor(changeColor);
        this.jSpinBoxMin.setChangeColor(changeColor);
        this.jSpinBoxSec.setChangeColor(changeColor);
    }

    public void showExtended(boolean show) {
        this.labelDegree.setVisible(show);
        this.labelMinute.setVisible(show);
        this.labelSecond.setVisible(show);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new FlowLayout());
        contentPane.add(new RmaJLatitudeComponent());
        contentPane.add(new RmaJLongitudeComponent());
        frame.pack();
        frame.setVisible(true);
    }
}

