/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.data.DataSetException;
import hec.data.ParamInteger;
import hec.data.Parameter;
import hec.data.Units;
import java.awt.Font;
import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.UIManager;
import javax.swing.text.Document;
import rma.services.units.UnitsComponent;
import rma.swing.RmaJTextField;
import rma.swing.text.IntegerDocument;
import rma.swing.text.LongDocument;
import rma.swing.text.RmaLongVerifier;

public class RmaJLongField
extends RmaJTextField
implements UnitsComponent {
    private Toolkit toolkit;
    private DecimalFormat decimalFormatter;
    private IntegerDocument ind = new IntegerDocument();
    private long _minValue = Long.MIN_VALUE;
    private long _maxValue = Long.MIN_VALUE;
    private long _value = Long.MIN_VALUE;
    private int _displayUnitsType = 0;
    private int _displayUnitsSystem = 0;
    private int _paramId = Integer.MIN_VALUE;
    private int _dataUnitsSystem = 0;

    public RmaJLongField() {
        this.toolkit = Toolkit.getDefaultToolkit();
        this.decimalFormatter = (DecimalFormat)DecimalFormat.getNumberInstance(Locale.US);
        this.decimalFormatter.setGroupingUsed(false);
        this.setHorizontalAlignment(4);
        this.setInputVerifier(RmaLongVerifier.getVerifier());
        Font f = UIManager.getFont("NumericField.font");
        if (f != null) {
            this.setFont(f);
        }
    }

    public RmaJLongField(long value, int columns) {
        super(columns);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.decimalFormatter = (DecimalFormat)DecimalFormat.getNumberInstance(Locale.US);
        this.decimalFormatter.setGroupingUsed(false);
        this.setHorizontalAlignment(4);
        this.setInputVerifier(RmaLongVerifier.getVerifier());
        Font f = UIManager.getFont("NumericField.font");
        if (f != null) {
            this.setFont(f);
        }
        this.setValue(value);
    }

    private double getNonParamValueAsDouble() {
        double retVal = 0.0;
        if (!this.isModified() && this._value != Long.MIN_VALUE) {
            return this._value;
        }
        try {
            this._value = (long)this.decimalFormatter.parse(this.getText()).doubleValue();
        }
        catch (ParseException e) {
            this._value = Long.MIN_VALUE;
        }
        return this._value;
    }

    public long getValueUndefined(long undefinedValue) {
        double retVal = undefinedValue;
        try {
            retVal = this.decimalFormatter.parse(this.getText()).doubleValue();
            retVal = this.getValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return (long)retVal;
    }

    public long getValueUndefined() {
        return this.getValueUndefined(Long.MIN_VALUE);
    }

    private double getParamValueAsDouble() {
        double retVal = 0.0;
        if (!this.isModified() && this._value != Long.MIN_VALUE) {
            if (this._dataUnitsSystem != this._displayUnitsSystem) {
                double[] x = new double[]{this._value};
                String oldUnits = Parameter.getUnitsStringForSystem(this._paramId, this._displayUnitsSystem);
                String newUnits = Parameter.getUnitsStringForSystem(this._paramId, this._dataUnitsSystem);
                try {
                    Units.convertUnits(x, oldUnits, newUnits);
                    retVal = x[0];
                }
                catch (DataSetException e) {
                    System.out.println("EXCEPTION <RMALongField.getParamValueAsDouble()> : " + e.getMessage());
                }
            }
            return retVal;
        }
        try {
            retVal = this.decimalFormatter.parse(this.getText()).doubleValue();
            if (this._dataUnitsSystem != this._displayUnitsSystem) {
                double[] x = new double[]{retVal};
                String oldUnits = Parameter.getUnitsStringForSystem(this._paramId, this._displayUnitsSystem);
                String newUnits = Parameter.getUnitsStringForSystem(this._paramId, this._dataUnitsSystem);
                try {
                    Units.convertUnits(x, oldUnits, newUnits);
                    retVal = x[0];
                }
                catch (DataSetException e) {
                    System.out.println("EXCEPTION <RMALongField.getParamValueAsDouble()> : " + e.getMessage());
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this._value = (long)retVal;
        return retVal;
    }

    public long getValue() {
        return (long)this.getValueAsDbl();
    }

    public double getValueAsDbl() {
        if ((long)this._paramId == Long.MIN_VALUE) {
            return this.getNonParamValueAsDouble();
        }
        return this.getParamValueAsDouble();
    }

    public Double getTextAsDbl() {
        return new Double(this.getValueAsDbl());
    }

    public Long getTextAsLong() {
        return new Long(this.getValue());
    }

    public void setValue(ParamInteger param) {
        this.setValue(param.getValue());
        this._paramId = param.getParameterId();
        this._displayUnitsSystem = param.getUnitSystem();
    }

    public void setValue(long value) {
        this._value = value;
        if (value == Long.MIN_VALUE) {
            this.setText("");
            return;
        }
        this.setText(this.decimalFormatter.format(value));
    }

    public void setValue(double value) {
        this._value = (long)value;
        if (value == Double.NEGATIVE_INFINITY) {
            this.setText("");
            this._value = Long.MIN_VALUE;
            return;
        }
        this.setText(this.decimalFormatter.format(value));
    }

    @Override
    protected Document createDefaultModel() {
        return new LongDocument();
    }

    public void setMinValue(long min) {
        this._minValue = min;
    }

    public long getMinValue() {
        return this._minValue;
    }

    public void setMaxValue(long max) {
        this._maxValue = max;
    }

    public long getMaxValue() {
        return this._maxValue;
    }

    @Override
    protected boolean validateData(boolean showErrorMsg) {
        return RmaLongVerifier.getVerifier().verify(this);
    }

    @Override
    public String getDisplayUnitsString(int unitSystem) {
        if (this._paramId == Integer.MIN_VALUE) {
            return "";
        }
        return Parameter.getUnitsStringForSystem(this._paramId, unitSystem);
    }

    @Override
    public void setDisplayScaleFactor(int paramId, double scaleFactor) {
    }

    @Override
    public void setDisplayUnitsSystem(int ut) {
        int oldDisplayUnitSystem = this._displayUnitsSystem;
        this._displayUnitsSystem = ut;
        if (this._paramId == Integer.MIN_VALUE) {
            return;
        }
        long retVal = 0L;
        if (this.isModified()) {
            try {
                retVal = this.getValue();
            }
            catch (Exception exception) {}
        } else {
            if ((double)this._value == Double.NEGATIVE_INFINITY) {
                return;
            }
            retVal = this._value;
        }
        String oldUnits = Parameter.getUnitsStringForSystem(this._paramId, oldDisplayUnitSystem);
        String newUnits = Parameter.getUnitsStringForSystem(this._paramId, this._displayUnitsSystem);
        double[] valArry = new double[]{retVal};
        try {
            Units.convertUnits(valArry, oldUnits, newUnits);
            this.setValue(valArry[0]);
        }
        catch (DataSetException e) {
            System.out.println("EXCEPTION <RMALongField.setDisplayUnitsSystem()> : " + e.getMessage());
        }
    }

    @Override
    public void setMaxLength(int length) {
        Document longDoc = this.getDocument();
        if (longDoc instanceof LongDocument) {
            ((LongDocument)longDoc).setLength(length);
            return;
        }
        super.setMaxLength(length);
    }
}

