/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import rma.swing.RmaImage;

public class RmaJMultiActionButton
extends JButton {
    private List<Action> _actions = new ArrayList<Action>();
    private int _offset = -3;

    public RmaJMultiActionButton() {
        this.init();
    }

    public RmaJMultiActionButton(String text) {
        super(text);
        this.init();
    }

    private void init() {
        this.setIcon(RmaImage.getImageIcon("Images/forwardbutton.gif"));
        this.setHorizontalTextPosition(10);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmaJMultiActionButton.this.buttonClicked();
            }
        });
    }

    protected void buttonClicked() {
        JPopupMenu menu = new JPopupMenu();
        Font f = this.getFont();
        for (int i = 0; i < this._actions.size(); ++i) {
            JMenuItem menuItem = menu.add(this._actions.get(i));
            menuItem.setFont(f);
        }
        menu.show(this, this.getWidth() + this._offset, 0);
    }

    public void setDropDownOffset(int offset) {
        this._offset = offset;
    }

    public int getDropDownOffset() {
        return this._offset;
    }

    public void addAction(Action action) {
        if (action == null) {
            return;
        }
        this._actions.add(action);
    }

    public boolean removeAction(Action action) {
        return this._actions.remove(action);
    }
}

