/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import rma.lang.Modifiable;
import rma.swing.FormManagementListener;
import rma.swing.RmaJTable;
import rma.swing.RmaValidComponent;
import rma.util.RMAUtil;

public class RmaJPasswordField
extends JPasswordField
implements DocumentListener,
RmaValidComponent,
FocusListener,
MouseMotionListener,
FormManagementListener,
Modifiable {
    private static final Color DISABLED_COLOR = UIManager.getColor("TextField.disabledBackground");
    private boolean _modified = false;
    Color _changeColor = null;
    boolean _emptyOk = true;
    boolean _showError = true;
    protected RmaJTable _minMaxTable = null;
    protected int _minMaxTableCol = -1;
    protected JTextComponent _statusLine = null;
    protected String _statusText = null;
    protected String _name = null;
    protected Window _parentWindow = null;

    public RmaJPasswordField(String text, int columns) {
        super(text, columns);
        this.setToolTipText("");
        this.createListeners();
    }

    public RmaJPasswordField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.setToolTipText("");
        this.createListeners();
    }

    public RmaJPasswordField(int columns) {
        super(columns);
        this.setToolTipText("");
        this.createListeners();
    }

    public RmaJPasswordField() {
        this.setToolTipText("");
        this.createListeners();
    }

    public RmaJPasswordField(String text) {
        super(text);
        this.setToolTipText("");
        this.createListeners();
    }

    private void createListeners() {
        this.getCaret().setBlinkRate(0);
        this.addFocusListener(this);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (RmaJPasswordField.isCursorKey(e.getKeyCode())) {
                    return;
                }
                int modifiers = e.getModifiers();
                if ((modifiers & 0x12) > 0 || (modifiers & 0x11) > 0) {
                    return;
                }
                RmaJPasswordField.this.setModified(true);
            }
        });
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (b) {
            this.setBackground(UIManager.getColor("TextField.background"));
        } else {
            this.setBackground(DISABLED_COLOR);
        }
    }

    @Override
    public void setEditable(boolean b) {
        super.setEditable(b);
        if (b) {
            this.setBackground(UIManager.getColor("TextField.background"));
        } else {
            this.setBackground(DISABLED_COLOR);
        }
    }

    public void setChangeColor(Color changeColor) {
        if (changeColor == null) {
            this.getDocument().removeDocumentListener(this);
        } else {
            if (this._changeColor == null) {
                this.getDocument().addDocumentListener(this);
            }
            this._changeColor = changeColor;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setForeground(this._changeColor);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setForeground(this._changeColor);
    }

    public void setEmptyOk(boolean b) {
        this._emptyOk = b;
    }

    public boolean isEmptyOk() {
        return this._emptyOk;
    }

    public void errorMsg(String msg) {
        if (!this._showError) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        final RmaJPasswordField c2 = this;
        final String m = msg;
        if (this._parentWindow == null) {
            this._parentWindow = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (RmaJPasswordField.this.isEnabled() && RmaJPasswordField.this.isShowing()) {
                    JOptionPane.showMessageDialog(c2, m, "", 0);
                }
            }
        });
    }

    public void takeFocus() {
        final RmaJPasswordField c2 = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                c2.requestFocus();
            }
        });
    }

    @Override
    public boolean isValid(boolean showErr) {
        return this.validateData(showErr);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.isTemporary() || this.getParent() instanceof JTable) {
            return;
        }
        Container c2 = this.getParent();
        if (c2 == null) {
            return;
        }
        if (c2.isVisible()) {
            this.validateData(true);
        }
    }

    public void setShowErrorMsg(boolean b) {
        this._showError = b;
    }

    protected boolean validateData(boolean showErrorMsg) {
        return true;
    }

    public void setMinMaxTable(RmaJTable tbl, int col) {
        this._minMaxTable = tbl;
        this._minMaxTableCol = col;
        if (this._minMaxTable != null) {
            this._minMaxTable.addTableMinMaxTracker(this._minMaxTableCol);
        }
    }

    public void setStatusLineField(JTextComponent statusLine, String statusText) {
        if (statusLine == null) {
            this.removeMouseMotionListener(this);
            statusText = null;
        } else if (this._statusText != null && this._statusText.length() > 0) {
            this.addMouseMotionListener(this);
            this._statusLine = statusLine;
            this._statusText = statusText;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getID() == 504) {
            this._statusLine.setText(this._statusText);
        } else if (e.getID() == 505) {
            this._statusLine.setText("");
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getToolTipText() {
        String text = this.getText();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm.stringWidth(text) > this.getWidth()) {
            return text;
        }
        return null;
    }

    @Override
    public void clearPerformed() {
        this.setText("");
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setModified(boolean b) {
        this._modified = b;
        if (!b && this.getForeground().equals(this._changeColor)) {
            this.setForeground(UIManager.getColor("TextField.foreground"));
        }
        if (b) {
            RMAUtil.setParentModified(this);
        }
    }

    public static final boolean isCursorKey(int keyCode) {
        return keyCode == 39 || keyCode == 37 || keyCode == 38 || keyCode == 40 || keyCode == 35 || keyCode == 36 || keyCode == 18 || keyCode == 20 || keyCode == 17 || keyCode == 16 || keyCode == 144 || keyCode == 33 || keyCode == 34;
    }
}

