/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.data.Parameter;
import hec.data.Units;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import rma.lang.Modifiable;
import rma.services.units.UnitsComponent;
import rma.swing.EditableComponent;
import rma.swing.FormManagementListener;
import rma.swing.RmaValidComponent;
import rma.util.RMAUtil;

public class RmaJRadioButton
extends JRadioButton
implements ActionListener,
FormManagementListener,
RmaValidComponent,
Modifiable,
EditableComponent,
UnitsComponent {
    Color _changeColor = null;
    private boolean _modified = false;
    private boolean _modifiable = true;
    private Component _comp = null;
    private String _templateLabel = null;
    private int _unitSystem;
    private int _paramId = -1;

    public RmaJRadioButton() {
        this.addActionListener(this);
    }

    public RmaJRadioButton(Icon icon) {
        super(icon);
        this.addActionListener(this);
    }

    public RmaJRadioButton(String text) {
        super(text);
        this.addActionListener(this);
        this._templateLabel = text;
    }

    public RmaJRadioButton(String text, Icon icon) {
        super(text, icon);
        this.addActionListener(this);
        this._templateLabel = text;
    }

    public RmaJRadioButton(Icon icon, boolean selected) {
        super(icon, selected);
        this.addActionListener(this);
    }

    public RmaJRadioButton(String text, boolean selected) {
        super(text, selected);
        this.addActionListener(this);
        this._templateLabel = text;
    }

    public RmaJRadioButton(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.addActionListener(this);
        this._templateLabel = text;
    }

    @Override
    public void clearPerformed() {
    }

    public void setModifiable(boolean b) {
        this._modifiable = b;
    }

    public void setChangeColor(Color color) {
        this._changeColor = color;
    }

    @Override
    public boolean isValid(boolean showError) {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._modifiable) {
            this.setModified(true);
        }
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setModified(boolean b) {
        this._modified = b;
        if (b) {
            RMAUtil.setParentModified(this);
        }
        if (!b && this.getForeground() == this._changeColor) {
            this.setForeground(UIManager.getColor("CheckBox.foreground"));
        }
        this.repaint();
    }

    @Override
    public void setIsEditable(boolean b) {
        if (this._modifiable) {
            this.setEnabled(b);
        }
    }

    public void setLabelFor(Component c2) {
        this._comp = c2;
    }

    @Override
    public void setDisplayScaleFactor(int paramId, double scaleFactor) {
    }

    @Override
    public void setDisplayUnitsSystem(int unitSystem) {
        if (!Units.isValidUnitsSystem(unitSystem)) {
            throw new IllegalArgumentException("Invalid Unit System");
        }
        this._unitSystem = unitSystem;
        String unitsLbl = null;
        int indexL = -1;
        int indexS = -1;
        if (this._templateLabel == null || (indexL = this._templateLabel.indexOf("%L")) == -1 && (indexS = this._templateLabel.indexOf("%S")) == -1) {
            return;
        }
        StringBuffer sb = new StringBuffer(this._templateLabel);
        if (this._comp != null && this._comp instanceof UnitsComponent && this._templateLabel.length() > 0) {
            UnitsComponent uc = (UnitsComponent)((Object)this._comp);
            unitsLbl = uc.getDisplayUnitsString(this._unitSystem);
        } else if (this._paramId != -1) {
            unitsLbl = Parameter.getUnitsStringForSystem(this._paramId, unitSystem);
        }
        if (unitsLbl != null) {
            if (indexL >= 0) {
                sb.replace(indexL, indexL + 2, "");
                sb.insert(indexL, unitsLbl);
                super.setText(sb.toString());
            }
            if (indexS >= 0) {
                sb.replace(indexS, indexS + 2, "");
                sb.insert(indexS, unitsLbl);
                super.setText(sb.toString());
            }
        }
    }

    public void setParameterId(int id) {
        this._paramId = id;
    }

    @Override
    public String getDisplayUnitsString(int param) {
        return "";
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this._templateLabel = text;
    }
}

