/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.lang.Modifiable;
import rma.swing.EditableComponent;
import rma.swing.FormManagementListener;
import rma.swing.RmaSpinnerNumberEditor;
import rma.swing.RmaSpinnerNumberModel;
import rma.util.RMAUtil;

public class RmaJSpinner
extends JSpinner
implements EditableComponent,
FormManagementListener,
Modifiable {
    private ChangeListener _changeListener;
    private boolean _modified;
    private Color _changeColor;
    private boolean _forwardModifiedEvents = true;

    public RmaJSpinner() {
        this.addListeners();
    }

    public RmaJSpinner(SpinnerModel model) {
        super(model);
        this.addListeners();
    }

    protected void addListeners() {
        this._changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RmaJSpinner.this.setModified(true);
            }
        };
        this.addChangeListener(this._changeListener);
    }

    @Override
    public void setIsEditable(boolean b) {
        this.setEnabled(b);
    }

    @Override
    public void clearPerformed() {
        SpinnerModel model = this.getModel();
        if (model instanceof SpinnerNumberModel) {
            SpinnerNumberModel snm = (SpinnerNumberModel)model;
            Comparable<?> min = snm.getMinimum();
            this.setValue(min);
        } else if (model instanceof RmaSpinnerNumberModel) {
            model.setValue(null);
        } else {
            try {
                this.setValue("");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setBackground(UIManager.getColor("Spinner.background"));
        } else {
            this.setBackground(UIManager.getColor("TextField.disabledBackground"));
        }
    }

    @Override
    public void setModified(boolean b) {
        this._modified = b;
        if (!b && this.getForeground().equals(this._changeColor)) {
            this.setForeground(UIManager.getColor("Spinner.foreground"));
        }
        if (b && this.forwardModifiedEvents()) {
            RMAUtil.setParentModified(this);
        }
    }

    public void setChangeColor(Color changeColor) {
        this._changeColor = changeColor == null ? changeColor : changeColor;
    }

    public boolean forwardModifiedEvents() {
        return this._forwardModifiedEvents;
    }

    public void setFowardModifiedEvents(boolean b) {
        this._forwardModifiedEvents = b;
    }

    @Override
    protected JComponent createEditor(SpinnerModel model) {
        if (model instanceof RmaSpinnerNumberModel) {
            return new RmaSpinnerNumberEditor(this);
        }
        return super.createEditor(model);
    }
}

