/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.lang.Modifiable;
import rma.swing.RmaValidComponent;
import rma.util.RMAUtil;

public class RmaJTabbedPane
extends JTabbedPane
implements ChangeListener,
Modifiable {
    int _lastIndex = 0;
    private boolean _modified = true;

    public RmaJTabbedPane(int tabPlacement) {
        super(tabPlacement);
        this.addChangeListener(this);
    }

    public RmaJTabbedPane() {
        this.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this._lastIndex < 0) {
            return;
        }
        Component c2 = this.getComponentAt(this._lastIndex);
        if (c2 instanceof Container && !this.validateComponents((Container)c2)) {
            this.removeChangeListener(this);
            this.setSelectedIndex(this._lastIndex);
            this.addChangeListener(this);
            return;
        }
        this._lastIndex = this.getSelectedIndex();
    }

    public boolean validateComponents(Container c2) {
        if (c2 == null) {
            return true;
        }
        Component[] comps = c2.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof RmaValidComponent ? !((RmaValidComponent)((Object)comps[i])).isValid(true) : comps[i] instanceof Container && !this.validateComponents((Container)comps[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setModified(boolean b) {
        this._modified = b;
        if (b) {
            RMAUtil.setParentModified(this);
        } else {
            RMAUtil.setChildrenUnmodified(this);
        }
    }
}

