/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.Units;
import hec.heclib.util.HecDouble;
import hec.io.Identifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import rma.lang.Modifiable;
import rma.lang.ModifiedEventControl;
import rma.services.tz.TimeZoneComponent;
import rma.services.units.UnitsComponent;
import rma.swing.EditableComponent;
import rma.swing.FormManagementListener;
import rma.swing.IParameterScale;
import rma.swing.InsertDlg;
import rma.swing.JScrollPaneAdjuster;
import rma.swing.RmaJ24HourTimeField;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDateField;
import rma.swing.RmaJDateTimeField;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDssPathPartField;
import rma.swing.RmaJFrame;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJLongField;
import rma.swing.RmaJTextArea;
import rma.swing.RmaJTextField;
import rma.swing.RmaValidComponent;
import rma.swing.ToggleDocument;
import rma.swing.event.TableChangeListener;
import rma.swing.event.TableUpdateEvent;
import rma.swing.list.RmaListModel;
import rma.swing.print.PageText;
import rma.swing.table.AlignTableCellRenderer;
import rma.swing.table.CellLocation;
import rma.swing.table.ColumnGroup;
import rma.swing.table.ComboBoxRenderer;
import rma.swing.table.DecimalCellRenderer;
import rma.swing.table.GroupableColumnTableModel;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.MleHeadRenderer;
import rma.swing.table.MultiLineCellRenderer;
import rma.swing.table.NonContiguousSelectionModel;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaCellRenderer;
import rma.swing.table.RmaColorRenderer;
import rma.swing.table.RmaDateTimeEditor;
import rma.swing.table.RmaDateTimeRenderer;
import rma.swing.table.RmaJTableExportDialog;
import rma.swing.table.RmaJTableFillDialog;
import rma.swing.table.RmaRowHeaderRenderer;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.swing.table.RowCellEditor;
import rma.swing.table.RowCellRenderer;
import rma.swing.table.TableExportOptions;
import rma.swing.table.TablePrintManager;
import rma.swing.table.TableSearcher;
import rma.swing.table.TimeZoneHeaderRenderer;
import rma.swing.table.ToolTipHeader;
import rma.swing.table.UnitsCellRenderer;
import rma.swing.table.UnitsHeaderRenderer;
import rma.swing.text.FixedLengthDocument;
import rma.util.PowerfulTokenizer;
import rma.util.RMAConst;
import rma.util.RMAIO;
import rma.util.RMAUtil;

public class RmaJTable
extends JTable
implements ActionListener,
CellEditorListener,
TextListener,
KeyListener,
MouseListener,
DocumentListener,
ItemListener,
TableModelListener,
FormManagementListener,
Printable,
Modifiable,
EditableComponent,
UnitsComponent,
TimeZoneComponent,
RmaValidComponent {
    private static final long serialVersionUID = 9099082702473296444L;
    TablePrintManager _printManager;
    Component _parent = null;
    private JPopupMenu _popup;
    private JMenuItem _sumEntireColumnMenuItem;
    private JMenuItem _sumSelectedCellsMenuItem;
    private JMenuItem _insertMi;
    private JMenuItem _appendMi;
    private JMenuItem _deleteMi;
    private JMenuItem _fillMi;
    private JMenuItem _reverseMi;
    private JMenuItem _printMi;
    private JMenuItem _printPreviewMi;
    private JMenuItem _exportMi;
    private boolean _popupEnabled = true;
    boolean _modified = false;
    char kd;
    char kp;
    char kr;
    char curr_char;
    JScrollPane _scrollPane;
    boolean addRemoveEnabled = true;
    boolean _tabToEditCell = true;
    RmaSelectionListener _colSL;
    RmaSelectionListener _rowSL;
    Vector<CellEditorListener> _cellEditorListeners = new Vector();
    Vector<TableChangeListener> _tableChangeListeners = new Vector();
    Vector<MinMaxEntry> _tableMinMaxEntries = new Vector();
    protected Hashtable<Integer, Color> _rowForeground = new Hashtable();
    protected Hashtable<Integer, Color> _rowBackground = new Hashtable();
    protected Hashtable<String, Color> _cellForeground = new Hashtable();
    protected Hashtable<String, Color> _cellBackground = new Hashtable();
    Hashtable<String, Font> _cellFonts = new Hashtable();
    Hashtable<Integer, Color> _columnForeground = new Hashtable();
    Hashtable<Integer, Color> _columnBackground = new Hashtable();
    boolean _hasMultilineRenderer = false;
    boolean _rowHeaderEnabled = false;
    boolean _autoRowHeaders = false;
    int _autoRowHeaderOffset = 0;
    protected boolean _firstFixedRow = false;
    UnitsHeaderRenderer _unitsHeadRend = null;
    MleHeadRenderer _mleheadrend = null;
    CurrencyCellRenderer _currencyCellRend;
    RmaCellRenderer _rmaCellRend;
    DecimalCellRenderer _decCellRend;
    MultiLineCellRenderer _mlCellRend;
    boolean _useRmaCellRenderer = false;
    boolean _addedToScrollPane = false;
    boolean _processKeyEvents = true;
    Color _pasteBackground;
    Color _pasteForeground;
    Color _modForegroundColor;
    Color _errorForegroundColor;
    int _precision = 1;
    RmaJTable _rowheaderTbl;
    RmaJTable _parentTbl;
    Border _defaultBorder;
    int _clickCountToStart = 2;
    int _oneClickToStart = 1;
    protected int _maxNumPage = 1;
    private PageText _titleInfo = null;
    private PageText _otherInfo = null;
    private String _printDateStr = null;
    private boolean _defaultPopup = true;
    private boolean _editable = true;
    private boolean _isEditable = true;
    private boolean _useNonContiguousSelection = false;
    private NonContiguousSelectionModel _nonContiguousSelectionModel;
    private RmaJTableExportDialog _exportOptionsDialog;
    private RmaJTableFillDialog _fillDialog;
    private Hashtable<Integer, ParameterScale> _parameterScaleTable = new Hashtable();
    private boolean _pasteAddsRows = true;
    private boolean _useDefaultPrintHeader = true;
    private Point _popupPoint;
    static boolean _pasteDebug = false;
    int _scaleFactor = 1;
    int _displayUnitSystem = 1;
    private JMenuItem _clearMi;
    private JMenuItem _pasteMi;
    private JMenuItem _copyMi;
    private JMenuItem _cutMi;
    private boolean _alternatingReportBackground;
    private Color _alternatingReportBackgroundColor;
    private int _origRowHeight;
    private TableSearcher _searcher;
    private boolean _lastKeyWasEnd;
    private ArrayList<PopupItem> _additionalPopupItems;
    private TableRowSorterListener _rowSorterListener;

    public RmaJTable() {
        this.buildControls();
    }

    public RmaJTable(Component parent) {
        this();
        this.setParent(parent);
    }

    public RmaJTable(RmaTableModelInterface dm) {
        super(dm);
        this.buildControls();
    }

    public RmaJTable(Component parent, RmaTableModelInterface dm) {
        super(dm);
        this.setParent(parent);
        this.buildControls();
    }

    public RmaJTable(Component parent, Object[] columnNames) {
        super(new RmaTableModel((String[])columnNames, new Object[1][columnNames.length], new boolean[columnNames.length]));
        for (int i = 0; i < columnNames.length; ++i) {
            this.setColumnEnabled(true, i);
        }
        super.revalidate();
        this.setParent(parent);
        this.buildControls();
    }

    public RmaJTable(Component parent, Object[][] rowData, Object[] columnNames) {
        super(new RmaTableModel((String[])columnNames, rowData, new boolean[columnNames.length]));
        for (int i = 0; i < columnNames.length; ++i) {
            this.setColumnEnabled(true, i);
        }
        super.revalidate();
        this.setParent(parent);
        this.buildControls();
    }

    public RmaJTable(Component parent, Vector rowData, Vector columnNames) {
        super(new RmaTableModel(columnNames, rowData, new Vector(columnNames.size())));
        super.revalidate();
        this.setParent(parent);
        this.buildControls();
    }

    public Map<Integer, ParameterScale> getDisplayScaleMap() {
        return this._parameterScaleTable;
    }

    @Override
    public void setDisplayScaleFactor(int paramId, double scaleFactor) {
        int i;
        this.commitEdit(true);
        TableColumnModel tcm = this.getColumnModel();
        TableModel tm = this.getModel();
        if (tm instanceof RmaTableModelInterface) {
            for (i = 0; i < tm.getColumnCount(); ++i) {
                if (((RmaTableModelInterface)tm).getColumnParameter(i) != paramId) continue;
                this._parameterScaleTable.put(new Integer(i), new ParameterScale(paramId, scaleFactor));
            }
        }
        for (i = 0; i < tcm.getColumnCount(); ++i) {
            TableCellEditor tce;
            ParameterScale ps = this._parameterScaleTable.get(new Integer(this.convertColumnIndexToModel(i)));
            if (ps == null) continue;
            TableCellRenderer tcr = tcm.getColumn(i).getCellRenderer();
            if (tcr instanceof RmaCellRenderer) {
                ((RmaCellRenderer)tcr).setDisplayScaleFactor(i, paramId, scaleFactor);
            }
            if (!((tce = tcm.getColumn(i).getCellEditor()) instanceof RmaCellEditor)) continue;
            ((RmaCellEditor)tce).setDisplayScaleFactor(paramId, scaleFactor);
        }
        if (this._rowheaderTbl != null) {
            this._rowheaderTbl.setDisplayScaleFactor(paramId, scaleFactor);
        }
        this.getTableHeader().repaint();
        this.repaint();
    }

    @Override
    public void setDisplayUnitsSystem(int unitSystem) {
        TableModel model;
        if (!Units.isValidUnitsSystem(unitSystem)) {
            System.out.println("ERROR <RmaJTable.setDisplayUnitsSystem()> : Invalid Unit System being Set " + unitSystem);
            System.out.println("ERROR <RmaJTable.setDisplayUnitsSystem()> : (2) SI (1) English");
            return;
        }
        this.commitEdit(true);
        this._displayUnitSystem = unitSystem;
        for (Object o : this.defaultEditorsByColumnClass.values()) {
            if (!(o instanceof RmaCellEditor)) continue;
            RmaCellEditor editor = (RmaCellEditor)o;
            editor.setDisplayUnitSystem(unitSystem);
        }
        for (Object o : this.defaultRenderersByColumnClass.values()) {
            if (!(o instanceof UnitsCellRenderer)) continue;
            UnitsCellRenderer renderer = (UnitsCellRenderer)o;
            renderer.setDisplayUnitsSystem(unitSystem);
        }
        TableColumnModel tcm = this.getColumnModel();
        ColumnGroup cg = null;
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            JTableHeader header;
            TableCellEditor tce;
            TableCellRenderer tcr = tcm.getColumn(i).getHeaderRenderer();
            if (tcr instanceof UnitsCellRenderer) {
                ((UnitsCellRenderer)tcr).setDisplayUnitsSystem(unitSystem);
            }
            if ((tcr = tcm.getColumn(i).getCellRenderer()) instanceof UnitsCellRenderer) {
                ((UnitsCellRenderer)tcr).setDisplayUnitsSystem(unitSystem);
            }
            if ((tce = tcm.getColumn(i).getCellEditor()) instanceof RmaCellEditor) {
                ((RmaCellEditor)tce).setDisplayUnitSystem(unitSystem);
            }
            if (!((header = this.getTableHeader()) instanceof GroupableTableHeader)) continue;
            Enumeration e = ((GroupableTableHeader)header).getColumnGroups(tcm.getColumn(i));
            while (e != null && e.hasMoreElements()) {
                cg = (ColumnGroup)e.nextElement();
                if (!(cg.getHeaderRenderer() instanceof UnitsCellRenderer)) continue;
                ((UnitsCellRenderer)cg.getHeaderRenderer()).setDisplayUnitsSystem(unitSystem);
            }
        }
        if (this._rowheaderTbl != null) {
            this._rowheaderTbl.setDisplayUnitsSystem(unitSystem);
        }
        if ((model = this.getModel()) instanceof RmaTableModelInterface) {
            ((RmaTableModelInterface)model).setDisplayUnitsSystem(unitSystem);
        }
        if (this.getTableHeader() != null) {
            this.getTableHeader().repaint();
        }
        this.repaint();
    }

    public int getDisplayUnitSystem() {
        return this._displayUnitSystem;
    }

    @Override
    public void setTimeZone(TimeZone tz) {
        this.commitEdit(true);
        TableColumnModel tcm = this.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            TableCellRenderer hdr;
            TableCellEditor tce;
            TableCellRenderer tcr = tcm.getColumn(i).getCellRenderer();
            if (tcr instanceof RmaDateTimeRenderer) {
                ((RmaDateTimeRenderer)tcr).setTimeZone(tz);
            }
            if ((tce = tcm.getColumn(i).getCellEditor()) instanceof RmaDateTimeEditor) {
                ((RmaDateTimeEditor)tce).setTimeZone(tz);
            }
            if (!((hdr = tcm.getColumn(i).getHeaderRenderer()) instanceof TimeZoneHeaderRenderer)) continue;
            ((TimeZoneHeaderRenderer)hdr).setTimeZone(tz);
        }
        if (this._rowheaderTbl != null) {
            this._rowheaderTbl.setTimeZone(tz);
        }
        if (this.getTableHeader() != null) {
            this.getTableHeader().repaint();
        }
        this.repaint();
    }

    @Override
    public TimeZone getTimeZone() {
        return null;
    }

    public void setColumnParameters(int[] params) {
        TableModel tm = this.getModel();
        if (tm instanceof RmaTableModelInterface) {
            ((RmaTableModelInterface)tm).setColumnParameters(params);
        }
    }

    @Override
    public String getDisplayUnitsString(int system) {
        return "";
    }

    public String getDisplayUnitsString(int system, int column) {
        TableModel tm = this.getModel();
        if (tm instanceof RmaTableModelInterface) {
            int paramId = ((RmaTableModelInterface)tm).getColumnParameter(column);
            if (paramId == -1) {
                return "";
            }
            Object label = Parameter.getUnitsStringForSystem(paramId, system);
            if (paramId == Parameter.PARAMID_CURENCY) {
                ParameterScale ps = this._parameterScaleTable.get(new Integer(column));
                label = ps == null ? (String)label + "1" : (String)label + Math.round(1.0 / ps.scale);
            }
            return label;
        }
        return "";
    }

    public RmaCellRenderer createRmaCellRenderer() {
        return new RmaCellRenderer(new JLabel());
    }

    public void setCellRenderer() {
        this._rmaCellRend = this.createRmaCellRenderer();
        TableColumnModel tcm = this.getTableHeader().getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            tc.setCellRenderer(this._rmaCellRend);
            this._useRmaCellRenderer = true;
        }
    }

    @Override
    public TableCellRenderer getDefaultRenderer(Class<?> columnClass) {
        TableCellRenderer renderer = super.getDefaultRenderer(columnClass);
        if (renderer == null) {
            renderer = new RmaCellRenderer();
        }
        if (renderer instanceof UnitsCellRenderer) {
            ((UnitsCellRenderer)renderer).setDisplayUnitsSystem(this.getDisplayUnitSystem());
        }
        return renderer;
    }

    @Override
    protected TableModel createDefaultDataModel() {
        RmaTableModel model = new RmaTableModel(new String[1], new Object[1][1], new boolean[1]);
        model.setColEnabled(true, 0);
        return model;
    }

    @Override
    public void createDefaultEditors() {
        this._clickCountToStart = 2;
        this.defaultEditorsByColumnClass = new Hashtable(4);
        RmaJTextField textField = new RmaJTextField();
        if (this._defaultBorder == null) {
            this.createDefaultBorder();
        }
        textField.setBorder(this._defaultBorder);
        RmaCellEditor dce = new RmaCellEditor(textField);
        dce.setClickCountToStart(this._clickCountToStart);
        this.setDefaultEditor(this.getClassForName("java.lang.Object"), dce);
        this.setDefaultEditor(this.getClassForName("java.lang.String"), dce);
        RmaJDecimalField rightAlignedTextField = new RmaJDecimalField();
        rightAlignedTextField.setHorizontalAlignment(4);
        rightAlignedTextField.setBorder(this._defaultBorder);
        dce = new RmaCellEditor(rightAlignedTextField);
        dce.setClickCountToStart(this._clickCountToStart);
        this.setDefaultEditor(Number.class, dce);
        this.setDefaultEditor(this.getClassForName("hec.data.ParamDouble"), dce);
        RmaJCheckBox centeredCheckBox = new RmaJCheckBox();
        centeredCheckBox.setHorizontalAlignment(0);
    }

    @Override
    protected void createDefaultRenderers() {
        this.defaultRenderersByColumnClass = new Hashtable();
        RmaCellRenderer label1 = new RmaCellRenderer(new JLabel());
        this.setDefaultRenderer(this.getClassForName("java.lang.Object"), label1);
        this.setDefaultRenderer(this.getClassForName("java.lang.String"), label1);
        RmaCellRenderer rightAlignedLabel = new RmaCellRenderer(new JLabel());
        rightAlignedLabel.setHorizontalAlignment(4);
        this.setDefaultRenderer(this.getClassForName("java.lang.Number"), rightAlignedLabel);
        this.setDefaultRenderer(this.getClassForName("hec.data.ParamDouble"), rightAlignedLabel);
        RmaCellRenderer centeredLabel = new RmaCellRenderer(new JLabel()){

            public void setValue(Object value) {
                this.setIcon((Icon)value);
            }
        };
        centeredLabel.setHorizontalAlignment(0);
        this.setDefaultRenderer(this.getClassForName("javax.swing.ImageIcon"), centeredLabel);
        CheckBoxRenderer booleanRenderer = new CheckBoxRenderer();
        booleanRenderer.setHorizontalAlignment(0);
        this.setDefaultRenderer(this.getClassForName("java.lang.Boolean"), booleanRenderer);
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new ToolTipHeader(this.getColumnModel());
    }

    protected void createDefaultBorder() {
        this._defaultBorder = BorderFactory.createLineBorder(Color.black);
    }

    protected void buildControls() {
        if (Boolean.getBoolean("RmaJTable.AllowsFontResizing")) {
            this.setAllowsFontResizing(true);
        }
        this.buildPopup();
        this._modForegroundColor = Color.getColor("Table.editedForeground", Color.blue);
        this._errorForegroundColor = Color.getColor("Table.errorForeground", Color.red);
        if (this._defaultBorder == null) {
            this.createDefaultBorder();
        }
        this._scrollPane = this.createScrollPane();
        this.addMouseListener(this);
        this.tableHeader.setReorderingAllowed(false);
        ListSelectionModel csm = this.getColumnModel().getSelectionModel();
        this._colSL = new RmaSelectionListener(csm, 1);
        csm.addListSelectionListener(this._colSL);
        ListSelectionModel rsm = this.getSelectionModel();
        this._rowSL = new RmaSelectionListener(rsm, 2);
        rsm.addListSelectionListener(this._rowSL);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(true);
        RmaJTextField tf = new RmaJTextField();
        tf.setBorder(this._defaultBorder);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn tc = this.getColumnModel().getColumn(i);
            if (tc == null) {
                return;
            }
            tf.addMouseListener(this);
            RmaCellEditor dcf = new RmaCellEditor(tf);
            dcf.setClickCountToStart(this._clickCountToStart);
            tc.setCellEditor(dcf);
        }
        this.setCellRenderer();
        this.setUpTabKeys();
    }

    protected JScrollPane createScrollPane() {
        return new JScrollPane();
    }

    public void setPopupMenu(JPopupMenu popup) {
        this._popup = popup;
        this._defaultPopup = false;
    }

    protected void buildPopup() {
        String[] labels = new String[]{"Cut", "Copy", "Paste", "Clear"};
        String[] commands = new String[]{"cut", "copy", "paste", "clear"};
        this.addKeyListener(this);
        this._popup = new JPopupMenu();
        Font f = this.getPopupMenuItemFont();
        JMenuItem mi = new JMenuItem("Undo");
        mi.setActionCommand("undo");
        mi.addActionListener(this);
        mi.setVisible(false);
        mi.setFont(f);
        this._popup.add(mi);
        JPopupMenu.Separator c2 = new JPopupMenu.Separator();
        ((Component)c2).setVisible(false);
        this._popup.add(c2);
        int i = 0;
        this._cutMi = new JMenuItem(labels[i]);
        this._cutMi.setActionCommand(commands[i]);
        this._cutMi.addActionListener(this);
        this._cutMi.setFont(f);
        this._popup.add(this._cutMi);
        this._copyMi = new JMenuItem(labels[++i]);
        this._copyMi.setActionCommand(commands[i]);
        this._copyMi.addActionListener(this);
        this._copyMi.setFont(f);
        this._popup.add(this._copyMi);
        this._pasteMi = new JMenuItem(labels[++i]);
        this._pasteMi.setActionCommand(commands[i]);
        this._pasteMi.addActionListener(this);
        this._pasteMi.setFont(f);
        this._popup.add(this._pasteMi);
        this._clearMi = new JMenuItem(labels[++i]);
        this._clearMi.setActionCommand(commands[i]);
        this._clearMi.addActionListener(this);
        this._clearMi.setFont(f);
        this._popup.add(this._clearMi);
        this._popup.addSeparator();
        this._fillMi = new JMenuItem("Fill...");
        this._fillMi.setFont(f);
        this._fillMi.setActionCommand("fill");
        this._fillMi.addActionListener(this);
        this._popup.add(this._fillMi);
        if (Boolean.getBoolean("RmaJTable.HasReverse")) {
            this._reverseMi = new JMenuItem("Reverse");
            this._reverseMi.setFont(f);
            this._reverseMi.setActionCommand("reverse");
            this._reverseMi.addActionListener(this);
            this._popup.add(this._reverseMi);
        }
        this._popup.addSeparator();
        mi = new JMenuItem("Select All");
        mi.setFont(f);
        mi.setActionCommand("selectall");
        mi.addActionListener(this);
        mi.setEnabled(true);
        this._popup.add(mi);
        this._insertMi = new JMenuItem("Insert Row(s)...");
        this._insertMi.setFont(f);
        this._insertMi.setActionCommand("insertrow");
        this._insertMi.addActionListener(this);
        this._popup.add(this._insertMi);
        this._appendMi = new JMenuItem("Append Row");
        this._appendMi.setFont(f);
        this._appendMi.setActionCommand("appendrow");
        this._appendMi.addActionListener(this);
        this._popup.add(this._appendMi);
        this._deleteMi = new JMenuItem("Delete Row(s)");
        this._deleteMi.setFont(f);
        this._deleteMi.setActionCommand("deleterow");
        this._deleteMi.addActionListener(this);
        this._popup.add(this._deleteMi);
        this._popup.addSeparator();
        this._printMi = new JMenuItem("Print...");
        this._printMi.setFont(f);
        this._printMi.setActionCommand("print");
        this._printMi.addActionListener(this);
        this._popup.add(this._printMi);
        this._printPreviewMi = new JMenuItem("Print Preview...");
        this._printPreviewMi.setFont(f);
        this._printPreviewMi.setActionCommand("printPreview");
        this._printPreviewMi.addActionListener(this);
        this._popup.add(this._printPreviewMi);
        this._exportMi = new JMenuItem("Export...");
        this._exportMi.setFont(f);
        this._exportMi.setActionCommand("export");
        this._exportMi.addActionListener(this);
        this._popup.add(this._exportMi);
        this._popup.addSeparator();
        this._sumSelectedCellsMenuItem = new JMenuItem("Sum Selected Cells");
        this._sumSelectedCellsMenuItem.setFont(f);
        this._sumSelectedCellsMenuItem.setActionCommand("sumselected");
        this._sumSelectedCellsMenuItem.addActionListener(this);
        this._popup.add(this._sumSelectedCellsMenuItem);
        this._sumEntireColumnMenuItem = new JMenuItem("Sum Entire Column");
        this._sumEntireColumnMenuItem.setFont(f);
        this._sumEntireColumnMenuItem.setActionCommand("sumcolumn");
        this._sumEntireColumnMenuItem.addActionListener(this);
        this._popup.add(this._sumEntireColumnMenuItem);
        if (this._additionalPopupItems != null) {
            for (int a = this._additionalPopupItems.size() - 1; a >= 0; --a) {
                PopupItem item = this._additionalPopupItems.get(a);
                int pos = item.pos;
                JComponent menuItem = item.comp;
                if (pos < 0) {
                    pos = 0;
                }
                if (pos >= this._popup.getComponentCount()) {
                    pos = this._popup.getComponentCount() - 1;
                }
                menuItem.setFont(f);
                this._popup.insert(menuItem, pos);
            }
        }
    }

    protected Font getPopupMenuItemFont() {
        return UIManager.getFont("TextField.font");
    }

    protected void setUpTabKeys() {
        AbstractAction tabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ancRow = RmaJTable.this.getSelectedRow();
                int ancCol = RmaJTable.this.getSelectedColumn();
                if (ancCol + 1 >= RmaJTable.this.getColumnCount() && RmaJTable.this._parentTbl != null) {
                    RmaJTable.this._parentTbl.tabForwardAction(ancRow, -1);
                } else {
                    RmaJTable.this.tabForwardAction(ancRow, ancCol);
                }
            }
        };
        InputMap imap = this.getInputMap();
        ActionMap amap = this.getActionMap();
        imap.put(KeyStroke.getKeyStroke(9, 0), "tabForward");
        amap.put("tabForward", tabAction);
        AbstractAction tabBackAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ancRow = RmaJTable.this.getSelectedRow();
                int ancCol = RmaJTable.this.getSelectedColumn();
                if (ancCol - 1 < 0 && RmaJTable.this._parentTbl != null) {
                    RmaJTable.this._parentTbl.tabBackAction(ancRow - 1, RmaJTable.this._parentTbl.getColumnCount());
                } else {
                    RmaJTable.this.tabBackAction(ancRow, ancCol);
                }
            }
        };
        imap.put(KeyStroke.getKeyStroke(9, 1), "tabBack");
        amap.put("tabBack", tabBackAction);
        AbstractAction findAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmaJTable.this.findInTableAction();
            }
        };
        imap.put(KeyStroke.getKeyStroke(70, 128), "find");
        amap.put("find", findAction);
    }

    protected void tabBackAction(int ancRow, int ancCol) {
        this.requestFocus();
        this.requestFocus();
        if (ancCol - 1 < 0) {
            if (ancRow - 1 < 0 && this._rowheaderTbl == null) {
                FocusManager.getCurrentManager().focusPreviousComponent(this);
                return;
            }
            if (this._rowheaderTbl != null && ancRow > -1) {
                int hdrColCnt = this._rowheaderTbl.getColumnCount();
                for (int i = hdrColCnt - 1; i >= 0; --i) {
                    if (!this._rowheaderTbl.isCellEditable(ancRow, i)) continue;
                    this._rowheaderTbl.requestFocusInWindow();
                    this._rowheaderTbl.setRowSelectionInterval(ancRow, ancRow);
                    this._rowheaderTbl.setColumnSelectionInterval(i, i);
                    this._rowheaderTbl.setRowSelectionInterval(ancRow, ancRow);
                    this._rowheaderTbl.setColumnSelectionInterval(i, i);
                    this.clearSelection();
                    this._rowheaderTbl.scrollRectToVisible(this._rowheaderTbl.getCellRect(ancRow, i, true));
                    this.scrollRectToVisible(this.getCellRect(ancRow, 0, true));
                    return;
                }
            }
            ancCol = this.getColumnCount() - 1;
            --ancRow;
        } else {
            --ancCol;
        }
        this.commitEdit(true);
        if (this._tabToEditCell && !this.isCellEditable(ancRow, ancCol)) {
            int i;
            int numb = this.getColumnCount();
            boolean ifound = false;
            for (i = ancCol; i >= 0; --i) {
                if (!this.isCellEditable(ancRow, i)) continue;
                ancCol = i;
                ifound = true;
                break;
            }
            if (!ifound && ancRow > 0) {
                for (i = numb - 1; i >= 0; --i) {
                    if (!this.isCellEditable(ancRow - 1, i)) continue;
                    ancCol = i;
                    --ancRow;
                    break;
                }
            }
        }
        if (ancRow > -1) {
            this.setRowSelectionInterval(ancRow, ancRow);
            this.setColumnSelectionInterval(ancCol, ancCol);
            this.setRowSelectionInterval(ancRow, ancRow);
            this.setColumnSelectionInterval(ancCol, ancCol);
            this.scrollRectToVisible(this.getCellRect(ancRow, ancCol, true));
        }
    }

    protected void tabForwardAction(int ancRow, int ancCol) {
        this.requestFocus();
        this.requestFocus();
        int n = ancRow = ancRow < 0 ? 0 : ancRow;
        if (ancCol + 1 >= this.getColumnCount()) {
            if (ancRow + 1 >= this.getRowCount()) {
                FocusManager.getCurrentManager().focusNextComponent(this);
                return;
            }
            ++ancRow;
            ancCol = 0;
            if (this._rowheaderTbl != null) {
                int hdrColCnt = this._rowheaderTbl.getColumnCount();
                for (int i = 0; i < hdrColCnt; ++i) {
                    if (!this._rowheaderTbl.isCellEditable(ancRow, i)) continue;
                    this._rowheaderTbl.requestFocusInWindow();
                    this._rowheaderTbl.setRowSelectionInterval(ancRow, ancRow);
                    this._rowheaderTbl.setColumnSelectionInterval(ancCol, ancCol);
                    this._rowheaderTbl.setRowSelectionInterval(ancRow, ancRow);
                    this._rowheaderTbl.setColumnSelectionInterval(ancCol, ancCol);
                    this.clearSelection();
                    this._rowheaderTbl.scrollRectToVisible(this._rowheaderTbl.getCellRect(ancRow, ancCol, true));
                    this.scrollRectToVisible(this.getCellRect(ancRow, 0, true));
                    return;
                }
            }
        } else {
            ++ancCol;
        }
        this.commitEdit(true);
        RmaJTable tbl = this;
        if (this._tabToEditCell && !this.isCellEditable(ancRow, ancCol)) {
            int colCnt = this.getColumnCount();
            boolean ifound = false;
            for (int i = ancCol; i < colCnt; ++i) {
                if (!this.isCellEditable(ancRow, i)) continue;
                ancCol = i;
                ifound = true;
                break;
            }
            if (!ifound && ancRow < this.getRowCount() - 1) {
                boolean foundNextCell = false;
                if (this._rowheaderTbl != null) {
                    int hdrColCnt = this._rowheaderTbl.getColumnCount();
                    for (int i = 0; i < hdrColCnt; ++i) {
                        if (!this._rowheaderTbl.isCellEditable(ancRow + 1, i)) continue;
                        ancCol = i;
                        ++ancRow;
                        foundNextCell = true;
                        tbl = this._rowheaderTbl;
                        break;
                    }
                }
                if (!foundNextCell) {
                    for (int i = 0; i < colCnt; ++i) {
                        if (!this.isCellEditable(ancRow + 1, i)) continue;
                        ancCol = i;
                        ++ancRow;
                        break;
                    }
                }
            } else if (!ifound && this.getRowCount() >= ancRow) {
                for (int testRow = ancRow; testRow >= 0; --testRow) {
                    if (testRow > this.getRowCount() || !this.isCellEditable(testRow, ancCol)) continue;
                    ancRow = testRow;
                    break;
                }
                if (this.getRowCount() <= ancRow) {
                    return;
                }
            }
        }
        tbl.setRowSelectionInterval(ancRow, ancRow);
        tbl.setColumnSelectionInterval(ancCol, ancCol);
        tbl.setRowSelectionInterval(ancRow, ancRow);
        tbl.setColumnSelectionInterval(ancCol, ancCol);
        tbl.scrollRectToVisible(this.getCellRect(ancRow, ancCol, true));
    }

    protected void findInTableAction() {
        if (this._searcher == null) {
            this._searcher = new TableSearcher(this);
        }
        this._searcher.displayFindDialog();
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent e) {
        if (!this._processKeyEvents) {
            return;
        }
        super.processComponentKeyEvent(e);
        if (e.isConsumed()) {
            return;
        }
        if (e.getKeyCode() == 10 || e.getKeyChar() == '\n') {
            if (e.getID() == 402) {
                // empty if block
            }
        } else if ((e.getKeyCode() == 27 || e.getKeyChar() == '\u001b') && e.getID() == 402) {
            e.consume();
        }
    }

    private boolean editCellOnKeyStroke() {
        int anchorRow = this.getSelectionModel().getAnchorSelectionIndex();
        int anchorColumn = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
        return anchorRow == -1 || anchorColumn == -1 || this.isEditing() || this.editCellAt(anchorRow, anchorColumn, null);
    }

    public void addTableModelListener(TableModelListener l) {
        this.getModel().addTableModelListener(l);
    }

    private void sizeColorVector(int size) {
    }

    public void addTableChangeListener(TableChangeListener t) {
        if (t == null || this._tableChangeListeners.contains(t)) {
            return;
        }
        this._tableChangeListeners.addElement(t);
    }

    public void removeTableChangeListener(TableChangeListener t) {
        if (t == null) {
            return;
        }
        this._tableChangeListeners.removeElement(t);
    }

    public void addTableMinMaxTracker(int col) {
        if (col < 0 || col >= this.getColumnCount()) {
            return;
        }
        MinMaxEntry mme = new MinMaxEntry(col);
        if (!this._tableMinMaxEntries.contains(mme)) {
            this.setMinMax(mme);
            this._tableMinMaxEntries.addElement(mme);
        }
    }

    public void removeCellEditorListener(TableChangeListener l) {
        this._tableChangeListeners.removeElement(l);
    }

    public void addCellEditorListener(CellEditorListener l) {
        for (int i = 0; i < this._cellEditorListeners.size(); ++i) {
            if (!this._cellEditorListeners.contains(l)) continue;
            return;
        }
        this._cellEditorListeners.addElement(l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this._cellEditorListeners.removeElement(l);
    }

    protected void removeEditorListeners() {
        Component comp = this.getEditorComponent();
        if (comp != null && this._modForegroundColor != null) {
            if (comp instanceof JTextComponent) {
                Document doc = ((JTextComponent)comp).getDocument();
                doc.removeDocumentListener(this);
            } else if (comp instanceof AbstractButton) {
                AbstractButton ab = (AbstractButton)comp;
                ab.removeActionListener(this);
            } else if (comp instanceof JComboBox) {
                JComboBox cb = (JComboBox)comp;
                cb.removeItemListener(this);
            }
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.removeEditorListeners();
        super.editingCanceled(e);
        for (int i = 0; i < this._cellEditorListeners.size(); ++i) {
            CellEditorListener obj = this._cellEditorListeners.elementAt(i);
            if (obj == null || !(obj instanceof CellEditorListener)) continue;
            CellEditorListener cel = obj;
            cel.editingCanceled(e);
        }
    }

    public boolean _editingStopped(ChangeEvent e) {
        final TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            Component comp = null;
            if (editor instanceof RmaCellEditor) {
                comp = ((RmaCellEditor)editor).getComponent();
            }
            Object value = editor.getCellEditorValue();
            if (!(!(comp instanceof RmaValidComponent) || ((RmaValidComponent)((Object)comp)).isValid(true) && this.isValid(true))) {
                final int row = this.editingRow;
                final int col = this.editingColumn;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (RmaJTable.this.getEditingRow() != row || RmaJTable.this.getEditingColumn() != col) {
                            RmaJTable.this.editCellAt(row, col);
                            editor.removeCellEditorListener(RmaJTable.this);
                        }
                        RmaJTable.this.setRowSelectionInterval(row, row);
                        RmaJTable.this.setColumnSelectionInterval(col, col);
                        RmaJTable.this.setRowSelectionInterval(row, row);
                        RmaJTable.this.setColumnSelectionInterval(col, col);
                        RmaJTable.this.getEditorComponent().requestFocus();
                    }
                });
                return false;
            }
            this.setValueAt(value, this.editingRow, this.editingColumn);
            if (comp instanceof Modifiable && ((Modifiable)((Object)comp)).isModified()) {
                this.setCellForeground(this.editingRow, this.editingColumn, this._modForegroundColor);
            }
            this.removeEditor();
        }
        return true;
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        this.removeEditorListeners();
        if (!this._editingStopped(e)) {
            return;
        }
        for (int i = 0; i < this._cellEditorListeners.size(); ++i) {
            CellEditorListener obj = this._cellEditorListeners.elementAt(i);
            if (obj == null || !(obj instanceof CellEditorListener)) continue;
            CellEditorListener cel = obj;
            cel.editingStopped(e);
        }
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean b = super.editCellAt(row, column, e);
        if (!b) {
            return b;
        }
        Component comp = this.getEditorComponent();
        if (comp != null && this._modForegroundColor != null) {
            if (comp instanceof JScrollPane) {
                comp = ((JScrollPane)comp).getViewport().getView();
            }
            if (comp instanceof JTextComponent) {
                final JTextComponent textComp = (JTextComponent)comp;
                textComp.setBorder(this._defaultBorder);
                boolean addDocListener = true;
                if (comp instanceof ModifiedEventControl) {
                    addDocListener = ((ModifiedEventControl)((Object)comp)).getForwardModifiedEvents();
                }
                if (addDocListener) {
                    Document doc = ((JTextComponent)comp).getDocument();
                    doc.removeDocumentListener(this);
                    doc.addDocumentListener(this);
                    if (e instanceof MouseEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                textComp.selectAll();
                            }
                        });
                    }
                }
            } else if (comp instanceof AbstractButton) {
                AbstractButton ab = (AbstractButton)comp;
                ab.removeActionListener(this);
                ab.addActionListener(this);
            } else if (comp instanceof JComboBox) {
                JComboBox cb = (JComboBox)comp;
                cb.removeItemListener(this);
                cb.addItemListener(this);
            }
        }
        return b;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (e.getLastRow() == -1) {
            this.setModified(false);
        }
        if (this._tableMinMaxEntries == null) {
            return;
        }
        int size = this._tableMinMaxEntries.size();
        if (size < 1) {
            return;
        }
        int col = e.getColumn();
        int row = e.getFirstRow();
        this.getValueAt(row, col);
        for (int i = 0; i < size; ++i) {
            MinMaxEntry mme = this._tableMinMaxEntries.elementAt(i);
            if (mme._col != col) continue;
            mme._isCurrent = false;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        this.setModified(true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setModified(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setModified(true);
    }

    public Object[] getMinMax(int col) {
        int size = this._tableMinMaxEntries.size();
        Object[] minMax = new Object[2];
        for (int i = 0; i < size; ++i) {
            MinMaxEntry mme = this._tableMinMaxEntries.elementAt(i);
            if (mme._col != col) continue;
            if (!mme._isCurrent) {
                Class<?> type = this.getModel().getColumnClass(col);
                int rows = this.getRowCount();
                mme._min = this.getValueAt(0, col);
                mme._max = this.getValueAt(0, col);
                for (int ii = 1; ii < rows; ++ii) {
                    Object obj1 = this.getValueAt(ii, col);
                    if (obj1.toString().length() < 1) continue;
                    int comp = this.compareValues(mme._min, obj1, type);
                    if (comp > 0) {
                        mme._min = obj1;
                    }
                    if ((comp = this.compareValues(mme._max, obj1, type)) >= 0) continue;
                    mme._max = obj1;
                }
                mme._isCurrent = true;
            }
            if (!mme._isCurrent) continue;
            minMax[0] = mme._min;
            minMax[1] = mme._max;
            return minMax;
        }
        return null;
    }

    private int compareValues(Object newVal, Object oldVal, Class type) {
        if (newVal == null) {
            return 0;
        }
        String sNewVal = newVal.toString();
        String sOldVal = oldVal.toString();
        Class numClass = this.getClassForName("java.lang.Number");
        if (type == numClass || type.getSuperclass() == numClass) {
            double d2;
            double d1;
            try {
                d1 = new Double(sNewVal);
            }
            catch (NumberFormatException nfe) {
                d1 = 0.0;
            }
            try {
                d2 = new Double(sOldVal);
            }
            catch (NumberFormatException nfe) {
                d2 = 0.0;
            }
            if (d1 < d2) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
        if (type == this.getClassForName("java.util.Date")) {
            long n2;
            long n1 = new Date(sNewVal).getTime();
            if (n1 < (n2 = new Date(sOldVal).getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (type == this.getClassForName("java.lang.String")) {
            int result = sNewVal.compareTo(sOldVal);
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == this.getClassForName("java.lang.Boolean")) {
            boolean b2;
            boolean b1 = new Boolean(sNewVal);
            if (b1 == (b2 = new Boolean(sOldVal).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        int result = sNewVal.compareTo(sOldVal);
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Component comp;
        Object value = this.getValueAt(row, column);
        boolean isSelected = this.isCellSelected(row, column);
        Component originalComponent = comp = editor.getTableCellEditorComponent(this, value, isSelected, row, column);
        if (comp instanceof JScrollPane) {
            comp = ((JScrollPane)comp).getViewport().getView();
        }
        if (comp instanceof JComponent) {
            ((JComponent)comp).setNextFocusableComponent(this);
        }
        if (comp != null && comp.getFont() == null) {
            comp.setFont(this.getFont());
        }
        if (comp != null && comp instanceof JTextComponent) {
            ((JTextComponent)comp).selectAll();
        }
        return originalComponent;
    }

    public int getNumRows() {
        return this.getRowCount();
    }

    public Vector<?> getRow(int rowNum) {
        if (this.getModel() instanceof RmaTableModelInterface) {
            return ((RmaTableModelInterface)this.getModel()).getRow(rowNum);
        }
        return null;
    }

    public JScrollPane getScrollPane() {
        Container parent = this.getParent();
        if (parent == null) {
            this._scrollPane.setViewportView(this);
            this._addedToScrollPane = true;
            return this._scrollPane;
        }
        if (parent instanceof JViewport) {
            JViewport viewport = (JViewport)parent;
            JScrollPane sp = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, viewport);
            if (sp == null) {
                this._scrollPane.setViewportView(this);
                this._addedToScrollPane = true;
                return this._scrollPane;
            }
            this._scrollPane = sp;
            return sp;
        }
        return this._scrollPane;
    }

    public void setRowSelectionInterval(int index0, int index1, boolean scrollToSelection) {
        super.setRowSelectionInterval(index0, index1);
        if (scrollToSelection && this._addedToScrollPane && this._scrollPane != null) {
            JScrollBar vertBar = this._scrollPane.getVerticalScrollBar();
            int min = vertBar.getMinimum();
            int max = vertBar.getMaximum();
            if (index0 < 1) {
                vertBar.setValue(min);
            } else if (index0 > this.getRowCount()) {
                vertBar.setValue(max);
            } else {
                float rowPercent = (float)index0 / (float)this.getRowCount();
                int scrollVal = (int)((float)min * rowPercent + (float)max * rowPercent);
                int barVal = vertBar.getValue();
                int vis = vertBar.getVisibleAmount();
                if (scrollVal < barVal || scrollVal > barVal + vis) {
                    vertBar.setValue(scrollVal);
                }
            }
        }
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setModified(boolean modified) {
        this._modified = modified;
        if (this._modForegroundColor != null && !modified) {
            this.setForeground(UIManager.getColor("Table.foreground"));
            Enumeration<String> e = this._cellForeground.keys();
            boolean aChange = false;
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                Color c2 = this._cellForeground.get(key);
                if (c2 != this._modForegroundColor) continue;
                this._cellForeground.remove(key);
                aChange = true;
            }
            if (aChange) {
                this.repaint();
            }
        }
        if (modified) {
            RMAUtil.setParentModified(this);
        }
    }

    public void setParent(Component parent) {
        this._parent = parent;
    }

    public void setColumnWidths(int ... widths) {
        if (widths == null || widths.length == 0) {
            return;
        }
        for (int i = 0; i < widths.length; ++i) {
            this.setColumnWidth(i, widths[i]);
        }
    }

    private void setMinMax(MinMaxEntry mme) {
        if (mme == null) {
            return;
        }
        int col = mme._col;
        if (col >= this.getColumnCount()) {
            return;
        }
        int rows = this.getRowCount();
        for (int i = 0; i < rows; ++i) {
            Object obj = this.getValueAt(i, col);
            mme.checkMin(obj, i);
            mme.checkMax(obj, i);
        }
    }

    public void setDefaultHeaderToolTipText() {
        if (this.getColumnModel() == null) {
            return;
        }
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            Component component;
            TableColumn aColumn = this.getColumnModel().getColumn(i);
            TableCellRenderer renderer = aColumn.getHeaderRenderer();
            if (renderer == null || !((component = renderer.getTableCellRendererComponent(this, aColumn.getHeaderValue(), false, false, -1, i)) instanceof JLabel)) continue;
            JLabel jlabel = (JLabel)component;
            jlabel.setToolTipText(jlabel.getText());
        }
    }

    public void setColumnWidth(int colNum, int width) {
        if (colNum >= this.getColumnCount()) {
            return;
        }
        TableColumn tc = this.getColumnModel().getColumn(colNum);
        if (tc == null) {
            System.out.println("setColumnWidth(): TableColumn at col " + colNum + " is null");
            return;
        }
        if (width == -1) {
            Object obj = tc.getHeaderValue();
            if (obj instanceof String) {
                String st = (String)obj;
                int newWidth = st.length() * 5;
                tc.setPreferredWidth(newWidth);
            }
        } else {
            tc.setPreferredWidth(width);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("copy".equals(command)) {
            this.copy(true);
        } else if ("paste".equals(command)) {
            this.paste();
        } else if ("cut".equals(command)) {
            this.cut();
        } else if ("undo".equals(command)) {
            this.undo();
        } else if ("clear".equals(command)) {
            this.clear(true);
        } else if ("selectall".equals(command)) {
            this.selectAll();
        } else if ("insertrow".equals(command)) {
            this.insertRow();
        } else if ("deleterow".equals(command)) {
            this.deleteRow();
        } else if ("appendrow".equals(command)) {
            if ((event.getModifiers() & 2) != 0) {
                this.appendRows();
            } else {
                this.appendRow();
            }
        } else if ("fill".equals(command)) {
            this.fill();
        } else if ("reverse".equals(command)) {
            this.reverseSelectionContents();
        } else if ("linearFill".equals(command)) {
            this.linearFill();
        } else if ("repeatFill".equals(command)) {
            this.repeatFill();
        } else if ("fillToEnd".equals(command)) {
            this.fillToEnd();
        } else if ("print".equals(command)) {
            this.printData();
        } else if ("printPreview".equals(command)) {
            this.printPreview();
        } else if ("export".equals(command)) {
            this.exportData();
        } else if ("sumselected".equals(command)) {
            this.sumColumn(false);
        } else if ("sumcolumn".equals(command)) {
            this.sumColumn(true);
        }
    }

    public Vector getSelectedRowsVector() {
        Vector selectedData = new Vector();
        if (!this.getRowSelectionAllowed()) {
            return selectedData;
        }
        int[] rows = this.getSelectedRows();
        Vector tableData = this.getCells();
        for (int i = 0; i < rows.length && i <= tableData.size(); ++i) {
            selectedData.addElement(tableData.elementAt(rows[i]));
        }
        return selectedData;
    }

    public Object getSelectedCellData() {
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row > -1 && col > -1) {
            return this.getValueAt(row, col);
        }
        return null;
    }

    public void setNumColumns(int columns) {
        if (!(this.getModel() instanceof RmaTableModelInterface)) {
            return;
        }
        String colName = "";
        int colCount = this.getColumnCount();
        while (columns > this.getColumnCount()) {
            ((RmaTableModelInterface)this.getModel()).addColumn(colName);
            this.revalidate();
            for (int i = colCount; i < columns && i < this.getColumnModel().getColumnCount(); ++i) {
                TableColumn tc = this.getColumnModel().getColumn(i);
                if (tc == null) {
                    return;
                }
                RmaJTextField tf = new RmaJTextField();
                tf.setBorder(this._defaultBorder);
                tf.addMouseListener(this);
                RmaCellEditor dcf = new RmaCellEditor(tf);
                dcf.setClickCountToStart(this._clickCountToStart);
                tc.setCellEditor(dcf);
            }
        }
    }

    public int getClickCountToStart() {
        return this._clickCountToStart;
    }

    private void initRowBackgrounds() {
        Color color = this.getBackground();
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            this._rowBackground.put(new Integer(i), color);
        }
    }

    private void initRowForegrounds() {
        Color color = this.getForeground();
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            this._rowForeground.put(new Integer(i), color);
        }
    }

    public void setRowForeground(int rowNum, Color rfColor) {
        if (rfColor == null) {
            this._rowForeground.remove(new Integer(rowNum));
            return;
        }
        this._rowForeground.put(new Integer(rowNum), rfColor);
    }

    public void setRowBackground(int rowNum, Color rbColor) {
        if (rbColor == null) {
            this._rowBackground.remove(new Integer(rowNum));
            return;
        }
        this._rowBackground.put(new Integer(rowNum), rbColor);
    }

    public void clearRowBackgrounds() {
        this._rowBackground.clear();
    }

    public Color getRowBackground(int rowNum) {
        Color color = this._rowBackground.get(new Integer(rowNum));
        if (color == null) {
            return this.getBackground();
        }
        return color;
    }

    public Color getRowBackground(int rowNum, int colNum) {
        Color color = this._rowBackground.get(new Integer(rowNum));
        if (color == null) {
            return this.getColumnBackground(colNum);
        }
        return color;
    }

    public void setColumnBackground(int colNum, Color color) {
        this._columnBackground.put(new Integer(colNum), color);
    }

    public void setColumnForeground(int colNum, Color color) {
        this._columnForeground.put(new Integer(colNum), color);
    }

    public Color getColumnBackground(int colNum) {
        Color color = this._columnBackground.get(new Integer(colNum));
        if (color == null) {
            return this.getBackground();
        }
        return color;
    }

    public Color getColumnForeground(int colNum) {
        Color color = this._columnForeground.get(new Integer(colNum));
        if (color == null) {
            return super.getForeground();
        }
        return color;
    }

    public void setModifiedForegroundColor(Color color) {
        this._modForegroundColor = color;
    }

    public Color getModifiedForegroundColor() {
        return this._modForegroundColor;
    }

    public void setPasteBackground(Color color) {
        this._pasteBackground = color;
    }

    public void setPasteForeground(Color color) {
        this._pasteForeground = color;
    }

    public Color getPasteBackground() {
        return this._pasteBackground;
    }

    public Color getPasteForeground() {
        return this._pasteForeground;
    }

    public void setCellBackground(int row, int column, Color rbColor) {
        String key = row + "," + column;
        if (rbColor == null) {
            this._cellBackground.remove(key);
        } else {
            this._cellBackground.put(key, rbColor);
        }
    }

    public void setCellForeground(int row, int column, Color rfColor) {
        String key = row + "," + column;
        if (rfColor == null) {
            this._cellForeground.remove(key);
        } else {
            this._cellForeground.put(key, rfColor);
        }
    }

    public void setCellFont(int row, int column, Font font) {
        this._cellFonts.put(row + "," + column, font);
    }

    public Font getCellFont(int row, int column) {
        Font f = this._cellFonts.get(row + "," + column);
        return f;
    }

    public Color getCellBackground(int row, int column) {
        Color col = this._cellBackground.get(row + "," + column);
        if (col == null) {
            return this.getRowBackground(row, column);
        }
        return col;
    }

    public Color getDisabledBackground(int row, int col) {
        return UIManager.getDefaults().getColor("TextField.disabledBackground");
    }

    public Color getCellForeground(int row, int column) {
        Color col = this._cellForeground.get(row + "," + column);
        if (col == null) {
            return this.getRowForeground(row, column);
        }
        return col;
    }

    public Color getRowForeground(int rowNum) {
        Color color = this._rowForeground.get(new Integer(rowNum));
        if (color == null) {
            return this.getForeground();
        }
        return color;
    }

    public Color getRowForeground(int rowNum, int colNum) {
        Color color = this._rowForeground.get(new Integer(rowNum));
        if (color == null) {
            return this.getColumnForeground(colNum);
        }
        return color;
    }

    public void setPrecision(int p) {
        if (p < 0) {
            p = 0;
        }
        this._precision = p;
        if (this._decCellRend != null) {
            this._decCellRend.setPrecision(p);
        }
    }

    public void setAlternatingReportBackground(boolean b) {
        this._alternatingReportBackground = b;
    }

    public boolean getAlternatingReportBackground() {
        return this._alternatingReportBackground;
    }

    public void setAlternatingReportBackgroundColor(Color color) {
        this._alternatingReportBackgroundColor = color;
    }

    public Color getAlternatingReportBackgroundColor() {
        return this._alternatingReportBackgroundColor;
    }

    public int getPrecision() {
        return this._precision;
    }

    public String getColumnLabel(int colNum) {
        String label = null;
        TableColumnModel tcm = this.getColumnModel();
        if (colNum >= 0 && colNum < tcm.getColumnCount()) {
            label = (String)tcm.getColumn(colNum).getHeaderValue();
        }
        return label;
    }

    public String[] getColumnLabels() {
        TableColumnModel tcm = this.getColumnModel();
        String[] colLabels = new String[tcm.getColumnCount()];
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            colLabels[i] = (String)tcm.getColumn(i).getHeaderValue();
        }
        return colLabels;
    }

    public void setColumnLabel(int colNum, String label) {
        String[] labels = this.getColumnLabels();
        if (colNum >= 0 && colNum < labels.length) {
            labels[colNum] = label;
            this.setColumnLabels(labels);
        }
    }

    public void setColumnLabels(String[] colNames) {
        TableColumnModel tcm = this.getColumnModel();
        for (int i = 0; i < colNames.length; ++i) {
            if (i > this.getColumnCount() || i >= tcm.getColumnCount()) {
                return;
            }
            tcm.getColumn(i).setHeaderValue(colNames[i]);
        }
        if (this.getModel() instanceof RmaTableModelInterface) {
            ((RmaTableModelInterface)this.getModel()).setColumnNames(colNames);
        }
        this.revalidate();
    }

    public Color getColumnHeaderForeground(int colNum) {
        Color color = null;
        TableColumnModel tcm = this.getColumnModel();
        if (colNum >= 0 && colNum < tcm.getColumnCount()) {
            TableCellRenderer tcr = tcm.getColumn(colNum).getHeaderRenderer();
            if (tcr == null) {
                tcr = this.getTableHeader().getDefaultRenderer();
            }
            color = tcr.getTableCellRendererComponent(this, "abc", false, false, -1, colNum).getForeground();
        }
        return color;
    }

    public void setColumnHeaderForeground(int colNum, Color color) {
        if (color != null) {
            TableColumnModel tcm = this.getColumnModel();
            if (colNum >= 0 && colNum < tcm.getColumnCount()) {
                TableCellRenderer tcr = tcm.getColumn(colNum).getHeaderRenderer();
                if (tcr == null) {
                    tcr = this.getTableHeader().getDefaultRenderer();
                }
                Component component = tcr.getTableCellRendererComponent(this, "abc", false, false, -1, colNum);
                Color background = component.getBackground();
                Font font = component.getFont();
                Class<?> tcrClass = tcr.getClass();
                try {
                    tcr = (TableCellRenderer)tcrClass.getConstructors()[0].newInstance(new Object[0]);
                    if (tcr instanceof MleHeadRenderer) {
                        ((MleHeadRenderer)tcr).setAllowDefaultFont(true);
                        ((MleHeadRenderer)tcr).setFont(font);
                    }
                    component = tcr.getTableCellRendererComponent(this, "abc", false, false, -1, colNum);
                    component.setForeground(color);
                    component.setBackground(background);
                    component.setFont(font);
                    tcm.getColumn(colNum).setHeaderRenderer(tcr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public Color getColumnHeaderBackground(int colNum) {
        Color color = null;
        TableColumnModel tcm = this.getColumnModel();
        if (colNum >= 0 && colNum < tcm.getColumnCount()) {
            TableCellRenderer tcr = tcm.getColumn(colNum).getHeaderRenderer();
            if (tcr == null) {
                tcr = this.getTableHeader().getDefaultRenderer();
            }
            color = tcr.getTableCellRendererComponent(this, "abc", false, false, -1, colNum).getBackground();
        }
        return color;
    }

    public void setColumnHeaderBackground(int colNum, Color color) {
        if (color != null) {
            TableColumnModel tcm = this.getColumnModel();
            if (colNum >= 0 && colNum < tcm.getColumnCount()) {
                TableCellRenderer tcr = tcm.getColumn(colNum).getHeaderRenderer();
                if (tcr == null) {
                    tcr = this.getTableHeader().getDefaultRenderer();
                }
                Component component = tcr.getTableCellRendererComponent(this, "abc", false, false, -1, colNum);
                Color foreground = component.getForeground();
                Font font = component.getFont();
                Class<?> tcrClass = tcr.getClass();
                try {
                    tcr = (TableCellRenderer)tcrClass.getConstructors()[0].newInstance(new Object[0]);
                    if (tcr instanceof MleHeadRenderer) {
                        ((MleHeadRenderer)tcr).setAllowDefaultFont(true);
                        ((MleHeadRenderer)tcr).setFont(font);
                    }
                    component = tcr.getTableCellRendererComponent(this, "abc", false, false, -1, colNum);
                    component.setForeground(foreground);
                    component.setBackground(color);
                    component.setFont(font);
                    tcm.getColumn(colNum).setHeaderRenderer(tcr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public Font getColumnHeaderFont(int colNum) {
        Font font = null;
        TableColumnModel tcm = this.getColumnModel();
        if (colNum >= 0 && colNum < tcm.getColumnCount()) {
            TableCellRenderer tcr = tcm.getColumn(colNum).getHeaderRenderer();
            if (tcr == null) {
                tcr = this.getTableHeader().getDefaultRenderer();
            }
            font = tcr.getTableCellRendererComponent(this, "abc", false, false, -1, colNum).getFont();
        }
        return font;
    }

    public void setColumnHeaderFont(int colNum, Font font) {
        if (font != null) {
            TableColumnModel tcm = this.getColumnModel();
            if (colNum >= 0 && colNum < tcm.getColumnCount()) {
                TableCellRenderer tcr = tcm.getColumn(colNum).getHeaderRenderer();
                if (tcr == null) {
                    tcr = this.getTableHeader().getDefaultRenderer();
                }
                Component component = tcr.getTableCellRendererComponent(this, "abc", false, false, -1, colNum);
                Color foreground = component.getForeground();
                Color background = component.getBackground();
                Class<?> tcrClass = tcr.getClass();
                try {
                    tcr = (TableCellRenderer)tcrClass.getConstructors()[0].newInstance(new Object[0]);
                    if (tcr instanceof MleHeadRenderer) {
                        ((MleHeadRenderer)tcr).setAllowDefaultFont(true);
                        ((MleHeadRenderer)tcr).setFont(font);
                    }
                    component = tcr.getTableCellRendererComponent(this, "abc", false, false, -1, colNum);
                    component.setForeground(foreground);
                    component.setBackground(background);
                    component.setFont(font);
                    tcm.getColumn(colNum).setHeaderRenderer(tcr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public TableColumn setColumnVisible(int colNum, boolean show, int preferedWidth) throws IllegalArgumentException {
        return this.setColumnVisible(colNum, colNum, show, preferedWidth);
    }

    public TableColumn setColumnVisible(int tmColNum, int tcmColNum, boolean show, int preferedWidth) throws IllegalArgumentException {
        TableColumn tc;
        int modelColNum = this.getModel().getColumnCount();
        if (tmColNum < 0) {
            throw new IllegalArgumentException("Table Model Column " + tmColNum + " less than 0");
        }
        if (tmColNum > modelColNum) {
            throw new IllegalArgumentException("Table Model Column " + tmColNum + " greater than number of columns in Table model " + modelColNum);
        }
        if (tcmColNum < 0) {
            throw new IllegalArgumentException("Table Column Model Column " + tcmColNum + " less than 0");
        }
        TableColumnModel tcm = this.getColumnModel();
        if (!show) {
            tc = tcm.getColumn(tcmColNum);
            this.removeColumn(tc);
        } else {
            tc = new TableColumn(tmColNum, preferedWidth);
            if (this._mleheadrend != null) {
                tc.setHeaderRenderer(this._mleheadrend);
            } else if (this._unitsHeadRend != null) {
                tc.setHeaderRenderer(this._unitsHeadRend);
            }
            tc.setCellRenderer(this._rmaCellRend);
            Class<?> cls = this.getModel().getColumnClass(tcmColNum);
            this._rmaCellRend.setDisplayUnitsSystem(this.getDisplayUnitSystem());
            ParameterScale ps = this._parameterScaleTable.get(new Integer(tcmColNum));
            if (ps != null) {
                this._rmaCellRend.setDisplayScaleFactor(tcmColNum, ps.paramId, ps.scale);
            }
            this.addColumn(tc);
            if (tcmColNum < tcm.getColumnCount()) {
                tcm.moveColumn(tcm.getColumnCount() - 1, tcmColNum);
            }
            TableCellEditor tce = this.getDefaultEditor(cls);
            tc.setCellEditor(tce);
            if (tce instanceof RmaCellEditor) {
                RmaCellEditor dce = (RmaCellEditor)tce;
                dce.setClickCountToStart(this._clickCountToStart);
                Component c2 = dce.getComponent();
                if (c2 != null) {
                    c2.removeMouseListener(this);
                    c2.addMouseListener(this);
                }
            }
        }
        this.revalidate();
        return tc;
    }

    public void displayNumCol(int colNum) {
        if (colNum < 0) {
            return;
        }
        int modelColNum = this.getModel().getColumnCount();
        TableColumnModel tcm = this.getColumnModel();
        if (colNum >= this.getColumnCount()) {
            for (int i = this.getColumnCount(); i < colNum; ++i) {
                if (i > modelColNum) {
                    System.out.println("columns " + i + " greater than model columns " + modelColNum);
                    break;
                }
                TableColumn newCol = new TableColumn(i);
                this.addColumn(newCol);
            }
            this.revalidate();
            this.sizeColumnsToFit(false);
            return;
        }
        for (int i = this.getColumnCount() - 1; i >= colNum; --i) {
            TableColumn tc = tcm.getColumn(i);
            this.removeColumn(tc);
        }
        this.revalidate();
        this.sizeColumnsToFit(false);
    }

    public int getHorizontalAlignment(int col) {
        TableColumn tc = this.getColumnModel().getColumn(col);
        TableCellRenderer tcr = tc.getCellRenderer();
        if (tcr instanceof AlignTableCellRenderer) {
            AlignTableCellRenderer ar = (AlignTableCellRenderer)tc.getCellRenderer();
            return ar.getHorizontalAlignment();
        }
        if (tcr instanceof RmaCellRenderer) {
            RmaCellRenderer rcr = (RmaCellRenderer)tcr;
            return rcr.getHorizontalAlignment();
        }
        if (Number.class.isAssignableFrom(this.getColumnClass(col))) {
            return 4;
        }
        return 2;
    }

    public AlignTableCellRenderer createAlignTableCellRenderer(int align) {
        return new AlignTableCellRenderer(align);
    }

    public void setHorizontalAlignment(int align) {
        AlignTableCellRenderer rtcr = this.createAlignTableCellRenderer(align);
        rtcr.setDisplayUnitsSystem(this.getDisplayUnitSystem());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn tc = this.getColumnModel().getColumn(i);
            if (tc == null) continue;
            ParameterScale ps = this._parameterScaleTable.get(new Integer(this.convertColumnIndexToModel(i)));
            if (ps != null) {
                rtcr.setDisplayScaleFactor(i, ps.paramId, ps.scale);
            }
            tc.setCellRenderer(rtcr);
        }
    }

    public void setHorizontalAlignment(int align, int col) {
        if (col >= this.getColumnCount()) {
            return;
        }
        AlignTableCellRenderer rtcr = this.createAlignTableCellRenderer(align);
        rtcr.setDisplayUnitsSystem(this.getDisplayUnitSystem());
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return;
        }
        ParameterScale ps = this._parameterScaleTable.get(new Integer(this.convertColumnIndexToModel(col)));
        if (ps != null) {
            rtcr.setDisplayScaleFactor(col, ps.paramId, ps.scale);
        }
        tc.setCellRenderer(rtcr);
    }

    public void setTabToEditCell(boolean tabToEditCell) {
        this._tabToEditCell = tabToEditCell;
    }

    public RmaJDecimalField setCurrencyCellEditor(int col) {
        TableColumnModel tcm = this.getColumnModel();
        if (this._currencyCellRend == null) {
            this._currencyCellRend = new CurrencyCellRenderer();
        }
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        RmaJDecimalField ta = new RmaJDecimalField();
        ta.setPrecision(2);
        ta.addMouseListener(this);
        RmaCellEditor dcf = new RmaCellEditor(ta);
        this.setHorizontalAlignment(4, col);
        dcf.setClickCountToStart(this._clickCountToStart);
        tc.setCellEditor(dcf);
        if (this.getModel() instanceof RmaTableModelInterface) {
            ((RmaTableModelInterface)this.getModel()).setColumnClass(col, Number.class);
        }
        tc.setCellRenderer(this._currencyCellRend);
        return ta;
    }

    public JTextArea setTextAreaCellEditor(int col, boolean addSrcollPane) {
        TableColumnModel tcm = this.getColumnModel();
        if (this._mlCellRend == null) {
            this._mlCellRend = new MultiLineCellRenderer();
        }
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        RmaJTextArea ta = new RmaJTextArea();
        ta.setWrapStyleWord(true);
        ta.setLineWrap(true);
        ta.setToolTipText("");
        ta.setFont(this.getFont());
        ta.addMouseListener(this);
        RmaCellEditor dcf = new RmaCellEditor(ta, addSrcollPane);
        dcf.setClickCountToStart(this._clickCountToStart);
        tc.setCellEditor(dcf);
        tc.setCellRenderer(this._mlCellRend);
        this._hasMultilineRenderer = true;
        return ta;
    }

    public JTextArea setTextAreaCellEditor(int col) {
        return this.setTextAreaCellEditor(col, true);
    }

    public void setToggleCellEditor(int col, char key1, char key2, char toggleKey) {
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return;
        }
        ToggleDocument td = new ToggleDocument();
        td.setToggleValues(key1, key2);
        td.setToggleKey(toggleKey);
        RmaJTextField tf = new RmaJTextField(td, "" + key1, 5);
        tf.setBorder(this._defaultBorder);
        tf.addMouseListener(this);
        RmaCellEditor dcf = new RmaCellEditor(tf);
        dcf.setClickCountToStart(this._clickCountToStart);
        tc.setCellEditor(dcf);
    }

    public JButton setButtonCellEditor(int col) {
        JButton button = new JButton();
        button.setFocusPainted(false);
        RmaCellEditor ce = new RmaCellEditor(button);
        this.getColumnModel().getColumn(col).setCellEditor(ce);
        this.getColumnModel().getColumn(col).setCellRenderer(new ButtonRenderer());
        return button;
    }

    public void setDoubleCellEditor() {
        this.setDoubleCellEditor(false);
    }

    public void setDoubleCellEditor(boolean showFormatting) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.setDoubleCellEditor(i, showFormatting);
        }
    }

    public void setDoubleCellEditor(int beginCol, int endCol) {
        this.setDoubleCellEditor(beginCol, endCol, false);
    }

    public void setDoubleCellEditor(int beginCol, int endCol, boolean showFormatting) {
        for (int i = beginCol; i <= endCol; ++i) {
            this.setDoubleCellEditor(i, showFormatting);
        }
    }

    public RmaJDecimalField setDoubleCellEditor(int col) {
        return this.setDoubleCellEditor(col, false);
    }

    public RmaJDecimalField setDoubleCellEditor(int col, boolean showFormatting) {
        TableColumnModel tcm = this.getColumnModel();
        if (showFormatting && this._decCellRend == null) {
            this._decCellRend = new DecimalCellRenderer(this._precision);
        }
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        RmaJDecimalField df = this.createDecimalField(col, this._precision);
        RmaCellEditor dcf = new RmaCellEditor(df);
        dcf.setDisplayUnitSystem(this.getDisplayUnitSystem());
        ParameterScale ps = this._parameterScaleTable.get(new Integer(this.convertColumnIndexToModel(col)));
        if (ps != null) {
            dcf.setDisplayScaleFactor(ps.paramId, ps.scale);
        }
        dcf.setClickCountToStart(this._clickCountToStart);
        tc.setCellEditor(dcf);
        if (showFormatting) {
            tc.setCellRenderer(this._decCellRend);
        } else {
            this.setHorizontalAlignment(4, col);
        }
        if (this.getModel() instanceof RmaTableModelInterface) {
            ((RmaTableModelInterface)this.getModel()).setColumnClass(col, Number.class);
        }
        return df;
    }

    public RmaJDecimalField setDoubleEditorForCell(int row, int col) {
        RmaJDecimalField fld = new RmaJDecimalField();
        fld.setHorizontalAlignment(4);
        return (RmaJDecimalField)this.setEditorForCell(row, col, fld);
    }

    protected JTextField setEditorForCell(int row, int col, JTextField fld) {
        if (row < 0 || row >= this.getNumRows()) {
            return null;
        }
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        fld.addMouseListener(this);
        TableCellEditor tce = tc.getCellEditor();
        RmaCellEditor dcf = new RmaCellEditor(fld);
        dcf.setClickCountToStart(1);
        dcf.setDisplayUnitSystem(this.getDisplayUnitSystem());
        if (tce instanceof RowCellEditor) {
            ((RowCellEditor)tce).add(row, dcf);
        } else {
            RowCellEditor rce = new RowCellEditor(tce);
            tc.setCellEditor(rce);
            rce.add(row, dcf);
            rce.setClickCountToStart(1);
        }
        return fld;
    }

    protected RmaJDecimalField createDecimalField(int col, int precision) {
        RmaJDecimalField df = new RmaJDecimalField(0, 5);
        df.setPrecision(precision);
        df.setHorizontalAlignment(4);
        df.addMouseListener(this);
        return df;
    }

    public RmaJIntegerField setIntegerCellEditor(int col) {
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        RmaJIntegerField df = new RmaJIntegerField(0, 5);
        df.setHorizontalAlignment(4);
        df.addMouseListener(this);
        RmaCellEditor dcf = new RmaCellEditor(df);
        dcf.setDisplayUnitSystem(this.getDisplayUnitSystem());
        ParameterScale ps = this._parameterScaleTable.get(new Integer(this.convertColumnIndexToModel(col)));
        if (ps != null) {
            dcf.setDisplayScaleFactor(ps.paramId, ps.scale);
        }
        dcf.setClickCountToStart(this._clickCountToStart);
        tc.setCellEditor(dcf);
        this.setHorizontalAlignment(4, col);
        if (this.getModel() instanceof RmaTableModelInterface) {
            ((RmaTableModelInterface)this.getModel()).setColumnClass(col, Number.class);
        }
        return df;
    }

    public RmaJIntegerField setIntegerEditorForCell(int row, int col) {
        RmaJIntegerField fld = new RmaJIntegerField();
        fld.setHorizontalAlignment(4);
        return (RmaJIntegerField)this.setEditorForCell(row, col, fld);
    }

    public RmaJLongField setLongCellEditor(int col) {
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        RmaJLongField lf = new RmaJLongField(0L, 5);
        lf.setHorizontalAlignment(4);
        lf.addMouseListener(this);
        RmaCellEditor dcf = new RmaCellEditor(lf);
        dcf.setDisplayUnitSystem(this.getDisplayUnitSystem());
        ParameterScale ps = this._parameterScaleTable.get(new Integer(this.convertColumnIndexToModel(col)));
        if (ps != null) {
            dcf.setDisplayScaleFactor(ps.paramId, ps.scale);
        }
        dcf.setClickCountToStart(this._clickCountToStart);
        tc.setCellEditor(dcf);
        this.setHorizontalAlignment(4, col);
        if (this.getModel() instanceof RmaTableModelInterface) {
            ((RmaTableModelInterface)this.getModel()).setColumnClass(col, Number.class);
        }
        return lf;
    }

    public RmaJDescriptionField setDescriptionCellEditor(int col) {
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        RmaJDescriptionField df = new RmaJDescriptionField();
        df.addMouseListener(this);
        RmaCellEditor dcf = new RmaCellEditor(df);
        dcf.setDisplayUnitSystem(this.getDisplayUnitSystem());
        ParameterScale ps = this._parameterScaleTable.get(new Integer(this.convertColumnIndexToModel(col)));
        if (ps != null) {
            dcf.setDisplayScaleFactor(ps.paramId, ps.scale);
        }
        dcf.setClickCountToStart(this._clickCountToStart);
        tc.setCellEditor(dcf);
        this.setHorizontalAlignment(2, col);
        if (this.getModel() instanceof RmaTableModelInterface) {
            ((RmaTableModelInterface)this.getModel()).setColumnClass(col, String.class);
        }
        return df;
    }

    public RmaJ24HourTimeField setTimeCellEditor(int col) {
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        RmaJ24HourTimeField mf = new RmaJ24HourTimeField();
        mf.addMouseListener(this);
        RmaCellEditor dcf = new RmaCellEditor(mf);
        dcf.setClickCountToStart(this._clickCountToStart);
        tc.setCellEditor(dcf);
        this.setHorizontalAlignment(0, col);
        if (this.getModel() instanceof RmaTableModelInterface) {
            ((RmaTableModelInterface)this.getModel()).setColumnClass(col, Number.class);
        }
        return mf;
    }

    public RmaJ24HourTimeField setTimeEditorForCell(int row, int col) {
        RmaJ24HourTimeField mf = new RmaJ24HourTimeField();
        return (RmaJ24HourTimeField)this.setEditorForCell(row, col, mf);
    }

    public RmaJDateField setDateEditorForCell(int row, int col, String format, boolean showCalendar) {
        RmaJDateField df = showCalendar ? new RmaJCalendarField(format, "") : new RmaJDateField(format, "");
        return (RmaJDateField)this.setEditorForCell(row, col, df);
    }

    public RmaJCalendarField setDateCellEditor(int col, String format) {
        return (RmaJCalendarField)this.setDateCellEditor(col, format, true);
    }

    public RmaJDateField setDateCellEditor(int col, String format, boolean showCalendar) {
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        RmaJDateField df = null;
        df = showCalendar ? new RmaJCalendarField(format, "") : new RmaJDateField(format, "");
        df.addMouseListener(this);
        RmaCellEditor dcf = new RmaCellEditor(df);
        dcf.setClickCountToStart(1);
        tc.setCellEditor(dcf);
        this.setHorizontalAlignment(2, col);
        if (this.getModel() instanceof RmaTableModelInterface) {
            ((RmaTableModelInterface)this.getModel()).setColumnClass(col, Number.class);
        }
        return df;
    }

    public RmaJDateTimeField setDateTimeCellEditor(int col) {
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        RmaJDateTimeField df = new RmaJDateTimeField();
        df.addMouseListener(this);
        RmaCellEditor dcf = new RmaCellEditor(df);
        dcf.setClickCountToStart(1);
        tc.setCellEditor(dcf);
        this.setHorizontalAlignment(2, col);
        if (this.getModel() instanceof RmaTableModelInterface) {
            ((RmaTableModelInterface)this.getModel()).setColumnClass(col, Number.class);
        }
        return df;
    }

    public RmaJDateTimeField setDateTimeEditorForCell(int row, int col) {
        RmaJDateTimeField df = new RmaJDateTimeField();
        return (RmaJDateTimeField)this.setEditorForCell(row, col, df);
    }

    public RmaJDssPathPartField setDssPathPartCellEditor(int col) {
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        RmaJDssPathPartField df = new RmaJDssPathPartField();
        df.addMouseListener(this);
        RmaCellEditor dcf = new RmaCellEditor(df);
        dcf.setClickCountToStart(this._clickCountToStart);
        tc.setCellEditor(dcf);
        if (this.getModel() instanceof RmaTableModelInterface) {
            ((RmaTableModelInterface)this.getModel()).setColumnClass(col, Number.class);
        }
        return df;
    }

    public void clearAllComboBoxRowEditorValues(int col) {
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return;
        }
        TableCellEditor tce = tc.getCellEditor();
        if (tce instanceof RowCellEditor) {
            RowCellEditor rce = (RowCellEditor)tce;
            Map map = rce.getCellEditorTable();
            Collection values = map.values();
            for (Object obj : values) {
                if (!(obj instanceof JComboBox)) continue;
                ((JComboBox)obj).removeAllItems();
            }
        }
    }

    public RmaJComboBox setComboBoxRowEditor(int row, int col, Vector data) {
        if (row < 0 || row >= this.getNumRows()) {
            return null;
        }
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        RmaJComboBox cb = new RmaJComboBox(data);
        return this.setComboBoxCellEditor(row, col, cb);
    }

    public RmaJComboBox setComboBoxCellEditor(int row, int col, RmaJComboBox comboBox) {
        if (row < 0 || row >= this.getNumRows()) {
            return null;
        }
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        comboBox.addItemListener(this);
        comboBox.addMouseListener(this);
        comboBox.getEditor().getEditorComponent().addMouseListener(this);
        TableCellEditor tce = tc.getCellEditor();
        RmaCellEditor dcf = new RmaCellEditor(comboBox);
        dcf.setClickCountToStart(1);
        if (tce instanceof RowCellEditor) {
            ((RowCellEditor)tce).add(row, dcf);
        } else {
            RowCellEditor rce = new RowCellEditor(tce);
            tc.setCellEditor(rce);
            rce.add(row, dcf);
            rce.setClickCountToStart(1);
        }
        ComboBoxRenderer cellRenderer = new ComboBoxRenderer();
        TableCellRenderer tcr = tc.getCellRenderer();
        if (tcr instanceof RowCellRenderer) {
            RowCellRenderer rcr = (RowCellRenderer)tcr;
            rcr.add(row, cellRenderer);
        } else {
            RowCellRenderer rcr = new RowCellRenderer(tcr);
            tc.setCellRenderer(rcr);
            rcr.add(row, cellRenderer);
        }
        dcf.setClickCountToStart(1);
        return comboBox;
    }

    public void setTextFieldRowEditor(int row, int col, String value) {
        TableColumn tc = this.getColumnModel().getColumn(col);
        RmaJTextField textField = new RmaJTextField(value);
        RmaCellEditor textEditor = new RmaCellEditor(textField);
        RmaCellRenderer cellRenderer = new RmaCellRenderer();
        TableCellEditor tce = tc.getCellEditor();
        if (tce instanceof RowCellEditor) {
            ((RowCellEditor)tce).add(row, textEditor);
        } else {
            RowCellEditor rce = new RowCellEditor(tce);
            rce.add(row, textEditor);
            rce.setClickCountToStart(1);
            tc.setCellEditor(rce);
        }
        TableCellRenderer tcr = tc.getCellRenderer();
        if (tcr instanceof RowCellRenderer) {
            RowCellRenderer rcr = (RowCellRenderer)tcr;
            rcr.add(row, cellRenderer);
        } else {
            RowCellRenderer rcr = new RowCellRenderer(tcr);
            tc.setCellRenderer(rcr);
            rcr.add(row, cellRenderer);
        }
    }

    public RmaJColorComboBox setColorComboBoxEditor(int col) {
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        RmaJColorComboBox cb = new RmaJColorComboBox();
        cb.addMouseListener(this);
        cb.getEditor().getEditorComponent().addMouseListener(this);
        RmaCellEditor dcf = new RmaCellEditor(cb);
        dcf.setClickCountToStart(this._clickCountToStart);
        tc.setCellRenderer(new RmaColorRenderer());
        tc.setCellEditor(dcf);
        return cb;
    }

    public JComboBox setComboBoxEditor(int col, Object[] data) {
        return this.setComboBoxEditor(col, data, true);
    }

    public JComboBox setComboBoxEditor(int col, Object[] data, boolean sortData) {
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        RmaJComboBox cb = this.createComboBoxEditor(col, data, sortData);
        cb.setModifiable(true);
        cb.setBorder(null);
        cb.addMouseListener(this);
        cb.getEditor().getEditorComponent().addMouseListener(this);
        RmaCellEditor dcf = new RmaCellEditor(cb);
        dcf.setClickCountToStart(1);
        ComboBoxRenderer cellRenderer = new ComboBoxRenderer();
        tc.setCellRenderer(cellRenderer);
        tc.setCellEditor(dcf);
        return cb;
    }

    protected RmaJComboBox createComboBoxEditor(int col, Object[] data, boolean sortData) {
        RmaListModel<Object> model = new RmaListModel<Object>(sortData, data);
        return new RmaJComboBox<Object>(model);
    }

    public JComboBox setComboBoxEditor(int col, Vector data) {
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        RmaJComboBox cb = new RmaJComboBox(data);
        cb.setBorder(null);
        cb.setModifiable(true);
        cb.addMouseListener(this);
        cb.getEditor().getEditorComponent().addMouseListener(this);
        RmaCellEditor dcf = new RmaCellEditor(cb);
        dcf.setClickCountToStart(1);
        tc.setCellRenderer(new ComboBoxRenderer());
        tc.setCellEditor(dcf);
        return cb;
    }

    public void setColumnEditor(int col, RmaCellEditor editor) {
        this.setColumnEditor(col, editor, null);
    }

    public void setColumnEditor(int col, RmaCellEditor editor, TableCellRenderer renderer) {
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return;
        }
        Component c2 = editor.getComponent();
        c2.addMouseListener(this);
        editor.setClickCountToStart(this._clickCountToStart);
        tc.setCellEditor(editor);
        if (renderer != null) {
            tc.setCellRenderer(renderer);
        }
    }

    public void setFixedLengthCellEditor(int col, int length, int Case) {
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return;
        }
        FixedLengthDocument fld = new FixedLengthDocument(length);
        if (Case == 1) {
            fld.setUppercase();
        } else if (Case == -1) {
            fld.setLowercase();
        }
        RmaJTextField tf = new RmaJTextField(fld, "", length);
        tf.setBorder(this._defaultBorder);
        tf.addMouseListener(this);
        RmaCellEditor dcf = new RmaCellEditor(tf);
        dcf.setClickCountToStart(this._clickCountToStart);
        tc.setCellEditor(dcf);
    }

    public void setUnitsHeaderRenderer() {
        this.setUnitsHeaderRenderer(false);
    }

    public void setUnitsHeaderRenderer(boolean useDefaultRenderer) {
        this._unitsHeadRend = new UnitsHeaderRenderer(useDefaultRenderer);
        TableColumnModel tcm = this.getTableHeader().getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            tc.setHeaderRenderer(this._unitsHeadRend);
        }
    }

    public MleHeadRenderer setMlHeaderRenderer() {
        this._mleheadrend = new MleHeadRenderer();
        TableColumnModel tcm = this.getTableHeader().getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            tc.setHeaderRenderer(this._mleheadrend);
        }
        return this._mleheadrend;
    }

    public JCheckBox setCheckBoxCellEditor(int col) {
        return this.setCheckBoxCellEditor(col, true);
    }

    public JCheckBox setCheckBoxCellEditor(int col, boolean useSelectionBackground) {
        TableColumnModel tcm = this.getColumnModel();
        if (col > tcm.getColumnCount()) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        RmaJCheckBox cb = new RmaJCheckBox();
        cb.setHorizontalAlignment(0);
        cb.setBorder(this._defaultBorder);
        RmaCellEditor dcf = new RmaCellEditor(cb);
        dcf.setClickCountToStart(1);
        tc.setCellEditor(dcf);
        TableCellRenderer dcr = this.createBooleanRenderer(useSelectionBackground);
        tc.setCellRenderer(dcr);
        this.setColumnWidth(col, -1);
        return cb;
    }

    protected TableCellRenderer createBooleanRenderer(boolean useSelectionBackground) {
        return new BooleanRenderer(useSelectionBackground);
    }

    public void setAllColumnsEnabled(boolean enable) {
        if (!(this.getModel() instanceof RmaTableModelInterface)) {
            return;
        }
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            ((RmaTableModelInterface)this.getModel()).setColEnabled(enable, i);
        }
    }

    @Override
    public void setIsEditable(boolean b) {
        this._isEditable = b;
        this.setMenusEnabled(b);
        boolean enabled = b;
        if (!this.addRemoveEnabled || !b) {
            enabled = false;
        }
        this._insertMi.setVisible(enabled);
        this._insertMi.setEnabled(enabled);
        this._appendMi.setVisible(enabled);
        this._appendMi.setEnabled(enabled);
        this._deleteMi.setVisible(enabled);
        this._deleteMi.setEnabled(enabled);
        Color bgColor = UIManager.getColor("Table.background");
        if (bgColor == null) {
            bgColor = Color.white;
        }
        this.setBackground(b ? bgColor : this.getDisabledBackground(0, 0));
        super.setEnabled(b);
    }

    @Override
    public void setEnabled(boolean enable) {
        this.setEditable(enable);
    }

    public final void setUseNonContiguousSelection(boolean useNonContiguousSelection) {
        this._useNonContiguousSelection = useNonContiguousSelection;
        if (useNonContiguousSelection && Objects.isNull(this._nonContiguousSelectionModel)) {
            this._nonContiguousSelectionModel = new NonContiguousSelectionModel();
        }
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        if (this._useNonContiguousSelection && this.getRowSelectionAllowed() && this.getColumnSelectionAllowed()) {
            if (!toggle && !extend) {
                this._nonContiguousSelectionModel.clear();
                this._nonContiguousSelectionModel.add(rowIndex, columnIndex);
            } else if (!toggle && extend) {
                if (!this._nonContiguousSelectionModel.contains(rowIndex, columnIndex)) {
                    this._nonContiguousSelectionModel.add(rowIndex, columnIndex);
                }
            } else if (toggle && !extend) {
                if (this._nonContiguousSelectionModel.contains(rowIndex, columnIndex)) {
                    this._nonContiguousSelectionModel.remove(rowIndex, columnIndex);
                } else {
                    this._nonContiguousSelectionModel.add(rowIndex, columnIndex);
                }
            }
            this.repaint();
        }
    }

    @Override
    public boolean isCellSelected(int row, int column) {
        if (this._useNonContiguousSelection) {
            return this._nonContiguousSelectionModel.contains(row, column);
        }
        return super.isCellSelected(row, column);
    }

    @Override
    public void clearSelection() {
        if (this._useNonContiguousSelection) {
            this._nonContiguousSelectionModel.clear();
        } else {
            super.clearSelection();
        }
    }

    @Override
    public int[] getSelectedRows() {
        if (this._useNonContiguousSelection) {
            return this._nonContiguousSelectionModel.getSelectedRows();
        }
        return super.getSelectedRows();
    }

    @Override
    public int[] getSelectedColumns() {
        if (this._useNonContiguousSelection) {
            return this._nonContiguousSelectionModel.getSelectedColumns();
        }
        return super.getSelectedColumns();
    }

    protected void setMenusEnabled(boolean editable) {
        if (this._defaultPopup && this._popup != null) {
            JMenuItem c2 = this._cutMi;
            ((Component)c2).setEnabled(editable);
            ((Component)c2).setVisible(editable);
            c2 = this._pasteMi;
            ((Component)c2).setEnabled(editable);
            ((Component)c2).setVisible(editable);
            c2 = this._clearMi;
            ((Component)c2).setEnabled(editable);
            ((Component)c2).setVisible(editable);
            c2 = this._fillMi;
            ((Component)c2).setEnabled(editable);
            ((Component)c2).setVisible(editable);
            if (this.addRemoveEnabled) {
                this._insertMi.setEnabled(editable);
                this._insertMi.setVisible(editable);
            }
            if (this.addRemoveEnabled) {
                this._appendMi.setEnabled(editable);
                this._appendMi.setVisible(editable);
            }
            if (this.addRemoveEnabled) {
                this._deleteMi.setEnabled(editable);
                this._deleteMi.setVisible(editable);
            }
        }
    }

    public void setEditable(boolean editable) {
        this.setMenusEnabled(editable);
        this.setAllColumnsEnabled(editable);
        this._editable = editable;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setRowEnabled(boolean enable, int row) {
        TableModel model = this.getModel();
        if (!(model instanceof RmaTableModelInterface)) {
            return;
        }
        ((RmaTableModelInterface)model).setRowEnabled(enable, row);
    }

    public void resetRowEnabled() {
        TableModel model = this.getModel();
        if (!(model instanceof RmaTableModelInterface)) {
            return;
        }
        ((RmaTableModelInterface)model).resetRowEnabled();
    }

    public void setColumnsEnabled(boolean enabled, int ... cols) {
        if (!(this.getModel() instanceof RmaTableModelInterface)) {
            return;
        }
        for (int i = 0; i < cols.length; ++i) {
            ((RmaTableModelInterface)this.getModel()).setColEnabled(enabled, cols[i]);
        }
    }

    public void setColumnEnabled(boolean enable, int col) {
        if (!(this.getModel() instanceof RmaTableModelInterface)) {
            return;
        }
        ((RmaTableModelInterface)this.getModel()).setColEnabled(enable, col);
    }

    public void setCellEnabled(boolean enable, int row, int col) {
        if (row < 0 || col < 0) {
            return;
        }
        TableModel tm = this.getModel();
        if (tm instanceof RmaTableModelInterface) {
            ((RmaTableModelInterface)tm).setCellEnabled(enable, row, col);
        } else {
            System.out.println("setCellEnabled: tableModel not a RmaTableModel it's a" + tm.getClass());
        }
    }

    public void setColumnsEnabled(boolean[] enabled) {
        for (int i = 0; i < enabled.length; ++i) {
            this.setColumnEnabled(enabled[i], i);
        }
    }

    public void setNumRows(int rows) {
        block3: {
            int curRowCnt;
            block2: {
                curRowCnt = this.getRowCount();
                if (rows <= curRowCnt) break block2;
                for (int i = curRowCnt; i < rows; ++i) {
                    this.appendRow();
                }
                break block3;
            }
            if (rows >= curRowCnt) break block3;
            for (int i = 0; i < curRowCnt - rows; ++i) {
                this.removeLastRow();
            }
        }
    }

    public Vector getSelectedCells() {
        Object obj = this.getSelectedCellData();
        Vector<Object> v = new Vector<Object>();
        v.addElement(obj);
        return v;
    }

    public CellLocation getFirstSelectedCell() {
        int[] cols = this.getSelectedColumns();
        int[] rows = this.getSelectedRows();
        if (rows.length == 0 || cols.length == 0) {
            System.out.println("No Row or column selected");
            return null;
        }
        CellLocation cl = new CellLocation(rows[0], cols[0], this.getValueAt(rows[0], cols[0]));
        return cl;
    }

    public CellLocation getLastSelectedCell() {
        int[] cols = this.getSelectedColumns();
        int[] rows = this.getSelectedRows();
        if (rows.length == 0 || cols.length == 0) {
            return null;
        }
        CellLocation cl = new CellLocation(rows[rows.length - 1], cols[cols.length - 1], this.getValueAt(rows[rows.length - 1], cols[cols.length - 1]));
        return cl;
    }

    public Vector<CellLocation> getSelectedCellRange() {
        Vector<CellLocation> v = new Vector<CellLocation>();
        int[] cols = this.getSelectedColumns();
        int[] rows = this.getSelectedRows();
        if (rows.length == 0 && cols.length == 0) {
            return v;
        }
        for (int r = 0; r < rows.length; ++r) {
            int c2;
            if (this.getCellSelectionEnabled()) {
                for (c2 = 0; c2 < cols.length; ++c2) {
                    CellLocation cl = new CellLocation(rows[r], cols[c2], this.getValueAt(rows[r], cols[c2]));
                    v.addElement(cl);
                }
                continue;
            }
            if (this.getRowSelectionAllowed()) {
                TableColumnModel tcm = this.getColumnModel();
                for (c2 = 0; c2 < tcm.getColumnCount(); ++c2) {
                    CellLocation cl = new CellLocation(rows[r], c2, this.getValueAt(rows[r], c2));
                    v.addElement(cl);
                }
                continue;
            }
            if (!this.getColumnSelectionAllowed()) continue;
        }
        return v;
    }

    public Vector<Vector<CellLocation>> getSelectedCellRangeVector() {
        Vector<Vector<CellLocation>> v = new Vector<Vector<CellLocation>>();
        int[] cols = this.getSelectedColumns();
        int[] rows = this.getSelectedRows();
        if (rows.length == 0 && cols.length == 0) {
            return v;
        }
        for (int r = 0; r < rows.length; ++r) {
            Vector<CellLocation> row = new Vector<CellLocation>();
            for (int c2 = 0; c2 < cols.length; ++c2) {
                CellLocation cl = new CellLocation(rows[r], cols[c2], this.getValueAt(rows[r], cols[c2]));
                row.addElement(cl);
            }
            v.addElement(row);
        }
        return v;
    }

    protected Vector<Vector<CellLocation>> getFillToEndCellRangeVector() {
        Vector<Vector<CellLocation>> v = new Vector<Vector<CellLocation>>();
        int[] cols = this.getSelectedColumns();
        int[] rows = this.getSelectedRows();
        if (rows.length == 0 && cols.length == 0) {
            return v;
        }
        int lastRow = this.getRowCount();
        if (rows[rows.length - 1] != lastRow) {
            int size = lastRow - rows[0];
            int[] newRows = new int[size];
            System.arraycopy(rows, 0, newRows, 0, rows.length);
            int idx = rows[rows.length - 1] + 1;
            for (int i = rows[rows.length - 1]; i < newRows.length; ++i) {
                newRows[i] = idx++;
            }
            rows = newRows;
        }
        for (int r = 0; r < rows.length; ++r) {
            Vector<CellLocation> row = new Vector<CellLocation>();
            for (int c2 = 0; c2 < cols.length; ++c2) {
                CellLocation cl = new CellLocation(rows[r], cols[c2], this.getValueAt(rows[r], cols[c2]));
                row.addElement(cl);
            }
            v.addElement(row);
        }
        return v;
    }

    public Vector<Vector<CellLocation>> getColumnCellRangeVector() {
        Vector<Vector<CellLocation>> v = new Vector<Vector<CellLocation>>();
        int[] cols = this.getSelectedColumns();
        if (cols.length == 0) {
            return v;
        }
        for (int r = 0; r < this.getRowCount(); ++r) {
            Vector<CellLocation> row = new Vector<CellLocation>();
            for (int c2 = 0; c2 < cols.length; ++c2) {
                CellLocation cl = new CellLocation(r, cols[c2], this.getValueAt(r, cols[c2]));
                row.addElement(cl);
            }
            v.addElement(row);
        }
        return v;
    }

    public Object getCell(int row, int col) {
        return this.getModel().getValueAt(row, col);
    }

    public void setCell(Object obj, int row, int col) {
        this.getModel().setValueAt(obj, row, col);
    }

    @Override
    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        if (tableModel instanceof GroupableColumnTableModel) {
            List<8> level;
            GroupableColumnTableModel gtm = (GroupableColumnTableModel)((Object)tableModel);
            GroupableTableHeader header = new GroupableTableHeader(this.getColumnModel());
            this.setTableHeader(header);
            int numGroupLevels = gtm.getNumberColumnGroupLevels();
            ArrayList<List<8>> cgLevels = new ArrayList<List<8>>();
            for (int zz = 0; zz < numGroupLevels; ++zz) {
                level = new ArrayList();
                int numColumnGroups = gtm.getNumberColumnGroups(zz);
                TableColumnModel tcm = this.getColumnModel();
                cgLevels.add(level);
                for (int i = 0; i < numColumnGroups; ++i) {
                    int start = gtm.getStartColumnIndex(zz, i);
                    int end = gtm.getEndColumnIndex(zz, i);
                    final GroupableColumnTableModel gtm2 = gtm;
                    final int clevel = zz;
                    final int cgroup = i;
                    ColumnGroup cg = new ColumnGroup(gtm.getColumnGroupName(zz, i)){

                        @Override
                        public Object getHeaderValue() {
                            return gtm2.getColumnGroupName(clevel, cgroup);
                        }
                    };
                    if (zz == 0) {
                        for (int z = start; z <= end; ++z) {
                            if (z < 0 || z >= tcm.getColumnCount()) continue;
                            cg.add(tcm.getColumn(z));
                        }
                    } else {
                        List subLevel = (List)cgLevels.get(zz - 1);
                        for (int z = start; z <= end; ++z) {
                            if (z < 0 || z >= subLevel.size()) continue;
                            cg.add(subLevel.get(z));
                        }
                    }
                    level.add(cg);
                }
            }
            for (int i = cgLevels.size() - 1; i >= 0; --i) {
                level = (List)cgLevels.get(i);
                for (int z = 0; z < level.size(); ++z) {
                    header.addColumnGroup((ColumnGroup)level.get(z));
                }
            }
        }
    }

    public void setCells(Object[][] data) {
        if (data == null) {
            return;
        }
        while (data.length >= this.getRowCount()) {
            this.appendRow();
        }
        for (int row = 0; row < data.length; ++row) {
            this.setRow(row, data[row]);
        }
    }

    public void setCells(Vector data) {
        if (data == null) {
            return;
        }
        while (data.size() >= this.getRowCount()) {
            this.appendRow();
        }
        for (int row = 0; row < data.size(); ++row) {
            this.setRow(row, (Vector)data.elementAt(row));
        }
    }

    public boolean setRow(int rowNum, Object[] rowData) {
        Vector<Object> rData = new Vector<Object>();
        for (int i = 0; i < rowData.length; ++i) {
            rData.addElement(rowData[i]);
        }
        return this.setRow(rowNum, rData);
    }

    public boolean setRow(int rowNum, Vector rowData) {
        if (rowNum > this.getRowCount()) {
            return false;
        }
        if (rowData.size() < this.getColumnCount()) {
            rowData.ensureCapacity(this.getColumnCount());
        }
        for (int i = 0; i < this.getColumnCount() && i < rowData.size(); ++i) {
            String data;
            Object obj = rowData.elementAt(i);
            if (obj == null) {
                data = "";
            } else if (obj instanceof String) {
                data = (String)obj;
            } else if (obj instanceof CellLocation) {
                data = (String)((CellLocation)obj).getData();
            } else if (obj instanceof Identifier) {
                this.setValueAt(obj, rowNum, i);
                data = null;
            } else {
                this.setValueAt(obj, rowNum, i);
                data = null;
            }
            if (data == null) continue;
            this.setValueAt(data, rowNum, i);
        }
        this.revalidate();
        return true;
    }

    public Vector getCells() {
        if (!(this.getModel() instanceof RmaTableModelInterface)) {
            return null;
        }
        return ((RmaTableModelInterface)this.getModel()).getDataVector();
    }

    public void clearAll() {
        this.clearColors();
        this.deleteCells();
        for (int i = 0; i < this.getModel().getColumnCount() + 1; ++i) {
            try {
                this.setColumnVisible(0, false, 0);
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        this.setColumnLabels(new String[0]);
    }

    public void clearColors() {
        this._rowForeground.clear();
        this._rowBackground.clear();
        this._cellForeground.clear();
        this._cellBackground.clear();
        this._columnForeground.clear();
        this._columnBackground.clear();
    }

    public void clearCells() {
        for (int c2 = 0; c2 < this.getColumnCount(); ++c2) {
            Object empty = this.getClearedCellValue(c2);
            for (int r = 0; r < this.getRowCount(); ++r) {
                try {
                    this.setValueAt(empty, r, c2);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println("clearCells:" + e);
                    System.out.println("clearCells:" + this.getColumnModel().getColumn(c2).getHeaderValue());
                    System.out.println("clearCells:row=" + r + " col=" + c2);
                    RowSorter<? extends TableModel> rs = this.getRowSorter();
                    if (rs instanceof TableRowSorter) {
                        TableRowSorter trs = (TableRowSorter)rs;
                        TableModel model = (TableModel)trs.getModel();
                        System.out.println("clearCells:sorter model max row=" + model.getRowCount() + " max col=" + model.getColumnCount());
                    }
                    System.out.println("clearCells:model max row=" + this.getModel().getRowCount() + " max col=" + this.getModel().getColumnCount());
                    e.printStackTrace();
                }
            }
        }
        this.revalidate();
        this.repaint();
    }

    protected Object getClearedCellValue(int col) {
        return "";
    }

    public void deleteCells() {
        if (!(this.getModel() instanceof RmaTableModelInterface)) {
            return;
        }
        ((RmaTableModelInterface)this.getModel()).clearAll();
    }

    public boolean commitEdit(boolean commit) {
        if (!this.isEditing()) {
            return true;
        }
        TableCellEditor dce = this.getCellEditor();
        if (dce == null) {
            return true;
        }
        if (commit) {
            return dce.stopCellEditing();
        }
        dce.cancelCellEditing();
        return true;
    }

    @Override
    public void textValueChanged(TextEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        int keyCode = ke.getKeyCode();
        if (!ke.isControlDown()) {
            return;
        }
        switch (keyCode) {
            case 88: {
                this.cut();
                break;
            }
            case 67: {
                this.copy(true);
                ke.consume();
                break;
            }
            case 86: {
                this.paste();
                ke.consume();
                break;
            }
            case 65: {
                this.traverseCellRight();
                break;
            }
            case 90: {
                this.undo();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (RmaJTextField.isCursorKey(ke.getKeyCode())) {
            if (ke.getKeyCode() == 35) {
                if (this._lastKeyWasEnd) {
                    int lastRow = this.getRowCount() - 1;
                    int lastCol = this.getColumnCount() - 1;
                    this.updateSelection(lastRow, lastCol, false, false);
                }
                this._lastKeyWasEnd = true;
            } else {
                this._lastKeyWasEnd = false;
            }
            return;
        }
        if (!this.isEditing()) {
            return;
        }
        if (!this._modified) {
            this.setModified(true);
        }
        this._modified = true;
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.handlePopupMenu(event);
    }

    protected void handlePopupMenu(MouseEvent event) {
        if (this._popup == null) {
            return;
        }
        if (!event.isMetaDown() || !this._popupEnabled) {
            return;
        }
        boolean visible = this.getModel() instanceof RmaTableModelInterface;
        this._insertMi.setVisible(visible);
        this._appendMi.setVisible(visible);
        this._deleteMi.setVisible(visible);
        if (!SwingUtilities.isRightMouseButton(event)) {
            if (this._popup.isVisible()) {
                this._popup.setVisible(false);
            }
            return;
        }
        this._popupPoint = event.getPoint();
        int x = event.getX();
        int y = event.getY();
        Object obj = this.getSelectedCellData();
        Component comp = this.getEditorComponent();
        if (event.getSource() != this) {
            return;
        }
        if (comp != null && event.getSource() == this) {
            comp = null;
        }
        if (obj == null) {
            // empty if block
        }
        int column = this.columnAtPoint(event.getPoint());
        int row = this.rowAtPoint(event.getPoint());
        if (column == 0 && (this._rowHeaderEnabled || this._autoRowHeaders)) {
            return;
        }
        if (this._defaultPopup) {
            if (this._firstFixedRow && row == 0) {
                this._insertMi.setEnabled(false);
            } else if (this.addRemoveEnabled && this._editable && this.isEnabled()) {
                this._insertMi.setEnabled(true);
            }
        }
        Dimension dim = this._popup.getPreferredSize();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension scrnsiz = toolkit.getScreenSize();
        Point pt0 = this.getLocationOnScreen();
        int windowsToolBarHeight = 50;
        int offset = scrnsiz.height - (pt0.y + y + dim.height + windowsToolBarHeight);
        if (offset < 0) {
            y += offset;
        }
        boolean isaNumber = this.isCellaNumber(row, column, obj);
        if (this._editable) {
            if (this.isCellEditable(row, column)) {
                this.setMenusEnabled(true);
                if (isaNumber) {
                    this._fillMi.setEnabled(this.getSelectedRowCount() > 0);
                }
            } else {
                this.setMenusEnabled(false);
            }
        }
        if (this.shouldShowPopup(this._popupPoint)) {
            if (comp != null && this.isEditing()) {
                this._popup.show(comp, x, y);
            } else {
                this._popup.show(this, x, y);
            }
        }
    }

    boolean isCellaNumber(int row, int column, Object obj) {
        if (row < 0 || column < 0 || row >= this.getRowCount() || column >= this.getColumnCount()) {
            return false;
        }
        if (obj == null) {
            obj = this.getValueAt(row, column);
        }
        if (obj != null && obj instanceof HecDouble) {
            return true;
        }
        boolean isaNumber = Number.class.isAssignableFrom(this.getColumnClass(column));
        if (!isaNumber && obj != null) {
            String s = obj.toString().trim();
            if (s.length() == 0) {
                return true;
            }
            Number ob = null;
            try {
                ob = new DecimalFormat().parse(s);
                if (ob != null) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return isaNumber;
    }

    protected boolean shouldShowPopup(Point popupPoint) {
        return true;
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public boolean mouseDown(Event event, int x, int y) {
        return true;
    }

    boolean checkEditDouble(String text) {
        if (text.length() == 1 && (text.equals(".") || text.equals("-") || text.equals("+"))) {
            return true;
        }
        if (text.length() == 2 && (text.equals("-.") || text.equals("+."))) {
            return true;
        }
        try {
            new Double(text);
        }
        catch (NumberFormatException efmt) {
            return false;
        }
        return true;
    }

    boolean checkEditFloat(String text) {
        if (text.length() == 1 && (text.equals(".") || text.equals("-") || text.equals("+"))) {
            return true;
        }
        if (text.length() == 2 && (text.equals("-.") || text.equals("+."))) {
            return true;
        }
        try {
            new Float(text);
        }
        catch (NumberFormatException efmt) {
            return false;
        }
        return true;
    }

    boolean checkEditInteger(String text) {
        try {
            new Integer(text);
        }
        catch (NumberFormatException efmt) {
            return false;
        }
        return true;
    }

    protected void fireTableChangeEvent(int changeType, int startRow, int startCol, int endRow, int endCol) {
        TableUpdateEvent tue = new TableUpdateEvent(this, startRow, startCol, endRow, endCol, changeType);
        for (int i = 0; i < this._tableChangeListeners.size(); ++i) {
            this._tableChangeListeners.elementAt(i).tableDataChanged(tue);
        }
        if (changeType != TableUpdateEvent.COPY) {
            this.setModified(true);
        }
    }

    @Override
    public void clearPerformed() {
        this.commitEdit(true);
        this.clearCells();
    }

    @Override
    public void selectAll() {
        super.selectAll();
    }

    public void undo() {
    }

    public void cut() {
        this.commitEdit(true);
        CellLocation ce = this.getFirstSelectedCell();
        CellLocation ce2 = this.getLastSelectedCell();
        this.copy(false);
        this.clear(false);
        if (ce == null || ce2 == null) {
            return;
        }
        this.fireTableChangeEvent(TableUpdateEvent.CLEAR, ce.getRow(), ce.getCol(), ce2.getRow(), ce2.getCol());
    }

    public void fillColumn(int[] values, int col) {
        if (col >= this.getModel().getColumnCount()) {
            return;
        }
        int rowCnt = this.getModel().getRowCount();
        int end = rowCnt > values.length ? values.length : rowCnt;
        for (int i = 0; i < end; ++i) {
            if (i >= rowCnt) {
                return;
            }
            this.setValueAt(new Integer(values[i]), i, col);
        }
    }

    public void fillColumn(Object[] values, int col) {
        if (col >= this.getModel().getColumnCount()) {
            return;
        }
        int rowCnt = this.getModel().getRowCount();
        int end = rowCnt > values.length ? values.length : rowCnt;
        for (int i = 0; i < end; ++i) {
            if (i >= rowCnt) {
                return;
            }
            this.setValueAt(values[i], i, col);
        }
    }

    private void fillColumn(Object value, int startRow, int col, int rows) {
        if (col >= this.getModel().getColumnCount()) {
            return;
        }
        for (int i = startRow; i < rows + startRow; ++i) {
            if (i >= this.getModel().getRowCount()) {
                return;
            }
            if (!this.isCellEditable(i, col)) continue;
            if (this._pasteBackground != null) {
                this.setCellBackground(i, col, this._pasteBackground);
            }
            if (this._pasteForeground != null) {
                this.setCellForeground(i, col, this._pasteForeground);
            }
            if (value instanceof ParamDouble) {
                ParamDouble pd = (ParamDouble)value;
                try {
                    ParamDouble pdnew = (ParamDouble)pd.clone();
                    this.setValueAt(pdnew, i, col);
                }
                catch (Exception e) {
                    this.setValueAt(pd.toString(), i, col);
                }
                continue;
            }
            this.setValueAt(value, i, col);
        }
    }

    protected RmaJTableFillDialog getFillDialog(RmaJTable table) {
        return RmaJTableFillDialog.getFillDialog(this);
    }

    public void fill() {
        CellLocation firstCell;
        this.cellEditor = this.getCellEditor();
        if (this.cellEditor != null) {
            this.cellEditor.stopCellEditing();
        }
        if ((firstCell = this.getFirstSelectedCell()) == null) {
            return;
        }
        Object obj = this.getValueAt(firstCell.getRow(), firstCell.getCol());
        if (this.isCellaNumber(firstCell.getRow(), firstCell.getCol(), obj)) {
            if (this._fillDialog == null) {
                this._fillDialog = this.getFillDialog(this);
            }
            this._fillDialog.setVisible(true);
            if (this._fillDialog.isCanceled()) {
                return;
            }
        } else {
            this.linearFill();
        }
    }

    public void reverseSelectionContents() {
        CellLocation firstCell;
        this.cellEditor = this.getCellEditor();
        if (this.cellEditor != null) {
            this.cellEditor.stopCellEditing();
        }
        if ((firstCell = this.getFirstSelectedCell()) == null) {
            return;
        }
        CellLocation lastCell = this.getLastSelectedCell();
        if (lastCell == null) {
            return;
        }
        int last = lastCell.getRow();
        int end = lastCell.getRow() / 2 + 1;
        int col = firstCell.getCol();
        for (int r = firstCell.getRow(); r < end; ++r) {
            Object obj = this.getValueAt(r, col);
            Object obj2 = this.getValueAt(last, col);
            this.setValueAt(obj2, r, col);
            this.setValueAt(obj, last, col);
            --last;
        }
        this.setModified(true);
    }

    public void linearFill() {
        CellLocation lastCell = this.getLastSelectedCell();
        CellLocation firstCell = this.getFirstSelectedCell();
        Vector<Vector<CellLocation>> cellTable = this.getSelectedCellRangeVector();
        this.linearFill(firstCell, lastCell, cellTable);
    }

    public void linearFill(CellLocation firstCell, CellLocation lastCell) {
        if (firstCell == null || lastCell == null) {
            return;
        }
        if (firstCell.getCol() != lastCell.getCol()) {
            System.out.println("linearFill(): startCell col " + firstCell.getCol() + " != stopCell col " + lastCell.getCol());
            return;
        }
        if (firstCell.getRow() > lastCell.getRow()) {
            System.out.println("linearFill(): startCell row " + firstCell.getRow() + " > stopCell row " + lastCell.getRow());
            return;
        }
        Vector<Vector<CellLocation>> cellTable = new Vector<Vector<CellLocation>>(lastCell.getRow() - firstCell.getRow());
        int col = firstCell.getCol();
        for (int r = firstCell.getRow(); r <= lastCell.getRow(); ++r) {
            Vector<CellLocation> row = new Vector<CellLocation>();
            for (int c2 = 0; c2 < 1; ++c2) {
                CellLocation cl = new CellLocation(r, col, this.getValueAt(r, col));
                row.addElement(cl);
            }
            cellTable.addElement(row);
        }
        this.linearFill(firstCell, lastCell, cellTable);
    }

    private void linearFill(CellLocation firstCell, CellLocation lastCell, Vector<Vector<CellLocation>> cellTable) {
        System.out.println("linearFill: start=" + firstCell + " end=" + lastCell + " cells=" + cellTable.size());
        if (lastCell != null && !lastCell.equals(firstCell)) {
            Vector<CellLocation> row = cellTable.elementAt(0);
            for (int i = 0; i < row.size(); ++i) {
                int len;
                int idx;
                double startVal;
                double endVal;
                firstCell = row.elementAt(i);
                Object startValue = firstCell.getData();
                lastCell = cellTable.elementAt(cellTable.size() - 1).elementAt(i);
                Object endValue = lastCell.getData();
                int startRow = firstCell.getRow();
                int c2 = firstCell.getCol();
                int stopRow = lastCell.getRow();
                int numSteps = stopRow - startRow;
                if (numSteps == 0) {
                    numSteps = 1;
                }
                String endValueStr = null;
                String startValueStr = null;
                if (endValue != null) {
                    endValueStr = endValue.toString();
                }
                if (startValue != null) {
                    startValueStr = startValue.toString();
                }
                if ("".equals(endValueStr)) {
                    this.fillColumn(startValue, startRow, c2, cellTable.size());
                    continue;
                }
                try {
                    endVal = RMAIO.parseDouble(endValue);
                    startVal = RMAIO.parseDouble(startValue);
                    if (!RMAConst.isValidValue(startVal)) {
                        JOptionPane.showMessageDialog(this, "Start Value for Fill is invalid", "Invalid Value", 1);
                        return;
                    }
                    if (!RMAConst.isValidValue(endVal)) {
                        JOptionPane.showMessageDialog(this, "End Value for Fill is invalid", "Invalid Value", 1);
                        return;
                    }
                }
                catch (NumberFormatException nfe) {
                    System.out.println("linearFill: " + nfe);
                    this.fillColumn(startValue, startRow, c2, cellTable.size());
                    continue;
                }
                int sPrecision = -1;
                int ePrecision = -1;
                if (startValueStr != null) {
                    idx = startValueStr.indexOf(".");
                    len = startValueStr.length() - 1;
                    sPrecision = len - idx;
                }
                if (endValueStr != null) {
                    idx = endValueStr.indexOf(".");
                    len = endValueStr.length() - 1;
                    ePrecision = len - idx;
                }
                int usePrecision = Math.max(sPrecision, ePrecision);
                double stepValue = (endVal - startVal) / (double)numSteps;
                for (int j = 1; j < cellTable.size() - 1; ++j) {
                    if (!this.isCellEditable(startRow + j, c2)) continue;
                    double value = startVal + stepValue * (double)j;
                    TableColumn tc = this.getColumnModel().getColumn(c2);
                    TableCellEditor tce = tc.getCellEditor();
                    if (tce instanceof RmaCellEditor) {
                        Component cmp = ((RmaCellEditor)tce).getComponent();
                        if (cmp instanceof RmaJDecimalField) {
                            if (this.getValueAt(startRow + j, c2) instanceof ParamDouble) {
                                ParamDouble pdv = (ParamDouble)this.getValueAt(startRow + j, c2);
                                int iprecis = pdv.getPrecision();
                                if (this._precision > iprecis && iprecis != -1) {
                                    iprecis = this._precision;
                                }
                                iprecis = Math.max(iprecis, usePrecision);
                                pdv.setValue(value);
                                pdv.setPrecision(iprecis);
                                this.setValueAt(pdv, startRow + j, c2);
                            } else {
                                int precision = Math.max(this._precision, usePrecision);
                                this.setValueAt(new Double(RMAIO.setPrecision2(value, precision)), startRow + j, c2);
                            }
                        } else if (cmp instanceof RmaJIntegerField) {
                            this.setValueAt(new Integer(RMAIO.setPrecision2(value, 0)), startRow + j, c2);
                        } else {
                            int precision = Math.max(this._precision, usePrecision);
                            this.setValueAt(new Double(RMAIO.setPrecision2(value, precision)), startRow + j, c2);
                        }
                    } else {
                        int precision = Math.max(this._precision, usePrecision);
                        this.setValueAt(RMAIO.setPrecision2(value, precision), startRow + j, c2);
                    }
                    if (this._pasteBackground != null) {
                        this.setCellBackground(startRow + j, c2, this._pasteBackground);
                    }
                    if (this._pasteForeground == null) continue;
                    this.setCellForeground(startRow + j, c2, this._pasteForeground);
                }
            }
        }
        this.repaint();
        if (firstCell != null && lastCell != null) {
            this.fireTableChangeEvent(TableUpdateEvent.LINEAR_FILL, firstCell.getRow(), firstCell.getCol(), lastCell.getRow(), lastCell.getCol());
        }
    }

    public void constantFill(double constantValue) {
        this.valueFill(constantValue, true);
    }

    public void factorFill(double factorValue) {
        this.valueFill(factorValue, false);
    }

    protected void valueFill(double fillValue, boolean addIt) {
        if (RMAConst.isUndefinedValue(fillValue)) {
            return;
        }
        Vector<Vector<CellLocation>> cellTable = this.getSelectedCellRangeVector();
        CellLocation lastCell = this.getLastSelectedCell();
        CellLocation firstCell = this.getFirstSelectedCell();
        if (lastCell != null) {
            for (int i = 0; i < cellTable.size(); ++i) {
                Vector<CellLocation> row = cellTable.elementAt(i);
                for (int j = 0; j < row.size(); ++j) {
                    int c2;
                    int r;
                    block17: {
                        CellLocation cl = row.get(j);
                        r = cl.getRow();
                        c2 = cl.getCol();
                        Object value = cl.getData();
                        if (!this.isCellEditable(r, c2)) continue;
                        if (value instanceof ParamDouble) {
                            ParamDouble pd = (ParamDouble)value;
                            if (addIt) {
                                pd.setValue(pd.getValue() + fillValue);
                            } else {
                                pd.setValue(pd.getValue() * fillValue);
                            }
                            try {
                                this.setValueAt(pd, r, c2);
                                break block17;
                            }
                            catch (Exception e) {
                                continue;
                            }
                        }
                        if (value instanceof Double) {
                            Double nd = addIt ? new Double((Double)value + fillValue) : new Double((Double)value * fillValue);
                            this.setValueAt(nd, r, c2);
                        } else if (value instanceof HecDouble) {
                            HecDouble newValue = new HecDouble((HecDouble)value);
                            if (addIt) {
                                newValue.add(fillValue);
                            } else {
                                newValue.multiply(fillValue);
                            }
                            this.setValueAt(newValue, r, c2);
                        } else {
                            double d = RMAIO.parseDouble(value.toString());
                            if (!RMAConst.isValidValue(d)) continue;
                            d = addIt ? (d += fillValue) : (d *= fillValue);
                            this.setValueAt(RMAIO.toTable(d), r, c2);
                        }
                    }
                    if (this._pasteBackground != null) {
                        this.setCellBackground(r, c2, this._pasteBackground);
                    }
                    if (this._pasteForeground == null) continue;
                    this.setCellForeground(r, c2, this._pasteForeground);
                }
            }
        }
        this.repaint();
        lastCell = this.getLastSelectedCell();
        firstCell = this.getFirstSelectedCell();
        if (firstCell != null && lastCell != null) {
            this.fireTableChangeEvent(TableUpdateEvent.REPEAT_FILL, firstCell.getRow(), firstCell.getCol(), lastCell.getRow(), lastCell.getCol());
        }
    }

    public void fillToEnd() {
        CellLocation lastCell = this.getLastSelectedCell();
        int rowCnt = this.getRowCount() - 1;
        lastCell.setRow(rowCnt);
        Vector<Vector<CellLocation>> cellTable = this.getFillToEndCellRangeVector();
        this.repeatFill(cellTable, this.getFirstSelectedCell(), lastCell);
    }

    public void repeatFill() {
        Vector<Vector<CellLocation>> cellTable = this.getSelectedCellRangeVector();
        CellLocation lastCell = this.getLastSelectedCell();
        CellLocation firstCell = this.getFirstSelectedCell();
        this.repeatFill(cellTable, firstCell, lastCell);
    }

    protected void repeatFill(Vector<Vector<CellLocation>> cellTable, CellLocation firstCell, CellLocation lastCell) {
        if (lastCell != null && !lastCell.equals(firstCell)) {
            Vector<CellLocation> row = cellTable.elementAt(0);
            for (int i = 0; i < row.size(); ++i) {
                Object value = row.elementAt(i).getData();
                int r = row.elementAt(i).getRow();
                int c2 = row.elementAt(i).getCol();
                for (int j = 1; j < cellTable.size(); ++j) {
                    if (!this.isCellEditable(r + j, c2)) continue;
                    if (value instanceof ParamDouble) {
                        ParamDouble pd = (ParamDouble)value;
                        try {
                            ParamDouble pdnew = (ParamDouble)pd.clone();
                            this.setValueAt(pdnew, r + j, c2);
                        }
                        catch (Exception e) {
                            this.setValueAt(pd.toString(), r + j, c2);
                        }
                    } else {
                        this.setValueAt(value, r + j, c2);
                    }
                    if (this._pasteBackground != null) {
                        this.setCellBackground(r + j, c2, this._pasteBackground);
                    }
                    if (this._pasteForeground == null) continue;
                    this.setCellForeground(r + j, c2, this._pasteForeground);
                }
            }
        }
        this.repaint();
        lastCell = this.getLastSelectedCell();
        firstCell = this.getFirstSelectedCell();
        if (firstCell != null && lastCell != null) {
            this.fireTableChangeEvent(TableUpdateEvent.REPEAT_FILL, firstCell.getRow(), firstCell.getCol(), lastCell.getRow(), lastCell.getCol());
        }
    }

    public void sumColumn(boolean entireColumn) {
        Vector<Vector<CellLocation>> cellTable = entireColumn ? this.getColumnCellRangeVector() : this.getSelectedCellRangeVector();
        double sum = 0.0;
        boolean found = false;
        for (int i = 0; i < cellTable.size(); ++i) {
            Vector<CellLocation> row = cellTable.elementAt(i);
            for (int j = 0; j < row.size(); ++j) {
                double d;
                CellLocation cl = row.get(j);
                int r = cl.getRow();
                int c2 = cl.getCol();
                Object value = cl.getData();
                if (value instanceof ParamDouble) {
                    ParamDouble pd = (ParamDouble)value;
                    if (pd.doubleValue() == Double.NEGATIVE_INFINITY) continue;
                    sum += pd.doubleValue();
                    found = true;
                    continue;
                }
                if (value instanceof Double) {
                    if ((Double)value == Double.NEGATIVE_INFINITY) continue;
                    sum += ((Double)value).doubleValue();
                    found = true;
                    continue;
                }
                if (value instanceof HecDouble) {
                    if (((HecDouble)value).isDefined()) {
                        sum += ((HecDouble)value).value();
                    }
                    found = true;
                    continue;
                }
                if (value.toString().trim().length() <= 0 || !RMAConst.isValidValue(d = RMAIO.parseDouble(value.toString()))) continue;
                sum += d;
                found = true;
            }
        }
        if (!found) {
            JOptionPane.showMessageDialog(this._parent, "No valid values found for selected column.", "Sum", 2);
        } else {
            HecDouble hecDouble = new HecDouble(sum);
            if (entireColumn) {
                JOptionPane.showMessageDialog(this._parent, "       Column sum = " + hecDouble, "Sum", -1);
            } else {
                JOptionPane.showMessageDialog(this._parent, "      Selected cells sum = " + hecDouble, "Sum", -1);
            }
        }
    }

    public void paste() {
        int i = 0;
        Clipboard cb = this.getToolkit().getSystemClipboard();
        Transferable t = cb.getContents(this);
        if (t == null) {
            this.getToolkit().beep();
            System.out.println("paste:no data in clipboard");
            return;
        }
        this.commitEdit(true);
        try {
            String cellValues = (String)t.getTransferData(DataFlavor.stringFlavor);
            if (_pasteDebug) {
                System.out.println("paste: pasting [" + cellValues + "]");
            }
            StringTokenizer rows = new StringTokenizer(cellValues, "\r\n", true);
            Vector<Vector<CellLocation>> cellTable = this.getSelectedCellRangeVector();
            CellLocation lastCell = this.getLastSelectedCell();
            CellLocation firstCell = this.getFirstSelectedCell();
            int rowCnt = 1;
            this.getColumnModel();
            int invalidCnt = 0;
            boolean lastRowWasSeparator = false;
            boolean lastWasToken = false;
            boolean firstCellInRow = false;
            this.getModel();
            int colCnt = this.getColumnCount();
            rowCnt = this.getRowCount();
            if (lastCell != null && lastCell.equals(firstCell)) {
                int numAddRows;
                int numOfPasteRows;
                int r = firstCell.getRow();
                int c2 = firstCell.getCol();
                if (_pasteDebug) {
                    System.out.println("paste:no selection so starting at row=" + r + " col=" + c2 + " rowCnt=" + rows.countTokens());
                }
                int numberTokens = rows.countTokens();
                int count = 0;
                if (this._pasteAddsRows && r + (numOfPasteRows = numberTokens / 2 + 1) > rowCnt) {
                    numAddRows = r + numOfPasteRows - rowCnt;
                    if (_pasteDebug) {
                        System.out.println("paste:have " + numOfPasteRows + " rows to add. starting at row " + r + " adding " + numAddRows + " rows.");
                    }
                    this.appendRows(numAddRows);
                    rowCnt = this.getRowCount();
                }
                while (rows.hasMoreTokens()) {
                    if (r >= rowCnt) {
                        if (_pasteDebug) {
                            System.out.println("paste: at end of rows");
                        }
                        if (!this._pasteAddsRows) break;
                        numOfPasteRows = (numberTokens - count) / 2 + 1;
                        if (r + numOfPasteRows > rowCnt) {
                            numAddRows = r + numOfPasteRows - rowCnt;
                            if (_pasteDebug) {
                                System.out.println("paste:have " + numOfPasteRows + " rows to add. starting at row " + r + " adding " + numAddRows + " rows.");
                            }
                            this.appendRows(numAddRows);
                            rowCnt = this.getRowCount();
                        }
                    }
                    String rowToken = rows.nextToken();
                    ++count;
                    c2 = firstCell.getCol();
                    if (rowToken.equals("\r\n") || rowToken.equals("\r") || rowToken.equals("\n")) {
                        if (lastRowWasSeparator) {
                            if (_pasteDebug) {
                                System.out.println("paste:missing data row at " + r + " using empty string");
                            }
                            this.pasteCell("", r, c2);
                            ++r;
                        }
                        lastRowWasSeparator = true;
                        continue;
                    }
                    lastRowWasSeparator = false;
                    if (_pasteDebug) {
                        System.out.println("row(" + r + ")=[" + rowToken + "]");
                    }
                    StringTokenizer cells = new StringTokenizer(rowToken, "\t", true);
                    if (_pasteDebug) {
                        System.out.println("paste: have " + cells.countTokens() + " cols for row " + r);
                    }
                    firstCellInRow = true;
                    while (cells.hasMoreTokens()) {
                        String str = cells.nextToken();
                        if (str.equals("\t")) {
                            if (lastWasToken || firstCellInRow) {
                                if (_pasteDebug) {
                                    System.out.println("paste:missing data point at " + r + "," + c2 + " using empty string");
                                }
                                this.pasteCell("", r, c2);
                                if (c2 + 1 < this.getColumnCount()) {
                                    ++c2;
                                } else {
                                    ++r;
                                    for (int k = 0; k < this.getColumnCount(); ++k) {
                                        if (!this.isCellEditable(r, k)) continue;
                                        c2 = k;
                                    }
                                }
                            }
                            lastWasToken = true;
                            continue;
                        }
                        lastWasToken = false;
                        firstCellInRow = false;
                        if (c2 >= colCnt) {
                            if (!_pasteDebug) continue;
                            System.out.println("paste: at end of cols");
                            continue;
                        }
                        invalidCnt += this.pasteCell(str, r, c2);
                        if (c2 + 1 >= this.getColumnCount()) continue;
                        ++c2;
                    }
                    ++r;
                }
                this.fireTableChangeEvent(TableUpdateEvent.PASTE, firstCell.getRow(), firstCell.getCol(), r, c2);
                if (invalidCnt > 0) {
                    System.out.println("Found " + invalidCnt + " cells with invalid data");
                }
                this.revalidate();
                this.repaint();
                return;
            }
            if (cellTable.size() < 1) {
                if (_pasteDebug) {
                    System.out.println("paste: no cellTables selected");
                }
                return;
            }
            rowCnt = this.getRowCount();
            if (_pasteDebug) {
                System.out.println("paste: filling selected range");
            }
            block6: for (int k = i; k < cellTable.size(); k += rowCnt) {
                Vector<CellLocation> rowVec = cellTable.elementAt(k);
                if (rowVec == null || rowVec.size() == 0) continue;
                rows = new StringTokenizer(cellValues, "\r\n", true);
                while (rows.hasMoreTokens()) {
                    CellLocation curSelCell = rowVec.elementAt(0);
                    int r = curSelCell.getRow();
                    int c3 = curSelCell.getCol();
                    if (r >= rowCnt) continue block6;
                    String rowToken = rows.nextToken();
                    if (rowToken.equals("\r\n") || rowToken.equals("\r") || rowToken.equals("\n")) {
                        if (lastRowWasSeparator) {
                            if (_pasteDebug) {
                                System.out.println("paste:missing data at row " + r + " using empty string");
                            }
                            this.pasteCell("", r, c3);
                            ++r;
                            ++i;
                        }
                        lastRowWasSeparator = true;
                        if (i >= cellTable.size()) continue block6;
                        rowVec = cellTable.elementAt(i);
                        continue;
                    }
                    lastRowWasSeparator = false;
                    if (_pasteDebug) {
                        System.out.println("row(" + r + ")=[" + rowToken + "]");
                    }
                    StringTokenizer cells = new StringTokenizer(rowToken, "\t", true);
                    c3 = curSelCell.getCol();
                    firstCellInRow = true;
                    while (cells.hasMoreTokens()) {
                        String str = cells.nextToken();
                        if (_pasteDebug) {
                            System.out.println("paste: next token=[" + (str.equals("\t") ? "{TAB}" : str) + "]");
                        }
                        if (str.equals("\t")) {
                            if (lastWasToken || firstCellInRow) {
                                if (_pasteDebug) {
                                    System.out.println("paste:missing data point at " + r + "," + c3 + " using empty string");
                                }
                                this.pasteCell("", r, c3);
                                ++c3;
                            }
                            lastWasToken = true;
                            continue;
                        }
                        lastWasToken = false;
                        firstCellInRow = false;
                        if (c3 >= colCnt || c3 > lastCell.getCol()) continue;
                        invalidCnt += this.pasteCell(str, r, c3);
                        ++c3;
                    }
                    ++r;
                    if (++i >= cellTable.size()) continue block6;
                    rowVec = cellTable.elementAt(i);
                }
            }
            this.fireTableChangeEvent(TableUpdateEvent.REPEAT_FILL, firstCell.getRow(), firstCell.getCol(), lastCell.getRow(), lastCell.getCol());
            if (invalidCnt > 0) {
                System.out.println("Found " + invalidCnt + " cells with invalid data");
            }
            this.revalidate();
            this.repaint();
        }
        catch (UnsupportedFlavorException e) {
            this.getToolkit().beep();
            if (_pasteDebug) {
                e.printStackTrace(System.out);
            }
        }
        catch (Exception e) {
            System.out.println("paste: error occurred during paste " + e);
            e.printStackTrace(System.out);
            this.getToolkit().beep();
        }
    }

    protected int pasteCell(String str, int r, int c2) {
        RmaTableModelInterface rtm;
        int paramId;
        if (_pasteDebug) {
            System.out.println("pasteCell: pasting '" + str + "' at row=" + r + " col=" + c2);
        }
        int modelCol = this.convertColumnIndexToModel(c2);
        Object objValue = str;
        TableModel tableModel = this.getModel();
        if (tableModel instanceof RmaTableModelInterface && (paramId = (rtm = (RmaTableModelInterface)tableModel).getColumnParameter(modelCol)) != -1) {
            ParameterScale scale = this._parameterScaleTable.get(new Integer(modelCol));
            ParamDouble pd = new ParamDouble();
            pd.setValue(str);
            pd.setParameterId(paramId);
            pd.setUnitSystem(this.getDisplayUnitSystem());
            int pdParamId = pd.getParameterId();
            if (scale != null && pdParamId == scale.getParamId()) {
                pd.scaleValue(1.0 / scale.scale);
            }
            objValue = pd;
            int rtmUnitSystem = rtm.getUnitSystem();
            if (this.getDisplayUnitSystem() != rtmUnitSystem && Units.isValidUnitsSystem(rtmUnitSystem)) {
                try {
                    if (_pasteDebug) {
                        System.out.println("pasteCell: attempting conversion: paramId=" + pdParamId + "Table Model unit System " + rtmUnitSystem);
                    }
                    String fromUnits = Parameter.getUnitsStringForSystem(pdParamId, pd.getUnitSystem());
                    String toUnits = Parameter.getUnitsStringForSystem(pdParamId, rtmUnitSystem);
                    ParamDouble pd2 = Units.convertUnits(pd, fromUnits, toUnits);
                    pd2.setUnitSystem(rtmUnitSystem);
                    objValue = pd2;
                }
                catch (Exception e) {
                    System.out.println("pasteCell: unit conversion error r=" + r + "c=" + c2 + " " + e);
                }
            }
            if (_pasteDebug) {
                System.out.println("pasteCell: conversion yielded '" + objValue + "'");
            }
        }
        TableColumnModel tcm = this.getColumnModel();
        boolean invalidData = false;
        if (this.isCellEditable(r, c2)) {
            TableColumn tc;
            TableCellEditor editor;
            if (this._pasteBackground != null) {
                this.setCellBackground(r, c2, this._pasteBackground);
            }
            if (this._pasteForeground != null) {
                this.setCellForeground(r, c2, this._pasteForeground);
            }
            if ((editor = (tc = tcm.getColumn(c2)).getCellEditor()) instanceof RmaCellEditor) {
                RmaCellEditor rce = (RmaCellEditor)editor;
                Component comp = rce.getTableCellEditorComponent(this, objValue, this.isCellSelected(r, c2), r, c2);
                objValue = rce.getCellEditorValue();
                if (comp instanceof RmaJTextField) {
                    ((RmaJTextField)comp).setText(str);
                    if (!((RmaJTextField)comp).isValid(false)) {
                        invalidData = true;
                        System.out.println("pasteCell: invalid data at row=" + r + " col=" + c2 + " data='" + str + "'");
                    }
                    if (!(comp instanceof UnitsComponent)) {
                        objValue = ((RmaJTextField)comp).getText();
                    }
                }
            } else {
                invalidData = false;
            }
            if (!invalidData) {
                this.setComboValue(objValue, r, c2);
                this.setValueAt(objValue, r, c2);
                if (_pasteDebug) {
                    System.out.println("pasteCell: setting cell row=" + r + " col=" + c2 + " to '" + objValue + "'");
                }
                return 0;
            }
            return 1;
        }
        if (_pasteDebug) {
            System.out.println("pasteCell: cell not editable at row=" + r + " col=" + c2);
        }
        return 0;
    }

    private void setComboValue(Object value, int row, int col) {
        Component comp;
        if (this.isEditing() && this.getEditingRow() != row && this.getEditingColumn() != col) {
            return;
        }
        TableColumnModel tcm = this.getColumnModel();
        TableColumn tc = tcm.getColumn(col);
        TableCellEditor editor = tc.getCellEditor();
        if (editor instanceof RmaCellEditor && (comp = ((RmaCellEditor)editor).getComponent()) instanceof JComboBox) {
            this.editCellAt(row, col);
            ((JComboBox)comp).setSelectedItem(value);
            this.commitEdit(true);
        }
    }

    public void copyall() {
    }

    public void copy() {
        this.copy(true);
    }

    public void clear() {
        this.clear(true);
    }

    private void clear(boolean postEvent) {
        Clipboard cb = this.getToolkit().getSystemClipboard();
        cb.getContents(this);
        int row = 0;
        int col = 0;
        int lastRow = 0;
        int lastCol = 0;
        try {
            Vector<CellLocation> cellLocations = this.getSelectedCellRange();
            if (cellLocations.size() < 1) {
                return;
            }
            this.commitEdit(false);
            Object obj = "";
            CellLocation location = cellLocations.elementAt(0);
            row = location.getRow();
            col = location.getCol();
            for (int i = 0; i < cellLocations.size(); ++i) {
                location = cellLocations.elementAt(i);
                if (!this.isCellEditable(location.getRow(), location.getCol())) continue;
                obj = this.getClearedCellValue(location.getCol());
                lastRow = location.getRow();
                lastCol = location.getCol();
                Class<?> cls = this.getColumnClass(location.getCol());
                if (cls == null) {
                    try {
                        obj = cls.newInstance();
                    }
                    catch (Exception e) {
                        obj = this.getClearedCellValue(location.getCol());
                    }
                }
                this.setValueAt(obj, location.getRow(), location.getCol());
            }
        }
        catch (Exception e) {
            System.out.println("Error in clear " + e.getMessage());
        }
        this.revalidate();
        this.repaint();
        if (postEvent) {
            this.fireTableChangeEvent(TableUpdateEvent.CLEAR, row, col, lastRow, lastCol);
        }
    }

    private void copy(boolean postEvent) {
        Clipboard cb = this.getToolkit().getSystemClipboard();
        StringSelection s = null;
        try {
            Vector<CellLocation> cellLocations = this.getSelectedCellRange();
            if (cellLocations.size() < 1) {
                return;
            }
            StringBuffer cellValues = new StringBuffer();
            CellLocation location = cellLocations.elementAt(0);
            int row = location.getRow();
            for (int i = 0; i < cellLocations.size(); ++i) {
                String current;
                Object obj;
                location = cellLocations.elementAt(i);
                TableColumn tc = this.getColumnModel().getColumn(location.getCol());
                if (tc != null) {
                    Component c2;
                    TableCellRenderer renderer = tc.getCellRenderer();
                    if (renderer == null) {
                        renderer = this.getDefaultRenderer(this.getColumnClass(location.getCol()));
                    }
                    obj = (c2 = renderer.getTableCellRendererComponent(this, location.getData(), false, false, location.getRow(), location.getCol())) instanceof JLabel ? ((JLabel)c2).getText() : location.getData();
                } else {
                    obj = location.getData();
                }
                if (i > 0) {
                    if (location.getRow() == row) {
                        cellValues.append("\t");
                    } else {
                        row = location.getRow();
                        cellValues.append("\n");
                    }
                }
                if ((current = obj != null ? obj.toString() : null) != null) {
                    if (current.length() < 1) {
                        current = " ";
                    }
                } else {
                    current = " ";
                }
                cellValues.append(current);
            }
            s = new StringSelection(cellValues.toString());
        }
        catch (Exception e) {
            System.out.println("Error in copy " + e.getMessage());
        }
        cb.setContents(s, s);
        if (postEvent) {
            CellLocation cl = this.getFirstSelectedCell();
            CellLocation cl2 = this.getLastSelectedCell();
            if (cl == null || cl2 == null) {
                return;
            }
            this.fireTableChangeEvent(TableUpdateEvent.COPY, cl.getRow(), cl.getCol(), cl2.getRow(), cl2.getCol());
        }
    }

    public void insertRow() {
        if (!(this.getModel() instanceof RmaTableModelInterface)) {
            return;
        }
        int insertRow = this.getRowsToInsert();
        if (insertRow < 1) {
            return;
        }
        this.commitEdit(false);
        int selRow = this.getSelectedRow();
        int i = 0;
        if (selRow < 0 || selRow >= this.getRowCount()) {
            for (i = 0; i < insertRow; ++i) {
                this.appendRow();
            }
            this.fireTableChangeEvent(TableUpdateEvent.APPEND_ROW, selRow, 0, selRow + i, 0);
            return;
        }
        int stop = insertRow;
        if (this.getModel() instanceof RmaTableModelInterface) {
            Vector<Object> v = new Vector<Object>(this.getColumnCount());
            for (int j = 0; j < this.getColumnCount(); ++j) {
                Class<?> cls = this.getModel().getColumnClass(j);
                try {
                    Object obj = cls.newInstance();
                    v.addElement(obj);
                    continue;
                }
                catch (Throwable e) {
                    v.addElement("");
                }
            }
            ((RmaTableModelInterface)this.getModel()).insertRows(selRow, stop, (Vector)v.clone());
            this.revalidate();
            this.fireTableChangeEvent(TableUpdateEvent.INSERT_ROW, selRow, 0, selRow + i, 0);
        }
    }

    protected int getRowsToInsert() {
        InsertDlg dialog = null;
        Window w = SwingUtilities.windowForComponent(this);
        if (w instanceof Dialog) {
            dialog = new InsertDlg((Dialog)w, "Insert Rows", true);
        } else if (w instanceof Frame) {
            dialog = new InsertDlg((Frame)w, "Insert Rows", true);
        } else {
            RMAIO.postWarning(this, "Can't open Insert Row Dialog, because there is not\na valid window component parent for thistable");
            return -1;
        }
        dialog.setRowsToInsert(1);
        dialog.setBounds(this.getBounds());
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return -1;
        }
        int insertRow = dialog.getRowsToInsert();
        return insertRow;
    }

    public void insertRow(Vector rowData, int row) {
        if (rowData == null || row < 0) {
            return;
        }
        if (this.getModel() instanceof RmaTableModelInterface) {
            ((RmaTableModelInterface)this.getModel()).insertRows(row, 1, rowData);
            this.revalidate();
            this.fireTableChangeEvent(TableUpdateEvent.INSERT_ROW, row, 0, row, 0);
        }
    }

    public void appendRows() {
        InsertDlg dialog = null;
        Window w = SwingUtilities.windowForComponent(this);
        if (w instanceof Dialog) {
            dialog = new InsertDlg((Dialog)w, "Append Rows", true, "Number to append:");
        } else if (w instanceof Frame) {
            dialog = new InsertDlg((Frame)w, "Append Rows", true, "Number to append:");
        } else {
            RMAIO.postWarning(this, "Can't open Append Row Dialog, because there is not\na valid window component parent for thistable");
            return;
        }
        dialog.setRowsToInsert(1);
        dialog.setBounds(this.getBounds());
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        int appendRows = dialog.getRowsToInsert();
        this.appendRows(appendRows);
    }

    public void appendRow() {
        TableModel tm = this.getModel();
        if (!(this.getModel() instanceof RmaTableModelInterface)) {
            return;
        }
        ((RmaTableModelInterface)tm).addRow(new Vector(this.getColumnCount()));
        this.revalidate();
        this.fireTableChangeEvent(TableUpdateEvent.APPEND_ROW, this.getRowCount() - 1, 0, this.getRowCount(), this.getColumnCount());
    }

    public void appendRow(Vector data) {
        this.appendRow(data, true);
    }

    public void appendRow(Vector data, boolean reval) {
        TableModel tm = this.getModel();
        if (!(tm instanceof RmaTableModelInterface)) {
            return;
        }
        data.ensureCapacity(this.getColumnCount());
        ((RmaTableModelInterface)tm).addRow(data);
        this.fireTableChangeEvent(TableUpdateEvent.APPEND_ROW, this.getRowCount() - 1, 0, this.getRowCount(), this.getColumnCount());
        if (reval) {
            this.revalidate();
        }
    }

    public void appendRow(Vector data, boolean reval, Color bcolor, Color fcolor) {
        TableModel tm = this.getModel();
        if (!(tm instanceof RmaTableModelInterface)) {
            return;
        }
        data.ensureCapacity(this.getColumnCount());
        ((RmaTableModelInterface)tm).addRow(data);
        int rowcnt = tm.getRowCount() - 1;
        this.setRowBackground(rowcnt, bcolor);
        this.setRowForeground(rowcnt, fcolor);
        if (reval) {
            this.revalidate();
        }
        this.fireTableChangeEvent(TableUpdateEvent.APPEND_ROW, this.getRowCount() - 1, 0, this.getRowCount(), this.getColumnCount());
    }

    public void appendRows(int rows) {
        TableModel tm = this.getModel();
        if (tm instanceof RmaTableModelInterface) {
            RmaTableModelInterface rtmi = (RmaTableModelInterface)tm;
            if (rows > 0) {
                int columnCount = this.getColumnCount();
                int startCount = rtmi.getRowCount();
                rtmi.insertRows(startCount, rows, new Vector(columnCount));
                this.revalidate();
                this.fireTableChangeEvent(TableUpdateEvent.APPEND_ROW, startCount, 0, startCount + rows, columnCount);
            }
        } else {
            for (int i = 0; i < rows; ++i) {
                this.appendRow();
            }
        }
    }

    public void deleteRow() {
        if (!(this.getModel() instanceof RmaTableModelInterface)) {
            return;
        }
        this.commitEdit(false);
        int[] rows = this.getSelectedRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        this.clearSelection();
        for (int i = rows.length - 1; i >= 0; --i) {
            if (rows[i] >= this.getModel().getRowCount()) continue;
            ((RmaTableModelInterface)this.getModel()).deleteRow(rows[i]);
            if (this._rowheaderTbl == null) continue;
            try {
                ((RmaTableModelInterface)this._rowheaderTbl.getModel()).deleteRow(rows[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fireTableChangeEvent(TableUpdateEvent.DELETE_ROW, rows[0], 0, rows[rows.length - 1], 0);
        this.revalidate();
    }

    public void deleteRow(int rowNum) {
        if (!(this.getModel() instanceof RmaTableModelInterface)) {
            return;
        }
        this.commitEdit(false);
        int row = this.convertRowIndexToModel(rowNum);
        ((RmaTableModelInterface)this.getModel()).deleteRow(row);
        this.fireTableChangeEvent(TableUpdateEvent.DELETE_ROW, rowNum, 0, rowNum, 0);
    }

    public void removeLastRow() {
        if (!(this.getModel() instanceof RmaTableModelInterface)) {
            return;
        }
        int rowcnt = this.getRowCount() - 1;
        ((RmaTableModelInterface)this.getModel()).deleteRow(rowcnt);
    }

    public void traverseCellLeft() {
    }

    public void traverseCellUp() {
    }

    public void traverseCellDown() {
    }

    public void traverseCellRight() {
    }

    public void setAddRemoveEnabled(boolean enable) {
        this.addRemoveEnabled = enable;
        this._insertMi.setEnabled(enable);
        this._insertMi.setVisible(enable);
        this._appendMi.setEnabled(enable);
        this._appendMi.setVisible(enable);
        this._deleteMi.setEnabled(enable);
        this._deleteMi.setVisible(enable);
    }

    public void setFirstFixedRow(boolean fixed) {
        this._firstFixedRow = fixed;
    }

    public boolean isFirstFixedRow() {
        return this._firstFixedRow;
    }

    public void setProcessKeyEvents(boolean process) {
        this._processKeyEvents = process;
    }

    public boolean getAddRemoveEnabled() {
        return this.addRemoveEnabled;
    }

    public void setPopupMenuEnabled(boolean enable) {
        this._popupEnabled = enable;
    }

    public boolean getPopupMenuEnabled() {
        return this._popupEnabled;
    }

    public JPopupMenu getPopupMenu() {
        return this._popup;
    }

    public void removePopupMenuSumOptions() {
        if (this._popup == null) {
            return;
        }
        this._popup.remove(this._sumEntireColumnMenuItem);
        this._popup.remove(this._sumSelectedCellsMenuItem);
        if (this._popup.getComponentCount() == 18 && this._popup.getComponent(8) instanceof JPopupMenu.Separator && this._popup.getComponent(17) instanceof JPopupMenu.Separator) {
            this._popup.remove(8);
            this._popup.remove(16);
        }
    }

    public void removePopupMenuPrintOptions() {
        if (this._popup == null) {
            return;
        }
        this._popup.remove(this._printMi);
        this._popup.remove(this._printPreviewMi);
    }

    public void removePopuMenuExportOptions() {
        if (this._popup == null) {
            return;
        }
        this._popup.remove(this._exportMi);
    }

    public void removePopuMenuFillOptions() {
        if (this._popup == null) {
            return;
        }
        this._popup.remove(this._fillMi);
    }

    public void removePopupMenuRowEditingOptions() {
        if (this._popup == null) {
            return;
        }
        this._popup.remove(this._insertMi);
        this._popup.remove(this._appendMi);
        this._popup.remove(this._deleteMi);
        if (this._popup.getComponentCount() == 14 && this._popup.getComponent(7) instanceof JPopupMenu.Separator && this._popup.getComponent(13) instanceof JPopupMenu.Separator) {
            this._popup.remove(7);
            this._popup.remove(12);
        }
    }

    public void removePopupMenuInsertAppendOnly() {
        if (this._popup == null) {
            return;
        }
        this._popup.remove(this._insertMi);
        this._popup.remove(this._appendMi);
        if (this._popup.getComponentCount() == 14 && this._popup.getComponent(7) instanceof JPopupMenu.Separator && this._popup.getComponent(13) instanceof JPopupMenu.Separator) {
            this._popup.remove(7);
            this._popup.remove(12);
        }
    }

    public void setRowHeaderEnabled(boolean enable) {
        this._rowHeaderEnabled = enable;
        if (!enable) {
            this.setColumnEnabled(enable, 0);
            TableColumnModel tcm = this.getColumnModel();
            TableColumn tc = tcm.getColumn(0);
            TableCellRenderer tcr = tc.getCellRenderer();
            if (tcr instanceof RmaRowHeaderRenderer) {
                tcr = ((RmaRowHeaderRenderer)tcr).getTableCellRenderer();
                tc.setCellRenderer(tcr);
            }
        } else {
            this.setRowHeaderRenderer(0);
        }
    }

    public void setRowHeaderRenderer(int column) {
        this._rowHeaderEnabled = true;
        this.setColumnEnabled(false, column);
        TableColumnModel tcm = this.getColumnModel();
        TableColumn tc = tcm.getColumn(column);
        TableCellRenderer tcr = tc.getCellRenderer();
        if (tcr == null) {
            tcr = new RmaCellRenderer();
        }
        tc.setCellRenderer(new RmaRowHeaderRenderer(tcr));
    }

    public boolean getRowHeaderEnabled() {
        return this._rowHeaderEnabled;
    }

    public void setAutoRowHeaders(boolean enable) {
        this._autoRowHeaders = enable;
        this.setRowHeaderRenderer(0);
    }

    public void setAutoRowHeaders(boolean enable, int offset) {
        this.setAutoRowHeaders(enable);
        this._autoRowHeaderOffset = offset;
    }

    public int getAutoRowHeaderOffset() {
        return this._autoRowHeaderOffset;
    }

    public boolean getAutoRowHeaders() {
        return this._autoRowHeaders;
    }

    public void columnSizes() {
        TableColumnModel tcm = this.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            System.out.print(tc.getWidth() + ",");
        }
        System.out.println("");
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Point p = event.getPoint();
        int column = this.columnAtPoint(p);
        int row = this.rowAtPoint(p);
        if (this.getAutoRowHeaders() && column == 0) {
            return super.getToolTipText(event);
        }
        Object obj = this.getValueAt(row, column);
        if (event.isControlDown() && event.isShiftDown() && obj != null) {
            TableCellRenderer cellRend = this.getCellRenderer(row, column);
            this.cellEditor = this.getCellEditor(row, column);
            return "<html>Object at " + row + ", " + column + " is a<br> " + obj.getClass().getName() + "@" + System.identityHashCode(obj) + "<br>\"" + obj.toString() + "\"<br>Cell Renderer=" + (cellRend != null ? cellRend.getClass().getName() : "unknown") + "<br>Cell Editor=" + (this.cellEditor != null ? this.cellEditor.getClass().getName() : "unknown") + "<br>Column Parameter=" + (Serializable)(this.getModel() instanceof RmaTableModel ? Integer.valueOf(((RmaTableModel)this.getModel()).getColumnParameter(column)) : "unknown") + "</html>";
        }
        if (obj != null && obj.toString() != null) {
            TableCellRenderer renderer = this.getCellRenderer(row, column);
            if (renderer == null) {
                String text = obj.toString();
                if (text != null && !" ".equals(text) && !"".equals(text)) {
                    return text;
                }
                return super.getToolTipText(event);
            }
            Component component = this.prepareRenderer(renderer, row, column);
            String compToolTip = null;
            if (component instanceof JComponent) {
                compToolTip = ((JComponent)component).getToolTipText();
            }
            if (compToolTip != null) {
                return compToolTip;
            }
            if (component instanceof JLabel) {
                String labelText = ((JLabel)component).getText();
                String labelToolTip = ((JLabel)component).getToolTipText();
                if (labelToolTip != null && labelToolTip.trim().length() > 0 && !labelToolTip.equals(labelText)) {
                    return labelToolTip;
                }
                return labelText;
            }
            String text = obj.toString();
            if (text != null && !text.equals(" ") && !text.equals("")) {
                return text;
            }
        }
        return super.getToolTipText(event);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.getAutoRowHeaders() && column == 0) {
            return false;
        }
        return super.isCellEditable(row, column);
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    @Override
    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle cellRect = super.getCellRect(row, column, includeSpacing);
        if (!this._hasMultilineRenderer) {
            return cellRect;
        }
        int rm = includeSpacing ? 0 : this.getRowMargin();
        int height = this.getRowHeight(row);
        int yPos = 0;
        for (int i = 0; i < row; ++i) {
            yPos += this.getRowHeight(i);
        }
        cellRect.setBounds(cellRect.x, yPos + rm / 2, cellRect.width, height - rm);
        return cellRect;
    }

    public int getColumnWidth(int col) {
        return this.getColumnModel().getColumn(col).getWidth();
    }

    public int[] getColumnWidths() {
        TableColumnModel model = this.getColumnModel();
        int columnCount = model.getColumnCount();
        int[] widths = new int[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            widths[i] = model.getColumn(i).getWidth();
        }
        return widths;
    }

    public void setColumnPrecision(int colNum, int precision) {
        TableColumnModel tcm = this.getColumnModel();
        if (colNum >= 0 && colNum < tcm.getColumnCount()) {
            TableCellRenderer tcr = tcm.getColumn(colNum).getCellRenderer();
            if (tcr == null) {
                tcr = this.getDefaultRenderer(this.getColumnClass(colNum));
            }
            Component component = tcr.getTableCellRendererComponent(this, "123", false, false, 0, colNum);
            Color foreground = component.getForeground();
            Color background = component.getBackground();
            Font font = component.getFont();
            Class<?> tcrClass = tcr.getClass();
            try {
                DecimalCellRenderer dcr = new DecimalCellRenderer(precision);
                dcr.setAllowDefaultFont(true);
                component = dcr.getTableCellRendererComponent(this, "123", false, false, 0, colNum);
                component.setForeground(background);
                component.setBackground(background);
                component.setFont(font);
                tcm.getColumn(colNum).setCellRenderer(dcr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public int getRowHeight(int row) {
        if (row < 0 || row > this.getRowCount() || !this._hasMultilineRenderer) {
            return super.getRowHeight(row);
        }
        int height = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableCellRenderer r = this.getColumnModel().getColumn(i).getCellRenderer();
            if (!(r instanceof MultiLineCellRenderer)) continue;
            int width = this.getColumnModel().getColumn(i).getWidth();
            Insets ins = ((MultiLineCellRenderer)r).getInsets();
            width -= this.getColumnModel().getColumnMargin();
            width -= ins.left + ins.right;
            Object value = this.getValueAt(row, i);
            if (value == null) continue;
            height = Math.max(height, this.getPreferredLineHeight(value.toString(), width));
        }
        if (height != -1) {
            return height;
        }
        return super.getRowHeight(row);
    }

    public int getPreferredLineHeight(String str, int width) {
        if (str == null || str.isEmpty()) {
            return 0;
        }
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        int lineCount = 1;
        int curWidth = 0;
        int spaceWidth = fm.charWidth(' ');
        PowerfulTokenizer tokenizer = new PowerfulTokenizer(str, " \n\r", true);
        tokenizer.setTrimTokens(false);
        String delim = null;
        String SPACE_DELIM = " ";
        while (tokenizer.hasMoreElements()) {
            int tokenWidth;
            String token = tokenizer.nextToken();
            if (tokenizer.hasMoreElements() && (delim = tokenizer.nextToken()) != null && delim.length() == 0) {
                delim = SPACE_DELIM;
            }
            int delimWidth = 0;
            if (delim != null) {
                delimWidth = fm.stringWidth(delim);
            }
            if ((tokenWidth = fm.stringWidth(token)) + delimWidth + curWidth > width || delim != null && delim.indexOf("\n") >= 0) {
                ++lineCount;
                curWidth = tokenWidth + delimWidth;
                continue;
            }
            curWidth += tokenWidth + delimWidth;
            delim = null;
        }
        return fm.getHeight() * lineCount + fm.getDescent();
    }

    @Override
    public int rowAtPoint(Point point) {
        int y = point.y;
        int rowCount = this.getRowCount();
        int height = 0;
        for (int row = 0; row < rowCount; ++row) {
            if (y >= (height += this.getRowHeight(row))) continue;
            return row;
        }
        return -1;
    }

    public RmaJTable setViewportRowHeader(TableModel model, ColumnGroup[] groups, int[][] columns, int width) {
        JViewport jv2 = new JViewport();
        final JScrollPane sp = this.getScrollPane();
        final RmaJTable parentTable = this;
        this._rowheaderTbl = new RmaJTable(this._parent){

            @Override
            protected void configureEnclosingScrollPane() {
                sp.setCorner("UPPER_LEFT_CORNER", this.getTableHeader());
            }

            @Override
            public void printData() {
                parentTable.printData();
            }

            @Override
            public void printPreview() {
                parentTable.printPreview();
            }
        };
        this._rowheaderTbl._parentTbl = this;
        this._rowheaderTbl.setModel(model);
        this._rowheaderTbl.setUnitsHeaderRenderer();
        this._rowheaderTbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                Point p = e.getPoint();
                int row = RmaJTable.this._rowheaderTbl.rowAtPoint(p);
                int column = 0;
                RmaJTable.this.updateSelection(row, column, e.isControlDown(), e.isShiftDown());
            }
        });
        this._rowheaderTbl.setBackground(UIManager.getColor("TableHeader.background"));
        this._rowheaderTbl.setCellSelectionEnabled(false);
        this._rowheaderTbl.setRowSelectionAllowed(false);
        this._rowheaderTbl.setColumnSelectionAllowed(false);
        this._rowheaderTbl.setEnabled(false);
        jv2.setPreferredSize(new Dimension(width, this.getPreferredSize().height));
        jv2.setView(this._rowheaderTbl);
        this._scrollPane.setRowHeader(jv2);
        new JScrollPaneAdjuster(this._scrollPane);
        if (groups != null) {
            GroupableTableHeader gTableHeader = new GroupableTableHeader(this._rowheaderTbl.getColumnModel());
            for (int i = 0; i < groups.length; ++i) {
                ColumnGroup g = groups[i];
                for (int j = 0; j < columns[i].length; ++j) {
                    g.add(this._rowheaderTbl.getColumnModel().getColumn(columns[i][j]));
                }
                gTableHeader.addColumnGroup(g);
            }
            this._rowheaderTbl.setTableHeader(gTableHeader);
        }
        UnitsHeaderRenderer uhr = new UnitsHeaderRenderer();
        TableColumnModel tcm = this._rowheaderTbl.getTableHeader().getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            tc.setHeaderRenderer(uhr);
        }
        this.setAddRemoveEnabled(false);
        this._rowHeaderEnabled = false;
        this._rowheaderTbl.setDisplayUnitsSystem(this.getDisplayUnitSystem());
        return this._rowheaderTbl;
    }

    public RmaJTable setViewportRowHeader(String[] headers, Object[][] data, ColumnGroup[] groups, int[][] columns, int width) {
        boolean[] editable = new boolean[headers.length];
        RmaTableModel model = new RmaTableModel(headers, data, editable);
        RmaJTable headerTbl = this.setViewportRowHeader(model, groups, columns, width);
        headerTbl.setRowHeaderEnabled(true);
        headerTbl.setHorizontalAlignment(0, 0);
        return headerTbl;
    }

    protected void updateSelectionModel(ListSelectionModel sm, int index, boolean toggle, boolean extend) {
        if (!extend) {
            if (!toggle) {
                sm.setSelectionInterval(index, index);
            } else if (sm.isSelectedIndex(index)) {
                sm.removeSelectionInterval(index, index);
            } else {
                sm.addSelectionInterval(index, index);
            }
        } else {
            sm.setLeadSelectionIndex(index);
        }
    }

    public void updateSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        Rectangle cellRect = this.getCellRect(rowIndex, columnIndex, false);
        if (cellRect != null) {
            this.scrollRectToVisible(cellRect);
        }
        ListSelectionModel rsm = this.getSelectionModel();
        ListSelectionModel csm = this.getColumnModel().getSelectionModel();
        this.updateSelectionModel(csm, columnIndex, toggle, extend);
        this.updateSelectionModel(rsm, rowIndex, toggle, extend);
    }

    public JTable getViewportRowHeader() {
        return this._rowheaderTbl;
    }

    protected Class getClassForName(String className) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (Exception e) {
            System.out.println("Can't find class " + className);
        }
        return cls;
    }

    public TablePrintManager getPrintManager() {
        if (this._printManager == null) {
            this._printManager = new TablePrintManager(this);
        }
        return this._printManager;
    }

    public void printData() {
        this.cellEditor = this.getCellEditor();
        if (this.cellEditor != null) {
            this.cellEditor.stopCellEditing();
        }
        if (this._printManager == null) {
            this._printManager = new TablePrintManager(this);
        }
        this._printManager.getPrintProperties().useDefaultPrintHeader = this._useDefaultPrintHeader;
        this._printManager.printData();
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int xTitleLoc;
        int yTitleLoc;
        int lineWidth;
        String line;
        int hLoc;
        int cnt;
        FontMetrics fm;
        double pageHeight;
        double pageWidth;
        double tableWidth;
        this.clearSelection();
        this.commitEdit(true);
        this.columnModel.getSelectionModel().setAnchorSelectionIndex(-1);
        this.selectionModel.setAnchorSelectionIndex(-1);
        if (this._printDateStr == null) {
            this._printDateStr = new Date().toString().substring(4);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        int fontHeight = g2.getFontMetrics().getHeight();
        int fontDesent = g2.getFontMetrics().getDescent();
        double imageableX = pageFormat.getImageableX();
        double imageableY = pageFormat.getImageableY();
        int titleLinesCnt = 0;
        int titleHeight = 0;
        StringTokenizer titleLines = null;
        PageText tableTitle = null;
        tableTitle = this.getPrintTitle();
        if (tableTitle != null) {
            titleLines = new StringTokenizer(tableTitle.getText(), "\n");
            titleLinesCnt = titleLines.countTokens();
        }
        PageText otherTitle = null;
        StringTokenizer otherLines = null;
        int otherLinesCnt = 0;
        otherTitle = this.getPrintOtherInfo();
        if (otherTitle != null) {
            otherLines = new StringTokenizer(otherTitle.getText(), "\n");
            otherLinesCnt = otherLines.countTokens();
        }
        if (titleLinesCnt > 0) {
            titleHeight = titleLinesCnt * fontHeight;
        }
        if (otherLinesCnt > 0) {
            titleHeight += otherLinesCnt * fontHeight;
        }
        if ((tableWidth = (double)this.getColumnModel().getTotalColumnWidth()) >= (pageWidth = pageFormat.getImageableWidth())) {
            pageFormat.setOrientation(0);
        }
        if (pageFormat.getOrientation() == 1) {
            pageHeight = pageFormat.getImageableHeight() - (double)fontHeight;
            pageWidth = pageFormat.getImageableWidth();
        } else {
            pageHeight = pageFormat.getImageableHeight() - (double)fontHeight;
            pageWidth = pageFormat.getImageableWidth();
        }
        double scale = 1.0;
        if (tableWidth >= pageWidth) {
            scale = pageWidth / tableWidth;
        }
        double headerHeightOnPage = (double)this.getTableHeader().getHeight() * scale;
        double tableWidthOnPage = tableWidth * scale;
        double oneRowHeight = (double)this.getRowHeight() * scale;
        int firstNumRowsOnAPage = (int)((pageHeight - headerHeightOnPage - (double)titleHeight) / oneRowHeight);
        int numRowsOnAPage = (int)((pageHeight - headerHeightOnPage) / oneRowHeight);
        double firstPageHeightForTable = oneRowHeight * (double)firstNumRowsOnAPage;
        double pageHeightForTable = oneRowHeight * (double)numRowsOnAPage;
        int totalNumPages = (int)Math.ceil((double)this.getRowCount() / (double)numRowsOnAPage);
        if (pageIndex >= totalNumPages) {
            this._printDateStr = null;
            return 1;
        }
        g2.translate(imageableX, imageableY);
        g2.drawString(this._printDateStr, 0, (int)(pageHeight + (double)fontHeight - (double)fontDesent));
        g2.drawString("Page: " + (pageIndex + 1), (int)pageWidth / 2 - 35, (int)(pageHeight + (double)fontHeight - (double)fontDesent));
        if (pageIndex == 0 && titleLines != null) {
            fm = g2.getFontMetrics();
            cnt = 0;
            hLoc = tableTitle.getHorizontalLocation();
            while (titleLines.hasMoreElements()) {
                line = titleLines.nextToken();
                lineWidth = fm.stringWidth(line);
                yTitleLoc = fontHeight * ++cnt - fontDesent;
                switch (hLoc) {
                    case 2: {
                        xTitleLoc = 0;
                        break;
                    }
                    case 4: {
                        xTitleLoc = (int)pageWidth - lineWidth;
                        break;
                    }
                    default: {
                        xTitleLoc = (int)pageWidth / 2 - lineWidth / 2;
                    }
                }
                g2.drawString(line, xTitleLoc, yTitleLoc);
            }
        }
        if (pageIndex == 0 && otherTitle != null) {
            fm = g2.getFontMetrics();
            cnt = 0;
            hLoc = otherTitle.getHorizontalLocation();
            while (otherLines.hasMoreElements()) {
                line = otherLines.nextToken();
                lineWidth = fm.stringWidth(line);
                yTitleLoc = fontHeight * ++cnt - fontDesent + titleLinesCnt * fontHeight;
                switch (hLoc) {
                    case 2: {
                        xTitleLoc = 0;
                        break;
                    }
                    case 4: {
                        xTitleLoc = (int)pageWidth - lineWidth;
                        break;
                    }
                    default: {
                        xTitleLoc = (int)pageWidth / 2 - lineWidth / 2;
                    }
                }
                g2.drawString(line, xTitleLoc, yTitleLoc);
            }
        }
        int xpos = 0;
        if (scale == 1.0 && (xpos = (int)((pageWidth - tableWidthOnPage) / 2.0)) < 0) {
            xpos = 0;
        }
        if (pageIndex == 0) {
            g2.translate(0.0, (double)(-pageIndex) * firstPageHeightForTable);
        } else {
            g2.translate(0.0, (double)(-pageIndex) * pageHeightForTable + 75.0);
        }
        g2.translate((double)xpos, headerHeightOnPage);
        if (pageIndex == 0) {
            g2.translate(0.0, (double)((titleLinesCnt + otherLinesCnt) * fontHeight));
        }
        if (pageIndex + 1 == totalNumPages) {
            int lastRowPrinted = numRowsOnAPage * (pageIndex - 1) + firstNumRowsOnAPage;
            int numRowsLeft = this.getRowCount() - lastRowPrinted;
            g2.setClip(0, (int)(pageHeightForTable * (double)(pageIndex - 1) + firstPageHeightForTable), (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(oneRowHeight * (double)numRowsLeft));
        } else if (pageIndex == 0) {
            g2.setClip(0, (int)(firstPageHeightForTable * (double)pageIndex), (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(firstPageHeightForTable));
        } else {
            g2.setClip(0, (int)(pageHeightForTable * (double)(pageIndex - 1) + firstPageHeightForTable), (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(pageHeightForTable));
        }
        g2.scale(scale, scale);
        this.paint(g2);
        g2.scale(1.0 / scale, 1.0 / scale);
        if (pageIndex == 0) {
            g2.translate(0.0, (double)pageIndex * firstPageHeightForTable);
        } else {
            g2.translate(0.0, (double)(pageIndex - 1) * pageHeightForTable + firstPageHeightForTable);
        }
        g2.translate(0.0, -headerHeightOnPage);
        g2.setClip(0, 0, (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(headerHeightOnPage));
        g2.scale(scale, scale);
        this.getTableHeader().paint(g2);
        return 0;
    }

    public void printPreview() {
        this.cellEditor = this.getCellEditor();
        if (this.cellEditor != null) {
            this.cellEditor.stopCellEditing();
        }
        if (this._printManager == null) {
            this._printManager = new TablePrintManager(this);
        }
        this._printManager.printPreview();
    }

    public void setPrintTitle(PageText titleInfo) {
        this._titleInfo = titleInfo;
        if (titleInfo != null) {
            this.getPrintManager().getPrintProperties().title = this._titleInfo.getText();
        }
    }

    public void setPrintOtherInfo(PageText otherInfo) {
        this._otherInfo = otherInfo;
        if (otherInfo != null) {
            this.getPrintManager().getPrintProperties().subTitle = this._otherInfo.getText();
        }
    }

    public PageText getPrintTitle() {
        return this._titleInfo;
    }

    public PageText getPrintOtherInfo() {
        return this._otherInfo;
    }

    public void exportData() {
        if (this._exportOptionsDialog == null) {
            this._exportOptionsDialog = RmaJTableExportDialog.getExportDialog(this);
        }
        this._exportOptionsDialog.setVisible(true);
        if (this._exportOptionsDialog.isCanceled()) {
            return;
        }
        Frame parent = JOptionPane.getFrameForComponent(this);
        if (parent != null) {
            parent.setCursor(Cursor.getPredefinedCursor(3));
        }
        JFileChooser fileDialog = new JFileChooser();
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        String exportDirectory = preferences.get("ExportDirectory", "");
        if (exportDirectory.length() == 0) {
            exportDirectory = System.getProperty("user.dir");
        }
        fileDialog.setCurrentDirectory(new File(exportDirectory));
        if (parent != null) {
            parent.setCursor(Cursor.getDefaultCursor());
        }
        fileDialog.showSaveDialog(null);
        File file = fileDialog.getSelectedFile();
        if (file == null) {
            return;
        }
        File f = fileDialog.getCurrentDirectory();
        preferences.put("ExportDirectory", f.getAbsolutePath());
        try {
            this.exportData(file, this._exportOptionsDialog.getExportOptions());
        }
        catch (IOException ioe) {
            System.out.println("exportData: failed to open file " + file.getPath() + " error " + ioe);
            JOptionPane.showMessageDialog(this, "Failed to open export file " + file.getPath());
        }
    }

    public void exportData(BufferedWriter writer, char delimiterChar, boolean writeColumnHeaders) {
        TableExportOptions teo = new TableExportOptions();
        teo.delimiter = delimiterChar;
        teo.columnHeader = writeColumnHeaders;
        this.exportData(writer, teo);
    }

    public void exportData(String fileName, TableExportOptions options) {
        if (fileName == null) {
            System.out.println("ExportData, Invalid filename: null");
            return;
        }
        File file = new File(fileName);
        try {
            this.exportData(file, options);
        }
        catch (IOException ioe) {
            System.out.println("ExportData: failed to open file " + file.getPath() + " error " + ioe);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportData(File file, TableExportOptions options) throws IOException {
        if (file == null) {
            System.out.println("ExportData, Invalid file: null");
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            this.exportData(writer, options);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ioe) {
                    System.out.println("exportData: failed to close file " + file.getPath() + " error " + ioe);
                }
            }
        }
    }

    public void exportData(BufferedWriter writer, TableExportOptions options) {
        if (writer == null) {
            return;
        }
        int numRows = this.getRowCount();
        int numCols = this.getColumnCount();
        StringBuffer line = new StringBuffer();
        Frame parent = JOptionPane.getFrameForComponent(this);
        if (parent != null) {
            parent.setCursor(Cursor.getPredefinedCursor(3));
        }
        JTableHeader header = this.getTableHeader();
        if (options.title != null) {
            try {
                writer.write(options.title);
                writer.newLine();
            }
            catch (IOException ioe) {
                System.out.println("exportData: IOExpception writing title " + ioe);
            }
        }
        int[] colWidths = null;
        if (options.fixedWidthCols) {
            colWidths = this.getMaxColumnWidths();
        }
        String horizontalGridline = null;
        if (header != null && options.columnHeader) {
            TableColumn aColumn;
            Enumeration<TableColumn> enumerator;
            StringBuffer lastLine = new StringBuffer();
            Vector<StringBuffer> headerLines = new Vector<StringBuffer>();
            boolean first = true;
            int colNum = 0;
            int colWidth = 0;
            if (header instanceof GroupableTableHeader) {
                int i;
                HashMap<ColumnGroup, ColumnGroup> displayedHeaders = new HashMap<ColumnGroup, ColumnGroup>();
                TableColumnModel tcm = header.getColumnModel();
                enumerator = tcm.getColumns();
                headerLines.addElement(line);
                int cnt = 0;
                while (enumerator.hasMoreElements()) {
                    aColumn = enumerator.nextElement();
                    ++cnt;
                    Enumeration cGroups = ((GroupableTableHeader)header).getColumnGroups(aColumn);
                    if (cGroups != null) {
                        first = true;
                        int headerLine = 0;
                        while (cGroups.hasMoreElements()) {
                            StringBuffer ptr;
                            colWidth = 0;
                            ++headerLine;
                            ColumnGroup cGroup = (ColumnGroup)cGroups.nextElement();
                            Vector tblCols = cGroup.getTableColumns();
                            if (options.fixedWidthCols) {
                                block12: for (i = 0; i < tcm.getColumnCount(); ++i) {
                                    TableColumn bColumn = tcm.getColumn(i);
                                    for (int j = 0; j < tblCols.size(); ++j) {
                                        int width;
                                        if (tblCols.get(j) != bColumn) continue;
                                        if (j != tblCols.size() - 1 || (width = cGroup.getHeaderValue().toString().length()) <= (colWidth += colWidths[i])) continue block12;
                                        int n = i;
                                        colWidths[n] = colWidths[n] + (width - colWidths[i]);
                                        colWidth = width;
                                        continue block12;
                                    }
                                }
                                colWidth += tblCols.size() - 1;
                                if (options.quotedStrings) {
                                    colWidth += tblCols.size();
                                }
                            }
                            if (!first && !displayedHeaders.containsKey(cGroup)) {
                                if (headerLines.size() < headerLine) {
                                    StringBuffer tmp = new StringBuffer();
                                    for (i = 0; i < cnt - 1; ++i) {
                                        if (colWidths != null) {
                                            tmp.append(RMAIO.fillString(colWidths[i], ' '));
                                        }
                                        tmp.append(" ");
                                    }
                                    headerLines.addElement(tmp);
                                    ptr = tmp;
                                } else {
                                    int tabs;
                                    ptr = (StringBuffer)headerLines.elementAt(headerLine - 1);
                                    for (int i2 = tabs = RMAIO.getNumChars(ptr.toString(), options.delimiter); i2 < cnt - 1; ++i2) {
                                        ptr.append(options.delimiter);
                                    }
                                }
                            } else {
                                ptr = line;
                            }
                            if (displayedHeaders.containsKey(cGroup)) {
                                first = false;
                                continue;
                            }
                            if (options.quotedStrings) {
                                ptr.append("\"");
                            }
                            displayedHeaders.put(cGroup, cGroup);
                            if (colWidths != null) {
                                ptr.append(RMAIO.center(colWidth, cGroup.getHeaderValue().toString().replace('\n', ' ')));
                            } else {
                                ptr.append(cGroup.getHeaderValue().toString().replace('\n', ' '));
                            }
                            if (options.quotedStrings) {
                                ptr.append("\"");
                            }
                            if (enumerator.hasMoreElements()) {
                                ptr.append(options.delimiter);
                            }
                            first = false;
                        }
                        continue;
                    }
                    if (colWidths != null && colWidths.length < cnt - 1) {
                        line.append(RMAIO.rightJustify2(colWidths[cnt - 1], " ").toString());
                    }
                    if (options.quotedStrings) {
                        line.append("  ");
                    }
                    if (options.gridLines) {
                        line.append("|");
                    }
                    if (options.fixedWidthCols) {
                        line.append(" ");
                        continue;
                    }
                    line.append(options.delimiter);
                }
                for (i = 0; i < headerLines.size(); ++i) {
                    try {
                        writer.write(((StringBuffer)headerLines.elementAt(i)).toString());
                        writer.newLine();
                        continue;
                    }
                    catch (IOException ioe) {
                        System.out.println("exportData: io error on export " + ioe);
                    }
                }
            }
            enumerator = header.getColumnModel().getColumns();
            int length = 0;
            while (enumerator.hasMoreElements()) {
                aColumn = enumerator.nextElement();
                String label = aColumn.getHeaderValue().toString().replace('\n', ' ');
                if (this.getModel() instanceof RmaTableModelInterface) {
                    int pId = ((RmaTableModelInterface)this.getModel()).getColumnParameter(colNum);
                    label = RmaJLabel.replaceUnitsTemplate(label, Parameter.getUnitsStringForSystem(pId, this.getDisplayUnitSystem()));
                }
                length = label.length();
                if (options.quotedStrings) {
                    lastLine.append("\"");
                }
                if (colWidths != null) {
                    if (length > colWidths[colNum]) {
                        colWidths[colNum] = length;
                    }
                    lastLine.append(RMAIO.rightJustify2(colWidths[colNum], label).toString());
                } else {
                    lastLine.append(label);
                }
                if (options.quotedStrings) {
                    lastLine.append("\"");
                }
                if (enumerator.hasMoreElements()) {
                    if (options.gridLines) {
                        lastLine.append("|");
                    } else {
                        lastLine.append(options.delimiter);
                    }
                }
                ++colNum;
            }
            try {
                writer.write(lastLine.toString());
                writer.newLine();
            }
            catch (IOException ioe) {
                System.out.println("exportData: io error on export " + ioe);
            }
            int sepWidth = lastLine.length();
            try {
                writer.write(RMAIO.fillString(sepWidth, '-').toString());
                writer.newLine();
            }
            catch (IOException ioe) {
                System.out.println("exportData: io error on export " + ioe);
            }
        }
        if (options.gridLines) {
            boolean noColWidths;
            boolean bl = noColWidths = colWidths == null;
            if (noColWidths) {
                colWidths = this.getMaxColumnWidths();
            }
            int gridWidth = 0;
            for (int i = 0; i < colWidths.length; ++i) {
                gridWidth += colWidths[i];
            }
            if (options.quotedStrings) {
                gridWidth += this.getColumnCount() * 2;
            }
            gridWidth += this.getColumnCount() - 1;
            if (noColWidths) {
                colWidths = null;
            }
            horizontalGridline = RMAIO.fillString(gridWidth, '-').toString();
        }
        line.setLength(0);
        for (int row = 0; row < numRows; ++row) {
            Object obj;
            if (options.rowHeader && this._rowheaderTbl != null) {
                for (int rowHeaderCol = 0; rowHeaderCol < this._rowheaderTbl.getColumnCount(); ++rowHeaderCol) {
                    obj = this._rowheaderTbl.getValueAt(row, rowHeaderCol);
                    if (obj == null || obj.toString().length() < 1) {
                        line.append(" ");
                    } else {
                        line.append(obj.toString());
                    }
                    if (options.gridLines) {
                        line.append("|");
                        continue;
                    }
                    line.append(options.delimiter);
                }
            }
            for (int col = 0; col < numCols; ++col) {
                obj = this.getValueAt(row, col);
                if (obj == null || obj.toString().length() < 1) {
                    if (options.quotedStrings) {
                        line.append("\"");
                    }
                    if (colWidths != null) {
                        line.append(RMAIO.rightJustify2(colWidths[col], " ").toString());
                    } else {
                        line.append(" ");
                    }
                    if (options.quotedStrings) {
                        line.append("\"");
                    }
                } else {
                    String value = obj.toString();
                    TableColumn tc = this.getColumnModel().getColumn(col);
                    if (tc != null) {
                        Component c2;
                        TableCellRenderer renderer = tc.getCellRenderer();
                        if (renderer == null) {
                            renderer = this.getDefaultRenderer(this.getColumnClass(col));
                        }
                        value = (c2 = renderer.getTableCellRendererComponent(this, obj, false, false, row, col)) instanceof JLabel ? ((JLabel)c2).getText() : obj.toString();
                    }
                    if (options.quotedStrings) {
                        line.append("\"");
                    }
                    if (value.indexOf(10) > -1) {
                        value = value.replace('\n', ' ');
                    }
                    if (colWidths != null) {
                        String s = this.getJustifiedValue(value, col, colWidths[col]);
                        line.append(s);
                    } else {
                        line.append(value);
                    }
                    if (options.quotedStrings) {
                        line.append("\"");
                    }
                }
                if (col == numCols - 1) continue;
                if (options.gridLines) {
                    line.append("|");
                    continue;
                }
                line.append(options.delimiter);
            }
            try {
                writer.write(line.toString());
                if (horizontalGridline != null) {
                    writer.newLine();
                    writer.write(horizontalGridline);
                }
                writer.newLine();
                writer.flush();
            }
            catch (IOException ioe) {
                System.out.println("exportData: io error on export " + ioe);
            }
            line.setLength(0);
        }
        if (parent != null) {
            parent.setCursor(Cursor.getDefaultCursor());
        }
    }

    public String getExportString(TableExportOptions options) {
        StringWriter strWriter = new StringWriter();
        BufferedWriter bufWriter = new BufferedWriter(strWriter);
        this.exportData(bufWriter, options);
        try {
            strWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return strWriter.toString();
    }

    public void exportAsXML(String fileName) {
        this.exportAsXML(fileName, null, "\t");
    }

    public void exportAsXML(String fileName, String title, String indent) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            this.exportAsXML(writer, title, indent);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void exportAsXML(BufferedWriter writer) {
        this.exportAsXML(writer, null, "\t");
    }

    public void exportAsXML(BufferedWriter writer, String title, String indent) {
        String delimiter = "\u0000";
        TableExportOptions expOpt = new TableExportOptions();
        expOpt.delimiter = delimiter.charAt(0);
        expOpt.quotedStrings = false;
        expOpt.title = null;
        expOpt.fixedWidthCols = false;
        expOpt.columnHeader = true;
        expOpt.rowHeader = false;
        expOpt.gridLines = false;
        try {
            int i;
            StringWriter strWriter = new StringWriter();
            BufferedWriter bufWriter = new BufferedWriter(strWriter);
            bufWriter.newLine();
            bufWriter.flush();
            String newLine = strWriter.toString();
            String[] lines = this.getExportString(expOpt).split(newLine);
            writer.write("<?xml version = \"1.0\" encoding = \"UTF-8\"?>");
            writer.newLine();
            writer.write("<Table>");
            writer.newLine();
            if (title != null && title.length() > 0) {
                writer.write(indent + "<Title>" + title + "</Title>");
                writer.newLine();
            }
            writer.write(indent + "<CaptionRow>");
            writer.newLine();
            String[] fields = lines[0].split(delimiter);
            for (i = 0; i < fields.length; ++i) {
                writer.write(indent + indent + "<CaptionItem>" + fields[i].trim() + "</CaptionItem>");
                writer.newLine();
            }
            writer.write(indent + "</CaptionRow>");
            writer.newLine();
            for (i = 2; i < lines.length; ++i) {
                writer.write(indent + "<ValuesRow>");
                writer.newLine();
                fields = lines[i].split(delimiter);
                for (int j = 0; j < fields.length; ++j) {
                    writer.write(indent + indent + "<ValuesItem>" + fields[j].trim() + "</ValuesItem>");
                    writer.newLine();
                }
                writer.write(indent + "</ValuesRow>");
                writer.newLine();
            }
            writer.write("</Table>");
            writer.newLine();
            writer.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String getXMLExportString() {
        return this.getXMLExportString(null, "\t");
    }

    public String getXMLExportString(String title, String indent) {
        StringWriter strWriter = new StringWriter();
        BufferedWriter bufWriter = new BufferedWriter(strWriter);
        this.exportAsXML(bufWriter, title, indent);
        try {
            strWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return strWriter.toString();
    }

    public void exportAsHTML(String fileName) {
        this.exportAsHTML(fileName, null, "\t");
    }

    public void exportAsHTML(String fileName, String title, String indent) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            this.exportAsHTML(writer, title, indent);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void exportAsHTML(BufferedWriter writer) {
        this.exportAsHTML(writer, null, "\t");
    }

    public void exportAsHTML(BufferedWriter writer, String title, String indent) {
        try {
            StringWriter strWriter = new StringWriter();
            BufferedWriter bufWriter = new BufferedWriter(strWriter);
            bufWriter.newLine();
            bufWriter.flush();
            String newLine = strWriter.toString();
            String htmlString = this.getXMLExportString(title, indent);
            htmlString = htmlString.replaceAll("<Table>", "<TABLE BORDER=1 RULES=\"ALL\">");
            htmlString = htmlString.replaceAll("</Table>", "</TABLE>");
            htmlString = htmlString.replaceAll("Title>", "CAPTION>");
            htmlString = htmlString.replaceAll("CaptionItem>", "TH ALIGN=\"CENTER\">");
            htmlString = htmlString.replaceAll("UnitsItem>", "TH ALIGN=\"CENTER\">");
            htmlString = htmlString.replaceAll("DataTypeItem>", "TH ALIGN=\"CENTER\">");
            htmlString = htmlString.replaceAll("ValuesItem>", "TD>");
            htmlString = htmlString.replaceAll("<CaptionRow>", "<TR ALIGN=\"RIGHT\">");
            htmlString = htmlString.replaceAll("<ValuesRow>", "<TR ALIGN=\"RIGHT\">");
            htmlString = htmlString.replaceAll("</CaptionRow>", "</TR>");
            htmlString = htmlString.replaceAll("</UnitsRow>", "</TR>");
            htmlString = htmlString.replaceAll("</DataTypeRow>", "</TR>");
            htmlString = htmlString.replaceAll("</ValuesRow>", "</TR>");
            String[] lines = htmlString.split(newLine);
            for (int i = 1; i < lines.length; ++i) {
                writer.write(lines[i]);
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String getHTMLExportString() {
        return this.getHTMLExportString(null, "\t");
    }

    public String getHTMLExportString(String title, String indent) {
        StringWriter strWriter = new StringWriter();
        BufferedWriter bufWriter = new BufferedWriter(strWriter);
        this.exportAsHTML(bufWriter, title, indent);
        try {
            strWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return strWriter.toString();
    }

    String getJustifiedValue(String value, int col, int colWidth) {
        int alignment = this.getHorizontalAlignment(col);
        switch (alignment) {
            case 4: {
                return RMAIO.leftJustify(colWidth, value).toString();
            }
            case 0: {
                return RMAIO.center(colWidth, value).toString();
            }
        }
        return RMAIO.rightJustify2(colWidth, value).toString();
    }

    int[] getMaxColumnWidths() {
        int colCount = this.getColumnCount();
        int[] widths = new int[colCount];
        for (int i = 0; i < colCount; ++i) {
            widths[i] = this.getMaxColumnCharacterWidth(i);
        }
        return widths;
    }

    int getMaxColumnCharacterWidth(int col) {
        int rowCnt = this.getRowCount();
        int maxWidth = this.getColumnModel().getColumn(col).getHeaderValue().toString().length();
        for (int row = 0; row < rowCnt; ++row) {
            int width;
            Object obj = this.getValueAt(row, col);
            if (obj == null || obj.toString().length() < 1) continue;
            String value = obj.toString();
            TableColumn tc = this.getColumnModel().getColumn(col);
            if (tc != null) {
                Component c2;
                TableCellRenderer renderer = tc.getCellRenderer();
                if (renderer == null) {
                    renderer = this.getDefaultRenderer(this.getColumnClass(col));
                }
                value = (c2 = renderer.getTableCellRendererComponent(this, obj, false, false, row, col)) instanceof JLabel ? ((JLabel)c2).getText() : obj.toString();
            }
            if (value == null || (width = value.length()) <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    @Override
    public boolean isValid(boolean showError) {
        return true;
    }

    public void setPasteAddsRows(boolean addRows) {
        this._pasteAddsRows = addRows;
    }

    public boolean getPasteAddsRows() {
        return this._pasteAddsRows;
    }

    public static void main(String[] args) {
        RmaJFrame frame = new RmaJFrame("RmaJTable Example"){

            @Override
            public void setModified(boolean modified) {
                if (modified) {
                    this.setTitle("RmaJTable Example*");
                } else {
                    this.setTitle("RmaJTable Example");
                }
                super.setModified(modified);
            }
        };
        frame.setDefaultCloseOperation(3);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[][] data = new Object[][]{{"Kathy", "Walrath", "Chasing toddlers", new Integer(2), new Boolean(false), "12", ""}, {"Alison", "Huml", "Rowing", new Integer(3), new Boolean(true), "5.50", ""}, {"Kathy", "Walrath", "Chasing toddlers", new Integer(2), new Boolean(false), "12.42", ""}, {"Angela", "Lih", "Teaching high school", new Integer(4), new Boolean(false), "112.42", ""}, {"Angela", "Lih", "Teaching high school", new Integer(4), new Boolean(false), "112.42", ""}, {"Angela", "Lih", "Teaching high school", new Integer(4), new Boolean(false), "112.42", ""}, {"Angela", "Lih", "Teaching high school", new Integer(4), new Boolean(false), "112.42", ""}, {"Angela", "Lih", "Teaching high school", new Integer(4), new Boolean(false), "112.42", ""}, {"Angela", "Lih", "Teaching high school", new Integer(4), new Boolean(false), "112.42", ""}, {"Angela", "Lih", "Teaching high school", new Integer(4), new Boolean(false), "112.42", ""}, {"Angela", "Lih", "Teaching high school", new Integer(4), new Boolean(false), "112.42", ""}, {"Angela", "Lih", "Teaching high school", new Integer(4), new Boolean(false), "112.42", ""}, {"Angela", "Lih", "Teaching high school", new Integer(4), new Boolean(false), "112.42", ""}, {"Angela", "Lih", "Teaching high school", new Integer(4), new Boolean(false), "112.42", ""}, {"Angela", "Lih", "Teaching high school", new Integer(4), new Boolean(false), "112.42", ""}, {"Angela", "Lih", "Teaching high school", new Integer(4), new Boolean(false), "112.42", ""}, {"Angela", "Lih", "Teaching high school", new Integer(4), new Boolean(false), "112.42", ""}};
        Object[] columnNames = new String[]{"First\nName", "Last\nName", "Sport", "# of Years", "Vegetarian", "Hourly\nRate", "Date/Time"};
        String[] columnNames2 = new String[]{"Name\nFirst", "Name\nLast", "Sport", "# of Years", "Vegetarian", "Hourly\nRate", "Date/Time"};
        RmaTableModel headerModel = new RmaTableModel(new String[]{"Index"}, new Object[0][0], new boolean[]{true});
        RmaJTable tbl = new RmaJTable((Component)frame, data, columnNames);
        RmaJTable headerTbl = tbl.setViewportRowHeader(headerModel, null, null, 50);
        headerTbl.setAutoRowHeaders(true);
        headerTbl.appendRows(data.length);
        headerTbl.setRowHeight(20);
        headerTbl.setColumnEnabled(true, 0);
        tbl.setName("List of\nnames\nand\ntheir info");
        tbl.setRowHeight(20);
        tbl.setCellRenderer();
        tbl.setMlHeaderRenderer();
        tbl.setCurrencyCellEditor(5);
        tbl.setDateTimeCellEditor(6);
        tbl.setRowHeaderEnabled(true);
        tbl.setCellForeground(1, 2, Color.red);
        tbl.setCellBackground(2, 1, Color.blue);
        tbl.setRowBackground(2, Color.green);
        tbl.setRowForeground(1, Color.yellow);
        tbl.setCellEnabled(false, 4, 2);
        tbl.setPasteAddsRows(true);
        tbl.setCheckBoxCellEditor(4);
        tbl.setPasteForeground(Color.red);
        tbl.setCellSelectionEnabled(false);
        tbl.setRowSelectionAllowed(true);
        tbl.setColumnSelectionAllowed(true);
        tbl.setRowEnabled(false, 2);
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < data.length; ++i) {
            v.addElement(data[i][2]);
        }
        tbl.setComboBoxEditor(2, v);
        RmaJDecimalField df = tbl.setDoubleCellEditor(3);
        df.setMinValue(0.0);
        df.setMaxValue(20.0);
        tbl.setPrecision(2);
        tbl.setIntegerEditorForCell(0, 3);
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        JButton h = new JButton("Headers");
        h.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        h.setFont(tbl.getFont());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        p.add((Component)h, gbc);
        h = new JButton(" Row  ");
        h.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        h.setFont(tbl.getFont());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        p.add((Component)h, gbc);
        h = new JButton("  Row ");
        h.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        h.setFont(tbl.getFont());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        p.add((Component)h, gbc);
        frame.getContentPane().add((Component)tbl.getScrollPane(), "North");
        frame.setSize(500, 300);
        tbl.setAutoResizeMode(0);
        JTable tbl2 = new JTable(data, columnNames);
        tbl2.setCellSelectionEnabled(true);
        tbl2.setRowSelectionAllowed(false);
        tbl2.setColumnSelectionAllowed(false);
        tbl2.setBackground(Color.lightGray);
        JScrollPane sbar = new JScrollPane(tbl2);
        frame.getContentPane().add((Component)sbar, "South");
        tbl.linearFill(new CellLocation(0, 3, ""), new CellLocation(4, 3, ""));
        frame.setModified(false);
        frame.setVisible(true);
        tbl.setColumnLabels(columnNames2);
        tbl.exportAsXML("table.export");
    }

    public boolean useDefaultPrintHeader() {
        return this._useDefaultPrintHeader;
    }

    public void setUseDefaultPrintHeader(boolean useDefaultPrintHeader) {
        this._useDefaultPrintHeader = useDefaultPrintHeader;
    }

    public int getColumnWidthFromData(int colNum) {
        int rowCnt = this.getRowCount();
        int width = 0;
        if (colNum >= this.getColumnCount()) {
            return width;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        for (int row = 0; row < rowCnt; ++row) {
            String str;
            Object obj = this.getValueAt(row, colNum);
            if (obj == null || (str = obj.toString()) == null) continue;
            if (str.toLowerCase().contains("<br>")) {
                str = this.findLongestHtmlString(str);
            } else if (str.toLowerCase().contains("\n")) {
                str = this.findLongestNewlineString(str);
            }
            width = Math.max(width, fm.stringWidth(str));
        }
        width = Math.max(width, this.getColumnWidth(colNum));
        return width + this.getColumnModel().getColumnMargin();
    }

    public void adjustAllColumnsWidthToFitData(int margin) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.adjustColumnWidthtoFitData(i, margin);
        }
    }

    public void adjustColumnWidthtoFitData(int column, int margin) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)this.getColumnModel();
        TableColumn col = colModel.getColumn(column);
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(this, col.getHeaderValue(), false, false, 0, 0);
        int width = comp.getPreferredSize().width;
        for (int r = 0; r < this.getRowCount(); ++r) {
            renderer = this.getCellRenderer(r, column);
            comp = renderer.getTableCellRendererComponent(this, this.getValueAt(r, column), false, false, r, column);
            int currentWidth = comp.getPreferredSize().width;
            width = Math.max(width, currentWidth);
        }
        col.setPreferredWidth(width += 2 * margin);
        col.setWidth(width);
    }

    private String findLongestNewlineString(String str) {
        if (str == null) {
            return null;
        }
        String[] ss = str.split("\n");
        String longest = "";
        for (int i = 0; i < ss.length; ++i) {
            if (ss[i].length() <= longest.length()) continue;
            longest = ss[i];
        }
        return longest;
    }

    private String findLongestHtmlString(String str) {
        String[] ss;
        if (str == null) {
            return null;
        }
        String longest = "";
        String s = str.toLowerCase();
        int idx = s.indexOf("<br>");
        if (s.startsWith("<html>")) {
            s = s.substring(6);
        }
        if (s.endsWith("<html>")) {
            s = s.substring(0, s.length() - 6);
        }
        if ((ss = s.split("<br>")) == null) {
            return null;
        }
        for (int i = 0; i < ss.length; ++i) {
            if (ss[i].length() <= longest.length()) continue;
            longest = ss[i];
        }
        return longest;
    }

    public Point getPopupPoint() {
        return this._popupPoint;
    }

    public void setAllowsFontResizing(boolean allowResizing) {
        if (allowResizing && this.getActionMap().get("increaseFont") == null) {
            this._origRowHeight = this.getRowHeight();
            AbstractAction increaseFontAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Font f = RmaJTable.this.getFont();
                    Font newFont = new Font(f.getName(), f.getStyle(), f.getSize() + 1);
                    RmaJTable.this.setFont(newFont);
                    RmaJTable.this.updateRowHeight();
                    RmaJTable.this.revalidate();
                }
            };
            AbstractAction decreaseFontAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Font f = RmaJTable.this.getFont();
                    Font newFont = new Font(f.getName(), f.getStyle(), f.getSize() - 1);
                    RmaJTable.this.setFont(newFont);
                    RmaJTable.this.updateRowHeight();
                    RmaJTable.this.revalidate();
                }
            };
            this.getInputMap(1).put(KeyStroke.getKeyStroke(61, 2), "increaseFont");
            this.getInputMap(1).put(KeyStroke.getKeyStroke(45, 2), "decreaseFont");
            this.getActionMap().put("increaseFont", increaseFontAction);
            this.getActionMap().put("decreaseFont", decreaseFontAction);
        } else {
            this.getActionMap().remove("increaseFont");
            this.getActionMap().remove("decreaseFont");
            this.getInputMap(1).remove(KeyStroke.getKeyStroke(61, 2));
            this.getInputMap(1).remove(KeyStroke.getKeyStroke(45, 2));
        }
    }

    private void updateRowHeight() {
        int rowHeight;
        FontMetrics f = this.getFontMetrics(this.getFont());
        if (f.getHeight() > rowHeight) {
            for (rowHeight = this.getRowHeight(); f.getHeight() > rowHeight; rowHeight += 2) {
            }
            this.setRowHeight(rowHeight);
        } else if (f.getHeight() < rowHeight) {
            while (f.getHeight() < rowHeight && rowHeight >= this._origRowHeight) {
                rowHeight -= 2;
            }
            this.setRowHeight(rowHeight);
        }
    }

    public void setSelectedIndices(int ... indices) {
        ListSelectionModel sm = this.getSelectionModel();
        sm.clearSelection();
        int size = this.getRowCount();
        for (int i = 0; i < indices.length; ++i) {
            int idx = this.convertRowIndexToModel(indices[i]);
            if (idx >= size) continue;
            sm.addSelectionInterval(idx, idx);
        }
    }

    @Override
    public void setTableHeader(JTableHeader header) {
        super.setTableHeader(header);
        if (header instanceof GroupableTableHeader) {
            this.configureEnclosingScrollPane();
        }
    }

    @Override
    public void setRowSorter(RowSorter<? extends TableModel> sorter) {
        if (sorter != null) {
            this._rowSorterListener = new TableRowSorterListener();
            sorter.addRowSorterListener(this._rowSorterListener);
        } else {
            RowSorter<? extends TableModel> oldSorter = this.getRowSorter();
            if (oldSorter != null && this._rowSorterListener != null) {
                oldSorter.removeRowSorterListener(this._rowSorterListener);
                this._rowSorterListener = null;
            }
        }
        super.setRowSorter(sorter);
    }

    public void addPopupItem(JComponent menuItem, int i) {
        if (menuItem == null) {
            return;
        }
        if (this._additionalPopupItems == null) {
            this._additionalPopupItems = new ArrayList();
        }
        this._additionalPopupItems.add(new PopupItem(menuItem, i));
        this.buildPopup();
    }

    static {
        _pasteDebug = Boolean.getBoolean("Table.pasteDebug");
        UIManager.put("Table.disabledCellColor", Color.lightGray);
    }

    static class ParameterScale
    implements IParameterScale {
        int paramId;
        double scale;

        public ParameterScale(int paramId, double scale) {
            this.paramId = paramId;
            this.scale = scale;
        }

        @Override
        public int getParamId() {
            return this.paramId;
        }

        @Override
        public double getScale() {
            return this.scale;
        }
    }

    private static class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private CheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Boolean) {
                this.setSelected(value != null && (Boolean)value != false);
            } else if (value instanceof String) {
                this.setSelected(Boolean.parseBoolean((String)value));
            }
            return this;
        }
    }

    public static class RmaSelectionListener
    implements ListSelectionListener {
        ListSelectionModel _lsModel;
        ListSelectionModel _colModel;
        ListSelectionModel _rowModel;
        int[] _selections;
        int _modelType;
        public int COL_MODEL = 1;
        public int ROW_MODEL = 2;

        public RmaSelectionListener(ListSelectionModel lsm, int modelType) {
            if (modelType == this.COL_MODEL) {
                this._colModel = lsm;
            } else {
                this._rowModel = lsm;
            }
            this._modelType = modelType;
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            this._lsModel = (ListSelectionModel)lse.getSource();
            if (!lse.getValueIsAdjusting()) {
                this._selections = this.getSelectedIndices(this._lsModel.getMinSelectionIndex(), this._lsModel.getMaxSelectionIndex());
            }
        }

        public int[] getSelections() {
            return this._selections;
        }

        public int[] getSelectedIndices(int start, int stop) {
            if (start == -1 || stop == -1) {
                return new int[0];
            }
            int[] guesses = new int[stop - start + 1];
            int index = 0;
            for (int i = start; i <= stop; ++i) {
                if (!this._lsModel.isSelectedIndex(i)) continue;
                guesses[index++] = i;
            }
            int[] realthing = new int[index];
            System.arraycopy(guesses, 0, realthing, 0, index);
            return realthing;
        }
    }

    private class PopupItem {
        JComponent comp;
        int pos;

        public PopupItem(JComponent c2, int p) {
            this.comp = c2;
            p = this.pos;
        }
    }

    public class MinMaxEntry {
        public int _col;
        public int _minRow;
        public int _maxRow;
        public Object _min;
        public Object _max;
        public boolean _isCurrent = false;

        public MinMaxEntry(int col) {
            this._col = col;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MinMaxEntry)) {
                return false;
            }
            MinMaxEntry mme = (MinMaxEntry)obj;
            return mme._col == this._col;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this._col;
            return result;
        }

        public boolean checkMin(Object obj, int row) {
            if (this._min == null) {
                this._min = obj;
                this._minRow = row;
                return true;
            }
            int comp = this.checkValue(obj, this._min);
            if (comp < 0 || row == this._minRow && comp > 0) {
                this._min = obj;
                this._minRow = row;
                return true;
            }
            return false;
        }

        public boolean checkMax(Object obj, int row) {
            if (this._max == null) {
                this._max = obj;
                this._maxRow = row;
                return true;
            }
            int comp = this.checkValue(obj, this._max);
            if (comp > 0 || this._maxRow == row && comp < 0) {
                this._max = obj;
                this._maxRow = row;
                return true;
            }
            return false;
        }

        private int checkValue(Object newVal, Object oldVal) {
            Class<?> type = RmaJTable.this.getModel().getColumnClass(this._col);
            if (newVal == null) {
                return 0;
            }
            String sNewVal = newVal.toString();
            String sOldVal = oldVal.toString();
            Class<Number> numClass = Number.class;
            if (type == numClass || type.getSuperclass() == numClass) {
                double d2;
                double d1;
                try {
                    d1 = new Double(sNewVal);
                }
                catch (NumberFormatException nfe) {
                    d1 = 0.0;
                }
                try {
                    d2 = new Double(sOldVal);
                }
                catch (NumberFormatException nfe) {
                    d2 = 0.0;
                }
                if (d1 < d2) {
                    return -1;
                }
                if (d1 > d2) {
                    return 1;
                }
                return 0;
            }
            if (type == RmaJTable.this.getClassForName("java.util.Date")) {
                long n2;
                long n1 = new Date(sNewVal).getTime();
                if (n1 < (n2 = new Date(sOldVal).getTime())) {
                    return -1;
                }
                if (n1 > n2) {
                    return 1;
                }
                return 0;
            }
            if (type == RmaJTable.this.getClassForName("java.lang.String")) {
                int result = sNewVal.compareTo(sOldVal);
                if (result < 0) {
                    return -1;
                }
                if (result > 0) {
                    return 1;
                }
                return 0;
            }
            if (type == RmaJTable.this.getClassForName("java.lang.Boolean")) {
                boolean b2;
                boolean b1 = new Boolean(sNewVal);
                if (b1 == (b2 = new Boolean(sOldVal).booleanValue())) {
                    return 0;
                }
                if (b1) {
                    return 1;
                }
                return -1;
            }
            int result = sNewVal.compareTo(sOldVal);
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
    }

    public static class CurrencyCellRenderer
    extends RmaCellRenderer {
        int _align;
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance();

        public CurrencyCellRenderer() {
            this.df.setDecimalSeparatorAlwaysShown(true);
            this.df.setGroupingUsed(true);
            this.setPrecision(2);
        }

        private void setPrecision(int precision) {
            this.df.setMaximumFractionDigits(precision);
            this.df.setMinimumFractionDigits(precision);
            if (precision == 0) {
                this.df.setDecimalSeparatorAlwaysShown(false);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Font f = label.getFont();
            label.setFont(new Font("monospaced", 0, f.getSize()));
            label.setHorizontalAlignment(4);
            double d = 0.0;
            boolean gotValue = false;
            try {
                d = Double.valueOf(label.getText());
                gotValue = true;
            }
            catch (NumberFormatException nfe) {
                gotValue = false;
            }
            if (gotValue) {
                if (d == 0.0) {
                    StringBuffer strBuf = new StringBuffer();
                    strBuf.append('0');
                    int precision = this.df.getMaximumFractionDigits();
                    if (precision > 0) {
                        strBuf.append('.');
                        for (int i = 0; i < precision; ++i) {
                            strBuf.append('0');
                        }
                    }
                    label.setText(strBuf.toString());
                } else {
                    String s = this.df.format(d);
                    s = "$".concat(s);
                    label.setText(s);
                }
            }
            return label;
        }
    }

    static class ButtonRenderer
    extends JButton
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean cellEditable = table.isCellEditable(row, column);
            if (!isSelected) {
                if (cellEditable) {
                    // empty if block
                }
                this.setForeground(table.getForeground());
            }
            this.setEnabled(cellEditable);
            this.setText(value != null ? value.toString() : "");
            return this;
        }
    }

    protected static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private boolean _useSelectionBackground;

        public BooleanRenderer(boolean useSelectionBackground) {
            this._useSelectionBackground = useSelectionBackground;
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table.isCellEditable(row, column)) {
                this.setEnabled(true);
                Color c2 = ((RmaJTable)table).getCellBackground(row, column);
                this.setBackground(c2);
            } else {
                this.setBackground(((RmaJTable)table).getDisabledBackground(row, column));
                this.setEnabled(false);
            }
            this.setForeground(table.getForeground());
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                if (this._useSelectionBackground) {
                    super.setBackground(table.getSelectionBackground());
                }
            }
            this.setSelected(value != null && "true".equalsIgnoreCase(value.toString()));
            return this;
        }
    }

    public class TableRowSorterListener
    implements RowSorterListener {
        @Override
        public void sorterChanged(RowSorterEvent e) {
            RmaJTable.this.commitEdit(true);
        }
    }

    @Deprecated
    public static class OneClickCheckBoxEditor
    extends RmaCellEditor {
        public OneClickCheckBoxEditor(JCheckBox x) {
            super(x);
            this.setClickCountToStart(1);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            boolean f = super.shouldSelectCell(anEvent);
            if (this.editorComponent instanceof JCheckBox) {
                final JCheckBox check = (JCheckBox)this.editorComponent;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("do the click");
                        check.doClick(0);
                        check.revalidate();
                    }
                });
                return f;
            }
            return f;
        }
    }
}

