/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.FocusManager;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import rma.lang.Modifiable;
import rma.swing.EditableComponent;
import rma.swing.FormManagementListener;
import rma.swing.RmaValidComponent;
import rma.util.RMAUtil;

public class RmaJTextArea
extends JTextArea
implements DocumentListener,
RmaValidComponent,
FocusListener,
MouseMotionListener,
FormManagementListener,
Modifiable,
EditableComponent {
    private boolean _modified;
    Color _changeColor;
    boolean _emptyOk = true;
    boolean _showError = true;
    protected JTextComponent _statusLine;
    protected String _statusText;
    protected String _name;
    protected Window _parentWindow;
    protected boolean _modifiable = true;
    private static final Color DISABLED_COLOR = UIManager.getColor("TextField.disabledBackground");
    private static StringBuffer _tooltipBuf = new StringBuffer();
    private String _toolTipText;
    private boolean _toolTipTextDisabled = false;
    private List<Action> _popupActions;

    public RmaJTextArea(String text, int rows, int columns) {
        super(text, rows, columns);
        this.setToolTipText("");
        this.createListeners();
    }

    public RmaJTextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
        this.setToolTipText("");
        this.createListeners();
    }

    public RmaJTextArea(int rows, int columns) {
        super(rows, columns);
        this.setToolTipText("");
        this.createListeners();
    }

    public RmaJTextArea() {
        this.setToolTipText("");
        this.createListeners();
    }

    public RmaJTextArea(String text) {
        super(text);
        this.setToolTipText("");
        this.createListeners();
    }

    private void createListeners() {
        this.addFocusListener(this);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isAltDown() || e.isControlDown() || e.isMetaDown()) {
                    return;
                }
                RmaJTextArea.this.setModified(true);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    RmaJTextArea.this.popupMenuAction(e.getPoint());
                }
            }
        });
    }

    protected void popupMenuAction(Point pt) {
        boolean hasSelection;
        JPopupMenu popup = new JPopupMenu();
        boolean editable = this.isEditable() && this.isEnabled();
        boolean bl = hasSelection = this.getSelectedText() != null;
        if (editable && hasSelection) {
            AbstractAction cutAction = new AbstractAction("Cut"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RmaJTextArea.this.cut();
                }
            };
            popup.add(cutAction);
        }
        if (hasSelection) {
            AbstractAction copyAction = new AbstractAction("Copy"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RmaJTextArea.this.copy();
                }
            };
            popup.add(copyAction);
        }
        if (editable) {
            AbstractAction pasteAction = new AbstractAction("Paste"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RmaJTextArea.this.paste();
                }
            };
            popup.add(pasteAction);
        }
        if (popup.getComponentCount() > 0) {
            popup.addSeparator();
        }
        AbstractAction selectAllAction = new AbstractAction("Select All"){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmaJTextArea.this.selectAll();
            }
        };
        popup.add(selectAllAction);
        if (this._popupActions != null) {
            popup.addSeparator();
            for (int i = 0; i < this._popupActions.size(); ++i) {
                popup.add(this._popupActions.get(i));
            }
        }
        popup.show(this, pt.x, pt.y);
    }

    public void addPopupAction(Action action) {
        if (action != null) {
            if (this._popupActions == null) {
                this._popupActions = new ArrayList<Action>();
            }
            this._popupActions.add(action);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (b) {
            this.setBackground(UIManager.getColor("TextField.background"));
        } else {
            this.setBackground(DISABLED_COLOR);
        }
    }

    @Override
    public void setEditable(boolean b) {
        super.setEditable(b);
        if (b) {
            this.setBackground(UIManager.getColor("TextField.background"));
        } else {
            this.setBackground(DISABLED_COLOR);
        }
    }

    public void setChangeColor(Color changeColor) {
        if (changeColor == null) {
            this.getDocument().removeDocumentListener(this);
        } else {
            if (this._changeColor == null) {
                this.getDocument().addDocumentListener(this);
            }
            this._changeColor = changeColor;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setForeground(this._changeColor);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setForeground(this._changeColor);
    }

    public void setEmptyOk(boolean b) {
        this._emptyOk = b;
    }

    public boolean isEmptyOk() {
        return this._emptyOk;
    }

    public void errorMsg(String msg) {
        if (!this._showError) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        final RmaJTextArea c2 = this;
        final String m = msg;
        if (this._parentWindow == null) {
            this._parentWindow = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (RmaJTextArea.this.isEnabled() && RmaJTextArea.this.isShowing()) {
                    JOptionPane.showMessageDialog(c2, m, "", 0);
                }
            }
        });
    }

    public void takeFocus() {
        final RmaJTextArea c2 = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                c2.requestFocus();
            }
        });
    }

    @Override
    public boolean isValid(boolean showErr) {
        return this.validateData(showErr);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.isTemporary() || this.getParent() instanceof JTable) {
            return;
        }
        Container c2 = this.getParent();
        if (c2 == null) {
            return;
        }
        if (c2.isVisible()) {
            this.validateData(true);
        }
    }

    public void setShowErrorMsg(boolean b) {
        this._showError = b;
    }

    protected boolean validateData(boolean showErrorMsg) {
        return true;
    }

    public void setStatusLineField(JTextComponent statusLine, String statusText) {
        if (statusLine == null) {
            this.removeMouseMotionListener(this);
            statusText = null;
        } else if (this._statusText != null && this._statusText.length() > 0) {
            this.addMouseMotionListener(this);
            this._statusLine = statusLine;
            this._statusText = statusText;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getID() == 504) {
            this._statusLine.setText(this._statusText);
        } else if (e.getID() == 505) {
            this._statusLine.setText("");
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    public boolean getToolTipTextDisabled() {
        return this._toolTipTextDisabled;
    }

    public void setToolTipTextDisabled(boolean toolTipTextDisabled) {
        this._toolTipTextDisabled = toolTipTextDisabled;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this._toolTipTextDisabled) {
            return null;
        }
        String superToolTip = super.getToolTipText();
        if (superToolTip == null || superToolTip.length() == 0) {
            if (this._toolTipText != null) {
                return this._toolTipText;
            }
            StringTokenizer tokenizer = new StringTokenizer(this.getText(), "\n");
            _tooltipBuf.setLength(0);
            _tooltipBuf.append("<html>");
            while (tokenizer.hasMoreTokens()) {
                _tooltipBuf.append(tokenizer.nextToken());
                if (!tokenizer.hasMoreTokens()) continue;
                _tooltipBuf.append("<BR>");
            }
            _tooltipBuf.append("</html>");
            this._toolTipText = _tooltipBuf.toString();
            return this._toolTipText;
        }
        return superToolTip;
    }

    @Override
    public void clearPerformed() {
        this.setText("");
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setModified(boolean b) {
        this._modified = b;
        if (!b && this.getForeground().equals(this._changeColor)) {
            this.setForeground(UIManager.getColor("TextField.foreground"));
        }
        if (b) {
            RMAUtil.setParentModified(this);
            this._toolTipText = null;
        }
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent e) {
        super.processComponentKeyEvent(e);
        if (e.isConsumed()) {
            return;
        }
        if (e.getKeyCode() == 10 || e.getKeyChar() == '\n') {
            if (e.getID() == 402) {
                e.consume();
            }
        } else if (e.getKeyCode() == 9 && e.isShiftDown() && e.getID() == 402 && this.getCaretPosition() == 0) {
            FocusManager.getCurrentManager().focusPreviousComponent(this);
            e.consume();
        }
    }

    @Override
    public void setIsEditable(boolean b) {
        if (this._modifiable) {
            this.setEditable(b);
        }
    }

    public void setModifiable(boolean m) {
        this._modifiable = m;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this._toolTipText = null;
    }
}

